/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["lucid.apps.Contacts.ContactForm"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["lucid.apps.Contacts.ContactForm"] = true;
dojo.provide("lucid.apps.Contacts.ContactForm");
dojo.require("dijit.form.TextBox");
dojo.require("dijit.form.Textarea");
dojo.require("dijit.form.ValidationTextBox");
dojo.require("dijit.form.Form");
dojo.require("dijit.layout.TabContainer");
dojo.require("dijit.layout.ContentPane");
dojo.requireLocalization("lucid.apps.Contacts", "Contacts", null, "ROOT,es,fr");

dojo.declare("lucid.apps.Contacts.ContactForm", dijit.form.Form, {
    widgetsInTemplate: true,
    templateString: null,
    templateString:"<form dojoAttachPoint='containerNode' dojoAttachEvent='onreset:_onReset,onsubmit:_onSubmit'>\n    <div dojoType=\"dijit.layout.BorderContainer\" dojoAttachPoint=\"borderContainer\" style=\"width: 100%; height: 100%;\">\n        <div dojoType=\"dijit.layout.TabContainer\" dojoAttachPoint=\"tabContainer\" region=\"center\">\n            <div dojoType=\"dijit.layout.ContentPane\" dojoAttachPoint=\"contactTab\" title=\"Contact\">\n                <div>\n                    <label for=\"${id}_name\" dojoAttachPoint=\"nameLabelNode\">Name:</label>\n                    <input dojoType=\"dijit.form.TextBox\" id=\"${id}_name\" name=\"name\" required=\"true\" />\n                </div>\n                <div>\n                    <label for=\"${id}_email\" dojoAttachPoint=\"emailLabelNode\">Email:</label>\n                    <input id=\"${id}_email\" name=\"email\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_phone_home\" dojoAttachPoint=\"homephoneLabelNode\">Home Phone:</label>\n                    <input id=\"${id}_phone_home\" name=\"phone-home\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_phone_work\" dojoAttachPoint=\"workphoneLabelNode\">Work Phone:</label>\n                    <input id=\"${id}_phone_work\" name=\"phone-work\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_phone_mobile\" dojoAttachPoint=\"mobilephoneLabelNode\">Mobile Phone:</label>\n                    <input id=\"${id}_phone_mobile\" name=\"phone-mobile\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_fax\" dojoAttachPoint=\"faxLabelNode\">Fax:</label>\n                    <input id=\"${id}_fax\" name=\"phone-fax\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n\n            </div>\n            <div dojoType=\"dijit.layout.ContentPane\" dojoAttachPoint=\"addressTab\" title=\"Address\">\n                <b dojoAttachPoint=\"homeLabelNode\">Home</b>\n                <hr />\n                <div>\n                    <label for=\"${id}_address_home\" dojoAttachPoint=\"addressHomeLabelNode\">Address:</label>\n                    <input dojoType=\"dijit.form.Textarea\" id=\"${id}_address_home\" name=\"address-home\" style=\"width: 70%;\" />\n                </div>\n                <div>\n                    <label for=\"${id}_pobox_home\" dojoAttachPoint=\"poboxHomeLabelNode\">PO Box:</label>\n                    <input id=\"${id}_pobox_home\" name=\"pobox-home\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_city_home\" dojoAttachPoint=\"cityHomeLabelNode\">City:</label>\n                    <input id=\"${id}_city_home\" name=\"city-home\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_zip_home\" dojoAttachPoint=\"zipHomeLabelNode\">Zip/Postal Code:</label>\n                    <input id=\"${id}_zip_home\" name=\"zip-home\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_state_home\" dojoAttachPoint=\"stateHomeLabelNode\">State/Province:</label>\n                    <input id=\"${id}_state_home\" name=\"state-home\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div style=\"margin-bottom: 10px;\">\n                    <label for=\"${id}_country_home\" dojoAttachPoint=\"countryHomeLabelNode\">Country:</label>\n                    <input id=\"${id}_country_home\" name=\"country-home\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n\n                <b dojoAttachPoint=\"workLabelNode\">Work</b>\n                <hr />\n                <div>\n                    <label for=\"${id}_address_work\" dojoAttachPoint=\"addressWorkLabelNode\">Address:</label>\n                    <input dojoType=\"dijit.form.Textarea\" id=\"${id}_address_work\" name=\"address-work\" style=\"width: 70%;\" />\n                </div>\n                <div>\n                    <label for=\"${id}_pobox_work\" dojoAttachPoint=\"poboxWorkLabelNode\">PO Box:</label>\n                    <input id=\"${id}_pobox_work\" name=\"pobox-work\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_city_work\" dojoAttachPoint=\"cityWorkLabelNode\">City:</label>\n                    <input id=\"${id}_city_work\" name=\"city-work\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_zip_work\" dojoAttachPoint=\"zipWorkLabelNode\">Zip/Postal Code:</label>\n                    <input id=\"${id}_zip_work\" name=\"zip-work\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div>\n                    <label for=\"${id}_state_work\" dojoAttachPoint=\"stateWorkLabelNode\">State/Province:</label>\n                    <input id=\"${id}_state_work\" name=\"state-work\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n                <div style=\"margin-bottom: 10px;\">\n                    <label for=\"${id}_country_work\" dojoAttachPoint=\"countryWorkLabelNode\">Country:</label>\n                    <input id=\"${id}_country_work\" name=\"country-work\" dojoType=\"dijit.form.TextBox\" />\n                </div>\n\n            </div>\n    \n        </div>\n        <div dojoType=\"dijit.layout.ContentPane\" region=\"bottom\">\n            <div style=\"text-align: right; margin-top: 5px;\">\n                <div dojoType=\"dijit.form.Button\" dojoAttachPoint=\"cancelButton\" class=\"dijitInline\" label=\"Cancel\" dojoAttachEvent=\"onClick:onCancel\"></div>\n                <div dojoType=\"dijit.form.Button\" dojoAttachPoint=\"saveButton\" class=\"dijitInline\" iconClass=\"icon-16-actions-document-save\" label=\"Save\" dojoAttachEvent=\"onClick:onSubmit\"></div>\n            </div>\n        </div>\n    </div>\n</form> \n",
    postCreate: function(){
        var values = {};
        dojo.forEach(this.store.getAttributes(this.item), function(key){
            values[key] = this.store.getValue(this.item, key);
        }, this);
        this.attr('value', values);
        this.doTranslations();
    },
    doTranslations: function(){
        var nls = dojo.i18n.getLocalization("lucid.apps.Contacts", "Contacts");
        for(var key in this){
            if(key.indexOf("LabelNode") === -1) continue;
            var str = key.match(/[a-z]+/)[0];
            console.log(this[key], str, nls[str]);
            if(nls[str])
                this[key].childNodes[0].data = nls[str]+":";
        }
        this.saveButton.attr("label", nls.save);
        this.cancelButton.attr("label", nls.cancel);
        this.contactTab.attr("title", nls.contact);
        this.addressTab.attr("title", nls.address);
    },
    onSubmit: function(){
        var values = this.getValues();
        for(var key in values){
            var value = values[key];
            this.store.setValue(this.item, key, value);
        }
        setTimeout(dojo.hitch(this.store, "save"), 200);
    },
    onCancel: function(){
    }
});

}
