/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["dojox.gfx.matrix"]){dojo._hasResource["dojox.gfx.matrix"]=true;dojo.provide("dojox.gfx.matrix");(function(){var m=dojox.gfx.matrix;var _2={};m._degToRad=function(_3){return _2[_3]||(_2[_3]=(Math.PI*_3/180));};m._radToDeg=function(_4){return _4/Math.PI*180;};m.Matrix2D=function(_5){if(_5){if(typeof _5=="number"){this.xx=this.yy=_5;}else{if(_5 instanceof Array){if(_5.length>0){var _6=m.normalize(_5[0]);for(var i=1;i<_5.length;++i){var l=_6,r=dojox.gfx.matrix.normalize(_5[i]);_6=new m.Matrix2D();_6.xx=l.xx*r.xx+l.xy*r.yx;_6.xy=l.xx*r.xy+l.xy*r.yy;_6.yx=l.yx*r.xx+l.yy*r.yx;_6.yy=l.yx*r.xy+l.yy*r.yy;_6.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_6.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}dojo.mixin(this,_6);}}else{dojo.mixin(this,_5);}}}};dojo.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});dojo.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_e){var c=Math.cos(_e);var s=Math.sin(_e);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_11){return m.rotate(m._degToRad(_11));},skewX:function(_12){return new m.Matrix2D({xy:Math.tan(_12)});},skewXg:function(_13){return m.skewX(m._degToRad(_13));},skewY:function(_14){return new m.Matrix2D({yx:Math.tan(_14)});},skewYg:function(_15){return m.skewY(m._degToRad(_15));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_22){return (_22 instanceof m.Matrix2D)?_22:new m.Matrix2D(_22);},clone:function(_23){var obj=new m.Matrix2D();for(var i in _23){if(typeof (_23[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_23[i]){obj[i]=_23[i];}}return obj;},invert:function(_26){var M=m.normalize(_26),D=M.xx*M.yy-M.xy*M.yx,M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_29,x,y){return {x:_29.xx*x+_29.xy*y+_29.dx,y:_29.yx*x+_29.yy*y+_29.dy};},multiplyPoint:function(_2c,a,b){var M=m.normalize(_2c);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiply:function(_30){var M=m.normalize(_30);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_35,x,y){return m.multiply(m.translate(x,y),_35,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_3c,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_3c),a,b);}return m._sandwich(m.rotate(_3c),a.x,a.y);},rotategAt:function(_3f,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_3f),a,b);}return m._sandwich(m.rotateg(_3f),a.x,a.y);},skewXAt:function(_42,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_42),a,b);}return m._sandwich(m.skewX(_42),a.x,a.y);},skewXgAt:function(_45,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_45),a,b);}return m._sandwich(m.skewXg(_45),a.x,a.y);},skewYAt:function(_48,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_48),a,b);}return m._sandwich(m.skewY(_48),a.x,a.y);},skewYgAt:function(_4b,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_4b),a,b);}return m._sandwich(m.skewYg(_4b),a.x,a.y);}});})();dojox.gfx.Matrix2D=dojox.gfx.matrix.Matrix2D;}if(!dojo._hasResource["dojox.gfx._base"]){dojo._hasResource["dojox.gfx._base"]=true;dojo.provide("dojox.gfx._base");(function(){var g=dojox.gfx,b=g._base;g._hasClass=function(_50,_51){var cls=_50.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_51+" ")>=0;};g._addClass=function(_53,_54){var cls=_53.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_54+" ")<0){_53.setAttribute("className",cls+(cls?" ":"")+_54);}};g._removeClass=function(_56,_57){var cls=_56.getAttribute("className");if(cls){_56.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_57+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _59={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};if(dojo.isIE){dojo.doc.documentElement.style.fontSize="100%";}var div=dojo.doc.createElement("div");var s=div.style;s.position="absolute";s.left="-100px";s.top="0px";s.width="30px";s.height="1000em";s.border="0px";s.margin="0px";s.padding="0px";s.outline="none";s.lineHeight="1";s.overflow="hidden";dojo.body().appendChild(div);for(var p in _59){div.style.fontSize=p;_59[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}dojo.body().removeChild(div);div=null;return _59;};var _5d=null;b._getCachedFontMeasurements=function(_5e){if(_5e||!_5d){_5d=b._getFontMeasurements();}return _5d;};var _5f=null,_60={};b._getTextBox=function(_61,_62,_63){var m,s;if(!_5f){m=_5f=dojo.doc.createElement("div");s=m.style;s.position="absolute";s.left="-10000px";s.top="0";dojo.body().appendChild(m);}else{m=_5f;s=m.style;}m.className="";s.border="0";s.margin="0";s.padding="0";s.outline="0";if(arguments.length>1&&_62){for(var i in _62){if(i in _60){continue;}s[i]=_62[i];}}if(arguments.length>2&&_63){m.className=_63;}m.innerHTML=_61;return dojo.marginBox(m);};var _67=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"Unique"+(++_67);}while(dojo.byId(id));return id;};})();dojo.mixin(dojox.gfx,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _69={};return function(_6a){var t=_69[_6a];if(t){return new t();}t=_69[_6a]=function(){};t.prototype=dojox.gfx["default"+_6a];return new t();};})(),normalizeColor:function(_6c){return (_6c instanceof dojo.Color)?_6c:new dojo.Color(_6c);},normalizeParameters:function(_6d,_6e){if(_6e){var _6f={};for(var x in _6d){if(x in _6e&&!(x in _6f)){_6d[x]=_6e[x];}}}return _6d;},makeParameters:function(_71,_72){if(!_72){return dojo.delegate(_71);}var _73={};for(var i in _71){if(!(i in _73)){_73[i]=dojo.clone((i in _72)?_72[i]:_71[i]);}}return _73;},formatNumber:function(x,_76){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _78=val.indexOf(".");if(_78>=0&&val.length-_78>5){val=x.toFixed(4);}}if(x<0){return val;}return _76?" "+val:val;},makeFontString:function(_79){return _79.style+" "+_79.variant+" "+_79.weight+" "+_79.size+" "+_79.family;},splitFontString:function(str){var _7b=dojox.gfx.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}_7b.style=t[0];_7b.varian=t[1];_7b.weight=t[2];var i=t[3].indexOf("/");_7b.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;break;}if(t[4].substr(0,1)=="/"){j=5;break;}}if(j+3>t.length){break;}_7b.size=t[j];_7b.family=t[j+1];}while(false);return _7b;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return dojox.gfx._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*dojox.gfx.px_in_pt();},px2pt:function(len){return len/dojox.gfx.px_in_pt();},normalizedLength:function(len){if(len.length==0){return 0;}if(len.length>2){var _82=dojox.gfx.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_82;case "in":return val*72*_82;case "pc":return val*12*_82;case "mm":return val*dojox.gfx.mm_in_pt*_82;case "cm":return val*dojox.gfx.cm_in_pt*_82;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a==b;}});}if(!dojo._hasResource["dojox.gfx"]){dojo._hasResource["dojox.gfx"]=true;dojo.provide("dojox.gfx");dojo.loadInit(function(){var gfx=dojo.getObject("dojox.gfx",true),sl,_88,_89;if(!gfx.renderer){var _8a=(typeof dojo.config.gfxRenderer=="string"?dojo.config.gfxRenderer:"svg,vml,silverlight,canvas").split(",");var ua=navigator.userAgent,_8c=0,_8d=0;if(dojo.isSafari>=3){if(ua.indexOf("iPhone")>=0||ua.indexOf("iPod")>=0){_89=ua.match(/Version\/(\d(\.\d)?(\.\d)?)\sMobile\/([^\s]*)\s?/);if(_89){_8c=parseInt(_89[4].substr(0,3),16);}}}if(dojo.isWebKit){if(!_8c){_89=ua.match(/Android\s+(\d+\.\d+)/);if(_89){_8d=parseFloat(_89[1]);}}}for(var i=0;i<_8a.length;++i){switch(_8a[i]){case "svg":if(!dojo.isIE&&(!_8c||_8c>=1521)&&!_8d&&!dojo.isAIR){dojox.gfx.renderer="svg";}break;case "vml":if(dojo.isIE){dojox.gfx.renderer="vml";}break;case "silverlight":try{if(dojo.isIE){sl=new ActiveXObject("AgControl.AgControl");if(sl&&sl.IsVersionSupported("1.0")){_88=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_88=true;}}}catch(e){_88=false;}finally{sl=null;}if(_88){dojox.gfx.renderer="silverlight";}break;case "canvas":if(!dojo.isIE){dojox.gfx.renderer="canvas";}break;}if(dojox.gfx.renderer){break;}}if(dojo.config.isDebug){console.log("gfx renderer = "+dojox.gfx.renderer);}}});dojo.requireIf(dojox.gfx.renderer=="svg","dojox.gfx.svg");dojo.requireIf(dojox.gfx.renderer=="vml","dojox.gfx.vml");dojo.requireIf(dojox.gfx.renderer=="silverlight","dojox.gfx.silverlight");dojo.requireIf(dojox.gfx.renderer=="canvas","dojox.gfx.canvas");}if(!dojo._hasResource["dojox.gfx.Mover"]){dojo._hasResource["dojox.gfx.Mover"]=true;dojo.provide("dojox.gfx.Mover");dojo.declare("dojox.gfx.Mover",null,{constructor:function(_8f,e,_91){this.shape=_8f;this.lastX=e.clientX;this.lastY=e.clientY;var h=this.host=_91,d=document,_94=dojo.connect(d,"onmousemove",this,"onFirstMove");this.events=[dojo.connect(d,"onmousemove",this,"onMouseMove"),dojo.connect(d,"onmouseup",this,"destroy"),dojo.connect(d,"ondragstart",dojo,"stopEvent"),dojo.connect(d,"onselectstart",dojo,"stopEvent"),_94];if(h&&h.onMoveStart){h.onMoveStart(this);}},onMouseMove:function(e){var x=e.clientX;var y=e.clientY;this.host.onMove(this,{dx:x-this.lastX,dy:y-this.lastY});this.lastX=x;this.lastY=y;dojo.stopEvent(e);},onFirstMove:function(){this.host.onFirstMove(this);dojo.disconnect(this.events.pop());},destroy:function(){dojo.forEach(this.events,dojo.disconnect);var h=this.host;if(h&&h.onMoveStop){h.onMoveStop(this);}this.events=this.shape=null;}});}if(!dojo._hasResource["dojox.gfx.Moveable"]){dojo._hasResource["dojox.gfx.Moveable"]=true;dojo.provide("dojox.gfx.Moveable");dojo.declare("dojox.gfx.Moveable",null,{constructor:function(_99,_9a){this.shape=_99;this.delay=(_9a&&_9a.delay>0)?_9a.delay:0;this.mover=(_9a&&_9a.mover)?_9a.mover:dojox.gfx.Mover;this.events=[this.shape.connect("onmousedown",this,"onMouseDown")];},destroy:function(){dojo.forEach(this.events,this.shape.disconnect,this.shape);this.events=this.shape=null;},onMouseDown:function(e){if(this.delay){this.events.push(this.shape.connect("onmousemove",this,"onMouseMove"));this.events.push(this.shape.connect("onmouseup",this,"onMouseUp"));this._lastX=e.clientX;this._lastY=e.clientY;}else{new this.mover(this.shape,e,this);}dojo.stopEvent(e);},onMouseMove:function(e){if(Math.abs(e.clientX-this._lastX)>this.delay||Math.abs(e.clientY-this._lastY)>this.delay){this.onMouseUp(e);new this.mover(this.shape,e,this);}dojo.stopEvent(e);},onMouseUp:function(e){this.shape.disconnect(this.events.pop());this.shape.disconnect(this.events.pop());},onMoveStart:function(_9e){dojo.publish("/gfx/move/start",[_9e]);dojo.addClass(dojo.body(),"dojoMove");},onMoveStop:function(_9f){dojo.publish("/gfx/move/stop",[_9f]);dojo.removeClass(dojo.body(),"dojoMove");},onFirstMove:function(_a0){},onMove:function(_a1,_a2){this.onMoving(_a1,_a2);this.shape.applyLeftTransform(_a2);this.onMoved(_a1,_a2);},onMoving:function(_a3,_a4){},onMoved:function(_a5,_a6){}});}if(!dojo._hasResource["dojox.gfx.move"]){dojo._hasResource["dojox.gfx.move"]=true;dojo.provide("dojox.gfx.move");}if(!dojo._hasResource["lucid.apps.Checkers"]){dojo._hasResource["lucid.apps.Checkers"]=true;dojo.provide("lucid.apps.Checkers");dojo.declare("lucid.apps.Checkers",lucid.apps._App,{init:function(_a7){var app=dojo.i18n.getLocalization("lucid","apps");this.win=new lucid.widget.Window({title:app["Checkers"],width:"400px",height:"400px",resizable:false,showMaximize:false,iconClass:this.iconClass,onClose:dojo.hitch(this,this.kill)});this.win.show();this.surface=dojox.gfx.createSurface(this.win.containerNode,400,400);this.drawBoard();this.win.startup();},kill:function(){if(!this.win.closed){this.win.close();}},drawBoard:function(){for(var i=0;i<400;i+=50){for(var j=0;j<400;j+=50){if(!(i%100==j%100)){this.surface.createRect({x:i,y:j,width:50,height:50}).setFill({type:"linear",x1:i,y1:j,x2:(i+50),y2:(j+50),colors:[{offset:0,color:"#888888"},{offset:1,color:"#222222"}]});}}}for(var i=0;i<400;i+=50){for(var j=0;j<400;j+=50){if(!(i%100==j%100)){if(j<150){this.makePiece({x:i+25,y:j+25,color:"red"});}else{if(j>200){this.makePiece({x:i+25,y:j+25,color:"black"});}}}}}},pieces:[],makePiece:function(c){var _ac=this.surface.createCircle({cx:c.x,cy:c.y,r:18}).setStroke({color:(c.color=="red"?[150,0,0,0.8]:"gray"),width:1});if(c.color=="red"){_ac.setFill({type:"radial",cx:c.x,cy:c.y,r:18,colors:[{offset:0,color:"#880000"},{offset:1,color:"#DD0000"}]});}else{_ac.setFill({type:"radial",cx:c.x,cy:c.y,r:18,colors:[{offset:0,color:"#000000"},{offset:1,color:"#444444"}]});}var _ad=new dojox.gfx.Moveable(_ac);_ac.checkMove=dojo.hitch(this,this.checkMove);_ac.checkKing=dojo.hitch(this,this.checkKing);_ac.connect("onmousedown",_ac,function(e){this.moveToFront();this.old_shape=this.getShape();this.old_pos=(this.getTransform()||{dx:0,dy:0});});var _af=this.win.containerNode;_ac.connect("onmouseup",_ac,function(e){var _b1=dojo.coords(_af,false);for(var c=0;c<=400;c+=50){if(e.clientY-_b1.y<=c&&e.clientY-_b1.y>=c-50){for(var v=0;v<=400;v+=50){if(e.clientX-_b1.x<=v&&e.clientX-_b1.x>=v-50){var os=this.old_shape;var pos=this.old_pos;var _b6={x:os.cx+pos.dx-25,y:os.cy+pos.dy-25};if(this.checkMove(_b6,v,c,this)){this.checkKing(v,c,this);this.setTransform({dx:(v+50)-os.cx-75,dy:(c+50)-os.cy-75});}else{var pos=this.getTransform();this.applyLeftTransform({dx:this.old_pos.dx-pos.dx,dy:this.old_pos.dy-pos.dy});}break;}}}}});_ac._checkers_color=c.color,_ac._checkers_king=false;_ac._checkers_id=this.pieceCount;this.pieces[this.pieces.length]={circle:_ac,movable:_ad,id:this.pieceCount};this.pieceCount++;},checkKing:function(x,y,_b9){if(_b9._checkers_color=="red"){if(y/50==8){_b9._checkers_king=true;_b9.setStroke("gold");}}if(_b9._checkers_color=="black"){if(y/50==1){_b9._checkers_king=true;_b9.setStroke("gold");}}},pieceCount:0,checkMove:function(_ba,x,y,_bd){if(!(x%100==y%100)){var _be=[];for(var i=1;i<=8;i++){_be[i]=[];}dojo.forEach(this.pieces,function(_c0){if(_c0){if(_c0.id!=_bd._checkers_id){var pos=_c0.circle.getShape();var _c2=(_c0.circle.getTransform()||{dx:0,dy:0});var c={x:pos.cx+_c2.dx-25,y:pos.cy+_c2.dy-25};if(typeof _be[c.x/50]=="undefined"){_be[c.x/50]=[];}_be[c.x/50][c.y/50]=_c0;}}});var _c4={x:Math.abs((_ba.x/50)-(x/50)+1),y:(_ba.y/50)-(y/50)+1};if(_bd._checkers_king){_c4.y=Math.abs(_c4.y);}else{if(_bd._checkers_color=="red"){_c4.y=-_c4.y;}}if(_c4.x==1&&_c4.y==1){if(typeof _be[(x/50)-1]!="undefined"&&typeof _be[(x/50)-1][(y/50)-1]=="undefined"){return true;}}else{if(_c4.x==2&&_c4.y==2){var ey=(((_ba.y/50)+(y/50))/2)-0.5;var ex=(((_ba.x/50)+(x/50))/2)-0.5;if(typeof _be[ex][ey]!="undefined"&&_be[ex][ey].circle._checkers_color!=_bd._checkers_color){if(typeof _be[(x/50)-1]!="undefined"&&typeof _be[(x/50)-1][(y/50)-1]=="undefined"){this.surface.remove(_be[ex][ey].circle);for(var i in this.pieces){var _c7=this.pieces[i];if(_c7){if(_c7.id==_be[ex][ey].id){this.pieces[i]=undefined;}}}return true;}}}}return false;}return false;}});}dojo.i18n._preloadLocalizations("lucid.apps.nls.Checkers",["ROOT","en","en-gb","en-us","es","es-es","fr","fr-fr","xx"]);
