<?php

/*
Widget Name: Slider
Description: Create a responsive slider of custom HTML content.
Author: LiveMesh
Author URI: https://www.livemeshthemes.com
*/

if (lsow_fs()->can_use_premium_code()) {
    class LSOW_Slider_Widget extends SiteOrigin_Widget {
        function __construct() {
            parent::__construct(
                "lsow-slider",
                __("Slider", "livemesh-so-widgets"),
                array(
                    "description" => __("Create a responsive slider of custom HTML content.", "livemesh-so-widgets"),
                    "panels_icon" => "dashicons dashicons-minus",
                    'help' => LSOW_PLUGIN_HELP_URL
                ),
                array(),
                array(
                    "title" => array(
                        "type" => "text",
                        "label" => __("Title", "livemesh-so-widgets"),
                    ),

                    "id" => array(
                        "type" => "text",
                        "description" => __("Set a ID for the slider. (optional).", "livemesh-so-widgets"),
                        "label" => __("ID", "livemesh-so-widgets"),
                    ),

                    "class" => array(
                        "type" => "text",
                        "description" => __("Set a unique CSS class for the slider. (optional).", "livemesh-so-widgets"),
                        "label" => __("Class", "livemesh-so-widgets"),
                    ),

                    'slides' => array(
                        'type' => 'repeater',
                        'label' => __('HTML Slides', 'livemesh-so-widgets'),
                        'item_name' => __('HTML Slide', 'livemesh-so-widgets'),
                        'item_label' => array(
                            'selector' => "[id*='slides-name']",
                            'update_event' => 'change',
                            'value_method' => 'val'
                        ),
                        'fields' => array(
                            'name' => array(
                                'type' => 'text',
                                'label' => __('Name', 'livemesh-so-widgets'),
                                'description' => __('The title to identify the HTML slide', 'livemesh-so-widgets'),
                            ),

                            'text' => array(
                                'type' => 'tinymce',
                                'label' => __('HTML element', 'livemesh-so-widgets'),
                                'description' => __('The HTML content for the slide.', 'livemesh-so-widgets'),
                            ),
                        )
                    ),

                    'settings' => array(
                        'type' => 'section',
                        'label' => __('Slider Settings', 'livemesh-so-widgets'),
                        'fields' => array(

                            "animation" => array(
                                "type" => "select",
                                "description" => __("Select your animation type.", "livemesh-so-widgets"),
                                "label" => __("Animation", "livemesh-so-widgets"),
                                "options" => array(
                                    "slide" => __("Slide", "livemesh-so-widgets"),
                                    "fade" => __("Fade", "livemesh-so-widgets"),
                                ),
                                "default" => "slide",
                            ),
                            "direction" => array(
                                "type" => "select",
                                "description" => __("Select the sliding direction.", "livemesh-so-widgets"),
                                "label" => __("Sliding Direction", "livemesh-so-widgets"),
                                "options" => array(
                                    "horizontal" => __("Horizontal", "livemesh-so-widgets"),
                                    "vertical" => __("Vertical", "livemesh-so-widgets"),
                                ),
                                "default" => "horizontal",
                            ),
                            "control_nav" => array(
                                "type" => "checkbox",
                                "description" => __("Create navigation for paging control of each slide?", "livemesh-so-widgets"),
                                "label" => __("Control navigation?", "livemesh-so-widgets"),
                                "default" => true,
                            ),
                            "direction_nav" => array(
                                "type" => "checkbox",
                                "description" => __("Create navigation for previous/next navigation?", "livemesh-so-widgets"),
                                "label" => __("Direction navigation?", "livemesh-so-widgets"),
                                "default" => false,
                            ),
                            "randomize" => array(
                                "type" => "checkbox",
                                "description" => __("Randomize slide order?", "livemesh-so-widgets"),
                                "label" => __("Randomize slides?", "livemesh-so-widgets"),
                                "default" => false,
                            ),
                            "pause_on_hover" => array(
                                "type" => "checkbox",
                                "description" => __("Pause the slideshow when hovering over slider, then resume when no longer hovering.", "livemesh-so-widgets"),
                                "label" => __("Pause on hover?", "livemesh-so-widgets"),
                                "default" => true,
                            ),
                            "pause_on_action" => array(
                                "type" => "checkbox",
                                "description" => __("Pause the slideshow when interacting with control elements.", "livemesh-so-widgets"),
                                "label" => __("Pause on action?", "livemesh-so-widgets"),
                                "default" => true,
                            ),
                            "loop" => array(
                                "type" => "checkbox",
                                "description" => __("Should the animation loop?", "livemesh-so-widgets"),
                                "label" => __("Loop", "livemesh-so-widgets"),
                                "default" => true,
                            ),
                            "slideshow" => array(
                                "type" => "checkbox",
                                "description" => __("Animate slider automatically without user intervention?", "livemesh-so-widgets"),
                                "label" => __("Slideshow", "livemesh-so-widgets"),
                                "default" => true,
                            ),
                            "slideshow_speed" => array(
                                "type" => "number",
                                "description" => __("Set the speed of the slideshow cycling, in milliseconds", "livemesh-so-widgets"),
                                "label" => __("Slideshow speed", "livemesh-so-widgets"),
                                "default" => 5000,
                            ),
                            "animation_speed" => array(
                                "type" => "number",
                                "description" => __("Set the speed of animations, in milliseconds.", "livemesh-so-widgets"),
                                "label" => __("Animation speed", "livemesh-so-widgets"),
                                "default" => 600,
                            ),
                        )
                    )
                )
            );
        }

        function initialize() {

            $this->register_frontend_scripts(
                array(
                    array(
                        'lsow-flexslider',
                        LSOW_PLUGIN_URL . 'assets/js/jquery.flexslider' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                )
            );

            $this->register_frontend_styles(
                array(
                    array(
                        'lsow-flexslider',
                        LSOW_PLUGIN_URL . 'assets/css/flexslider.css',
                        array(),
                        LSOW_VERSION
                    )
                )
            );

            $this->register_frontend_scripts(array(
                array(
                    'lsow-slider',
                    plugin_dir_url(__FILE__) . 'js/slider' . LSOW_JS_SUFFIX . '.js',
                    array('lsow-flexslider')
                )
            ));

            $this->register_frontend_styles(array(
                array(
                    'lsow-slider',
                    plugin_dir_url(__FILE__) . 'css/style.css'
                )
            ));

        }

        function get_template_variables($instance, $args) {
            return array(

                "id" => $instance["id"],

                "class" => $instance["class"],

                'settings' => $instance['settings'],

                'slides' => !empty($instance['slides']) ? $instance['slides'] : array(),
            );
        }

    }

    siteorigin_widget_register("lsow-slider", __FILE__, "LSOW_Slider_Widget");

}
