<?php

/*
Widget Name: Posts Block
Description: Display your blog posts or custom post types in a filterable block list layout.
Author: LiveMesh
Author URI: https://www.livemeshthemes.com
*/

if (lsow_fs()->can_use_premium_code()) {
    class LSOW_Posts_Block_Widget extends SiteOrigin_Widget {

        static public $block_counter = 0;

        function __construct() {
            parent::__construct(
                'lsow-posts-block',
                __('Posts Block', 'livemesh-so-widgets'),
                array(
                    'description' => __('Showcase your blog posts or any custom post types in a filterable block list layout.', 'livemesh-so-widgets'),
                    'panels_icon' => 'dashicons dashicons-minus',
                    'help' => LSOW_PLUGIN_HELP_URL . '#posts-block-widget'
                ),
                array(),
                false,
                plugin_dir_path(__FILE__)
            );
        }

        function initialize() {

            $this->register_frontend_scripts(
                array(
                    array(
                        'lsow-fancybox',
                        LSOW_PLUGIN_URL . 'assets/js/premium/jquery.fancybox' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-blocks',
                        LSOW_PLUGIN_URL . 'assets/js/premium/lsow-blocks' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                )
            );

            $this->register_frontend_styles(
                array(
                    array(
                        'lsow-icomoon-styles',
                        LSOW_PLUGIN_URL . 'assets/css/icomoon.css',
                        array(),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-fancybox',
                        LSOW_PLUGIN_URL . 'assets/css/premium/jquery.fancybox.css',
                        array(),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-frontend-styles',
                        LSOW_PLUGIN_URL . 'assets/css/lsow-frontend.css',
                        array(),
                        LSOW_VERSION
                    ),

                    array(
                        'lsow-premium-frontend-styles',
                        LSOW_PLUGIN_URL . 'assets/css/premium/lsow-frontend.css',
                        array(),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-block-styles',
                        LSOW_PLUGIN_URL . 'assets/css/premium/lsow-blocks.css',
                        array(),
                        LSOW_VERSION
                    ),

                )
            );

            $this->register_frontend_scripts(array(
                    array(
                        'lsow-posts-block',
                        plugin_dir_url(__FILE__) . 'js/posts-block' . LSOW_JS_SUFFIX . '.js',
                        array('jquery')
                    )
                )
            );

            $this->register_frontend_styles(array(
                    array(
                        'lsow-posts-block',
                        plugin_dir_url(__FILE__) . 'css/style.css'
                    )
                )
            );

            add_action('wp_enqueue_scripts', array($this, 'localize_scripts'), 999999);

        }

        public function localize_scripts() {

            /* Do not attach to widget scripts since they are enqueued really late for some reason */
            wp_localize_script('lsow-frontend-scripts', 'lsow_ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));

        }

        function get_widget_form() {
            return array(
                'title' => array(
                    'type' => 'text',
                    'label' => __('Title', 'livemesh-so-widgets'),
                ),

                'block_class' => array(
                    'type' => 'text',
                    'label' => __('Block Class/Identifier', 'livemesh-so-widgets'),
                    'description' => __('Specify an unique identifier used as a custom CSS class name and lightbox group name/slug for the block element.', 'livemesh-so-widgets'),
                ),

                'heading' => array(
                    'type' => 'text',
                    'label' => __('Heading for the block', 'livemesh-so-widgets'),
                ),

                'heading_url' => array(
                    'type' => 'link',
                    'label' => __('URL for the heading', 'livemesh-so-widgets'),
                ),

                'header_template' => array(
                    'type' => 'select',
                    'label' => __('Choose Header Style', 'livemesh-so-widgets'),
                    'state_emitter' => array(
                        'callback' => 'select',
                        'args' => array('header_template')
                    ),
                    'default' => 'block_header_1',
                    'options' => array(
                        'block_header_1' => __('Header Style 1', 'livemesh-so-widgets'),
                        'block_header_2' => __('Header Style 2', 'livemesh-so-widgets'),
                        'block_header_3' => __('Header Style 3', 'livemesh-so-widgets'),
                        'block_header_4' => __('Header Style 4', 'livemesh-so-widgets'),
                        'block_header_5' => __('Header Style 5', 'livemesh-so-widgets'),
                        'block_header_6' => __('Header Style 6', 'livemesh-so-widgets'),
                        'block_header_7' => __('Header Style 7', 'livemesh-so-widgets'),
                    )
                ),

                'block_type' => array(
                    'type' => 'select',
                    'label' => __('Choose Block Style', 'livemesh-so-widgets'),
                    'state_emitter' => array(
                        'callback' => 'select',
                        'args' => array('block_type')
                    ),
                    'default' => 'block_1',
                    'options' => array(
                        'block_1' => __('Block Style 1', 'livemesh-so-widgets'),
                        'block_2' => __('Block Style 2', 'livemesh-so-widgets'),
                        'block_3' => __('Block Style 3', 'livemesh-so-widgets'),
                        'block_4' => __('Block Style 4', 'livemesh-so-widgets'),
                        'block_5' => __('Block Style 5', 'livemesh-so-widgets'),
                        'block_6' => __('Block Style 6', 'livemesh-so-widgets'),
                        'block_7' => __('Block Style 7', 'livemesh-so-widgets'),
                        'block_8' => __('Block Style 8', 'livemesh-so-widgets'),
                        'block_9' => __('Block Style 9', 'livemesh-so-widgets'),
                        'block_10' => __('Block Style 10', 'livemesh-so-widgets'),
                        'block_11' => __('Block Style 11', 'livemesh-so-widgets'),
                        'block_12' => __('Block Style 12', 'livemesh-so-widgets'),
                        'block_13' => __('Block Style 13', 'livemesh-so-widgets'),
                    )
                ),

                'posts' => array(
                    'type' => 'posts',
                    'label' => __('Posts query', 'livemesh-so-widgets'),
                    'description' => __('After you build the query, make sure you choose the right taxonomy below to display for your posts and filter on, based on the post type selected during build query.', 'livemesh-so-widgets'),
                ),

                'taxonomy_chosen' => array(
                    'type' => 'select',
                    'label' => __('Choose the taxonomy to display and filter on.', 'livemesh-so-widgets'),
                    'description' => __('Choose the taxonomy information to display for posts and the taxonomy that is used to filter the posts. Takes effect only if no taxonomy filters are specified when building query.', 'livemesh-so-widgets'),
                    'options' => lsow_get_taxonomies_map(),
                    'default' => 'category',
                ),

                'settings' => array(
                    'type' => 'section',
                    'label' => __('Settings', 'livemesh-so-widgets'),
                    'fields' => array(

                        'per_line1' => array(
                            'type' => 'slider',
                            'label' => __('Posts per row', 'livemesh-so-widgets'),
                            'min' => 1,
                            'max' => 3,
                            'integer' => true,
                            'default' => 2,
                            'state_handler' => array(
                                'block_type[block_1,block_3,block_11,block_12]' => array('show'),
                                '_else[block_type]' => array('hide'),
                            ),
                        ),

                        'per_line2' => array(
                            'type' => 'slider',
                            'label' => __('Posts per row', 'livemesh-so-widgets'),
                            'min' => 1,
                            'max' => 6,
                            'integer' => true,
                            'default' => 3,
                            'state_handler' => array(
                                'block_type[block_2,block_4,block_5,block_6,block_10]' => array('show'),
                                '_else[block_type]' => array('hide'),
                            ),
                        ),

                        'per_line2_tablet' => array(
                            'type' => 'slider',
                            'label' => __('Posts per row in Tablet Resolution', 'livemesh-so-widgets'),
                            'min' => 1,
                            'max' => 6,
                            'integer' => true,
                            'default' => 2,
                            'state_handler' => array(
                                'block_type[block_2,block_4,block_5,block_6,block_10]' => array('show'),
                                '_else[block_type]' => array('hide'),
                            ),
                        ),

                        'per_line2_mobile' => array(
                            'type' => 'slider',
                            'label' => __('Posts per row in Mobile Resolution', 'livemesh-so-widgets'),
                            'min' => 1,
                            'max' => 4,
                            'integer' => true,
                            'default' => 1,
                            'state_handler' => array(
                                'block_type[block_2,block_4,block_5,block_6,block_10]' => array('show'),
                                '_else[block_type]' => array('hide'),
                            ),
                        ),

                        'filterable' => array(
                            'type' => 'checkbox',
                            'label' => __('Filterable?', 'livemesh-so-widgets'),
                            'default' => true
                        ),

                        'excerpt_length' => array(
                            'type' => 'number',
                            'description' => __('Provide the excerpt length in number of words.', 'livemesh-so-widgets'),
                            'label' => __('Excerpt Length?', 'livemesh-so-widgets'),
                            'default' => 25,
                        ),

                        'pagination' => array(
                            'type' => 'select',
                            'label' => __('AJAX Pagination', 'livemesh-so-widgets'),
                            'description' => __('Choose AJAX pagination type or choose None if no pagination is desired. Make sure the \'Post per page\' field value is set in the Build Query window to control number of posts to display per page.', 'livemesh-so-widgets'),
                            'default' => 'none',
                            'state_emitter' => array(
                                'callback' => 'select',
                                'args' => array('pagination')
                            ),
                            'options' => array(
                                'none' => __('None', 'livemesh-so-widgets'),
                                'next_prev' => __('Next Prev', 'livemesh-so-widgets'),
                                'paged' => __('Paged', 'livemesh-so-widgets'),
                                'load_more' => __('Load More', 'livemesh-so-widgets'),
                            ),
                        ),

                        'show_remaining' => array(
                            'type' => 'checkbox',
                            'label' => __('Display count of posts yet to be loaded with the load more button?', 'livemesh-so-widgets'),
                            'default' => true,
                            'state_handler' => array(
                                'pagination[load_more]' => array('show'),
                                '_else[pagination]' => array('hide'),
                            ),
                        ),

                        'image_linkable' => array(
                            'type' => 'checkbox',
                            'label' => __('Link the image to the post or custom post type?', 'livemesh-so-widgets'),
                            'default' => true
                        ),

                        'post_link_new_window' => array(
                            'type' => 'checkbox',
                            'label' => __('Open post links in new window?', 'livemesh-so-widgets'),
                            'default' => false
                        ),

                        'image_size' => array(
                            'type' => 'image-size',
                            'label' => __('Image Size', 'livemesh-so-widgets'),
                            'default' => 'large',
                        ),

                        'enable_lightbox' => array(
                            'type' => 'checkbox',
                            'label' => __('Enable Lightbox Gallery?', 'livemesh-so-widgets'),
                            'default' => false
                        ),

                        'post_data' => array(
                            'type' => 'section',
                            'label' => __('Post Data', 'livemesh-so-widgets'),
                            'fields' => array(

                                'display_title' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Display post title below the post or custom post type?', 'livemesh-so-widgets'),
                                    'default' => true
                                ),

                                'display_summary' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Display post excerpt/summary below the post or custom post type?', 'livemesh-so-widgets'),
                                    'default' => true
                                ),

                                'rich_text_excerpt' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Preserve shortcodes/HTML tags in excerpt?', 'livemesh-so-widgets'),
                                    'default' => false,
                                ),

                                'display_excerpt_lightbox' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Display post excerpt/summary in the lightbox?', 'livemesh-so-widgets'),
                                    'default' => true,
                                ),

                                'post_meta' => array(
                                    'type' => 'section',
                                    'label' => __('Post Meta', 'livemesh-so-widgets'),
                                    'fields' => array(

                                        'display_author' => array(
                                            'type' => 'checkbox',
                                            'label' => __('Display post author info below the post item?', 'livemesh-so-widgets'),
                                            'default' => true
                                        ),

                                        'display_post_date' => array(
                                            'type' => 'checkbox',
                                            'label' => __('Display post date info below the post item?', 'livemesh-so-widgets'),
                                            'default' => true
                                        ),

                                        'display_comments' => array(
                                            'type' => 'checkbox',
                                            'label' => __('Display comments number below the post item?', 'livemesh-so-widgets'),
                                            'default' => true
                                        ),

                                        'display_taxonomy' => array(
                                            'type' => 'checkbox',
                                            'label' => __('Display taxonomy info for the post item?', 'livemesh-so-widgets'),
                                            'default' => true
                                        ),

                                    )

                                ),

                            )

                        ),
                    )
                ),
            );
        }

        function modify_form($form) {

            $form['taxonomy_chosen']['options'] = lsow_get_taxonomies_map();
            return $form;
        }

        function get_less_variables($instance) {

            $vars = array();

            $options = get_option('lsow_settings');

            if ($options && isset($options['lsow_theme_color']))
                $vars['theme_color'] = $options['lsow_theme_color'];

            return $vars;
        }

        function get_template_variables($instance, $args) {

            $settings = array(

                'block_type' => $instance['block_type'],
                'posts' => $instance['posts'],
                'taxonomy_chosen' => $instance['taxonomy_chosen'],
                'heading' => $instance['heading'],
                'heading_url' => $instance['heading_url'],
                'header_template' => $instance['header_template'],

                'per_line1' => $instance['settings']['per_line1'],
                'per_line2' => $instance['settings']['per_line2'],
                'per_line2_tablet' => $instance['settings']['per_line2_tablet'],
                'per_line2_mobile' => $instance['settings']['per_line2_mobile'],
                'filterable' => $instance['settings']['filterable'],
                'pagination' => $instance['settings']['pagination'],
                'show_remaining' => $instance['settings']['show_remaining'],
                'excerpt_length' => $instance['settings']['excerpt_length'],
                'image_linkable' => $instance['settings']['image_linkable'],
                'post_link_new_window' => $instance['settings']['post_link_new_window'],
                'enable_lightbox' => $instance['settings']['enable_lightbox'],
                'image_size' => $instance['settings']['image_size'],

                'display_title' => $instance['settings']['post_data']['display_title'],
                'display_summary' => $instance['settings']['post_data']['display_summary'],
                'rich_text_excerpt' => $instance['settings']['post_data']['rich_text_excerpt'],
                'display_excerpt_lightbox' => $instance['settings']['post_data']['display_excerpt_lightbox'],
                'display_author' => $instance['settings']['post_data']['post_meta']['display_author'],
                'display_post_date' => $instance['settings']['post_data']['post_meta']['display_post_date'],
                'display_comments' => $instance['settings']['post_data']['post_meta']['display_comments'],
                'display_taxonomy' => $instance['settings']['post_data']['post_meta']['display_taxonomy'],
            );

            return array('settings' => $settings);
        }

    }

    siteorigin_widget_register('lsow-posts-block', __FILE__, 'LSOW_Posts_Block_Widget');

}