jQuery(function ($) {

    $('.lsow-block-posts').each(function () {

        if ($(this).find('.lsow-module').length === 0) {
            return; // no items to display or load and hence don't continue
        }

        var currentBlockObj = lsowBlocks.getBlockObjById($(this).data('block-uid'));

        /* ----------- Reorganize Filters when device width changes -------------- */

        /* https://stackoverflow.com/questions/24460808/efficient-way-of-using-window-resize-or-other-method-to-fire-jquery-functions */
        var lsowResizeTimeout;

        $(window).resize(function () {

            if (!!lsowResizeTimeout) {
                clearTimeout(lsowResizeTimeout);
            }

            lsowResizeTimeout = setTimeout(function () {

                currentBlockObj.organizeFilters();

            }, 200);
        });

        /* -------------- Taxonomy Filter --------------- */

        $(this).find('.lsow-taxonomy-filter .lsow-filter-item a, .lsow-block-filter .lsow-block-filter-item a').on('click', function (e) {

            e.preventDefault();

            currentBlockObj.handleFilterAction($(this));

            return false;
        });

        /* ------------------- Pagination ---------------------- */

        $(this).find('.lsow-pagination a.lsow-page-nav').on('click', function (e) {

            e.preventDefault();

            currentBlockObj.handlePageNavigation($(this));

        });

        /*---------------- Load More Button --------------------- */

        $(this).find('.lsow-pagination a.lsow-load-more').on('click', function (e) {

            e.preventDefault();

            currentBlockObj.handleLoadMore($(this));

        });

        /* ---------------------- Init Lightbox ---------------------- */

        currentBlockObj.initLightbox($(this));


    });

});