<?php

/*
Widget Name: Posts Grid
Description: Display posts or custom post types in a multi-column grid.
Author: LiveMesh
Author URI: https://www.livemeshthemes.com
*/

if (lsow_fs()->can_use_premium_code()) {
    class LSOW_Portfolio_Widget extends SiteOrigin_Widget {

        static public $grid_counter = 0;

        function __construct() {
            parent::__construct(
                'lsow-portfolio',
                __('Posts Grid', 'livemesh-so-widgets'),
                array(
                    'description' => __('Showcase your work or posts or any custom post types with a filterable portfolio layout. Make sure that Portfolio Post Type plugin is activated', 'livemesh-so-widgets'),
                    'panels_icon' => 'dashicons dashicons-minus',
                    'help' => LSOW_PLUGIN_HELP_URL . '#grid-widget'
                ),
                array(),
                false,
                plugin_dir_path(__FILE__)
            );
        }

        function initialize() {

            $this->register_frontend_scripts(
                array(
                    array(
                        'lsow-isotope',
                        LSOW_PLUGIN_URL . 'assets/js/isotope.pkgd' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-imagesloaded',
                        LSOW_PLUGIN_URL . 'assets/js/imagesloaded.pkgd' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-fancybox',
                        LSOW_PLUGIN_URL . 'assets/js/premium/jquery.fancybox' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-blocks',
                        LSOW_PLUGIN_URL . 'assets/js/premium/lsow-blocks' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                )
            );

            $this->register_frontend_styles(
                array(
                    array(
                        'lsow-icomoon-styles',
                        LSOW_PLUGIN_URL . 'assets/css/icomoon.css',
                        array(),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-fancybox',
                        LSOW_PLUGIN_URL . 'assets/css/premium/jquery.fancybox.css',
                        array(),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-frontend-styles',
                        LSOW_PLUGIN_URL . 'assets/css/lsow-frontend.css',
                        array(),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-premium-frontend-styles',
                        LSOW_PLUGIN_URL . 'assets/css/premium/lsow-frontend.css',
                        array(),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-block-styles',
                        LSOW_PLUGIN_URL . 'assets/css/premium/lsow-blocks.css',
                        array(),
                        LSOW_VERSION
                    ),
                )
            );

            $this->register_frontend_scripts(array(
                    array(
                        'lsow-portfolio',
                        plugin_dir_url(__FILE__) . 'js/portfolio' . LSOW_JS_SUFFIX . '.js',
                        array('jquery')
                    )
                )
            );

            $this->register_frontend_styles(array(
                    array(
                        'lsow-portfolio',
                        plugin_dir_url(__FILE__) . 'css/style.css'
                    )
                )
            );

            add_action('wp_enqueue_scripts', array($this, 'localize_scripts'), 999999);

        }

        public function localize_scripts() {

            /* Do not attach to widget scripts since they are enqueued really late for some reason */
            wp_localize_script('lsow-frontend-scripts', 'lsow_ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));

        }

        function get_widget_form() {
            return array(
                'title' => array(
                    'type' => 'text',
                    'label' => __('Title', 'livemesh-so-widgets'),
                ),

                'grid_class' => array(
                    'type' => 'text',
                    'label' => __('Grid Class/Identifier', 'livemesh-so-widgets'),
                    'description' => __('Specify an unique identifier used as a custom CSS class name and lightbox group name/slug for the grid element.', 'livemesh-so-widgets'),
                ),

                'heading' => array(
                    'type' => 'text',
                    'label' => __('Heading for the grid', 'livemesh-so-widgets'),
                ),

                'heading_url' => array(
                    'type' => 'link',
                    'label' => __('URL for the heading', 'livemesh-so-widgets'),
                ),

                'header_template' => array(
                    'type' => 'select',
                    'label' => __('Choose Header Style', 'livemesh-so-widgets'),
                    'state_emitter' => array(
                        'callback' => 'select',
                        'args' => array('header_template')
                    ),
                    'default' => 'block_header_6',
                    'options' => array(
                        'block_header_1' => __('Header Style 1', 'livemesh-so-widgets'),
                        'block_header_2' => __('Header Style 2', 'livemesh-so-widgets'),
                        'block_header_3' => __('Header Style 3', 'livemesh-so-widgets'),
                        'block_header_4' => __('Header Style 4', 'livemesh-so-widgets'),
                        'block_header_5' => __('Header Style 5', 'livemesh-so-widgets'),
                        'block_header_6' => __('Header Style 6', 'livemesh-so-widgets'),
                        'block_header_7' => __('Header Style 7', 'livemesh-so-widgets'),
                    )
                ),

                'block_type' => array(
                    'type' => 'select',
                    'label' => __('Choose Grid Style', 'livemesh-so-widgets'),
                    'state_emitter' => array(
                        'callback' => 'select',
                        'args' => array('block_type')
                    ),
                    'default' => 'block_grid_1',
                    'options' => array(
                        'block_grid_1' => __('Grid Style 1', 'livemesh-so-widgets'),
                        'block_grid_2' => __('Grid Style 2', 'livemesh-so-widgets'),
                        'block_grid_3' => __('Grid Style 3', 'livemesh-so-widgets'),
                        'block_grid_4' => __('Grid Style 4', 'livemesh-so-widgets'),
                        'block_grid_5' => __('Grid Style 5', 'livemesh-so-widgets'),
                        'block_grid_6' => __('Grid Style 6', 'livemesh-so-widgets'),
                    )
                ),

                'posts' => array(
                    'type' => 'posts',
                    'label' => __('Posts query', 'livemesh-so-widgets'),
                    'description' => __('After you build the query, make sure you choose the right taxonomy below to display for your posts and filter on, based on the post type selected during build query.', 'livemesh-so-widgets'),
                ),

                'taxonomy_filter' => array(
                    'type' => 'select',
                    'label' => __('Choose the taxonomy to display and filter on.', 'livemesh-so-widgets'),
                    'description' => __('Choose the taxonomy information to display for posts/portfolio and the taxonomy that is used to filter the portfolio/post. Takes effect only if no taxonomy filters are specified when building query.', 'livemesh-so-widgets'),
                    'options' => lsow_get_taxonomies_map(),
                    'default' => 'portfolio_category',
                ),

                'settings' => array(
                    'type' => 'section',
                    'label' => __('Settings', 'livemesh-so-widgets'),
                    'fields' => array(

                        'filterable' => array(
                            'type' => 'checkbox',
                            'label' => __('Filterable?', 'livemesh-so-widgets'),
                            'default' => true
                        ),

                        'layout_mode' => array(
                            'type' => 'select',
                            'label' => __('Choose a layout for the grid', 'livemesh-so-widgets'),
                            'state_emitter' => array(
                                'callback' => 'select',
                                'args' => array('layout_mode')
                            ),
                            'default' => 'fitRows',
                            'options' => array(
                                'fitRows' => __('Fit Rows', 'livemesh-so-widgets'),
                                'masonry' => __('Masonry', 'livemesh-so-widgets'),
                            )
                        ),

                        'pagination' => array(
                            'type' => 'select',
                            'label' => __('Pagination', 'livemesh-so-widgets'),
                            'description' => __('Choose pagination type or choose None if no pagination is desired. Make sure the \'Post per page\' field value is set in the Build Query window to control number of posts to display per page.', 'livemesh-so-widgets'),
                            'default' => 'none',
                            'state_emitter' => array(
                                'callback' => 'select',
                                'args' => array('pagination')
                            ),
                            'options' => array(
                                'none' => __('None', 'livemesh-so-widgets'),
                                'next_prev' => __('Next Prev', 'livemesh-so-widgets'),
                                'paged' => __('Paged', 'livemesh-so-widgets'),
                                'load_more' => __('Load More', 'livemesh-so-widgets'),
                            ),
                        ),

                        'show_remaining' => array(
                            'type' => 'checkbox',
                            'label' => __('Display count of posts yet to be loaded with the load more button?', 'livemesh-so-widgets'),
                            'default' => true,
                            'state_handler' => array(
                                'pagination[load_more]' => array('show'),
                                '_else[pagination]' => array('hide'),
                            ),
                        ),

                        'image_linkable' => array(
                            'type' => 'checkbox',
                            'label' => __('Link the image to the post/portfolio?', 'livemesh-so-widgets'),
                            'default' => true
                        ),

                        'post_link_new_window' => array(
                            'type' => 'checkbox',
                            'label' => __('Open post links in new window?', 'livemesh-so-widgets'),
                            'default' => false
                        ),

                        'image_size' => array(
                            'type' => 'image-size',
                            'label' => __('Image Size', 'livemesh-so-widgets'),
                            'default' => 'large',
                        ),

                        'enable_lightbox' => array(
                            'type' => 'checkbox',
                            'label' => __('Enable Lightbox Gallery?', 'livemesh-so-widgets'),
                            'default' => true
                        ),

                        'post_data' => array(
                            'type' => 'section',
                            'label' => __('Post Data', 'livemesh-so-widgets'),
                            'fields' => array(

                                'display_title_on_thumbnail' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Display project title on post/project thumbnail?', 'livemesh-so-widgets'),
                                    'default' => true,
                                    'state_handler' => array(
                                        'block_type[block_grid_1,block_grid_6]' => array('show'),
                                        '_else[block_type]' => array('hide'),
                                    ),
                                ),

                                'display_taxonomy_on_thumbnail' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Display taxonomy info on post/project thumbnail?', 'livemesh-so-widgets'),
                                    'default' => false,
                                    'state_handler' => array(
                                        'block_type[block_grid_1,block_grid_6]' => array('show'),
                                        '_else[block_type]' => array('hide'),
                                    ),
                                ),

                                'display_title' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Display project/post title?', 'livemesh-so-widgets'),
                                    'default' => true,
                                ),

                                'display_summary' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Display project/post excerpt/summary?', 'livemesh-so-widgets'),
                                    'default' => true,
                                    'state_handler' => array(
                                        'block_type[block_grid_2,block_grid_5]' => array('hide'),
                                        '_else[block_type]' => array('show'),
                                    ),
                                ),

                                'rich_text_excerpt' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Preserve shortcodes/HTML tags in excerpt?', 'livemesh-so-widgets'),
                                    'default' => false,
                                    'state_handler' => array(
                                        'block_type[block_grid_2,block_grid_5]' => array('hide'),
                                        '_else[block_type]' => array('show'),
                                    ),
                                ),

                                'excerpt_length' => array(
                                    'type' => 'number',
                                    'description' => __('Provide the excerpt length in number of words.', 'livemesh-so-widgets'),
                                    'label' => __('Excerpt Length?', 'livemesh-so-widgets'),
                                    'default' => 25,
                                    'state_handler' => array(
                                        'block_type[block_grid_2,block_grid_5]' => array('hide'),
                                        '_else[block_type]' => array('show'),
                                    ),
                                ),

                                'display_read_more' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Display read more link to the post/portfolio?', 'livemesh-so-widgets'),
                                    'default' => false,
                                    'state_handler' => array(
                                        'block_type[block_grid_2,block_grid_5]' => array('hide'),
                                        '_else[block_type]' => array('show'),
                                    ),
                                ),

                                'display_excerpt_lightbox' => array(
                                    'type' => 'checkbox',
                                    'label' => __('Display post excerpt/summary in the lightbox?', 'livemesh-so-widgets'),
                                    'default' => true,
                                ),

                                'post_meta' => array(
                                    'type' => 'section',
                                    'label' => __('Post Meta', 'livemesh-so-widgets'),
                                    'fields' => array(

                                        'display_author' => array(
                                            'type' => 'checkbox',
                                            'label' => __('Display post author info?', 'livemesh-so-widgets'),
                                            'default' => true,
                                            'state_handler' => array(
                                                'block_type[block_grid_5]' => array('hide'),
                                                '_else[block_type]' => array('show'),
                                            ),
                                        ),

                                        'display_post_date' => array(
                                            'type' => 'checkbox',
                                            'label' => __('Display post date info?', 'livemesh-so-widgets'),
                                            'default' => true,
                                            'state_handler' => array(
                                                'block_type[block_grid_5]' => array('hide'),
                                                '_else[block_type]' => array('show'),
                                            ),
                                        ),

                                        'display_comments' => array(
                                            'type' => 'checkbox',
                                            'label' => __('Display comments number for the post item?', 'livemesh-so-widgets'),
                                            'default' => false,
                                            'state_handler' => array(
                                                'block_type[block_grid_5]' => array('hide'),
                                                '_else[block_type]' => array('show'),
                                            ),
                                        ),

                                        'display_taxonomy' => array(
                                            'type' => 'checkbox',
                                            'label' => __('Display taxonomy info?', 'livemesh-so-widgets'),
                                            'default' => true
                                        ),

                                    )

                                ),

                            )

                        ),

                        'per_line' => array(
                            'type' => 'slider',
                            'label' => __('Columns per row', 'livemesh-so-widgets'),
                            'min' => 1,
                            'max' => 6,
                            'integer' => true,
                            'default' => 3
                        ),

                        'per_line_tablet' => array(
                            'type' => 'slider',
                            'label' => __('Columns per row in Tablet Resolution', 'livemesh-so-widgets'),
                            'min' => 1,
                            'max' => 6,
                            'integer' => true,
                            'default' => 2
                        ),

                        'per_line_mobile' => array(
                            'type' => 'slider',
                            'label' => __('Columns per row in Mobile Resolution', 'livemesh-so-widgets'),
                            'min' => 1,
                            'max' => 4,
                            'integer' => true,
                            'default' => 1
                        ),

                        'gutter' => array(
                            'type' => 'number',
                            'label' => __('Gutter', 'livemesh-so-widgets'),
                            'description' => __('Space between columns in masonry grid.', 'livemesh-so-widgets'),
                            'default' => 20
                        ),

                        'responsive' => array(
                            'type' => 'section',
                            'label' => __('Responsive', 'livemesh-so-widgets'),
                            'hide' => true,
                            'fields' => array(
                                'tablet' => array(
                                    'type' => 'section',
                                    'label' => __('Tablet', 'livemesh-so-widgets'),
                                    'fields' => array(

                                        'gutter' => array(
                                            'type' => 'number',
                                            'label' => __('Gutter', 'livemesh-so-widgets'),
                                            'description' => __('Space between columns.', 'livemesh-so-widgets'),
                                            'default' => 10
                                        ),

                                        'width' => array(
                                            'type' => 'text',
                                            'label' => __('Resolution', 'livemesh-so-widgets'),
                                            'description' => __('The resolution to treat as a tablet resolution.', 'livemesh-so-widgets'),
                                            'default' => 800,
                                            'sanitize' => 'intval',
                                        )
                                    )
                                ),
                                'mobile' => array(
                                    'type' => 'section',
                                    'label' => __('Mobile Phone', 'livemesh-so-widgets'),
                                    'fields' => array(

                                        'gutter' => array(
                                            'type' => 'number',
                                            'label' => __('Gutter', 'livemesh-so-widgets'),
                                            'description' => __('Space between columns.', 'livemesh-so-widgets'),
                                            'default' => 10
                                        ),

                                        'width' => array(
                                            'type' => 'text',
                                            'label' => __('Resolution', 'livemesh-so-widgets'),
                                            'description' => __('The resolution to treat as a mobile resolution.', 'livemesh-so-widgets'),
                                            'default' => 480,
                                            'sanitize' => 'intval',
                                        )
                                    )
                                )

                            )
                        ),
                    )
                ),
            );
        }

        function modify_form($form) {

            $form['taxonomy_filter']['options'] = lsow_get_taxonomies_map();
            return $form;
        }

        function get_less_variables($instance) {

            $vars = array(

                'gutter' => intval($instance['settings']['gutter']) . 'px',

                // All the responsive sizes
                'tablet_width' => intval($instance['settings']['responsive']['tablet']['width']) . 'px',
                'tablet_gutter' => intval($instance['settings']['responsive']['tablet']['gutter']) . 'px',
                'mobile_width' => intval($instance['settings']['responsive']['mobile']['width']) . 'px',
                'mobile_gutter' => intval($instance['settings']['responsive']['mobile']['gutter']) . 'px',
            );

            $options = get_option('lsow_settings');

            if ($options && isset($options['lsow_theme_color']))
                $vars['theme_color'] = $options['lsow_theme_color'];

            return $vars;
        }

        function get_template_variables($instance, $args) {

            $settings = array(

                'block_type' => $instance['block_type'],
                'posts' => $instance['posts'],
                'taxonomy_chosen' => $instance['taxonomy_filter'],
                'heading' => $instance['heading'],
                'heading_url' => $instance['heading_url'],
                'header_template' => $instance['header_template'],

                'per_line' => $instance['settings']['per_line'],
                'per_line_tablet' => $instance['settings']['per_line_tablet'],
                'per_line_mobile' => $instance['settings']['per_line_mobile'],
                'layout_mode' => $instance['settings']['layout_mode'],
                'filterable' => $instance['settings']['filterable'],
                'pagination' => $instance['settings']['pagination'],
                'show_remaining' => $instance['settings']['show_remaining'],
                'image_linkable' => $instance['settings']['image_linkable'],
                'post_link_new_window' => $instance['settings']['post_link_new_window'],
                'enable_lightbox' => $instance['settings']['enable_lightbox'],
                'image_size' => $instance['settings']['image_size'],

                'display_title_on_thumbnail' => $instance['settings']['post_data']['display_title_on_thumbnail'],
                'display_taxonomy_on_thumbnail' => $instance['settings']['post_data']['display_taxonomy_on_thumbnail'],
                'display_title' => $instance['settings']['post_data']['display_title'],
                'display_summary' => $instance['settings']['post_data']['display_summary'],
                'rich_text_excerpt' => $instance['settings']['post_data']['rich_text_excerpt'],
                'display_excerpt_lightbox' => $instance['settings']['post_data']['display_excerpt_lightbox'],
                'excerpt_length' => $instance['settings']['post_data']['excerpt_length'],
                'display_read_more' => $instance['settings']['post_data']['display_read_more'],
                'display_author' => $instance['settings']['post_data']['post_meta']['display_author'],
                'display_post_date' => $instance['settings']['post_data']['post_meta']['display_post_date'],
                'display_taxonomy' => $instance['settings']['post_data']['post_meta']['display_taxonomy'],
            );

            return array('settings' => $settings);
        }

    }

    siteorigin_widget_register('lsow-portfolio', __FILE__, 'LSOW_Portfolio_Widget');

}