jQuery(function ($) {

    $('.lsow-block-grid').each(function () {

        var currentBlockObj = lsowGrids.getBlockObjById($(this).data('block-uid'));

        var layoutMode = currentBlockObj.settings['layout_mode'];

        // layout Isotope after all images have loaded
        var $blockElemInner = $(this).find('.lsow-block-inner');

        $blockElemInner.isotope({
            itemSelector: '.lsow-block-column',
            layoutMode: layoutMode,
            transitionDuration: '0.8s',
        });

        $blockElemInner.imagesLoaded(function () {
            $blockElemInner.isotope('layout');
        });

        /* ----------- Reorganize Filters when device width changes -------------- */

        /* https://stackoverflow.com/questions/24460808/efficient-way-of-using-window-resize-or-other-method-to-fire-jquery-functions */
        var lsowResizeTimeout;

        $(window).resize(function () {

            if (!!lsowResizeTimeout) {
                clearTimeout(lsowResizeTimeout);
            }

            lsowResizeTimeout = setTimeout(function () {

                currentBlockObj.organizeFilters();

            }, 200);
        });

        /* -------------- Taxonomy Filter --------------- */

        $(this).find('.lsow-taxonomy-filter .lsow-filter-item a, .lsow-block-filter .lsow-block-filter-item a').on('click', function (e) {

            e.preventDefault();

            currentBlockObj.handleFilterAction($(this));

            return false;
        });

        /* ------------------- Pagination ---------------------- */

        $(this).find('.lsow-pagination a.lsow-page-nav').on('click', function (e) {

            e.preventDefault();

            currentBlockObj.handlePageNavigation($(this));

        });

        /*---------------- Load More Button --------------------- */

        $(this).find('.lsow-pagination a.lsow-load-more').on('click', function (e) {

            e.preventDefault();

            currentBlockObj.handleLoadMore($(this));

        });

        /* ---------------------- Init Lightbox ---------------------- */

        currentBlockObj.initLightbox($(this));

    });

});