<?php
/**
 * @var $class
 * @var $caption_style
 * @var $slider_type
 * @var $settings
 * @var $slides
 */

?>

<?php if (!empty($instance['title']))
    echo $args['before_title'] . esc_html($instance['title']) . $args['after_title'] ?>

<div class="lsow-image-slider lsow-container lsow-<?php echo $caption_style; ?>"
     data-slider-type="<?php echo $slider_type; ?>"
     data-settings='<?php echo wp_json_encode($settings); ?>'>

    <?php if ($slider_type == 'flex'): ?>

        <?php if ($settings['thumbnail_nav']):

            $carousel_id = uniqid('lsow-carousel-');
            $slider_id = uniqid('lsow-slider-');

        endif; ?>

        <div <?php echo($slider_id ? 'id="' . $slider_id . '"' : ''); ?>
            <?php echo($carousel_id ? 'data-carousel="' . $carousel_id . '"' : ''); ?>
                class="lsow-flexslider">

            <div class="lsow-slides">

                <?php foreach ($slides as $slide): ?>

                    <?php if (!empty($slide['image']) && wp_attachment_is_image($slide['image'])) : ?>

                        <?php

                        if ($settings['thumbnail_nav']):

                            $thumbnail_src = wp_get_attachment_image_src($slide['image'], 'medium');

                            if ($thumbnail_src)
                                $thumbnail_attr = 'data-thumb="' . $thumbnail_src[0] . '"';

                        endif;

                        ?>

                        <div <?php echo $thumbnail_attr; ?> class="lsow-slide">


                            <?php if (!empty($slide['slide_url'])) : ?>

                                <a href="<?php echo sow_esc_url($slide['slide_url']); ?>"
                                   title="<?php echo $slide['name']; ?>"
                                   target="<?php echo $settings['link_target']; ?>">

                                    <?php echo wp_get_attachment_image($slide['image'], $settings['image_size'], false, array('class' => 'lsow-image full', 'alt' => $slide['name'])); ?>

                                </a>

                            <?php else : ?>

                                <?php echo wp_get_attachment_image($slide['image'], $settings['image_size'], false, array('class' => 'lsow-image full', 'alt' => $slide['name'])); ?>

                            <?php endif; ?>

                            <?php $caption = $slide['caption']; ?>

                            <?php if (!empty($caption['heading'])): ?>

                                <div class="lsow-caption">

                                    <?php echo empty($caption['subheading']) ? '' : '<div class="lsow-subheading">' . htmlspecialchars_decode($caption['subheading']) . '</div>'; ?>

                                    <?php if (!empty($caption['heading'])): ?>

                                        <?php if (!empty($slide['slide_url'])) : ?>

                                            <h3 class="lsow-heading">
                                                <a href="<?php echo sow_esc_url($slide['slide_url']); ?>"
                                                   title="<?php echo $slide['name']; ?>"
                                                   target="<?php echo $settings['link_target']; ?>"><?php echo $caption['heading']; ?></a>
                                            </h3>

                                        <?php else : ?>

                                            <h3 class="lsow-heading"><?php echo $caption['heading']; ?></h3>

                                        <?php endif; ?>

                                    <?php endif; ?>

                                    <?php if ($caption_style == 'style1' && (!empty($caption['button']['button_url']))) : ?>

                                        <?php
                                        $color_class = ' lsow-' . esc_attr($caption['button']['color']);
                                        if (!empty($caption['button']['type']))
                                            $type = ' lsow-' . esc_attr($caption['button']['type']);

                                        $rounded = (!empty($caption['button']['rounded'])) ? ' lsow-rounded' : '';

                                        ?>

                                        <a class="lsow-button <?php echo $color_class . $type . $rounded; ?>"
                                           href="<?php echo sow_esc_url($caption['button']['button_url']); ?>"
                                            <?php echo (empty($caption['button']['new_window'])) ? '' : 'target="_blank"'; ?>><?php echo $caption['button']['button_text']; ?></a>

                                    <?php endif; ?>

                                </div>

                            <?php endif; ?>


                        </div>

                    <?php endif; ?>

                <?php endforeach; ?>

            </div>

        </div>

        <?php if ($carousel_id): ?>

            <div id="<?php echo $carousel_id; ?>" class="lsow-thumbnailslider lsow-flexslider">

                <div class="lsow-slides">

                    <?php foreach ($slides as $slide): ?>

                        <?php if (!empty($slide['image']) && wp_attachment_is_image($slide['image'])) : ?>

                            <div class="lsow-slide">

                                <?php echo wp_get_attachment_image($slide['image'], 'medium', false, array('class' => 'lsow-image medium', 'alt' => $slide['name'])); ?>

                            </div>

                        <?php endif; ?>

                    <?php endforeach; ?>

                </div>

            </div>

        <?php endif; ?>

    <?php elseif ($slider_type == 'nivo') : ?>

        <?php $nivo_captions = array(); ?>

        <div class="nivoSlider">

            <?php foreach ($slides as $slide): ?>

                <?php $caption_index = uniqid('lsow-nivo-caption-'); ?>

                <?php if (!empty($slide['image']) && wp_attachment_is_image($slide['image'])) : ?>

                    <?php

                    $thumbnail_src = wp_get_attachment_image_src($slide['image'], 'medium');

                    if ($thumbnail_src)
                        $thumbnail_src = $thumbnail_src[0];

                    ?>

                    <?php if (!empty($slide['slide_url'])) : ?>

                        <a href="<?php echo sow_esc_url($slide['slide_url']); ?>"
                           title="<?php echo $slide['name']; ?>"
                           target="<?php echo $settings['link_target']; ?>">

                            <?php echo wp_get_attachment_image($slide['image'], $settings['image_size'], false, array('class' => 'lsow-image full', 'data-thumb' => $thumbnail_src, 'alt' => $slide['name'], 'title' => ('#' . $caption_index))); ?>

                        </a>

                    <?php else : ?>

                        <?php echo wp_get_attachment_image($slide['image'], $settings['image_size'], false, array('class' => 'lsow-image full', 'data-thumb' => $thumbnail_src, 'alt' => $slide['name'], 'title' => ('#' . $caption_index))); ?>

                    <?php endif; ?>

                    <?php $caption = $slide['caption']; ?>

                    <?php if (!empty($caption['heading'])): ?>

                        <?php if (!empty($slide['slide_url'])) : ?>

                            <?php $nivo_captions[] = '<div id="' . $caption_index . '" class="nivo-html-caption">' . '<div class="lsow-subheading">' . htmlspecialchars_decode($caption['subheading']) . '</div>' . '<h3 class="lsow-heading">' . '<a href="' . sow_esc_url($slide['slide_url']) . '" title="' . $slide['name'] . '">' . $caption['heading'] . '</a></h3>' . '</div>'; ?>

                        <?php else : ?>

                            <?php $nivo_captions[] = '<div id="' . $caption_index . '" class="nivo-html-caption">' . '<div class="lsow-subheading">' . htmlspecialchars_decode($caption['subheading']) . '</div>' . '<h3 class="lsow-heading">' . $caption['heading'] . '</h3>' . '</div>'; ?>

                        <?php endif; ?>

                    <?php endif; ?>

                    <?php $nivo_captions[] = '<div id="' . $caption_index . '" class="nivo-html-caption">' . '<div class="lsow-subheading">' . htmlspecialchars_decode($caption['subheading']) . '</div>' . '<h3 class="lsow-heading">' . $caption['heading'] . '</h3>' . '</div>'; ?>

                <?php endif; ?>

            <?php endforeach; ?>

        </div>

        <div class="lsow-caption nivo-html-caption">

            <?php foreach ($nivo_captions as $nivo_caption): ?>

                <?php echo $nivo_caption . "\n"; ?>

            <?php endforeach; ?>

        </div>


    <?php elseif ($slider_type == 'slick') : ?>

        <div class="lsow-slickslider">

            <?php foreach ($slides as $slide): ?>

                <div class="lsow-slide">

                    <?php if (!empty($slide['image']) && wp_attachment_is_image($slide['image'])) : ?>

                        <?php if (!empty($slide['slide_url'])) : ?>

                            <a href="<?php echo sow_esc_url($slide['slide_url']); ?>"
                               title="<?php echo $slide['name']; ?>"
                               target="<?php echo $settings['link_target']; ?>">

                                <?php echo wp_get_attachment_image($slide['image'], $settings['image_size'], false, array('class' => 'lsow-image full', 'alt' => $slide['name'])); ?>

                            </a>

                        <?php else : ?>

                            <?php echo wp_get_attachment_image($slide['image'], $settings['image_size'], false, array('class' => 'lsow-image full', 'alt' => $slide['name'])); ?>

                        <?php endif; ?>

                        <?php $caption = $slide['caption']; ?>

                        <div class="lsow-caption">

                            <?php echo empty($caption['subheading']) ? '' : '<div class="lsow-subheading">' . htmlspecialchars_decode($caption['subheading']) . '</div>'; ?>

                            <?php if (!empty($caption['heading'])): ?>

                                <?php if (!empty($slide['slide_url'])) : ?>

                                    <h3 class="lsow-heading">
                                        <a href="<?php echo sow_esc_url($slide['slide_url']); ?>"
                                           title="<?php echo $slide['name']; ?>"
                                           target="<?php echo $settings['link_target']; ?>"><?php echo $caption['heading']; ?></a>
                                    </h3>

                                <?php else : ?>

                                    <h3 class="lsow-heading"><?php echo $caption['heading']; ?></h3>

                                <?php endif; ?>

                            <?php endif; ?>

                            <?php if ($caption_style == 'style1' && (!empty($caption['button']['button_url']))) : ?>

                                <?php
                                $color_class = ' lsow-' . esc_attr($caption['button']['color']);
                                if (!empty($caption['button']['type']))
                                    $type = ' lsow-' . esc_attr($caption['button']['type']);

                                $rounded = (!empty($caption['button']['rounded'])) ? ' lsow-rounded' : '';

                                ?>

                                <a class="lsow-button <?php echo $color_class . $type . $rounded; ?>"
                                   href="<?php echo sow_esc_url($caption['button']['button_url']); ?>"
                                    <?php echo (empty($caption['button']['new_window'])) ? '' : 'target="_blank"'; ?>><?php echo $caption['button']['button_text']; ?></a>

                            <?php endif; ?>

                        </div>

                    <?php endif; ?>

                </div>

            <?php endforeach; ?>

        </div>

    <?php elseif ($slider_type == 'responsive') : ?>

        <div class="rslides_container">

            <ul class="rslides lsow-slide">

                <?php foreach ($slides as $slide): ?>

                    <li>

                        <?php if (!empty($slide['image']) && wp_attachment_is_image($slide['image'])) : ?>

                            <?php if (!empty($slide['slide_url'])) : ?>

                                <a href="<?php echo sow_esc_url($slide['slide_url']); ?>"
                                   title="<?php echo $slide['name']; ?>"
                                   target="<?php echo $settings['link_target']; ?>">

                                    <?php echo wp_get_attachment_image($slide['image'], $settings['image_size'], false, array('class' => 'lsow-image full', 'alt' => $slide['name'])); ?>

                                </a>

                            <?php else : ?>

                                <?php echo wp_get_attachment_image($slide['image'], $settings['image_size'], false, array('class' => 'lsow-image full', 'alt' => $slide['name'])); ?>

                            <?php endif; ?>

                            <?php $caption = $slide['caption']; ?>

                            <div class="lsow-caption">

                                <?php echo empty($caption['subheading']) ? '' : '<div class="lsow-subheading">' . htmlspecialchars_decode($caption['subheading']) . '</div>'; ?>

                                <?php if (!empty($caption['heading'])): ?>

                                    <?php if (!empty($slide['slide_url'])) : ?>

                                        <h3 class="lsow-heading">
                                            <a href="<?php echo sow_esc_url($slide['slide_url']); ?>"
                                               title="<?php echo $slide['name']; ?>"
                                               target="<?php echo $settings['link_target']; ?>"><?php echo $caption['heading']; ?></a>
                                        </h3>

                                    <?php else : ?>

                                        <h3 class="lsow-heading"><?php echo $caption['heading']; ?></h3>

                                    <?php endif; ?>

                                <?php endif; ?>

                                <?php if ($caption_style == 'style1' && (!empty($caption['button']['button_url']))) : ?>

                                    <?php
                                    $color_class = ' lsow-' . esc_attr($caption['button']['color']);
                                    if (!empty($caption['button']['type']))
                                        $type = ' lsow-' . esc_attr($caption['button']['type']);

                                    $rounded = (!empty($caption['button']['rounded'])) ? ' lsow-rounded' : '';

                                    ?>

                                    <a class="lsow-button <?php echo $color_class . $type . $rounded; ?>"
                                       href="<?php echo sow_esc_url($caption['button']['button_url']); ?>"
                                        <?php echo (empty($caption['button']['new_window'])) ? '' : 'target="_blank"'; ?>><?php echo $caption['button']['button_text']; ?></a>

                                <?php endif; ?>

                            </div>

                        <?php endif; ?>

                    </li>

                <?php endforeach; ?>

            </ul>

        </div>

    <?php endif; ?>

</div>