<?php

/*
Widget Name: Image Slider
Description: Create a responsive image slider.
Author: LiveMesh
Author URI: https://www.livemeshthemes.com
*/

if (lsow_fs()->can_use_premium_code()) {
    class LSOW_Image_Slider_Widget extends SiteOrigin_Widget {
        function __construct() {
            parent::__construct(
                "lsow-image-slider",
                __("Image Slider", "livemesh-so-widgets"),
                array(
                    "description" => __("Create a responsive image slider.", "livemesh-so-widgets"),
                    "panels_icon" => "dashicons dashicons-minus",
                    'help' => LSOW_PLUGIN_HELP_URL . '#image-slider'
                ),
                array(),
                array(
                    "title" => array(
                        "type" => "text",
                        "label" => __("Title", "livemesh-so-widgets"),
                    ),
                    "class" => array(
                        "type" => "text",
                        "description" => __("Set a unique CSS class for the slider. (optional).", "livemesh-so-widgets"),
                        "label" => __("Class", "livemesh-so-widgets"),
                    ),

                    "slider_type" => array(
                        "type" => "select",
                        "description" => __("Select slider type.", "livemesh-so-widgets"),
                        "label" => __("Slider Type", "livemesh-so-widgets"),
                        "options" => array(
                            "flex" => __("Flex Slider", "livemesh-so-widgets"),
                            "nivo" => __("Nivo Slider", "livemesh-so-widgets"),
                            "slick" => __("Slick Slider", "livemesh-so-widgets"),
                            "responsive" => __("Responsive Slider", "livemesh-so-widgets"),
                        ),
                        'state_emitter' => array(
                            'callback' => 'select',
                            'args' => array('slider_type')
                        ),
                        "default" => "flex",
                    ),


                    'caption_style' => array(
                        'type' => 'select',
                        'label' => __('Choose Caption Style', 'livemesh-so-widgets'),
                        'state_emitter' => array(
                            'callback' => 'select',
                            'args' => array('caption_style')
                        ),
                        'default' => 'style1',
                        'options' => array(
                            'style1' => __('Style 1', 'livemesh-so-widgets'),
                            'style2' => __('Style 2', 'livemesh-so-widgets'),
                        )
                    ),

                    'slides' => array(
                        'type' => 'repeater',
                        'label' => __('Slides', 'livemesh-so-widgets'),
                        'item_name' => __('Slide', 'livemesh-so-widgets'),
                        'item_label' => array(
                            'selector' => "[id*='slides-name']",
                            'update_event' => 'change',
                            'value_method' => 'val'
                        ),
                        'fields' => array(
                            'name' => array(
                                'type' => 'text',
                                'label' => __('Name', 'livemesh-so-widgets'),
                                'description' => __('The title to identify the slide', 'livemesh-so-widgets'),
                            ),
                            'image' => array(
                                'type' => 'media',
                                'label' => __('Slide Image', 'livemesh-so-widgets'),
                                'library' => 'image',
                                'description' => __('The image for the slide.', 'livemesh-so-widgets'),
                            ),
                            'slide_url' => array(
                                'type' => 'link',
                                'label' => __('URL to link to by image and caption heading. (optional)', 'livemesh-so-widgets'),
                                'description' => __('Specify the URL to which the slide image and caption heading should link to. (optional)', 'livemesh-so-widgets'),
                            ),
                            'caption' => array(
                                'type' => 'section',
                                'label' => __('Slider Caption Details', 'livemesh-so-widgets'),
                                'fields' => array(
                                    'heading' => array(
                                        'type' => 'text',
                                        'label' => __('Caption Heading', 'livemesh-so-widgets'),
                                    ),
                                    'subheading' => array(
                                        'type' => 'text',
                                        'label' => __('Caption Sub-heading', 'livemesh-so-widgets'),
                                        'optional' => 'true',
                                    ),
                                    'button' => array(
                                        'type' => 'section',
                                        'label' => __('Slider Caption Button', 'livemesh-so-widgets'),
                                        'state_handler' => array(
                                            'caption_style[style1]' => array('show'),
                                            '_else[caption_style]' => array('hide'),
                                        ),
                                        'fields' => array(
                                            'button_text' => array(
                                                'type' => 'text',
                                                'label' => __('Button text', 'livemesh-so-widgets'),
                                                'state_handler' => array(
                                                    'slider_type[nivo]' => array('hide'),
                                                    '_else[slider_type]' => array('show'),
                                                ),
                                            ),
                                            'button_url' => array(
                                                'type' => 'link',
                                                'label' => __('Button URL', 'livemesh-so-widgets'),
                                            ),
                                            'new_window' => array(
                                                'type' => 'checkbox',
                                                'label' => __('Open URL in a new window', 'livemesh-so-widgets'),
                                            ),
                                            "color" => array(
                                                "type" => "select",
                                                "description" => __("The color of the button.", "livemesh-so-widgets"),
                                                "label" => __("Color", "livemesh-so-widgets"),
                                                "options" => array(
                                                    "default" => __("Default", "livemesh-so-widgets"),
                                                    "black" => __("Black", "livemesh-so-widgets"),
                                                    "blue" => __("Blue", "livemesh-so-widgets"),
                                                    "cyan" => __("Cyan", "livemesh-so-widgets"),
                                                    "green" => __("Green", "livemesh-so-widgets"),
                                                    "orange" => __("Orange", "livemesh-so-widgets"),
                                                    "pink" => __("Pink", "livemesh-so-widgets"),
                                                    "red" => __("Red", "livemesh-so-widgets"),
                                                    "teal" => __("Teal", "livemesh-so-widgets"),
                                                    "trans" => __("Transparent", "livemesh-so-widgets"),
                                                    "semitrans" => __("Semi Transparent", "livemesh-so-widgets"),
                                                ),
                                                "default" => "default"
                                            ),
                                            "type" => array(
                                                "type" => "select",
                                                "label" => __("Button Size", "livemesh-so-widgets"),
                                                "options" => array(
                                                    "medium" => __("Medium", "livemesh-so-widgets"),
                                                    "large" => __("Large", "livemesh-so-widgets"),
                                                    "small" => __("Small", "livemesh-so-widgets"),
                                                )
                                            ),
                                            'rounded' => array(
                                                'type' => 'checkbox',
                                                'label' => __('Display rounded button?', 'livemesh-so-widgets'),
                                                'default' => false
                                            ),
                                        )
                                    ),
                                )
                            ),
                        )
                    ),


                    'settings' => array(
                        'type' => 'section',
                        'label' => __('Slider Settings', 'livemesh-so-widgets'),
                        'fields' => array(

                            'image_size' => array(
                                'type' => 'image-size',
                                'label' => __('Image Size', 'livemesh-so-widgets'),
                                'default' => 'full',
                            ),

                            'link_target' => array(
                                'type' => 'select',
                                'label' => __('Link Target', 'livemesh-so-widgets'),
                                'default' => '_self',
                                'options' => array(
                                    '_self' => __('Same Window', 'livemesh-so-widgets'),
                                    '_blank' => __('New Window', 'livemesh-so-widgets'),
                                ),
                            ),

                            "animation" => array(
                                "type" => "select",
                                "description" => __("Select your animation type.", "livemesh-so-widgets"),
                                "label" => __("Animation", "livemesh-so-widgets"),
                                "options" => array(
                                    "slide" => __("Slide", "livemesh-so-widgets"),
                                    "fade" => __("Fade", "livemesh-so-widgets"),
                                ),
                                "default" => "slide",
                                'state_handler' => array(
                                    'slider_type[flex]' => array('show'),
                                    '_else[slider_type]' => array('hide'),
                                ),
                            ),
                            "direction" => array(
                                "type" => "select",
                                "description" => __("Select the sliding direction.", "livemesh-so-widgets"),
                                "label" => __("Sliding Direction", "livemesh-so-widgets"),
                                "options" => array(
                                    "horizontal" => __("Horizontal", "livemesh-so-widgets"),
                                    "vertical" => __("Vertical", "livemesh-so-widgets"),
                                ),
                                "default" => "horizontal",
                                'state_handler' => array(
                                    'slider_type[flex]' => array('show'),
                                    'slider_type[slick]' => array('show'),
                                    '_else[slider_type]' => array('hide'),
                                ),
                            ),
                            "control_nav" => array(
                                "type" => "checkbox",
                                "description" => __("Create navigation for paging control of each slide?", "livemesh-so-widgets"),
                                "label" => __("Control navigation?", "livemesh-so-widgets"),
                                "default" => true,
                            ),
                            "direction_nav" => array(
                                "type" => "checkbox",
                                "description" => __("Create navigation for previous/next navigation?", "livemesh-so-widgets"),
                                "label" => __("Direction navigation?", "livemesh-so-widgets"),
                                "default" => false,
                            ),
                            "thumbnail_nav" => array(
                                "type" => "checkbox",
                                "description" => __("Use thumbnails for Control Nav?", "livemesh-so-widgets"),
                                "label" => __("Thumbnails Navigation?", "livemesh-so-widgets"),
                                "default" => false,
                                'state_handler' => array(
                                    'slider_type[nivo]' => array('show'),
                                    'slider_type[flex]' => array('show'),
                                    '_else[slider_type]' => array('hide'),
                                ),
                            ),
                            "randomize" => array(
                                "type" => "checkbox",
                                "description" => __("Randomize slide order?", "livemesh-so-widgets"),
                                "label" => __("Randomize slides?", "livemesh-so-widgets"),
                                "default" => false,
                                'state_handler' => array(
                                    'slider_type[flex]' => array('show'),
                                    'slider_type[nivo]' => array('hide'),
                                    'slider_type[slick]' => array('hide'),
                                    'slider_type[responsive]' => array('show'),
                                ),
                            ),
                            "pause_on_hover" => array(
                                "type" => "checkbox",
                                "description" => __("Pause the slideshow when hovering over slider, then resume when no longer hovering.", "livemesh-so-widgets"),
                                "label" => __("Pause on hover?", "livemesh-so-widgets"),
                                "default" => true,
                            ),
                            "pause_on_action" => array(
                                "type" => "checkbox",
                                "description" => __("Pause the slideshow when interacting with control elements.", "livemesh-so-widgets"),
                                "label" => __("Pause on action?", "livemesh-so-widgets"),
                                "default" => true,
                                'state_handler' => array(
                                    'slider_type[flex]' => array('show'),
                                    '_else[slider_type]' => array('hide'),
                                ),
                            ),
                            "loop" => array(
                                "type" => "checkbox",
                                "description" => __("Should the animation loop?", "livemesh-so-widgets"),
                                "label" => __("Loop", "livemesh-so-widgets"),
                                "default" => true,
                                'state_handler' => array(
                                    'slider_type[flex]' => array('show'),
                                    'slider_type[slick]' => array('show'),
                                    '_else[slider_type]' => array('hide'),
                                ),
                            ),
                            "slideshow" => array(
                                "type" => "checkbox",
                                "description" => __("Animate slider automatically without user intervention?", "livemesh-so-widgets"),
                                "label" => __("Slideshow", "livemesh-so-widgets"),
                                "default" => true,
                            ),
                            "slideshow_speed" => array(
                                "type" => "number",
                                "description" => __("Set the speed of the slideshow cycling, in milliseconds", "livemesh-so-widgets"),
                                "label" => __("Slideshow speed", "livemesh-so-widgets"),
                                "default" => 5000,
                            ),
                            "animation_speed" => array(
                                "type" => "number",
                                "description" => __("Set the speed of animations, in milliseconds.", "livemesh-so-widgets"),
                                "label" => __("Animation speed", "livemesh-so-widgets"),
                                "default" => 600,
                            ),
                        )
                    )
                )
            );
        }

        function enqueue_frontend_scripts($instance) {

            if ($instance['slider_type'] == 'flex'):

                wp_enqueue_script('lsow-flexslider', LSOW_PLUGIN_URL . 'assets/js/jquery.flexslider' . LSOW_JS_SUFFIX . '.js', array('jquery'), LSOW_VERSION, true);

                wp_enqueue_style('lsow-flexslider', LSOW_PLUGIN_URL . 'assets/css/flexslider.css', array(), LSOW_VERSION);

            elseif ($instance['slider_type'] == 'nivo'):

                wp_enqueue_script('lsow-nivoslider', LSOW_PLUGIN_URL . 'assets/js/premium/jquery.nivo.slider' . LSOW_JS_SUFFIX . '.js', array('jquery'), LSOW_VERSION, true);

                wp_enqueue_style('lsow-nivoslider', LSOW_PLUGIN_URL . 'assets/css/premium/nivo-slider.css', array(), LSOW_VERSION);

            elseif ($instance['slider_type'] == 'slick'):

                wp_enqueue_script('lsow-slick', LSOW_PLUGIN_URL . 'assets/js/slick' . LSOW_JS_SUFFIX . '.js', array('jquery'), LSOW_VERSION, true);

                wp_enqueue_style('lsow-slick', LSOW_PLUGIN_URL . 'assets/css/slick.css', array(), LSOW_VERSION);

            elseif ($instance['slider_type'] == 'responsive'):

                wp_enqueue_script('lsow-responsiveslider', LSOW_PLUGIN_URL . 'assets/js/premium/responsiveslides' . LSOW_JS_SUFFIX . '.js', array('jquery'), LSOW_VERSION, true);

                wp_enqueue_style('lsow-responsiveslider', LSOW_PLUGIN_URL . 'assets/css/premium/responsiveslides.css', array(), LSOW_VERSION);

            endif;

            parent::enqueue_frontend_scripts($instance);
        }

        function initialize() {

            $this->register_frontend_scripts(array(
                array(
                    'lsow-image-slider',
                    plugin_dir_url(__FILE__) . 'js/image-slider' . LSOW_JS_SUFFIX . '.js',
                    array('jquery')
                )
            ));

            $this->register_frontend_styles(array(
                array(
                    'lsow-image-slider',
                    plugin_dir_url(__FILE__) . 'css/style.css'
                )
            ));

        }

        function get_less_variables($instance) {

            $return = array();

            $options = get_option('lsow_settings');

            if ($options && isset($options['lsow_theme_color'])) {
                $custom_color = $options['lsow_theme_color'];
                $return = array(
                    'theme_color' => $custom_color,
                );
            }

            return $return;

        }

        function get_template_variables($instance, $args) {
            return array(

                "class" => $instance["class"],
                "caption_style" => $instance["caption_style"],
                "slider_type" => $instance["slider_type"],
                'settings' => $instance['settings'],

                'slides' => !empty($instance['slides']) ? $instance['slides'] : array(),
            );
        }

    }

    siteorigin_widget_register("lsow-image-slider", __FILE__, "LSOW_Image_Slider_Widget");

}

