<?php
/**
 * @var $settings
 * @var $gallery_class
 * @var $heading
 * @var $items
 */

if( !empty( $instance['title'] ) ) echo $args['before_title'] . esc_html($instance['title']) . $args['after_title'];

if (!empty($items)) :

    $common = LSOW_Gallery_Common::get_instance();

    $settings = $common->parse_gallery_settings($settings);

    LSOW_Gallery_Widget::$gallery_counter++;

    $settings['gallery_class'] = !empty($gallery_class) ? sanitize_title($gallery_class) : 'gallery-' . LSOW_Gallery_Widget::$gallery_counter;

    $items = $common->parse_items($items);

    $terms = $common->get_gallery_terms($items);
    $max_num_pages = ceil(count($items) / $settings['items_per_page']);

    ?>

    <div class="lsow-gallery-wrap lsow-gapless-grid"
         data-settings='<?php echo wp_json_encode($settings); ?>'
         data-items='<?php echo ($settings['pagination'] !== 'none') ? json_encode($items, JSON_HEX_APOS) : ''; ?>'
         data-maxpages='<?php echo $max_num_pages; ?>'
         data-total='<?php echo count($items); ?>'
         data-current='1'>

        <?php if (!empty($heading) || $settings['filterable']): ?>

            <?php $header_class = (trim($heading) === '') ? ' lsow-no-heading' : ''; ?>

            <div class="lsow-gallery-header <?php echo $header_class; ?>">

                <?php if (!empty($heading)): ?>

                    <h3 class="lsow-heading"><?php echo wp_kses_post($heading); ?></h3>

                <?php endif; ?>

                <?php

                if ($settings['filterable'])
                    echo $common->get_gallery_terms_filter($terms);

                ?>

            </div>

        <?php endif; ?>

        <div class="lsow-gallery js-isotope lsow-<?php echo esc_attr($settings['layout_mode']); ?> lsow-grid-container <?php echo lsow_get_grid_classes($settings); ?> <?php echo $settings['gallery_class']; ?>"
             data-isotope-options='{ "itemSelector": ".lsow-gallery-item", "layoutMode": "<?php echo esc_attr($settings['layout_mode']); ?>", "masonry": { "columnWidth": ".lsow-grid-sizer" } }'>

            <?php if ($settings['layout_mode'] == 'masonry'): ?>

                <div class="lsow-grid-sizer"></div>

            <?php endif; ?>

            <?php $common->display_gallery($items, $settings, 1); ?>

        </div><!-- Isotope items -->

        <?php echo $common->paginate_gallery($items, $settings); ?>

    </div><!-- .lsow-gallery-wrap -->

    <?php

endif;