<?php

/*
Widget Name: Gallery
Description: Display images or videos in a multi-column grid.
Author: LiveMesh
Author URI: https://www.livemeshthemes.com
*/

if (lsow_fs()->can_use_premium_code()) {
    class LSOW_Gallery_Widget extends SiteOrigin_Widget {

        static public $gallery_counter = 0;

        function __construct() {
            parent::__construct(
                'lsow-gallery',
                __('Gallery', 'livemesh-so-widgets'),
                array(
                    'description' => __('Display images or videos in a multi-column grid', 'livemesh-so-widgets'),
                    'panels_icon' => 'dashicons dashicons-minus',
                    'help' => LSOW_PLUGIN_HELP_URL . '#image-video-gallery'
                ),
                array(),
                array(
                    'gallery_class' => array(
                        'type' => 'text',
                        'label' => __('Gallery Class/Identifier', 'livemesh-so-widgets'),
                        'description' => __('Specify an unique identifier used as a custom CSS class name and lightbox group name/slug for the gallery element.', 'livemesh-so-widgets'),
                    ),

                    'heading' => array(
                        'type' => 'text',
                        'label' => __('Heading for the grid', 'livemesh-so-widgets'),
                    ),

                    'heading' => array(
                        'type' => 'text',
                        'label' => __('Heading for the grid', 'livemesh-so-widgets'),
                    ),

                    'items' => array(
                        'type' => 'repeater',
                        'label' => __('Gallery Items', 'livemesh-so-widgets'),
                        'item_name' => __('Gallery Item', 'livemesh-so-widgets'),
                        'item_label' => array(
                            'selector' => "[id*='items-name']",
                            'update_event' => 'change',
                            'value_method' => 'val'
                        ),
                        'fields' => array(

                            'item_type' => array(
                                'type' => 'select',
                                'label' => __('Item Type', 'livemesh-so-widgets'),
                                'description' => __('Specify the item type - if this is an image or represents a YouTube/Vimeo/HTML5 video.', 'livemesh-so-widgets'),
                                'default' => 'image',
                                'state_emitter' => array(
                                    'callback' => 'select',
                                    'args' => array('item_type_{$repeater}')
                                ),
                                'options' => array(
                                    'image' => __('Image', 'livemesh-so-widgets'),
                                    'youtube' => __('YouTube Video', 'livemesh-so-widgets'),
                                    'vimeo' => __('Vimeo Video', 'livemesh-so-widgets'),
                                    'html5video' => __('HTML5 Video', 'livemesh-so-widgets'),
                                ),
                            ),
                            'name' => array(
                                'type' => 'text',
                                'label' => __('Item Label', 'livemesh-so-widgets'),
                                'description' => __('The label or name for the gallery item.', 'livemesh-so-widgets'),
                            ),
                            'image' => array(
                                'type' => 'media',
                                'label' => __('Gallery Image', 'livemesh-so-widgets'),
                                'library' => 'image',
                                'description' => __('The image for the gallery item. If item type chosen is YouTube or Vimeo video or MP4/WebM video, the image will be used as a placeholder image for video.', 'livemesh-so-widgets'),
                            ),
                            'tags' => array(
                                'type' => 'text',
                                'label' => __('Item Tag(s)', 'livemesh-so-widgets'),
                                'description' => __('One or more comma separated tags for the gallery item. Useful when items are made filterable.', 'livemesh-so-widgets'),
                            ),
                            'link' => array(
                                'type' => 'link',
                                'label' => __('Page URL', 'livemesh-so-widgets'),
                                'description' => __('The URL of the page to which the image gallery item points to (optional).', 'livemesh-so-widgets'),
                                'state_handler' => array(
                                    'item_type_{$repeater}[image]' => array('show'),
                                    '_else[item_type_{$repeater}]' => array('hide'),
                                ),
                            ),
                            'video_link' => array(
                                'type' => 'text',
                                'label' => __('Video URL', 'livemesh-so-widgets'),
                                'description' => __('The URL of the YouTube or Vimeo video.', 'livemesh-so-widgets'),
                                'state_handler' => array(
                                    'item_type_{$repeater}[image,html5video]' => array('hide'),
                                    '_else[item_type_{$repeater}]' => array('show'),
                                ),
                            ),
                            'mp4_video_link' => array(
                                'type' => 'text',
                                'label' => __('MP4 Video URL', 'livemesh-so-widgets'),
                                'description' => __('The URL of the MP4 video.', 'livemesh-so-widgets'),
                                'state_handler' => array(
                                    'item_type_{$repeater}[html5video]' => array('show'),
                                    '_else[item_type_{$repeater}]' => array('hide'),
                                ),
                            ),
                            'webm_video_link' => array(
                                'type' => 'text',
                                'label' => __('WebM Video URL', 'livemesh-so-widgets'),
                                'description' => __('The URL of the WebM video.', 'livemesh-so-widgets'),
                                'state_handler' => array(
                                    'item_type_{$repeater}[html5video]' => array('show'),
                                    '_else[item_type_{$repeater}]' => array('hide'),
                                ),
                            ),
                            'display_video_inline' => array(
                                'type' => 'checkbox',
                                'label' => __('Display video inline?', 'livemesh-so-widgets'),
                                'state_handler' => array(
                                    'item_type_{$repeater}[image]' => array('hide'),
                                    '_else[item_type_{$repeater}]' => array('show'),
                                ),
                                'default' => false
                            ),
                            'description' => array(
                                'type' => 'textarea',
                                'label' => __('Item description', 'livemesh-so-widgets'),
                                'description' => __('Short description for the gallery item displayed in the lightbox gallery.(optional)', 'livemesh-so-widgets'),
                            ),
                        )
                    ),

                    'settings' => array(
                        'type' => 'section',
                        'label' => __('Settings', 'livemesh-so-widgets'),
                        'fields' => array(

                            'filterable' => array(
                                'type' => 'checkbox',
                                'label' => __('Filterable?', 'livemesh-so-widgets'),
                                'default' => true
                            ),

                            'layout_mode' => array(
                                'type' => 'select',
                                'label' => __('Choose a layout for the grid', 'livemesh-so-widgets'),
                                'state_emitter' => array(
                                    'callback' => 'select',
                                    'args' => array('layout_mode')
                                ),
                                'default' => 'fitRows',
                                'options' => array(
                                    'fitRows' => __('Fit Rows', 'livemesh-so-widgets'),
                                    'masonry' => __('Masonry', 'livemesh-so-widgets'),
                                )
                            ),

                            'pagination' => array(
                                'type' => 'select',
                                'label' => __('Pagination', 'livemesh-so-widgets'),
                                'description' => __('Choose pagination type or choose None if no pagination is desired. Make sure you enter the items per page value in the option \'Number of items to be displayed per page and on each load more invocation\' field below to control number of items to display per page.', 'livemesh-so-widgets'),
                                'default' => 'none',
                                'state_emitter' => array(
                                    'callback' => 'select',
                                    'args' => array('pagination')
                                ),
                                'options' => array(
                                    'none' => __('None', 'livemesh-so-widgets'),
                                    'paged' => __('Paged', 'livemesh-so-widgets'),
                                    'load_more' => __('Load More', 'livemesh-so-widgets'),
                                ),
                            ),

                            'show_remaining' => array(
                                'type' => 'checkbox',
                                'label' => __('Display count of items yet to be loaded with the load more button?', 'livemesh-so-widgets'),
                                'default' => true,
                                'state_handler' => array(
                                    'pagination[load_more]' => array('show'),
                                    '_else[pagination]' => array('hide'),
                                ),
                            ),

                            'items_per_page' => array(
                                'type' => 'number',
                                'label' => __('Number of items to be displayed per page and on each load more invocation.', 'livemesh-so-widgets'),
                                'default' => 8,
                                'state_handler' => array(
                                    'pagination[none]' => array('hide'),
                                    '_else[pagination]' => array('show'),
                                ),
                            ),

                            'per_line' => array(
                                'type' => 'slider',
                                'label' => __('Gallery Items per row', 'livemesh-so-widgets'),
                                'min' => 1,
                                'max' => 6,
                                'integer' => true,
                                'default' => 3
                            ),

                            'per_line_tablet' => array(
                                'type' => 'slider',
                                'label' => __('Gallery Items per row in Tablet Resolution', 'livemesh-so-widgets'),
                                'min' => 1,
                                'max' => 6,
                                'integer' => true,
                                'default' => 2
                            ),

                            'per_line_mobile' => array(
                                'type' => 'slider',
                                'label' => __('Gallery Items per row in Mobile Resolution', 'livemesh-so-widgets'),
                                'min' => 1,
                                'max' => 4,
                                'integer' => true,
                                'default' => 1
                            ),

                            'image_size' => array(
                                'type' => 'image-size',
                                'label' => __('Image Size', 'livemesh-so-widgets'),
                                'default' => 'large',
                            ),

                            'link_target' => array(
                                'type' => 'select',
                                'label' => __('Link Target', 'livemesh-so-widgets'),
                                'default' => '_self',
                                'options' => array(
                                    '_self' => __('Same Window', 'livemesh-so-widgets'),
                                    '_blank' => __('New Window', 'livemesh-so-widgets'),
                                ),
                            ),

                            'enable_lightbox' => array(
                                'type' => 'checkbox',
                                'label' => __('Enable Lightbox Gallery?', 'livemesh-so-widgets'),
                                'default' => true
                            ),

                            'display_item_title' => array(
                                'type' => 'checkbox',
                                'label' => __('Display Item Title?', 'livemesh-so-widgets'),
                                'default' => true
                            ),

                            'display_item_tags' => array(
                                'type' => 'checkbox',
                                'label' => __('Display Item Tags?', 'livemesh-so-widgets'),
                                'default' => true
                            ),

                            'gutter' => array(
                                'type' => 'number',
                                'label' => __('Gutter', 'livemesh-so-widgets'),
                                'description' => __('Space between columns in masonry grid.', 'livemesh-so-widgets'),
                                'default' => 20
                            ),

                            'responsive' => array(
                                'type' => 'section',
                                'label' => __('Responsive', 'livemesh-so-widgets'),
                                'hide' => true,
                                'fields' => array(
                                    'tablet' => array(
                                        'type' => 'section',
                                        'label' => __('Tablet', 'livemesh-so-widgets'),
                                        'fields' => array(

                                            'gutter' => array(
                                                'type' => 'number',
                                                'label' => __('Gutter', 'livemesh-so-widgets'),
                                                'description' => __('Space between columns.', 'livemesh-so-widgets'),
                                                'default' => 10
                                            ),

                                            'width' => array(
                                                'type' => 'text',
                                                'label' => __('Resolution', 'livemesh-so-widgets'),
                                                'description' => __('The resolution to treat as a tablet resolution.', 'livemesh-so-widgets'),
                                                'default' => 800,
                                                'sanitize' => 'intval',
                                            )
                                        )
                                    ),
                                    'mobile' => array(
                                        'type' => 'section',
                                        'label' => __('Mobile Phone', 'livemesh-so-widgets'),
                                        'fields' => array(

                                            'gutter' => array(
                                                'type' => 'number',
                                                'label' => __('Gutter', 'livemesh-so-widgets'),
                                                'description' => __('Space between columns.', 'livemesh-so-widgets'),
                                                'default' => 10
                                            ),

                                            'width' => array(
                                                'type' => 'text',
                                                'label' => __('Resolution', 'livemesh-so-widgets'),
                                                'description' => __('The resolution to treat as a mobile resolution.', 'livemesh-so-widgets'),
                                                'default' => 480,
                                                'sanitize' => 'intval',
                                            )
                                        )
                                    )

                                )
                            ),
                        )
                    ),
                )
            );
        }

        function initialize() {

            $this->register_frontend_scripts(
                array(
                    array(
                        'lsow-isotope',
                        LSOW_PLUGIN_URL . 'assets/js/isotope.pkgd' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-imagesloaded',
                        LSOW_PLUGIN_URL . 'assets/js/imagesloaded.pkgd' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-fancybox',
                        LSOW_PLUGIN_URL . 'assets/js/premium/jquery.fancybox' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    )
                )
            );

            $this->register_frontend_styles(
                array(

                    array(
                        'lsow-icomoon-styles',
                        LSOW_PLUGIN_URL . 'assets/css/icomoon.css',
                        array(),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-fancybox',
                        LSOW_PLUGIN_URL . 'assets/css/premium/jquery.fancybox.css',
                        array(),
                        LSOW_VERSION
                    ),

                    array(
                        'lsow-frontend-styles',
                        LSOW_PLUGIN_URL . 'assets/css/lsow-frontend.css',
                        array(),
                        LSOW_VERSION
                    ),

                    array(
                        'lsow-premium-frontend-styles',
                        LSOW_PLUGIN_URL . 'assets/css/premium/lsow-frontend.css',
                        array(),
                        LSOW_VERSION
                    ),
                )
            );

            $this->register_frontend_scripts(array(
                    array(
                        'lsow-gallery',
                        plugin_dir_url(__FILE__) . 'js/gallery' . LSOW_JS_SUFFIX . '.js',
                        array('jquery')
                    )
                )
            );

            $this->register_frontend_styles(array(
                    array(
                        'lsow-gallery',
                        plugin_dir_url(__FILE__) . 'css/style.css'
                    )
                )
            );

            add_action('wp_enqueue_scripts', array($this, 'localize_scripts'), 999999);

        }

        public function localize_scripts() {

            /* Do not attach to widget scripts since they are enqueued really late for some reason */
            wp_localize_script('lsow-frontend-scripts', 'lsow_ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));

        }

        function get_less_variables($instance) {

            $vars = array(

                'gutter' => intval($instance['settings']['gutter']) . 'px',

                // All the responsive sizes
                'tablet_width' => intval($instance['settings']['responsive']['tablet']['width']) . 'px',
                'tablet_gutter' => intval($instance['settings']['responsive']['tablet']['gutter']) . 'px',
                'mobile_width' => intval($instance['settings']['responsive']['mobile']['width']) . 'px',
                'mobile_gutter' => intval($instance['settings']['responsive']['mobile']['gutter']) . 'px',
            );

            $options = get_option('lsow_settings');

            if ($options && isset($options['lsow_theme_color']))
                $vars['theme_color'] = $options['lsow_theme_color'];

            return $vars;
        }

        function get_template_variables($instance, $args) {
            return array(
                'items' => !empty($instance['items']) ? $instance['items'] : array(),
                'gallery_class' => $instance['gallery_class'],
                'heading' => $instance['heading'],
                'settings' => $instance['settings']
            );
        }

    }

    siteorigin_widget_register('lsow-gallery', __FILE__, 'LSOW_Gallery_Widget');

}