jQuery(function ($) {

    if ($().isotope === undefined) {
        return;
    }

    $('.lsow-gallery-wrap').each(function () {

        var container = $(this).find('.lsow-gallery:first');
        if (container.length === 0) {
            return; // no items to filter or load and hence don't continue
        }

        // layout Isotope after all images have loaded
        var htmlContent = $(this).find('.js-isotope:first');

        var isotopeOptions = htmlContent.data('isotope-options');

        htmlContent.isotope({
            // options
            itemSelector: isotopeOptions['itemSelector'],
            layoutMode: isotopeOptions['layoutMode'],
            transitionDuration: '0.8s',
            masonry: {
                columnWidth: '.lsow-grid-sizer'
            }
        });

        htmlContent.imagesLoaded(function () {
            htmlContent.isotope('layout');
        });

        // Relayout on inline full screen video and back
        $(document).on('webkitfullscreenchange mozfullscreenchange fullscreenchange',function(e){
            htmlContent.isotope('layout');
        });


        /* -------------- Taxonomy Filter --------------- */

        $(this).find('.lsow-taxonomy-filter .lsow-filter-item a').on('click', function (e) {
            e.preventDefault();

            var selector = $(this).attr('data-value');
            container.isotope({filter: selector});
            $(this).closest('.lsow-taxonomy-filter').children().removeClass('lsow-active');
            $(this).closest('.lsow-filter-item').addClass('lsow-active');
            return false;
        });

        /* ------------------- Pagination ---------------------- */

        $(this).find('.lsow-pagination a.lsow-page-nav').on('click', function (e) {
            e.preventDefault();

            var $this = $(this),
                $parent = $this.closest('.lsow-gallery-wrap'),
                settings = $parent.data('settings'),
                items = $parent.data('items'),
                maxpages = $parent.data('maxpages'),
                current = $parent.data('current'),
                paged = $this.data('page');

            // Do not continue if already processing or if the page is currently being shown
            if ($this.is('.lsow-current-page') || $parent.is('.lsow-processing'))
                return;

            if (paged == 'prev') {
                if (current <= 1)
                    return;
                paged = current - 1;
            }
            else if (paged == 'next') {
                if (current >= maxpages)
                    return;
                paged = current + 1;
            }

            $parent.addClass('lsow-processing');

            var data = {
                'action': 'lsow_load_gallery_items',
                'settings': settings,
                'items': items,
                'paged': paged
            };
            // We can also pass the url value separately from ajaxurl for front end AJAX implementations
            $.post(lsow_ajax_object.ajax_url, data, function (response) {

                var $grid = $parent.find('.lsow-gallery');

                var $existing_items = $grid.children('.lsow-gallery-item');

                $grid.isotope('remove', $existing_items);

                var $response = $('<div></div>').html(response);

                $response.imagesLoaded(function () {

                    var $new_items = $response.children('.lsow-gallery-item');

                    $grid.isotope('insert', $new_items);
                });

                // Set attributes of DOM elements based on page loaded

                $parent.data('current', paged);

                $this.siblings('.lsow-current-page').removeClass('lsow-current-page');

                $parent.find('.lsow-page-nav[data-page="' + parseInt(paged) + '"]').addClass('lsow-current-page');

                $parent.find('.lsow-page-nav[data-page="next"]').removeClass('lsow-disabled');
                $parent.find('.lsow-page-nav[data-page="prev"]').removeClass('lsow-disabled');

                if (paged <= 1)
                    $parent.find('.lsow-page-nav[data-page="prev"]').addClass('lsow-disabled');
                else if (paged >= maxpages)
                    $parent.find('.lsow-page-nav[data-page="next"]').addClass('lsow-disabled');

                $parent.removeClass('lsow-processing');
            });

        });


        /*---------------- Load More Button --------------------- */

        $(this).find('.lsow-pagination a.lsow-load-more').on('click', function (e) {
            e.preventDefault();

            var $this = $(this),
                $parent = $this.closest('.lsow-gallery-wrap'),
                paged = $this.attr('data-page'),
                settings = $parent.data('settings'),
                items = $parent.data('items'),
                maxpages = $parent.data('maxpages'),
                total = $parent.data('total'),
                current = $parent.data('current');

            if (current >= maxpages || $parent.is('.lsow-processing'))
                return;

            $parent.addClass('lsow-processing');

            paged = ++current;

            var data = {
                'action': 'lsow_load_gallery_items',
                'settings': settings,
                'items': items,
                'paged': paged
            };

            // We can also pass the url value separately from ajaxurl for front end AJAX implementations
            $.post(lsow_ajax_object.ajax_url, data, function (response) {

                var $grid = $parent.find('.lsow-gallery');

                var $response = $('<div></div>').html(response);

                $response.imagesLoaded(function () {

                    var $new_items = $response.children('.lsow-gallery-item');

                    $grid.isotope('insert', $new_items);

                });

                $parent.data('current', current);

                // Set remaining posts to be loaded and hide the button if we just loaded the last page
                if (settings['show_remaining']) {
                    if (current == maxpages) {
                        $this.find('span').text(0);
                    }
                    else {
                        var remaining = total - (current * settings['items_per_page']);
                        $this.find('span').text(remaining);
                    }
                }

                if (current == maxpages)
                    $this.addClass('lsow-disabled');

                $parent.removeClass('lsow-processing');
            });

        });

        /* ----------------- Lightbox Support ------------------ */

        $(this).fancybox({
            selector: 'a.lsow-lightbox-item, a.lsow-video-lightbox', // the selector for gallery item
            loop: true,
            caption: function (instance, item) {

                var caption = $(this).attr('title') || '';

                var description = $(this).data('description') || '';

                if (description !== '') {
                    caption += '<div class="lsow-fancybox-description">' + description + '</div>';
                }

                return caption;
            }
        });

    });


});