<?php
/**
 * @var $carousel_settings
 * @var $gallery_class
 * @var $items
 */

if (!empty($instance['title']))
    echo $args['before_title'] . esc_html($instance['title']) . $args['after_title'];

if (!empty($items)) : ?>

    <?php LSOW_Gallery_Carousel_Widget::$gallery_counter++; ?>

    <?php $carousel_settings['gallery_class'] = !empty($gallery_class) ? sanitize_title($gallery_class) : 'gallery-' . LSOW_Gallery_Carousel_Widget::$gallery_counter; ?>

    <div class="lsow-gallery-carousel lsow-container" <?php foreach ($carousel_settings as $key => $val) : ?>
        <?php if (!empty($val)) : ?>
            data-<?php echo $key . '="' . esc_attr($val) . '"' ?>
        <?php endif ?>
    <?php endforeach; ?>>

        <?php foreach ($items as $item): ?>

            <?php

            $style = '';
            if (!empty($item['tags'])) {
                $terms = explode(',', $item['tags']);

                foreach ($terms as $term) {
                    $style .= ' term-' . $term;
                }
            }
            ?>

            <?php

            $item_type = $item['item_type'];
            $item_class = 'lsow-' . $item_type . '-type';

            ?>

            <div class="lsow-gallery-carousel-item <?php echo $style; ?> <?php echo $item_class; ?>">

                <div class="lsow-project-image">

                    <?php if ($item_type == 'image' && !empty($item['link'])): ?>

                        <a href="<?php echo sow_esc_url($item['link']); ?>"
                           title="<?php echo esc_html($item['name']); ?>"
                           target="<?php echo $carousel_settings['link_target']; ?>"><?php echo wp_get_attachment_image($item['image'], $carousel_settings['image_size'], false, array('class' => 'lsow-image large', 'alt' => $item['name'])); ?> </a>

                    <?php else: ?>

                        <?php echo wp_get_attachment_image($item['image'], $carousel_settings['image_size'], false, array('class' => 'lsow-image large', 'alt' => $item['name'])); ?>

                    <?php endif; ?>

                    <div class="lsow-image-info">

                        <div class="lsow-entry-info">

                            <h3 class="lsow-entry-title">

                                <?php if ($item_type == 'image' && !empty($item['link'])): ?>

                                    <a href="<?php echo sow_esc_url($item['link']); ?>"
                                       title="<?php echo esc_html($item['name']); ?>"
                                       target="<?php echo $carousel_settings['link_target']; ?>"><?php echo esc_html($item['name']); ?></a>

                                <?php else: ?>

                                    <?php echo esc_html($item['name']); ?>

                                <?php endif; ?>

                            </h3>

                            <?php if ($item_type == 'youtube' || $item_type == 'vimeo') : ?>

                                <?php
                                $video_url = $item['video_link'];
                                ?>
                                <?php if (!empty($video_url)) : ?>

                                    <a class="lsow-video-lightbox"
                                       data-fancybox="<?php echo $carousel_settings['gallery_class']; ?>"
                                       href="<?php echo $video_url; ?>"
                                       title="<?php echo esc_html($item['name']); ?>"
                                       data-description="<?php echo wp_kses_post($item['description']); ?>"><i
                                                class="lsow-icon-video-play"></i></a>

                                <?php endif; ?>

                            <?php elseif ($item_type == 'html5video' && !empty($item['mp4_video_link'])) : ?>

                                <?php $video_id = 'lsow-video-' . $item['image']; // will use thumbnail id as id for video for now ?>

                                <a class="lsow-video-lightbox"
                                   data-fancybox="<?php echo $carousel_settings['gallery_class']; ?>"
                                   href="#<?php echo $video_id; ?>"
                                   title="<?php echo esc_html($item['name']); ?>"
                                   data-description="<?php echo wp_kses_post($item['description']); ?>"><i
                                            class="lsow-icon-video-play"></i></a>

                                <div id="<?php echo $video_id; ?>" class="lsow-fancybox-video">

                                    <?php

                                    $image_data = wp_get_attachment_image_src($item['image'], 'full');

                                    $image_src = ($image_data) ? $image_data[0]: '';

                                    ?>

                                    <video poster="<?php echo $image_src; ?>"
                                           src="<?php echo $item['mp4_video_link']; ?>"
                                           autoplay="1"
                                           preload="metadata"
                                           controls
                                           controlsList="nodownload">
                                        <source type="video/mp4"
                                                src="<?php echo $item['mp4_video_link']; ?>">
                                        <source type="video/webm"
                                                src="<?php echo $item['webm_video_link']; ?>">
                                    </video>

                                </div>

                            <?php endif; ?>

                            <span class="lsow-terms"><?php echo esc_html($item['tags']); ?></span>

                        </div>

                        <?php if ($item_type == 'image' && $carousel_settings['enable_lightbox']) : ?>

                            <?php
                            $image_data = wp_get_attachment_image_src($item['image'], 'full');
                            ?>
                            <?php if ($image_data) : ?>

                                <?php $image_src = $image_data[0]; ?>

                                <a class="lsow-lightbox-item"
                                   data-fancybox="<?php echo $carousel_settings['gallery_class']; ?>"
                                   href="<?php echo $image_src; ?>"
                                   title="<?php echo esc_html($item['name']); ?>"
                                   data-description="<?php echo wp_kses_post($item['description']); ?>"><i
                                            class="lsow-icon-full-screen"></i></a>

                            <?php endif; ?>

                        <?php endif; ?>


                    </div>

                </div>

            </div>

        <?php endforeach; ?>

    </div> <!-- .lsow-gallery-carousel -->

<?php endif; ?>
