<?php

/*
Widget Name: Gallery Carousel
Description: Display images or videos in a responsive carousel.
Author: LiveMesh
Author URI: https://www.livemeshthemes.com
*/

if (lsow_fs()->can_use_premium_code()) {
    class LSOW_Gallery_Carousel_Widget extends SiteOrigin_Widget {

        static public $gallery_counter = 0;

        function __construct() {
            parent::__construct(
                'lsow-gallery-carousel',
                __('Gallery Carousel', 'livemesh-so-widgets'),
                array(
                    'description' => __('Display images or videos in a responsive carousel.', 'livemesh-so-widgets'),
                    'panels_icon' => 'dashicons dashicons-minus',
                    'help' => LSOW_PLUGIN_HELP_URL . '#image-video-carousel'
                ),
                array(),
                array(
                    'title' => array(
                        'type' => 'text',
                        'label' => __('Title', 'livemesh-so-widgets'),
                    ),

                    'gallery_class' => array(
                        'type' => 'text',
                        'label' => __('Gallery Carousel Class/Identifier', 'livemesh-so-widgets'),
                        'description' => __('Specify an unique identifier used as a custom CSS class name and lightbox group name/slug for the gallery carousel element.', 'livemesh-so-widgets'),
                    ),

                    'items' => array(
                        'type' => 'repeater',
                        'label' => __('Gallery Items', 'livemesh-so-widgets'),
                        'item_name' => __('Gallery Item', 'livemesh-so-widgets'),
                        'item_label' => array(
                            'selector' => "[id*='items-name']",
                            'update_event' => 'change',
                            'value_method' => 'val'
                        ),
                        'fields' => array(

                            'item_type' => array(
                                'type' => 'select',
                                'label' => __('Item Type', 'livemesh-so-widgets'),
                                'description' => __('Specify the item type - if this is an image or represents a YouTube/Vimeo/HTML5 video.', 'livemesh-so-widgets'),
                                'default' => 'image',
                                'state_emitter' => array(
                                    'callback' => 'select',
                                    'args' => array('item_type_{$repeater}')
                                ),
                                'options' => array(
                                    'image' => __('Image', 'livemesh-so-widgets'),
                                    'youtube' => __('YouTube Video', 'livemesh-so-widgets'),
                                    'vimeo' => __('Vimeo Video', 'livemesh-so-widgets'),
                                    'html5video' => __('HTML5 Video', 'livemesh-so-widgets'),
                                ),
                            ),
                            'name' => array(
                                'type' => 'text',
                                'label' => __('Item Label', 'livemesh-so-widgets'),
                                'description' => __('The label or name for the gallery item.', 'livemesh-so-widgets'),
                            ),
                            'image' => array(
                                'type' => 'media',
                                'label' => __('Gallery Image', 'livemesh-so-widgets'),
                                'library' => 'image',
                                'description' => __('The image for the gallery item. If item type chosen is YouTube or Vimeo or MP4/WebM video, the image will be used as a placeholder image for video.', 'livemesh-so-widgets'),
                            ),
                            'tags' => array(
                                'type' => 'text',
                                'label' => __('Item Tag(s)', 'livemesh-so-widgets'),
                                'description' => __('One or more comma separated tags for the gallery item.', 'livemesh-so-widgets'),
                            ),
                            'link' => array(
                                'type' => 'link',
                                'label' => __('Page URL', 'livemesh-so-widgets'),
                                'description' => __('The URL of the page to which the image gallery item points to (optional).', 'livemesh-so-widgets'),
                                'state_handler' => array(
                                    'item_type_{$repeater}[image]' => array('show'),
                                    '_else[item_type_{$repeater}]' => array('hide'),
                                ),
                            ),
                            'video_link' => array(
                                'type' => 'text',
                                'label' => __('Video URL', 'livemesh-so-widgets'),
                                'description' => __('The URL of the YouTube or Vimeo video.', 'livemesh-so-widgets'),
                                'state_handler' => array(
                                    'item_type_{$repeater}[image,html5video]' => array('hide'),
                                    '_else[item_type_{$repeater}]' => array('show'),
                                ),
                            ),
                            'mp4_video_link' => array(
                                'type' => 'text',
                                'label' => __('MP4 Video URL', 'livemesh-so-widgets'),
                                'description' => __('The URL of the MP4 video.', 'livemesh-so-widgets'),
                                'state_handler' => array(
                                    'item_type_{$repeater}[html5video]' => array('show'),
                                    '_else[item_type_{$repeater}]' => array('hide'),
                                ),
                            ),
                            'webm_video_link' => array(
                                'type' => 'text',
                                'label' => __('WebM Video URL', 'livemesh-so-widgets'),
                                'description' => __('The URL of the WebM video.', 'livemesh-so-widgets'),
                                'state_handler' => array(
                                    'item_type_{$repeater}[html5video]' => array('show'),
                                    '_else[item_type_{$repeater}]' => array('hide'),
                                ),
                            ),
                            'description' => array(
                                'type' => 'textarea',
                                'label' => __('Item description', 'livemesh-so-widgets'),
                                'description' => __('Short description for the gallery item displayed in the lightbox gallery.(optional)', 'livemesh-so-widgets'),
                            ),
                        )
                    ),


                    'carousel_settings' => array(
                        'type' => 'section',
                        'label' => __('Carousel Settings', 'livemesh-so-widgets'),
                        'fields' => array(

                            'enable_lightbox' => array(
                                'type' => 'checkbox',
                                'label' => __('Enable Lightbox Gallery?', 'livemesh-so-widgets'),
                                'default' => true
                            ),

                            'image_size' => array(
                                'type' => 'image-size',
                                'label' => __('Image Size', 'livemesh-so-widgets'),
                                'default' => 'large',
                            ),

                            'link_target' => array(
                                'type' => 'select',
                                'label' => __('Link Target', 'livemesh-so-widgets'),
                                'default' => '_self',
                                'options' => array(
                                    '_self' => __('Same Window', 'livemesh-so-widgets'),
                                    '_blank' => __('New Window', 'livemesh-so-widgets'),
                                ),
                            ),

                            'arrows' => array(
                                'type' => 'checkbox',
                                'label' => __('Prev/Next Arrows?', 'livemesh-so-widgets'),
                                'default' => true
                            ),

                            'dots' => array(
                                'type' => 'checkbox',
                                'label' => __('Show dot indicators for navigation?', 'livemesh-so-widgets'),
                            ),

                            'autoplay' => array(
                                'type' => 'checkbox',
                                'label' => __('Autoplay?', 'livemesh-so-widgets'),
                                'description' => __('Should the carousel autoplay as in a slideshow.', 'livemesh-so-widgets'),
                                'default' => false
                            ),


                            'autoplay_speed' => array(
                                'type' => 'number',
                                'label' => __('Autoplay speed in ms', 'livemesh-so-widgets'),
                                'default' => 3000
                            ),


                            'animation_speed' => array(
                                'type' => 'number',
                                'label' => __('Autoplay animation speed in ms', 'livemesh-so-widgets'),
                                'default' => 300
                            ),

                            'pause_on_hover' => array(
                                'type' => 'checkbox',
                                'label' => __('Pause on mouse hover?', 'livemesh-so-widgets'),
                                'default' => true
                            ),

                            'display_columns' => array(
                                'type' => 'slider',
                                'label' => __('Columns per row', 'livemesh-so-widgets'),
                                'min' => 1,
                                'max' => 5,
                                'integer' => true,
                                'default' => 3
                            ),

                            'scroll_columns' => array(
                                'type' => 'slider',
                                'label' => __('Columns to scroll', 'livemesh-so-widgets'),
                                'min' => 1,
                                'max' => 5,
                                'integer' => true,
                                'default' => 3
                            ),

                            'gutter' => array(
                                'type' => 'number',
                                'label' => __('Gutter', 'livemesh-so-widgets'),
                                'description' => __('Space between columns.', 'livemesh-so-widgets'),
                                'default' => 10
                            ),

                            'responsive' => array(
                                'type' => 'section',
                                'label' => __('Responsive', 'livemesh-so-widgets'),
                                'hide' => true,
                                'fields' => array(
                                    'tablet' => array(
                                        'type' => 'section',
                                        'label' => __('Tablet', 'livemesh-so-widgets'),
                                        'fields' => array(
                                            'display_columns' => array(
                                                'type' => 'slider',
                                                'label' => __('Columns per row', 'livemesh-so-widgets'),
                                                'min' => 1,
                                                'max' => 5,
                                                'integer' => true,
                                                'default' => 2
                                            ),
                                            'scroll_columns' => array(
                                                'type' => 'slider',
                                                'label' => __('Columns to scroll', 'livemesh-so-widgets'),
                                                'min' => 1,
                                                'max' => 5,
                                                'integer' => true,
                                                'default' => 2
                                            ),
                                            'gutter' => array(
                                                'type' => 'number',
                                                'label' => __('Gutter', 'livemesh-so-widgets'),
                                                'description' => __('Space between columns.', 'livemesh-so-widgets'),
                                                'default' => 10
                                            ),
                                            'width' => array(
                                                'type' => 'text',
                                                'label' => __('Resolution', 'livemesh-so-widgets'),
                                                'description' => __('The resolution to treat as a tablet resolution.', 'livemesh-so-widgets'),
                                                'default' => 800,
                                                'sanitize' => 'intval',
                                            )
                                        )
                                    ),
                                    'mobile' => array(
                                        'type' => 'section',
                                        'label' => __('Mobile Phone', 'livemesh-so-widgets'),
                                        'fields' => array(
                                            'display_columns' => array(
                                                'type' => 'slider',
                                                'label' => __('Columns per row', 'livemesh-so-widgets'),
                                                'min' => 1,
                                                'max' => 5,
                                                'integer' => true,
                                                'default' => 1
                                            ),
                                            'scroll_columns' => array(
                                                'type' => 'slider',
                                                'label' => __('Columns to scroll', 'livemesh-so-widgets'),
                                                'min' => 1,
                                                'max' => 5,
                                                'integer' => true,
                                                'default' => 1
                                            ),
                                            'gutter' => array(
                                                'type' => 'number',
                                                'label' => __('Gutter', 'livemesh-so-widgets'),
                                                'description' => __('Space between columns.', 'livemesh-so-widgets'),
                                                'default' => 10
                                            ),
                                            'width' => array(
                                                'type' => 'text',
                                                'label' => __('Resolution', 'livemesh-so-widgets'),
                                                'description' => __('The resolution to treat as a mobile resolution.', 'livemesh-so-widgets'),
                                                'default' => 480,
                                                'sanitize' => 'intval',
                                            )
                                        )
                                    )

                                )
                            ),
                        )
                    ),
                )
            );
        }

        function initialize() {

            $this->register_frontend_scripts(
                array(
                    array(
                        'lsow-slick-carousel',
                        LSOW_PLUGIN_URL . 'assets/js/slick' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-fancybox',
                        LSOW_PLUGIN_URL . 'assets/js/premium/jquery.fancybox' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    )
                )
            );

            $this->register_frontend_styles(
                array(
                    array(
                        'lsow-slick',
                        LSOW_PLUGIN_URL . 'assets/css/slick.css',
                        array(),
                        LSOW_VERSION
                    ),
                    array(
                        'lsow-fancybox',
                        LSOW_PLUGIN_URL . 'assets/css/premium/jquery.fancybox.css',
                        array(),
                        LSOW_VERSION
                    ),

                    array(
                        'lsow-premium-frontend-styles',
                        LSOW_PLUGIN_URL . 'assets/css/premium/lsow-frontend.css',
                        array(),
                        LSOW_VERSION
                    ),
                )
            );

            $this->register_frontend_scripts(array(
                    array(
                        'lsow-gallery-carousel',
                        plugin_dir_url(__FILE__) . 'js/gallery-carousel' . LSOW_JS_SUFFIX . '.js',
                        array('jquery')
                    )
                )
            );

            $this->register_frontend_styles(array(
                    array(
                        'lsow-gallery-carousel',
                        plugin_dir_url(__FILE__) . 'css/style.css'
                    )
                )
            );


        }

        function get_less_variables($instance) {

            $vars = array(

                'gutter' => intval($instance['carousel_settings']['gutter']) . 'px',

                // All the responsive sizes
                'tablet_width' => intval($instance['carousel_settings']['responsive']['tablet']['width']) . 'px',
                'tablet_gutter' => intval($instance['carousel_settings']['responsive']['tablet']['gutter']) . 'px',
                'mobile_width' => intval($instance['carousel_settings']['responsive']['mobile']['width']) . 'px',
                'mobile_gutter' => intval($instance['carousel_settings']['responsive']['mobile']['gutter']) . 'px',
            );

            $options = get_option('lsow_settings');

            if ($options && isset($options['lsow_theme_color']))
                $vars['theme_color'] = $options['lsow_theme_color'];

            return $vars;
        }

        function get_template_variables($instance, $args) {

            $return = array(
                'gallery_class' => $instance['gallery_class'],
                'items' => !empty($instance['items']) ? $instance['items'] : array(),
                'carousel_settings' => $instance['carousel_settings']
            );

            unset($return['carousel_settings']['responsive']);

            $return['carousel_settings']['tablet_width'] = $instance['carousel_settings']['responsive']['tablet']['width'];
            $return['carousel_settings']['tablet_display_columns'] = $instance['carousel_settings']['responsive']['tablet']['display_columns'];
            $return['carousel_settings']['tablet_scroll_columns'] = $instance['carousel_settings']['responsive']['tablet']['scroll_columns'];
            $return['carousel_settings']['mobile_width'] = $instance['carousel_settings']['responsive']['mobile']['width'];
            $return['carousel_settings']['mobile_display_columns'] = intval($instance['carousel_settings']['responsive']['mobile']['display_columns']);
            $return['carousel_settings']['mobile_scroll_columns'] = $instance['carousel_settings']['responsive']['mobile']['scroll_columns'];

            return $return;
        }

    }

    siteorigin_widget_register('lsow-gallery-carousel', __FILE__, 'LSOW_Gallery_Carousel_Widget');

}