<?php
/**
 * @var $features
 * @var $id
 * @var $class
 * @var $image_size
 * @var $tiled
 * @var $settings
 */

?>

<?php if (!empty($instance['title']))
    echo balanceTags($args['before_title'] . esc_html($instance['title']) . $args['after_title']) ?>

<?php $class = ($tiled ? 'lsow-tiled ' . $class : $class); ?>

<div class="lsow-features <?php echo esc_attr($class); ?>">

    <?php foreach ($features as $feature): ?>

        <div class="lsow-feature lsow-image-text-toggle">

            <?php list($animate_class, $animation_attr) = lsow_get_animation_atts($feature['settings']['image_animation']); ?>

            <div class="lsow-feature-image lsow-image-content <?php echo $animate_class; ?>" <?php echo $animation_attr; ?>>

                <?php echo wp_get_attachment_image($feature['image'], $image_size, false, array('class' => 'image full')); ?>

            </div>

            <?php list($animate_class, $animation_attr) = lsow_get_animation_atts($feature['settings']['text_animation']); ?>

            <div class="lsow-feature-text lsow-text-content <?php echo $animate_class; ?>" <?php echo $animation_attr; ?>>

                <div class="lsow-subtitle"><?php echo esc_html($feature['subtitle']) ?></div>

                <h3 class="lsow-title"><?php echo esc_html($feature['title']) ?></h3>

                <div class="lsow-feature-details"><?php echo do_shortcode($feature['text']) ?></div>

            </div>

        </div>

        <?php

    endforeach;

    ?>

</div>