<?php

/*
Widget Name: Features
Description: Display product features or services offered
Author: LiveMesh
Author URI: https://www.livemeshthemes.com
*/

if (lsow_fs()->can_use_premium_code()) {

    class LSOW_Features_Widget extends SiteOrigin_Widget {
        function __construct() {
            parent::__construct(
                "lsow-features",
                esc_html__("Features", 'livemesh-so-widgets'),
                array(
                    "description" => esc_html__("Display product features or services offered.", 'livemesh-so-widgets'),
                    "panels_icon" => "dashicons dashicons-minus",
                    'help' => LSOW_PLUGIN_HELP_URL . '#features-widget'
                ),
                array(),

                array(
                    'title' => array(
                        'type' => 'text',
                        'label' => esc_html__('Title', 'livemesh-so-widgets'),
                    ),

                    'id' => array(
                        'type' => 'text',
                        'label' => esc_html__('Features Container ID', 'livemesh-so-widgets'),
                        'description' => esc_html__('The CSS ID for the features container DIV element.', 'livemesh-so-widgets'),
                    ),

                    'class' => array(
                        'type' => 'text',
                        'label' => esc_html__('Features Container Class', 'livemesh-so-widgets'),
                        'description' => esc_html__('The CSS class for the features container DIV element.', 'livemesh-so-widgets'),
                    ),

                    'image_size' => array(
                        'type' => 'image-size',
                        'label' => __('Image Size', 'livemesh-so-widgets'),
                        'default' => 'large',
                    ),

                    'tiled' => array(
                        'type' => 'checkbox',
                        'label' => __('Apply tiled design?', 'livemesh-so-widgets'),
                        'default' => false
                    ),

                    'features' => array(
                        'type' => 'repeater',
                        'label' => esc_html__('Features', 'livemesh-so-widgets'),
                        'item_name' => esc_html__('Feature', 'livemesh-so-widgets'),
                        'item_label' => array(
                            'selector' => "[id*='features-title']",
                            'update_event' => 'change',
                            'value_method' => 'val'
                        ),
                        'fields' => array(

                            'class' => array(
                                'type' => 'text',
                                'label' => esc_html__('Feature Class', 'livemesh-so-widgets'),
                                'description' => esc_html__('The CSS class for the feature DIV element.', 'livemesh-so-widgets'),
                            ),

                            'title' => array(
                                'type' => 'text',
                                'label' => esc_html__('Feature Title', 'livemesh-so-widgets'),
                                'description' => esc_html__('The title for the feature.', 'livemesh-so-widgets'),
                            ),

                            'subtitle' => array(
                                'type' => 'text',
                                'label' => esc_html__('Feature Subtitle', 'livemesh-so-widgets'),
                                'description' => esc_html__('The subtitle for the feature.', 'livemesh-so-widgets'),
                            ),

                            'image' => array(
                                'type' => 'media',
                                'library' => 'image',
                                'label' => esc_html__('Feature Image.', 'livemesh-so-widgets'),
                                'description' => esc_html__('An icon image or a bitmap which best represents the feature we are capturing', 'livemesh-so-widgets'),
                                'fallback' => true
                            ),

                            "text" => array(
                                "type" => "tinymce",
                                "description" => esc_html__("The feature content.", 'livemesh-so-widgets'),
                                "label" => esc_html__("Text", 'livemesh-so-widgets'),
                                "default" => esc_html__("Feature content goes here.", 'livemesh-so-widgets'),
                            ),

                            'settings' => array(
                                'type' => 'section',
                                'label' => esc_html__('Settings', 'livemesh-so-widgets'),
                                'fields' => array(

                                    'image_animation' => array(
                                        'type' => 'select',
                                        'label' => __('Choose Animation for Feature Image', 'livemesh-so-widgets'),
                                        'default' => 'none',
                                        'options' => lsow_get_animation_options(),
                                    ),

                                    'text_animation' => array(
                                        'type' => 'select',
                                        'label' => __('Choose Animation for Feature Text', 'livemesh-so-widgets'),
                                        'default' => 'none',
                                        'options' => lsow_get_animation_options(),
                                    ),
                                )
                            ),
                        )
                    ),

                )
            );
        }


        function initialize() {

            $this->register_frontend_styles(
                array(

                    array(
                        'lsow-frontend-styles',
                        LSOW_PLUGIN_URL . 'assets/css/lsow-frontend.css',
                        array(),
                        LSOW_VERSION
                    ),

                    array(
                        'lsow-premium-frontend-styles',
                        LSOW_PLUGIN_URL . 'assets/css/premium/lsow-frontend.css',
                        array(),
                        LSOW_VERSION
                    ),
                )
            );

            $this->register_frontend_styles(array(
                    array(
                        'lsow-features',
                        plugin_dir_url(__FILE__) . 'css/style.css'
                    )
                )
            );

        }

        function get_template_variables($instance, $args) {
            return array(
                "title" => $instance["title"],
                "id" => $instance["id"],
                "class" => $instance["class"],
                "image_size" => $instance["image_size"],
                "tiled" => $instance["tiled"],
                'features' => !empty($instance['features']) ? $instance['features'] : array()
            );
        }

    }

    siteorigin_widget_register("lsow-features", __FILE__, "LSOW_Features_Widget");

}

