<?php

/*
Widget Name: FAQ
Description: Capture frequently asked questions in a multi-column grid.
Author: LiveMesh
Author URI: https://www.livemeshthemes.com
*/

if (lsow_fs()->can_use_premium_code()) {
    class LSOW_FAQ_Widget extends SiteOrigin_Widget {


        function __construct() {
            parent::__construct(
                'lsow-faq',
                __('FAQ', 'livemesh-so-widgets'),
                array(
                    'description' => __('Create FAQ to display in a multi-column grid.', 'livemesh-so-widgets'),
                    'panels_icon' => 'dashicons dashicons-minus',
                    'help' => LSOW_PLUGIN_HELP_URL . '#faq-widget'
                ),
                array(),
                array(
                    'title' => array(
                        'type' => 'text',
                        'label' => __('Title', 'livemesh-so-widgets'),
                    ),

                    'faq_list' => array(
                        'type' => 'repeater',
                        'label' => __('Frequently Asked Questions', 'livemesh-so-widgets'),
                        'item_name' => __('FAQ Item', 'livemesh-so-widgets'),
                        'item_label' => array(
                            'selector' => "[id*='faq_list-question']",
                            'update_event' => 'change',
                            'value_method' => 'val'
                        ),
                        'fields' => array(

                            'question' => array(
                                'type' => 'text',
                                'label' => __('Question', 'livemesh-so-widgets'),
                                'description' => __('The question for the FAQ item.', 'livemesh-so-widgets'),
                            ),

                            'answer' => array(
                                'type' => 'tinymce',
                                'label' => __('Answer', 'mo_theme'),
                                'description' => __('The HTML content as answer for the FAQ item.', 'mo_theme'),
                            ),

                            'animation' => array(
                                'type' => 'select',
                                'label' => __('Choose Animation Type', 'livemesh-so-widgets'),
                                'default' => 'none',
                                'options' => lsow_get_animation_options(),
                            ),

                        )
                    ),

                    'settings' => array(
                        'type' => 'section',
                        'label' => __('Settings', 'livemesh-so-widgets'),
                        'fields' => array(

                            'per_line' => array(
                                'type' => 'slider',
                                'label' => __('FAQ Items per row', 'livemesh-so-widgets'),
                                'min' => 1,
                                'max' => 4,
                                'integer' => true,
                                'default' => 2
                            ),
                            'per_line_tablet' => array(
                                'type' => 'slider',
                                'label' => __('FAQ Items per row in Tablet Resolution', 'livemesh-so-widgets'),
                                'min' => 1,
                                'max' => 4,
                                'integer' => true,
                                'default' => 1
                            ),
                            'per_line_mobile' => array(
                                'type' => 'slider',
                                'label' => __('FAQ Items per row in Mobile Resolution', 'livemesh-so-widgets'),
                                'min' => 1,
                                'max' => 3,
                                'integer' => true,
                                'default' => 1
                            ),
                        )
                    ),
                )
            );
        }

        function enqueue_frontend_scripts($instance) {

            wp_enqueue_style('lsow-frontend-styles', LSOW_PLUGIN_URL . 'assets/css/lsow-frontend.css', array(), LSOW_VERSION);

            wp_enqueue_style('lsow-faq', siteorigin_widget_get_plugin_dir_url('lsow-faq') . 'css/style.css', array(), LSOW_VERSION);
        }

        function get_template_variables($instance, $args) {
            return array(
                'faq_list' => !empty($instance['faq_list']) ? $instance['faq_list'] : array(),
                'settings' => $instance['settings']
            );
        }

    }

    siteorigin_widget_register('lsow-faq', __FILE__, 'LSOW_FAQ_Widget');

}