<?php

/*
Widget Name: Countdown
Description: Display a countdown timer for an end date.
Author: LiveMesh
Author URI: https://www.livemeshthemes.com
*/

if (lsow_fs()->can_use_premium_code()) {

    class LSOW_Countdown_Widget extends SiteOrigin_Widget {

        function __construct() {
            parent::__construct(
                'lsow-countdown',
                __('Countdown', 'livemesh-so-widgets'),
                array(
                    'description' => __('Display a countdown timer for an end date.', 'livemesh-so-widgets'),
                    'panels_icon' => 'dashicons dashicons-minus',
                    'help' => LSOW_PLUGIN_HELP_URL . '#statistics-widgets'
                ),
                array(),
                array(
                    'title' => array(
                        'type' => 'text',
                        'label' => __('Title', 'livemesh-so-widgets'),
                    ),

                    'label' => array(
                        'type' => 'text',
                        'label' => __('Countdown Label', 'livemesh-so-widgets'),
                        'description' => __('The label for the countdown.', 'livemesh-so-widgets'),
                    ),

                    'end_date' => array(
                        'type' => 'timepicker',
                        'label' => __('End date', 'livemesh-so-widgets'),
                        'description' => __('The end date for the countdown.', 'livemesh-so-widgets'),
                    ),

                    'align' => array(
                        'type' => 'select',
                        'label' => __('Alignment', 'livemesh-so-widgets'),
                        'default' => 'left',
                        'options' => array(
                            'left' => __('Left', 'livemesh-so-widgets'),
                            'right' => __('Right', 'livemesh-so-widgets'),
                            'center' => __('Center', 'livemesh-so-widgets'),
                        )
                    ),

                )
            );
        }

        function initialize() {

            $this->register_frontend_scripts(
                array(
                    array(
                        'lsow-countdown-js',
                        LSOW_PLUGIN_URL . 'assets/js/premium/jquery.countdown' . LSOW_JS_SUFFIX . '.js',
                        array('jquery'),
                        LSOW_VERSION
                    ),
                )
            );


            $this->register_frontend_scripts(
                array(
                    array(
                        'lsow-countdown',
                        plugin_dir_url(__FILE__) . 'js/countdown' . LSOW_JS_SUFFIX . '.js',
                        array('jquery')
                    ),
                )
            );

            $this->register_frontend_styles(array(
                array(
                    'lsow-countdown',
                    plugin_dir_url(__FILE__) . 'css/style.css'
                )
            ));
        }

        function get_template_variables($instance, $args) {
            return array(
                'label' => $instance['label'],
                'end_date' => $instance['end_date'],
                'align' => $instance['align']
            );
        }

    }

    siteorigin_widget_register('lsow-countdown', __FILE__, 'LSOW_Countdown_Widget');

}