<?php
/**
 * @var $carousel_settings
 * @var $settings
 * @var $posts
 */

if (!empty($instance['title']))
    echo $args['before_title'] . esc_html($instance['title']) . $args['after_title'];

$taxonomies = array();

$query_args = siteorigin_widget_post_selector_process_query($posts);

// Use the processed post selector query to find posts.
$loop = new WP_Query($query_args);

// Loop through the posts and do something with them.
if ($loop->have_posts()) : ?>

    <div class="lsow-posts-carousel lsow-container" <?php foreach ($carousel_settings as $key => $val) : ?>
        <?php if (!empty($val)) : ?>
            data-<?php echo $key . '="' . esc_attr($val) . '"' ?>
        <?php endif ?>
    <?php endforeach; ?>>

        <?php
        // Check if any taxonomy filter has been applied
        list($chosen_terms, $taxonomies) = lsow_get_chosen_terms($query_args);
        if (empty($chosen_terms))
            $taxonomies[] = $settings['taxonomy_chosen'];

        ?>

        <?php while ($loop->have_posts()) : $loop->the_post(); ?>

            <div data-id="id-<?php the_ID(); ?>" class="lsow-posts-carousel-item">

                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                    <?php if ($thumbnail_exists = has_post_thumbnail()): ?>

                        <div class="lsow-project-image">

                            <?php if ($settings['image_linkable']): ?>

                                <a href="<?php the_permalink(); ?>"
                                   target="<?php echo $settings['link_target']; ?>"><?php the_post_thumbnail($settings['image_size']); ?></a>

                            <?php else: ?>

                                <?php the_post_thumbnail($settings['image_size']); ?>

                            <?php endif; ?>

                            <div class="lsow-image-info">

                                <div class="lsow-entry-info">

                                    <?php the_title('<h3 class="lsow-post-title"><a target="' . $settings["link_target"] . '" href="' . get_permalink() . '" title="' . get_the_title() . '"
                                               rel="bookmark">', '</a></h3>'); ?>

                                    <?php echo lsow_get_info_for_taxonomies($taxonomies); ?>

                                </div>

                            </div>

                            <div class="lsow-image-overlay"></div>

                        </div>

                    <?php endif; ?>

                    <?php if ($settings['display_title'] || $settings['display_summary']) : ?>

                        <div class="lsow-entry-text-wrap <?php echo($thumbnail_exists ? '' : ' nothumbnail'); ?>">

                            <?php if ($settings['display_title']) : ?>

                                <?php the_title('<h3 class="entry-title"><a target="' . $settings["link_target"] . '" href="' . get_permalink() . '" title="' . get_the_title() . '"
                                               rel="bookmark">', '</a></h3>'); ?>

                            <?php endif; ?>

                            <?php if ($settings['post_meta']['display_post_date'] || $settings['post_meta']['display_author'] || $settings['post_meta']['display_taxonomy']) : ?>

                                <div class="lsow-entry-meta">

                                    <?php if ($settings['post_meta']['display_author']): ?>

                                        <?php echo lsow_entry_author(); ?>

                                    <?php endif; ?>

                                    <?php if ($settings['post_meta']['display_post_date']): ?>

                                        <?php echo lsow_entry_published(); ?>

                                    <?php endif; ?>

                                    <?php if ($settings['post_meta']['display_taxonomy']): ?>

                                        <?php echo lsow_get_info_for_taxonomies($taxonomies); ?>

                                    <?php endif; ?>

                                </div>

                            <?php endif; ?>

                            <?php if ($settings['display_summary']) : ?>

                                <div class="entry-summary">

                                    <?php the_excerpt(); ?>

                                </div>

                            <?php endif; ?>

                        </div>

                    <?php endif; ?>

                </article>
                <!-- .hentry -->

            </div><!--.lsow-posts-carousel-item -->

        <?php endwhile; ?>

        <?php wp_reset_postdata(); ?>

    </div> <!-- .lsow-posts-carousel -->

<?php endif; ?>