<?php

abstract class LSOW_Block {

    protected $block_uid;

    protected $wp_query;

    protected $query_args;

    protected $settings = array();

    protected $block_header_obj;

    /* Force override  */
    abstract function get_block_class();

    /* Force override  */
    abstract function inner($posts, $settings);

    function init($settings) {

        $output = '';

        $this->add_related_posts_params($settings);

        $defaults = array(
            'class' => '',
            'heading' => '',
            'heading_url' => '',
            'block_type' => 'block_1',
            'filterable' => true,
            'taxonomy_chosen' => 'category',
            'current_filter_term' => '',
            'pagination' => 'none',
            'show_remaining' => true,
            'show_related_posts' => false,
            'current_post_id' => '',
        );

        $this->settings = wp_parse_args($settings, $defaults);

        $this->query_args = lsow_process_block_query($this->settings);

        $this->wp_query = new WP_Query($this->query_args);

        $this->block_uid = 'lsow-block-uid-' . uniqid();

        $this->add_class($this->block_uid);

        $block_filter_terms = $this->get_block_filter_terms();

        $block_header_args = array(
            'settings' => $this->settings,
            'block_uid' => $this->block_uid,
            'block_filter_terms' => $block_filter_terms
        );

        $block_header_class = LSOW_Blocks_Manager::get_class_name($this->settings['header_template']);

        $this->block_header_obj = new $block_header_class($block_header_args);

        return $output;

    }

    function render($settings) {

        $output = $this->init($settings);

        $output .= '<div id="' . $this->block_uid . '" class="' . $this->get_block_classes() . '" ' . $this->get_block_data_atts() . '>';

        $output .= $this->get_block_header();

        // add container class to enable column styling
        $output .= '<div class="lsow-block-inner lsow-grid-container '. $this->get_grid_classes($settings) . '">';

        $output .= $this->inner($this->wp_query->posts, $this->settings);

        $output .= '</div><!-- .block-inner -->';

        $output .= $this->get_block_pagination();

        $output .= '</div><!-- .block -->';

        return $output;

    }

    // get atts
    protected function get_block_data_atts() {

        $output = '';

        $output .= " data-block-uid='" . $this->block_uid . "'";

        $output .= " data-query='" . wp_json_encode($this->query_args) . "'";

        $output .= " data-settings='" . wp_json_encode(array_diff_key($this->settings, array('posts' => ''))) . "'";

        $output .= " data-taxonomies='" . wp_json_encode($this->settings['taxonomies']) . "'";

        $output .= " data-current='1'";

        $output .= " data-maxpages='" . $this->wp_query->max_num_pages . "'";

        // will be populated later when filter links are clicked by user
        $output .= " data-filter-term=''";
        $output .= " data-filter-taxonomy=''";

        return $output;

    }

    function get_block_header() {

        return $this->block_header_obj->get_block_header();

    }

    private function add_class($class_name) {

        if (!empty($this->settings['block_class'])) {

            $this->settings['class'] = $this->settings['block_class'] . ' ' . $class_name;
        }
        else {
            $this->settings['class'] = $class_name;
        }
    }

    private function add_related_posts_params($settings) {

        if (!empty($settings['show_related_posts'])) {

            $settings['current_post_id'] = get_queried_object_id();

        }
    }

    private function get_block_filter_terms() {

        $block_filter_terms = array();

        // Check if any taxonomy filter has been applied
        list($chosen_terms, $taxonomies) = lsow_get_chosen_terms($this->query_args);

        if (empty($chosen_terms))
            $taxonomies[] = $this->settings['taxonomy_chosen'];

        $this->settings['taxonomies'] = $taxonomies;

        if ($this->settings['filterable']) {

            if (empty($chosen_terms)) {

                global $wp_version;

                if (version_compare($wp_version, '4.5', '>=')) {
                    $terms = get_terms($taxonomies);
                }
                else {
                    $terms = get_terms($taxonomies[0]);
                }
            }
            else {
                $terms = $chosen_terms;
            }

            if (!empty($terms) && !is_wp_error($terms)) {
                $block_filter_terms = $terms;
            }
        }

        return $block_filter_terms;

    }


    function get_block_pagination() {

        $loop = $this->wp_query;

        $pagination_type = $this->settings['pagination'];

        // no pagination required if option is not chosen by user or if all posts are already displayed
        if ($pagination_type == 'none' || $loop->max_num_pages == 1)
            return;


        $output = '<div class="lsow-pagination ' . 'lsow-' . preg_replace('/_/', '-', $pagination_type) . '-nav">';

        switch ($pagination_type) {

            case 'next_prev':

                $output .= '<a class="lsow-page-nav lsow-disabled" href="#" data-page="prev"><i class="lsow-icon-arrow-left3"></i></a>';

                $output .= '<a class="lsow-page-nav" href="#" data-page="next"><i class="lsow-icon-arrow-right3"></i></a>';

                break;

            case 'load_more':

                $output .= '<a href="#" class="lsow-load-more lsow-button">';

                $output .= __('Load More', 'livemesh-so-widgets');

                if ($this->settings['show_remaining'])
                    $output .= ' - ' . '<span>' . (intval($loop->found_posts) - $loop->post_count) . '</span>';

                $output .= '</a>';

                break;

            case 'paged':

                $page_links = array();

                for ($n = 1; $n <= $loop->max_num_pages; $n++) :
                    $page_links[] = '<a class="lsow-page-nav lsow-numbered' . ($n == 1 ? ' lsow-current-page' : '') . '" href="#" data-page="' . $n . '">' . number_format_i18n($n) . '</a>';
                endfor;

                $r = join("\n", $page_links);

                if (!empty($page_links)) {
                    $prev_link = '<a class="lsow-page-nav lsow-disabled" href="#" data-page="prev"><i class="lsow-icon-arrow-left3"></i></a>';
                    $next_link = '<a class="lsow-page-nav" href="#" data-page="next"><i class="lsow-icon-arrow-right3"></i></a>';

                    $output .= $prev_link . "\n" . $r . "\n" . $next_link;
                }

                break;
        }

        $output .= '<span class="lsow-loading"></span>';

        $output .= '</div><!-- .lsow-pagination -->';

        return $output;
    }

    function get_column_class($column_size = 3) {

        // Ignore column size since grid class will determine the column size
        $style_class = 'lsow-grid-item';

        return $style_class;
    }

    function get_grid_classes_from_field($settings, $columns_field) {

        return lsow_get_grid_classes($settings, $columns_field);

    }

    protected function get_block_classes($classes_array = array()) {

        $block_classes = array();

        // add container class to enable column styling
        $block_classes[] = 'lsow-container';

        // add block wrap
        $block_classes[] = 'lsow-block';

        // add block id for styling
        $block_classes[] = $this->get_block_class();

        // add block header type for styling
        $block_classes[] = $this->block_header_obj->get_block_header_class();

        //add the classes that we receive via settings and those which are set based on block id
        $class = $this->settings['class'];
        if (!empty($class)) {
            $class_array = explode(' ', $class);
            $block_classes = array_merge(
                $block_classes,
                $class_array
            );
        }

        //marge the additional classes received from blocks code
        if (!empty($classes_array)) {
            $block_classes = array_merge(
                $block_classes,
                $classes_array
            );
        }

        //remove duplicates
        $block_classes = array_unique($block_classes);

        return implode(' ', $block_classes);
    }

    protected function get_grid_classes($settings) {

        return $this->get_grid_classes_from_field($settings, 'per_line');

    }


}