<?php

/**
 * Class description
 *
 * @package   package_name
 * @author    Cherry Team
 * @license   GPL-2.0+
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'Jet_Parallax_Element_Extension' ) ) {

	/**
	 * Define Jet_Parallax_Element_Extension class
	 */
	class Jet_Parallax_Element_Extension {

		/**
		 * [$parallax_sections description]
		 * @var array
		 */
		public $parallax_sections = array();

		/**
		 * A reference to an instance of this class.
		 *
		 * @since  1.0.0
		 * @access private
		 * @var    object
		 */
		private static $instance = null;

		/**
		 * Init Handler
		 */
		public function init() {
			add_action( 'elementor/element/section/section_layout/after_section_end', array( $this, 'after_section_end' ), 10, 2 );

			add_action( 'elementor/frontend/element/before_render', array( $this, 'section_before_render' ) );

			add_action( 'elementor/frontend/section/before_render', array( $this, 'section_before_render' ) );

			add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'enqueue_scripts' ), 9 );
		}

		/**
		 * After section_layout callback
		 *
		 * @param  object $obj
		 * @param  array $args
		 * @return void
		 */
		public function after_section_end( $obj, $args ) {

			$obj->start_controls_section(
				'section_parallax_plugin',
				array(
					'label' => esc_html__( 'Jet Parallax', 'jet-parallax' ),
					'tab'   => Elementor\Controls_Manager::TAB_LAYOUT,
				)
			);

			$repeater = new Elementor\Repeater();

			$repeater->add_control(
				'jet_parallax_plugin_layout_image',
				array(
					'label'     => esc_html__( 'Image', 'jet-parallax' ),
					'type'      => Elementor\Controls_Manager::MEDIA,
					'dynamic'   => array( 'active' => true ),
					'selectors' => array(
						'{{WRAPPER}} {{CURRENT_ITEM}}.jet-parallax-plugin-section__layout .jet-parallax-plugin-section__image' => 'background-image: url("{{URL}}") !important;',
					),
				)
			);

			$repeater->add_control(
				'jet_parallax_plugin_layout_speed',
				array(
					'label'      => esc_html__( 'Parallax Speed(%)', 'jet-parallax' ),
					'type'       => Elementor\Controls_Manager::SLIDER,
					'size_units' => array( '%' ),
					'range'      => array(
						'%' => array(
							'min'  => 1,
							'max'  => 100,
						),
					),
					'default' => array(
						'size' => 50,
						'unit' => '%',
					),
				)
			);

			$repeater->add_control(
				'jet_parallax_plugin_layout_type',
				array(
					'label'   => esc_html__( 'Parallax Type', 'jet-parallax' ),
					'type'    => Elementor\Controls_Manager::SELECT,
					'default' => 'scroll',
					'options' => array(
						'none'   => esc_html__( 'None', 'jet-parallax' ),
						'scroll' => esc_html__( 'Scroll', 'jet-parallax' ),
						'mouse'  => esc_html__( 'Mouse Move', 'jet-parallax' ),
					),
				)
			);

			$repeater->add_control(
				'jet_parallax_plugin_layout_z_index',
				array(
					'label'    => esc_html__( 'z-Index', 'jet-parallax' ),
					'type'     => Elementor\Controls_Manager::NUMBER,
					'min'      => 0,
					'max'      => 99,
					'step'     => 1,
					'default'  => 1,
				)
			);

			$repeater->add_control(
				'jet_parallax_plugin_layout_bg_x',
				array(
					'label'   => esc_html__( 'Background X Position(%)', 'jet-parallax' ),
					'type'    => Elementor\Controls_Manager::NUMBER,
					'min'     => -200,
					'max'     => 200,
					'step'    => 1,
					'default' => 50,
				)
			);

			$repeater->add_control(
				'jet_parallax_plugin_layout_bg_y',
				array(
					'label'   => esc_html__( 'Background Y Position(%)', 'jet-parallax' ),
					'type'    => Elementor\Controls_Manager::NUMBER,
					'min'     => -200,
					'max'     => 200,
					'step'    => 1,
					'default' => 50,
				)
			);

			$repeater->add_control(
				'jet_parallax_plugin_layout_bg_size',
				array(
					'label'   => esc_html__( 'Background Size', 'jet-parallax' ),
					'type'    => Elementor\Controls_Manager::SELECT,
					'default' => 'auto',
					'options' => array(
						'auto'    => esc_html__( 'Auto', 'jet-parallax' ),
						'cover'   => esc_html__( 'Cover', 'jet-parallax' ),
						'contain' => esc_html__( 'Contain', 'jet-parallax' ),
					),
				)
			);

			$repeater->add_control(
				'jet_parallax_plugin_layout_animation_prop',
				array(
					'label'   => esc_html__( 'Animation Property', 'jet-parallax' ),
					'type'    => Elementor\Controls_Manager::SELECT,
					'default' => 'transform',
					'options' => array(
						'bgposition'  => esc_html__( 'Background Position', 'jet-parallax' ),
						'transform'   => esc_html__( 'Transform', 'jet-parallax' ),
						'transform3d' => esc_html__( 'Transform 3D', 'jet-parallax' ),
					),
				)
			);

			$obj->add_control(
				'jet_parallax_plugin_layout_list',
				array(
					'type'    => Elementor\Controls_Manager::REPEATER,
					'fields'  => array_values( $repeater->get_controls() ),
					'default' => array(
						array(
							'jet_parallax_plugin_layout_image' => array(
								'url' => '',
							),
						)
					),
				)
			);

			$obj->end_controls_section();
		}

		/**
		 * Elementor before section render callback
		 *
		 * @param  object $obj
		 * @return void
		 */
		public function section_before_render( $obj ) {
			$data     = $obj->get_data();
			$type     = isset( $data['elType'] ) ? $data['elType'] : 'section';
			$settings = $data['settings'];

			if ( 'section' === $type && isset( $settings['jet_parallax_plugin_layout_list'] ) ) {
				$this->parallax_sections[ $data['id'] ] = method_exists( $obj, 'get_settings_for_display' ) ? $obj->get_settings_for_display( 'jet_parallax_plugin_layout_list' ) : $settings['jet_parallax_plugin_layout_list'];
			}
		}

		/**
		 * [enqueue_scripts description]
		 *
		 * @return void
		 */
		public function enqueue_scripts() {


			if ( ! array_key_exists( 'jetParallaxPluginSections', jet_parallax_assets()->localize_data ) ) {
				jet_parallax_assets()->localize_data['jetParallaxPluginSections'] = $this->parallax_sections;
			}
		}

		/**
		 * Returns the instance.
		 *
		 * @since  1.0.0
		 * @access public
		 * @return object
		 */
		public static function get_instance() {
			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
			}
			return self::$instance;
		}
	}
}

/**
 * Returns instance of Jet_Parallax_Element_Extension
 *
 * @return object
 */
function jet_parallax_element_extension() {
	return Jet_Parallax_Element_Extension::get_instance();
}
