<?php 
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
error_reporting(E_ERROR);
if(!isset($_SESSION['install_step']) || $_SESSION['install_step'] < 3) {
	header("location:./database_details.php");
	exit();
}
function randHash($len=32) {
	return substr(md5(openssl_random_pseudo_bytes(20)),-$len);
}
function secure_hash($password) {
	$salt = sha1($password);
	$password = sha1((md5($password).$salt));
	return sha1($password.md5($salt));
}
include("db/connect.php");

function validEmail($email) {
	return preg_match('/^\S+@[\w\d.-]{2,}\.[\w]{2,6}$/iU', $email) ? true : false;	
}

function isAlphaNum($val) {
	return (bool) preg_match("/^([a-zA-Z0-9])+$/i", $val);
}

function getDomain($url) {
	if(preg_match("#https?://#", $url) === 0) {
		$url = 'http://' . $url;
	}
	return strtolower(str_ireplace('www.', '', parse_url($url, PHP_URL_HOST)));
}

if(isset($_POST['submit'])) {
	$error = false;
	$basePathValue = rtrim(trim($_POST['basePath']),"/");
	$www =  0;
	$https = 0;
	if(empty($basePathValue)) {
		$error = true;
		$basePathError = "Should not be empty";
	}
	$title = $_POST['title'];
	if(empty($title)) {
		$titleError = "Should not be empty";
		$error = true;
	}
	$email = $_POST['email'];
	if(!validEmail($email)) {
		$emailError = "Invalid Email address.";
		$error = true;
	}
	$username = $_POST['username'];
	if(!isAlphaNum($username)) {
		$usernameError = "Only a-z and 0-9 allowed.";
		$error = true;
	}
	$password = $_POST['password'];
	$confirmPassword = $_POST['confirmPassword'];
	if(empty($password)) {
		$error = true;
		$passwordError = "Should not be empty";
	}
	else if(empty($confirmPassword)) {
		$error = true;
		$confirmPasswordError = "Should not be empty";
	}
	else if($password != $confirmPassword) {
		$error = true;
		$passwordError = "Passwords does not match";
	}
	$encryptionKey = randHash();
	if(empty($encryptionKey)) {
		$encryptionKeyError = "Should not be empty";
		$error = true;
	}
	
	if(!$error) {
		$sampleFile = file_get_contents("samples/config.sample");
		$sampleFile = str_replace("{{base_url}}",$basePathValue,$sampleFile);
		$sampleFile = str_replace("{{encryption_key}}",$encryptionKey,$sampleFile);
		file_put_contents("../application/config/config.php",$sampleFile);
		$date = date('Y-m-d');
		$uPassword = secure_hash($password);
		$mysqli->query("UPDATE `settings` SET `username`='$username',`email`='$email',`password`='$uPassword', `contactEmail`='$email', `version`='2.0'");
		$mysqli->query("IF (SELECT 1=1 FROM stats WHERE date='$date') THEN UPDATE stats SET pageviews=pageviews+1 WHERE date='$date'; ELSE INSERT INTO stats (date,pageviews) VALUES('$date',1); END IF");
		$mysqli->query("IF (SELECT 1=1 FROM stats WHERE date='$date') THEN UPDATE stats SET unique_hits=unique_hits+1 WHERE date='$date'; ELSE INSERT INTO stats (date,unique_hits) VALUES('$date',1); END IF");
		$mysqli->close();
		$_SESSION['install_step'] = 4;
		header("location:./finish.php");
		exit();
	}
}
include("includes/head.php"); 
?>
<title>Website Details And Settings</title>
<?php include("includes/header.php"); ?>
<?php include("includes/sidebar.php"); ?>
<div class="rightSide">
	<div class="col-xs-12">
		<div class="tab-content shadow-1">
			<div role="tabpanel" class="tab-pane active">
				<form class="form-horizontal" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
					<?php
					if(isset($_POST['submit']) && $error == true) {
						?>
						<div class="alert alert-danger alert-dismissable">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<strong>Error!</strong> Some error occured settings could not be update.
						</div>
						<?php
					}
					?>
					<div class="form-group">
						<label class="col-sm-3 control-label">Install Path</label>
						<div class="col-sm-9">
							<input type="text" name="basePath" placeholder="BasePath" value="http://<?php echo (isset($basePath) ? $basePath : getDomain($_SERVER['SERVER_NAME']) . str_replace("/install","",dirname($_SERVER['SCRIPT_NAME']))); ?>" class="form-control" />
							<?php
							if(isset($basePathError)) {
								?>
								<span class="text-danger"><?php echo $basePathError; ?></span>
								<?php
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">Website Title</label>
						<div class="col-sm-9">
							<input type="text" name="title" placeholder="Website Title..." value="<?php echo (isset($title) ? $title : ""); ?>" class="form-control" />
							<?php
							if(isset($titleError)) {
								?>
								<span class="text-danger"><?php echo $titleError; ?></span>
								<?php
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">Admin Email</label>
						<div class="col-sm-9">
							<input type="text" name="email" placeholder="Admin Email..." class="form-control" value="<?php echo (isset($email) ? $email : ""); ?>" />
							<?php
							if(isset($emailError)) {
								?>
								<span class="text-danger"><?php echo $emailError; ?></span>
								<?php
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">Admin Username</label>
						<div class="col-sm-9">
							<input type="text" name="username" placeholder="Admin Username..." class="form-control" value="<?php echo (isset($username) ? $username : ""); ?>" />
							<?php
							if(isset($usernameError)) {
								?>
								<span class="text-danger"><?php echo $usernameError; ?></span>
								<?php
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">Admin Password</label>
						<div class="col-sm-9">
							<input type="password" name="password" placeholder="Admin Password..." class="form-control" value="<?php echo (isset($password) ? $password : ""); ?>" />
							<?php
							if(isset($passwordError)) {
								?>
								<span class="text-danger"><?php echo $passwordError; ?></span>
								<?php
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">Confirm Admin Password</label>
						<div class="col-sm-9">
							<input type="password" name="confirmPassword" placeholder="Confirm Admin Password" class="form-control" value="<?php echo (isset($confirmPassword) ? $confirmPassword : ""); ?>" />
							<?php
							if(isset($confirmPasswordError)) {
								?>
								<span class="text-danger"><?php echo $confirmPasswordError; ?></span>
								<?php
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-8">
							<button type="submit" name="submit" class="btn btn-theme btn-lg">Submit</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<?php include("includes/footer.php"); ?>