-- Adminer 4.6.3 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `ads`;
CREATE TABLE `ads` (
  `medrec1` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `medrec1_status` tinyint(1) NOT NULL,
  `medrec2` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `medrec2_status` tinyint(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `ads` (`medrec1`, `medrec1_status`, `medrec2`, `medrec2_status`) VALUES
('<img src=\"https://placehold.it/728x90\">',	1,	'<img src=\"https://placehold.it/728x90\">',	1);

DROP TABLE IF EXISTS `affiliates`;
CREATE TABLE `affiliates` (
  `id` tinyint(5) NOT NULL,
  `affiliate_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `affiliate_title` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `displayOrder` tinyint(4) NOT NULL,
  `com` varchar(10) NOT NULL,
  `net` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `org` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  `url` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `precedence` tinyint(2) NOT NULL,
  `affiliates_links` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `us` varchar(10) NOT NULL,
  `info` varchar(10) NOT NULL,
  `co` varchar(10) NOT NULL,
  `biz` varchar(10) NOT NULL,
  `mobi` varchar(10) NOT NULL,
  `tv` varchar(10) NOT NULL,
  `uk` varchar(10) NOT NULL,
  `ca` varchar(10) NOT NULL,
  `in` varchar(10) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `affiliates` (`id`, `affiliate_name`, `affiliate_title`, `displayOrder`, `com`, `net`, `org`, `status`, `url`, `precedence`, `affiliates_links`, `us`, `info`, `co`, `biz`, `mobi`, `tv`, `uk`, `ca`, `in`) VALUES
(1,	'godaddy',	'Godaddy',	1,	'1.49',	'9.99',	'8.99',	1,	'http://www.dpbolvw.net/click-7753202-10388358',	1,	'https://signup.cj.com/member/publisherSignUp.do',	'',	'',	'',	'',	'',	'',	'',	'',	''),
(2,	'iwant_my_name',	'IWantMyName',	6,	'14.90',	'14.90',	'15.50',	1,	'https://www.shareasale.com/newconfirm.cfm?userID=936361&auth=KzxIISxHSVJeNEA7LVdfRCAK&m=25581',	2,	'https://iwantmyname.com/affiliate',	'',	'',	'',	'',	'',	'',	'',	'',	''),
(3,	'media_temple',	'Media Temple',	3,	'15',	'15',	'15',	1,	'http://www.mediatemple.net#a_aid=54d33fbe727e2',	3,	'http://member.impactradius.com/campaign-campaign-info/Media-Temple.brand',	'',	'',	'',	'',	'',	'',	'',	'',	''),
(4,	'name_cheap',	'Namecheap',	2,	'10.69',	'12.48',	'11.48',	1,	'http://www.anrdoezrs.net/click-7753202-11674393',	4,	'https://signup.cj.com/member/publisherSignUp.do',	'',	'',	'',	'',	'',	'',	'',	'',	''),
(5,	'one_one',	'1 & 1',	4,	'0.99',	'0.99',	'6.99',	1,	'http://www.tkqlhce.com/click-7756212-11231445',	5,	'https://signup.cj.com/member/publisherSignUp.do',	'',	'',	'',	'',	'',	'',	'',	'',	''),
(6,	'register',	'Register',	9,	'0',	'0',	'0',	1,	'http://www.anrdoezrs.net/click-7753202-11336055',	6,	'https://signup.cj.com/member/publisherSignUp.do',	'',	'',	'',	'',	'',	'',	'',	'',	''),
(7,	'united_domains',	'United Domain',	7,	'9.90',	'14.90',	'14.90',	1,	'https://www.dpbolvw.net/click-7384289-11323759?sid=1673601704.1419598115',	7,	'https://signup.cj.com/member/publisherSignUp.do',	'',	'',	'',	'',	'',	'',	'',	'',	''),
(8,	'yahoo',	'Yahoo',	5,	'9.95',	'9.95',	'9.95',	1,	'http://www.dpbolvw.net/click-7517193-10670391?sid=1673601704.1419598115',	8,	'https://signup.cj.com/member/publisherSignUp.do',	'',	'',	'',	'',	'',	'',	'',	'',	''),
(9,	'hover',	'Hover',	8,	'12.99',	'13.60',	'12.99',	1,	'https://hover.evyy.net/c/125102/154283/2799',	1,	'http://member.impactradius.com/campaign-campaign-info/Hover.brand',	'',	'',	'',	'',	'',	'',	'',	'',	'');

DROP TABLE IF EXISTS `analytics`;
CREATE TABLE `analytics` (
  `tracking_code` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `status` tinyint(2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `analytics` (`tracking_code`, `status`) VALUES
('<script async src=\"//www.googletagmanager.com/gtag/js?id=UA-2327545-22\"></script>\r\n<script> \r\nwindow.dataLayer = window.dataLayer || [];\r\nfunction gtag(){dataLayer.push(arguments);}\r\ngtag(\'js\', new Date());\r\n\r\ngtag(\'config\', \'UA-2327545-22\');\r\n</script>',	1);

DROP TABLE IF EXISTS `cache_settings`;
CREATE TABLE `cache_settings` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `tld_time` varchar(10) NOT NULL,
  `tld_status` tinyint(1) NOT NULL,
  `suggest_time` varchar(10) NOT NULL,
  `suggest_status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `cache_settings` (`id`, `tld_time`, `tld_status`, `suggest_time`, `suggest_status`) VALUES
(2,	'86400',	1,	'86400',	1);

DROP TABLE IF EXISTS `captcha_settings`;
CREATE TABLE `captcha_settings` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `captcha_contact_status` tinyint(2) NOT NULL,
  `captcha_admin_login_status` tinyint(2) NOT NULL,
  `recaptcha_key` varchar(250) DEFAULT NULL,
  `recaptcha_secret` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `captcha_settings` (`id`, `captcha_contact_status`, `captcha_admin_login_status`, `recaptcha_key`, `recaptcha_secret`) VALUES
(1,	0,	0,	'',	'');

DROP TABLE IF EXISTS `currency_settings`;
CREATE TABLE `currency_settings` (
  `cr_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `price_dollor` int(10) NOT NULL,
  `show_place` tinyint(2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `currency_settings` (`cr_name`, `price_dollor`, `show_place`) VALUES
('PKR',	130,	1);

DROP TABLE IF EXISTS `emailsettings`;
CREATE TABLE `emailsettings` (
  `esId` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(100) NOT NULL,
  `port` varchar(20) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL,
  `emailSMTP` varchar(100) NOT NULL,
  `emailMailer` varchar(100) NOT NULL,
  `type` tinyint(1) NOT NULL,
  PRIMARY KEY (`esId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `emailsettings` (`esId`, `host`, `port`, `username`, `password`, `emailSMTP`, `emailMailer`, `type`) VALUES
(1,	'',	'',	'',	'',	'',	'',	1);

DROP TABLE IF EXISTS `instant_domain`;
CREATE TABLE `instant_domain` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `domain` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `com` tinyint(1) NOT NULL,
  `net` tinyint(1) NOT NULL DEFAULT '0',
  `org` tinyint(1) NOT NULL DEFAULT '0',
  `last_date_check` date NOT NULL,
  `us` tinyint(1) NOT NULL,
  `info` tinyint(1) NOT NULL,
  `co` tinyint(1) NOT NULL,
  `biz` tinyint(1) NOT NULL,
  `mobi` tinyint(1) NOT NULL,
  `tv` tinyint(1) NOT NULL,
  `uk` tinyint(1) NOT NULL,
  `ca` tinyint(1) NOT NULL,
  `in` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `language`;
CREATE TABLE `language` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `lang_file` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `display_order` tinyint(2) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `RTL_status` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `language` (`id`, `lang_name`, `lang_file`, `display_order`, `status`, `RTL_status`) VALUES
(1,	'English (UK)',	'english.php',	1,	1,	0);

DROP TABLE IF EXISTS `linklanguage`;
CREATE TABLE `linklanguage` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `permalink` varchar(100) NOT NULL,
  `language` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `linklanguage` (`id`, `title`, `permalink`, `language`) VALUES
(1,	'Nexthon',	'https://nexthon.com',	'English (UK)'),
(2,	'Nexshot',	'https://nexshot.io',	'English (UK)');

DROP TABLE IF EXISTS `links`;
CREATE TABLE `links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `permalink` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `display_order` tinyint(4) NOT NULL,
  `header_status` tinyint(1) NOT NULL,
  `footer_status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `links` (`id`, `title`, `permalink`, `status`, `display_order`, `header_status`, `footer_status`) VALUES
(1,	'Nexthon',	'https://nexthon.com',	1,	1,	1,	1),
(2,	'Nexshot',	'https://nexshot.io',	1,	1,	1,	1);

DROP TABLE IF EXISTS `main_tld`;
CREATE TABLE `main_tld` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `tld` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `main_tld` (`id`, `tld`) VALUES
(1,	'co');

DROP TABLE IF EXISTS `pages`;
CREATE TABLE `pages` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `permalink` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(160) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `keywords` varchar(160) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  `display_order` tinyint(4) NOT NULL,
  `header_status` tinyint(1) NOT NULL,
  `footer_status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `pages` (`id`, `permalink`, `description`, `keywords`, `status`, `display_order`, `header_status`, `footer_status`) VALUES
(1,	'home',	'Instant Domain Search is a powerful php based script to search domain names instantly with AJAX.',	'Instant Domain Search,Search Domain,Easy Domain Finder,Domain Lookup,Search Domain Names',	1,	1,	1,	1),
(3,	'tos',	'Instant Domain Search is a powerful php based script to search domain names instantly with AJAX.',	'Instant Domain Search,Search Domain,Easy Domain Finder,Domain Lookup,Search Domain Names',	1,	4,	0,	1),
(4,	'about',	'Instant Domain Search is a powerful php based script to search domain names instantly with AJAX.',	'Instant Domain Search,Search Domain,Easy Domain Finder,Domain Lookup,Search Domain Names',	1,	3,	1,	1),
(5,	'contact',	'Instant Domain Search is a powerful php based script to search domain names instantly with AJAX.',	'Instant Domain Search,Search Domain,Easy Domain Finder,Domain Lookup,Search Domain Names',	1,	2,	1,	1),
(6,	'whois',	'Instant Domain Search is a powerful php based script to search domain names instantly with AJAX.',	'Instant Domain Search,Search Domain,Easy Domain Finder,Domain Lookup,Search Domain Names',	1,	5,	0,	0);

DROP TABLE IF EXISTS `page_language`;
CREATE TABLE `page_language` (
  `id` tinyint(2) NOT NULL,
  `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `permalink` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `page_language` (`id`, `title`, `permalink`, `content`, `language`) VALUES
(1,	'Home',	'home',	'<div class=\"index-content fr-tag\"><div class=\"container fr-tag\"><div class=\"row slideInDown animated fr-tag\"><div class=\"col-xs-12 fr-tag\"><div class=\"homepage-content-title fr-tag\"><span>Instant Domain Search Script</span></div><!-- .homepage-content-title --><div class=\"homepage-content-detail-main fr-tag\">Domain name search results appear as you type. We generate domain names, check domain extensions, and show domains for sale instantly. Many other domain search sites are slow or limit how many searches you can do. We usually show search results in less than 100 milliseconds, and you can use our site as much as you want.</div><!-- .homepage-content-detail-main --></div><!-- .col --></div><!-- .row --><div class=\"row fr-tag\"><div class=\"col-md-6 fadeInLeft animated fr-tag\"><div class=\"homepage-small-content-area fr-tag\"><div class=\"small-content-left fr-tag\"><img src=\"//i.imgur.com/ragGWlk.png\" class=\"fr-fin fr-tag\"></div><!-- .small-content-left --><div class=\"small-content-right fr-tag\"><div class=\"small-content-right-title fr-tag\">Domain Search</div><!-- .small-content-right-title --><div class=\"small-content-right-detail fr-tag\">We generate domain names and check domain extensions instantly. We use artificial intelligence&nbsp;techniques to find domains for sale that you can buy today and expired domains to&nbsp;backorder. Just start typing!</div><!-- .small-content-right-detail --></div><!-- .small-content-right --></div><!-- .homepage-small-content-area --></div><!-- .col --><div class=\"col-md-6 fadeInRight animated fr-tag\"><div class=\"homepage-small-content-area fr-tag\"><div class=\"small-content-left fr-tag\"><img src=\"//i.imgur.com/eFbtNHg.png\" class=\"fr-fin fr-tag\"></div><!-- .small-content-left --><div class=\"small-content-right fr-tag\"><div class=\"small-content-right-title fr-tag\">Whois Search</div><!-- .small-content-right-title --><div class=\"small-content-right-detail fr-tag\">Get verified Whois information for any Domain Name, Check Domain Availability for FREE.&nbsp;Whois is a query and response protocol that is widely used for querying databases that store the registered users or assignees of an Internet resource, such as a domain name</div><!-- .small-content-right-detail --></div><!-- .small-content-right --></div><!-- .homepage-small-content-area --></div><!-- .col --></div><!-- .row --><div class=\"row fr-tag\"><div class=\"col-md-6 fadeInLeft animated fr-tag\"><div class=\"homepage-small-content-area fr-tag\"><div class=\"small-content-left fr-tag\"><img src=\"//i.imgur.com/lVA4unA.png\" class=\"fr-fin fr-tag\"></div><!-- .small-content-left --><div class=\"small-content-right fr-tag\"><div class=\"small-content-right-title fr-tag\">Private and secure</div><!-- .small-content-right-title --><div class=\"small-content-right-detail fr-tag\">All traffic to the site is encrypted. Search results are not recorded. Hit Enter or Return to register your name at GoDaddy. Lookup new extensions like .club, .xyz, and over a hundred others. We also search country-code domains (ccTLDs) like .com.au, .co.uk, .de, and .br.</div><!-- .small-content-right-detail --></div><!-- .small-content-right --></div><!-- .homepage-small-content-area --></div><!-- .col --><div class=\"col-md-6 fadeInRight animated fr-tag\"><div class=\"homepage-small-content-area fr-tag\"><div class=\"small-content-left fr-tag\"><img src=\"//i.imgur.com/SSE4uQr.png\" class=\"fr-fin fr-tag\"></div><!-- .small-content-lef--><div class=\"small-content-right fr-tag\"><div class=\"small-content-right-title fr-tag\">Domain Suggestions</div><!-- .small-content-right-title --><div class=\"small-content-right-detail fr-tag\">Get smart domain name suggestions using synonyms, suffixes, prefixes, short url, new gtlds to find the perfect domain name. Generate ideas for social user names and check availability for free.&nbsp;  <span>Find a great available&nbsp;<em>domain</em>&nbsp;name for your website in seconds.</span><br></div><!-- .small-content-right-detail --></div><!-- .small-content-right --></div><!-- .homepage-small-content-area --></div><!-- .col --></div><!-- .row --></div><!-- .container --><div class=\"domain-availability-area fr-tag\"><div class=\"container fr-tag\"><div class=\"row fr-tag\"><div class=\"col-md-6 fadeInLeft animated fr-tag\"><div class=\"homepage-small-content-area domain-availability-area-padding fr-tag\"><div class=\"small-content-left fr-tag\"><img src=\"//i.imgur.com/bDLT2rs.png\" class=\"fr-fin fr-tag\"></div><!-- .small-content-left --><div class=\"small-content-right fr-tag\"><div class=\"small-content-right-titleLG fr-tag\">Domain name availability</div><!-- .small-content-right-titleLG --><div class=\"small-content-right-detailLG fr-tag\">Instant Domain Search verifies availability by doing a DNS query get search results as fast as possible. WHOIS lookups are much slower than DNS queries, but provide more information about who registered the name.</div><!-- .small-content-right-detailLG --></div><!-- .small-content-right --></div><!-- .homepage-small-content-area --></div><!-- .col --><div class=\"col-md-6 fadeInRight animated fr-tag\"><div class=\"results-icons-area fr-tag\"><div class=\"results-icons-left fr-tag\"><div class=\"results-icon fr-tag\"><img src=\"//i.imgur.com/0UyMk2i.png\" class=\"fr-fin fr-tag\"></div><!-- .results-icon --></div><!-- .results-icons-left --><div class=\"results-icons-right fr-tag\"><div class=\"results-text fr-tag\"><span class=\"red\">Red</span> results mean that the name is taken. Do a WHOIS lookup to see when the current registration expires.</div><!-- .results-text --></div><!-- .results-icons-right --></div><!-- .results-icons-area --><div class=\"results-icons-area fr-tag\"><div class=\"results-icons-left fr-tag\"><div class=\"results-icon fr-tag\"><img src=\"//i.imgur.com/OVsFPRd.png\" class=\"fr-fin fr-tag\"></div><!-- .results-icon --></div><!-- .results-icons-left --><div class=\"results-icons-right fr-tag\"><div class=\"results-text fr-tag\"><span class=\"green\">Red</span> results mean that the name is taken. Do a WHOIS lookup to see when the current registration expires.</div></div></div><div class=\"results-icons-area fr-tag\"><div class=\"results-icons-right fr-tag\"><div class=\"results-text fr-tag\"></div><!-- .results-text --></div><!-- .results-icons-right --></div><!-- .results-icons-area --></div><!-- .col --></div><!-- .row --></div><!-- .container --></div><!-- .domain-availability-area --></div><!-- .index-content -->',	'English (UK)'),
(3,	'T.O.S',	'tos',	'<div class=\"index-content fr-tag\"><div class=\"container fr-tag\"><div class=\"row slideInLeft animated fr-tag\"><div class=\"col-xs-12 fr-tag\"><div class=\"homepage-content-title fr-tag\"><span>Terms of Service (eng)<br></span></div><!-- .homepage-content-title --><div class=\"homepage-content-detail-main fr-tag\"><p class=\"fr-tag\"><strong><em>(NOTE: This is dummy content don\'t forget to add your own Term Of Service)</em></strong></p><p class=\"fr-tag\"><em>THESE TERMS AND C</em>ONDITIONS ARE THE CONTRACT BETWEEN YOU AND NEXTHON. PLEASE READ THEM CAREFULLY BEFORE SIGNING UP FOR OR USING THE INSTANT DOMAIN SEARCH SCRIPT SERVICE.</p><p class=\"fr-tag\">By using this web site (“Instant Domain Search Script”), a service of Nexthon (“NEXTHON”), you are agreeing to be bound by the following terms and conditions.</p><p class=\"fr-tag\">In connection with your use of the service, you agree to:</p><ul class=\"fr-tag\"><li class=\"fr-tag\"><p class=\"fr-tag\">obey the law;</p></li><li class=\"fr-tag\"><p class=\"fr-tag\">obey any codes of conduct or other notices we provide you; and</p></li><li class=\"fr-tag\"><p class=\"fr-tag\">promptly notify us if you learn of a security breach related to the service.</p></li></ul><p class=\"fr-tag\">You are solely responsible for all uses of your account under your password. You must protect your password.</p><p class=\"fr-tag\">You will provide us an email address, where we may contact you with information about your account or our products or services. It is your responsibility to ensure that your email address is entered correctly and is kept up to date.</p><p class=\"fr-tag\"><strong>Your use of Instant Domain Search Script is at your sole risk.</strong> The service is provided on an “AS IS” and “as available” basis.</p><p class=\"fr-tag\">Nexthon makes no express or implied warranty of the quality or suitability of Instant Domain Search Script for any purpose.</p><p class=\"fr-tag\">We will do our best to preserve and protect your data, but make no guarantees that it won’t get lost, corrupted, or inadvertently leaked. You should back up critical data or take other steps to protect your vital information.</p><h3 class=\"fr-tag\">Termination.</h3><ul class=\"fr-tag\"><li class=\"fr-tag\"><p class=\"fr-tag\">We reserve the right to terminate your account for any reason at any time.</p></li><li class=\"fr-tag\"><p class=\"fr-tag\">You may terminate your account at any time upon ten (10) days prior notice to us.</p></li></ul><p class=\"fr-tag\">You expressly agree that Nexthon WILL NOT be liable for any indirect, incidental, special, consequential or exemplary damages, including but not limited to, damages for loss of profits, goodwill, use, data or other intangible losses (even if Nexthon has been advised of the possibility of such damages), resulting from: (i) the use or the inability to use Instant Domain Search Script; (ii) the cost of procurement of substitute goods or services resulting from any goods, data, information or services purchased or obtained through or from Instant Domain Search Script; (iii) unauthorized access to or alteration of your transmissions or data; (iv) statements or conduct of any third party on Instant Domain Search Script; (v) termination of your account; or (vi) any other matter relating to Instant Domain Search Script. If you are not satisfied with Instant Domain Search Script, your sole and exclusive remedy is to stop using it. IN NO EVENT WILL NEXTHON BE LIABLE TO YOU FOR ANY AMOUNT IN EXCESS OF THE AMOUNT THAT YOU HAVE ACTUALLY PAID NEXTHON IN THE TWELVE (12) MONTHS IMMEDIATELY PRECEDING THE EVENT GIVING RISE TO YOUR CLAIM.</p><p class=\"fr-tag\">The disclaimers and limitations of liability set forth in these terms and conditions are an essential basis of your bargain with Nexthon for the use of Instant Domain Search Script.</p><p class=\"fr-tag\">We reserve the right to modify the service at any time.</p><p class=\"fr-tag\">You will indemnify, defend and hold Nexthon, its officers, directors, employees, affiliates and service providers from any claim or cause of action of any kind whatsoever arising out of (a) any data, information or materials of any kind that are input or uploaded to the service using your account, and (b) your use of the service.</p><p class=\"fr-tag\">From time to time you may give us suggestions or feedback about Instant Domain Search Script. If you do so, you hereby grant us an irrevocable, perpetual, royalty-free, fully paid-up, worldwide license to use such suggestions or feedback for any purpose.</p><p class=\"fr-tag\">We reserve the right to modify these terms and conditions at any time upon notice to you, which we may make either by sending you mail (written or electronic) or posting the change on our website. You agree that any subsequent use of Instant Domain Search Script will constitute your acceptance of those modified terms and conditions going forward.</p><p class=\"fr-tag\">Nexthon will have the right to assign this Agreement to an affiliate of Nexthon at any time without notice.</p><p class=\"fr-tag\">These terms and conditions are the entire agreement between you and Nexthon regarding the use of Instant Domain Search Script. No other communication, whether written or oral, will be deemed to supplement or supersede these terms and conditions unless made in writing and signed by both you and Nexthon.</p></div><!-- .homepage-content-detail-main --></div><!-- .col --></div><!-- .row --></div><!-- .container --></div><!-- .index-content -->',	'English (UK)'),
(4,	'About',	'about',	'<div class=\"index-content\">\r\n		<div class=\"container\">\r\n			<div class=\"row slideInLeft animated\">\r\n				<div class=\"col-xs-12\">\r\n					<div class=\"homepage-content-title\">\r\n						<span>About Us</span>\r\n					</div><!-- .homepage-content-title -->\r\n					<div class=\"homepage-content-detail-main\">\r\n						<p class=\"fr-tag\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean tempus maximus semper. Nam erat lectus, lobortis ut ipsum vitae, porttitor feugiat lectus. Sed at dignissim arcu. Donec tincidunt pharetra iaculis. Donec vitae mauris ac enim aliquam gravida eget sed libero. Praesent ultrices, libero a tempor tempus, metus ligula porta arcu, sit amet imperdiet tellus lacus at nunc. Integer orci elit, luctus quis hendrerit in, volutpat nec erat. Etiam aliquet massa sit amet libero vestibulum, sit amet ornare erat blandit.</p><p class=\"fr-tag\">Mauris convallis lectus sed placerat iaculis. Morbi facilisis quis leo quis tincidunt. Phasellus rutrum erat sit amet neque interdum tempor. Sed scelerisque sem tortor, id auctor nunc blandit in. Suspendisse tellus leo, ullamcorper non faucibus et, viverra non tellus. Nullam mattis, neque in tempor congue, erat dolor pellentesque lorem, eget porttitor elit odio quis ligula. Aenean elementum libero at ligula sollicitudin consequat. Suspendisse nulla justo, fringilla quis maximus in, eleifend et lorem. Maecenas aliquam, ipsum at consequat consectetur, diam augue ullamcorper nulla, ut accumsan enim leo ac quam. Proin et porttitor ligula. Nulla consequat nisl at luctus ultrices.</p><p class=\"fr-tag\">Vivamus eget dui nec neque facilisis semper ut id nisl. Vestibulum accumsan sem quis mi consequat tincidunt. Phasellus in placerat magna. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam eleifend pharetra lorem et ullamcorper. Nullam ut odio non tellus tristique pulvinar ut vitae leo. In lobortis ultricies sollicitudin. Aliquam feugiat iaculis suscipit. Mauris malesuada nulla neque, ac mollis elit suscipit vel. Duis et vehicula mauris, ut malesuada libero. Vivamus pretium eros mauris, quis euismod dui ullamcorper ut. Donec dolor lacus, finibus vitae fermentum ac, tempor sed ligula. Aenean tincidunt eleifend risus, id ullamcorper elit egestas sit amet. Nullam eu euismod sem, ac feugiat dui. Vestibulum congue neque ut interdum dictum. Sed eget semper orci.</p><p class=\"fr-tag\">Aenean fermentum volutpat velit, ut congue dui. Mauris eu urna vulputate, eleifend tortor at, accumsan sapien. Duis vitae vestibulum lacus. Aenean tristique consequat sem, a cursus ex blandit id. Sed vulputate egestas sem, hendrerit dapibus tortor convallis at. In luctus dui in tortor vulputate, id dapibus elit sollicitudin. Etiam ultrices nibh maximus quam egestas, nec viverra purus sodales. Integer in sapien massa. Aenean vulputate interdum tellus, et venenatis risus convallis in. Mauris vestibulum magna odio, sit amet blandit odio pharetra id. Donec rutrum nisl turpis, vitae sodales orci commodo ac. Pellentesque eu nunc ac diam malesuada malesuada nec at elit. Nullam accumsan magna quis nunc porta pulvinar.</p><p class=\"fr-tag\">Nullam mauris felis, iaculis eget consectetur nec, suscipit id dolor. Donec ut malesuada nunc, nec ultrices massa. Quisque hendrerit, nunc ac sodales aliquam, lorem eros cursus nisl, id faucibus erat sapien vitae lacus. Nam turpis purus, laoreet vitae dui eget, tempor laoreet libero. Vivamus finibus dui eu ligula dignissim tempus. Nam nec tempus metus. Aenean cursus massa eget odio aliquam feugiat. Donec pulvinar nibh a neque semper malesuada. Sed congue tincidunt imperdiet. Proin pharetra sollicitudin magna, sit amet posuere ante vulputate vel. Vestibulum sit amet pellentesque arcu, ac interdum lacus.</p>		\r\n					</div><!-- .homepage-content-detail-main -->\r\n				</div><!-- .col -->\r\n			</div><!-- .row -->\r\n			\r\n		</div><!-- .container -->\r\n		\r\n	</div><!-- .index-content -->',	'English (UK)'),
(5,	'Contact Us',	'contact',	'<div class=\"index-content fr-tag\"><div class=\"container fr-tag\"><div class=\"row slideInLeft animated fr-tag\"><div class=\"col-xs-12 fr-tag\"><div class=\"homepage-content-title fr-tag\"><span>Contact Us</span></div><!-- .homepage-content-title --><div class=\"homepage-content-detail-main fr-tag\"><p class=\"m-b-30 fr-tag\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean tempus maximus semper. Nam erat lectus, lobortis ut ipsum vitae, porttitor feugiat lectus. Sed at dignissim arcu. Donec tincidunt pharetra iaculis. Donec vitae mauris ac enim aliquam gravida eget sed libero. Praesent ultrices, libero a tempor tempus, metus ligula porta arcu, sit amet imperdiet tellus lacus at nunc. Integer orci elit, luctus quis hendrerit in, volutpat nec erat. Etiam aliquet massa sit amet libero vestibulum, sit amet ornare erat blandit.</p>{{doNotDeleteThisTagThisTagContainsFormOfContactUs}}                              <div class=\"clearfix fr-tag\"></div></div><!-- .homepage-content-detail-main --></div><!-- .col-xs-12 --></div><!-- .slideInLeft --></div><!-- .container --></div><!-- .index-content -->',	'English (UK)'),
(6,	'Whois Search',	'whois',	'<p class=\"fr-tag\">Whois Script :)</p>',	'English (UK)');

DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `name` varchar(100) NOT NULL,
  `title` varchar(100) NOT NULL,
  `keywords` varchar(160) NOT NULL,
  `description` varchar(160) NOT NULL,
  `rootpath` varchar(100) NOT NULL,
  `logo` varchar(20) NOT NULL,
  `favicon` varchar(20) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(40) NOT NULL,
  `email` varchar(70) NOT NULL,
  `contactEmail` varchar(70) NOT NULL,
  `resetHash` varchar(100) DEFAULT NULL,
  `f_loader` tinyint(1) NOT NULL,
  `p_loader` tinyint(1) NOT NULL,
  `whoisStatus` tinyint(1) NOT NULL,
  `version` float NOT NULL,
  `whois_url` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `captcha_admin_login_status` tinyint(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `settings` (`name`, `title`, `keywords`, `description`, `rootpath`, `logo`, `favicon`, `username`, `password`, `email`, `contactEmail`, `resetHash`, `f_loader`, `p_loader`, `whoisStatus`, `version`, `whois_url`, `captcha_admin_login_status`) VALUES
('Instant Domain Search',	'Instant Domain Search',	'Instant Domain Search Script,IDS Script,newone,other one,oneother one',	'Just start typing! If the domain name you are looking for is taken, you can click WHOIS to find out who registered it or the URL to visit the website.',	'',	'logo.png',	'favicon.png',	'administrator',	'2825ba7f3f7dc9e50ec678966f59fb40a613f344',	'nexthon@live.com',	'nexthon@live.com',	'5b5322b6d00b4',	0,	0,	1,	2,	'',	0);

DROP TABLE IF EXISTS `sitemaps`;
CREATE TABLE `sitemaps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pagesStatus` tinyint(1) NOT NULL,
  `contactStatus` tinyint(1) NOT NULL,
  `filename` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `dateUpdated` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `sitemaps` (`id`, `pagesStatus`, `contactStatus`, `filename`, `dateUpdated`) VALUES
(1,	1,	1,	'sitemap.xml',	'2018-08-30');

DROP TABLE IF EXISTS `social_profiles`;
CREATE TABLE `social_profiles` (
  `facebook` varchar(50) NOT NULL,
  `twitter` varchar(50) NOT NULL,
  `google_plus` varchar(50) NOT NULL,
  `f_status` tinyint(1) NOT NULL,
  `t_status` tinyint(1) NOT NULL,
  `g_status` tinyint(1) NOT NULL,
  `social_buttons` tinyint(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `social_profiles` (`facebook`, `twitter`, `google_plus`, `f_status`, `t_status`, `g_status`, `social_buttons`) VALUES
('nexthon',	'nexthon',	'104682548360379303861',	1,	1,	1,	1);

DROP TABLE IF EXISTS `stats`;
CREATE TABLE `stats` (
  `unique_hits` int(11) NOT NULL,
  `pageviews` int(11) NOT NULL,
  `total_searches` int(11) NOT NULL,
  `affiliates_hits` int(11) NOT NULL,
  `date` date NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `stats` (`unique_hits`, `pageviews`, `total_searches`, `affiliates_hits`, `date`) VALUES
(1,	21,	1,	0,	'2018-11-01'),
(1,	30,	2,	0,	'2018-11-02');

DROP TABLE IF EXISTS `suggessted_limit`;
CREATE TABLE `suggessted_limit` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `limit` tinyint(2) NOT NULL,
  `preserve_days` tinyint(2) NOT NULL,
  `suggestedDomains` varchar(100) NOT NULL,
  `instantLimit` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `suggessted_limit` (`id`, `limit`, `preserve_days`, `suggestedDomains`, `instantLimit`) VALUES
(1,	12,	10,	'net,com,tv,cc',	0);

DROP TABLE IF EXISTS `suggested_language`;
CREATE TABLE `suggested_language` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `language` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `suggested_language` (`id`, `language`) VALUES
(1,	'ENG');

DROP TABLE IF EXISTS `themes`;
CREATE TABLE `themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `colors` text NOT NULL,
  `filname` varchar(100) NOT NULL,
  `status` tinyint(2) NOT NULL,
  `uniqueid` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `themes` (`id`, `name`, `colors`, `filname`, `status`, `uniqueid`) VALUES
(1,	'Default',	'#1d1e2a-#272835-#272835-#1d1e2a-#efefef-#009688-#16baab-#d0011b-#e3132d-#ffffff-#ffffff-#ffffff-#F4D6D9-#d0011b-#ECFBDC-#009688-#efefef-#1D1D27-#333-#009688-#ffffff-#272835-#efefef-#C2C7CD-#CBE1B2-#E0AEB4-#fff-#fff',	'default.css',	1,	'8fff828f8f3dd6d7c0169c7701d2a1ff'),
(2,	'Fsdfsdf',	'#1d1e2a-#272835-#272835-#1d1e2a-#efefef-#009688-#16baab-#d0011b-#e3132d-#ffffff-#ffffff-#ffffff-#f4d6d9-#d0011b-#ecfbdc-#009688-#efefef-#1d1d27-#333333-#009688-#ffffff-#272835-#efefef-#c2c7cd-#cbe1b2-#e0aeb4-#ffffff-#ffffff',	'theme-097a155d14d6d30158dc7146b5a94151.css',	0,	'dba71d48a86c795729cb0a0a70bd13ea');

DROP TABLE IF EXISTS `tlds`;
CREATE TABLE `tlds` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `display_order` tinyint(2) NOT NULL,
  `tld` varchar(50) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `server` varchar(100) NOT NULL,
  `response` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `tlds` (`id`, `display_order`, `tld`, `status`, `server`, `response`) VALUES
(1,	1,	'com',	1,	'whois.crsnic.net',	'No match for'),
(2,	2,	'net',	1,	'whois.crsnic.net',	'No match for'),
(3,	3,	'org',	1,	'whois.pir.org',	'NOT FOUND'),
(87,	9,	'us',	1,	'whois.nic.us',	'No Data Found'),
(98,	8,	'tv',	1,	'whois.nic.tv',	'No match for'),
(99,	10,	'uk',	1,	'whois.nic.uk',	'This domain name has not been registered.'),
(94,	4,	'info',	1,	'whois.afilias.net',	'NOT FOUND'),
(95,	7,	'co',	1,	'whois.nic.co',	'Not found'),
(96,	5,	'biz',	1,	'whois.nic.biz',	'Not found'),
(97,	6,	'mobi',	1,	'whois.dotmobiregistry.net',	'NOT FOUND'),
(100,	11,	'ca',	1,	'whois.cira.ca',	'Domain status: available'),
(101,	12,	'in',	1,	'whois.inregistry.in',	'NOT FOUND');

DROP TABLE IF EXISTS `whoisserverlist`;
CREATE TABLE `whoisserverlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `whois` varchar(200) NOT NULL,
  `response` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `whoisserverlist` (`id`, `name`, `whois`, `response`) VALUES
(1,	'abogado',	'whois-dub.mm-registry.com',	'is available for registration'),
(2,	'ac',	'whois.nic.ac',	'Available'),
(3,	'ac.ac',	'whois.nic.ac',	'Available'),
(4,	'ac.at',	'whois.nic.at',	'nothing found'),
(5,	'ac.be',	'whois.dns.be',	'No such domain'),
(6,	'ac.cn',	'whois.cnnic.net.cn',	'no matching record'),
(7,	'ac.il',	'whois.isoc.org.il',	'No data was found'),
(8,	'ac.in',	'whois.inregistry.in',	'NOT FOUND'),
(9,	'ac.jp',	'whois.nic.ad.jp',	'No match!!'),
(11,	'ac.kr',	'whois.nic.or.kr',	'is not registered'),
(12,	'ac.nz',	'whois.srs.net.nz',	'220 Available'),
(13,	'ac.th',	'whois.thnic.net',	'No match for'),
(14,	'ac.uk',	'whois.ja.net',	'Sorry - no'),
(16,	'academy',	'whois.donuts.co',	'Domain not found'),
(17,	'accountants',	'whois.donuts.co',	'Domain not found.'),
(18,	'actor',	'whois.unitedtld.com',	'Domain not found.'),
(19,	'ad',	'whois.ripe.net',	'no entries found'),
(20,	'adm.br',	'whois.nic.br',	'No match for'),
(21,	'adult',	'whois.afilias-srs.net',	'NOT FOUND'),
(22,	'adv.br',	'whois.nic.br',	'No match for'),
(23,	'ae',	'whois-check.aeda.net.ae',	'---Available'),
(24,	'aero',	'whois.aero',	'NOT FOUND'),
(25,	'af',	'whois.netnames.net',	'No Match'),
(26,	'ag',	'whois.nic.ag',	'NOT FOUND'),
(27,	'agency',	'whois.donuts.co',	'Domain not found.'),
(28,	'agro.pl',	'whois.dns.pl',	'No information available'),
(29,	'ah.cn',	'whois.cnnic.net.cn',	'no matching record'),
(30,	'aid.pl',	'whois.dns.pl',	'No information available'),
(31,	'airforce',	'whois.unitedtld.com',	'Domain not found.'),
(32,	'allfinanz',	'whois.ksregistry.net',	'not found...'),
(33,	'alsace',	'whois-alsace.nic.fr',	'Requested Domain cannot be found'),
(35,	'am',	'whois.nic.am',	'No match'),
(36,	'am.br',	'whois.nic.br',	'No match for'),
(37,	'android',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(38,	'apartments',	'whois.donuts.co',	'Domain not found.'),
(39,	'aquarelle',	'whois-aquarelle.nic.fr',	'Requested Domain cannot be found'),
(40,	'archi',	'whois.ksregistry.net',	'not found...'),
(41,	'army',	'whois.rightside.co',	'Domain not found.'),
(42,	'arq.br',	'whois.nic.br',	'No match for'),
(43,	'art.br',	'whois.nic.br',	'No match for'),
(44,	'arts.ro',	'whois.rotld.ro',	'No entries found'),
(45,	'as',	'whois.nic.as',	'Domain Not Found'),
(46,	'asia',	'whois.nic.asia',	'NOT FOUND'),
(47,	'asn.au',	'whois.aunic.net',	'No Data Found'),
(48,	'asso.fr',	'whois.nic.fr',	'No entries found'),
(49,	'asso.mc',	'whois.ripe.net',	'no entries found'),
(50,	'associates',	'whois.donuts.co',	'Domain not found.'),
(51,	'at',	'whois.nic.at',	'nothing found'),
(52,	'atm.pl',	'whois.dns.pl',	'No information available'),
(53,	'attorney',	'whois.rightside.co',	'Domain not found.'),
(54,	'au',	'whois.audns.net.au',	'No Data Found'),
(55,	'auction',	'whois.unitedtld.com',	'Domain not found.'),
(56,	'audio',	'whois.uniregistry.net',	'is available for'),
(57,	'auto.pl',	'whois.dns.pl',	'No information available'),
(58,	'aw',	'whois.nic.aw',	'is free'),
(59,	'ax',	'whois.ax',	'No records matching'),
(60,	'band',	'whois.rightside.co',	'Domain not found.'),
(61,	'bank',	'whois.nic.bank',	'No match for'),
(62,	'bar',	'whois.nic.bar',	'DOMAIN NOT FOUND'),
(63,	'barclaycard',	'whois.nic.barclaycard',	'No Data Found'),
(64,	'barclays',	'whois.nic.barclays',	'No Data Found'),
(65,	'bargains',	'whois.donuts.co',	'Domain not found.'),
(66,	'bayern',	'whois-dub.mm-registry.com',	'is available for registration'),
(67,	'bbs.tr',	'whois.metu.edu.tr',	'No match found'),
(68,	'be',	'whois.dns.be',	'Status: AVAILABLE'),
(69,	'beer',	'whois-dub.mm-registry.com',	'is available for registration'),
(70,	'berlin',	'whois.nic.berlin',	'% No match'),
(71,	'best',	'whois.nic.best',	'Not found:'),
(72,	'bg',	'whois.register.bg',	'does not exist in database'),
(73,	'bi',	'whois1.nic.bi',	'Domain Status: No Object Found'),
(74,	'bike',	'whois.donuts.co',	'Domain not found'),
(75,	'bingo',	'whois.donuts.co',	'Domain not found.'),
(76,	'bio',	'whois.ksregistry.net',	'not found...'),
(77,	'bio.br',	'whois.nic.br',	'No match for'),
(78,	'biz',	'whois.nic.biz',	'Not found'),
(79,	'biz.pl',	'whois.dns.pl',	'No information available'),
(80,	'bj',	'whois.nic.bj',	'No records matching'),
(81,	'bj.cn',	'whois.cnnic.net.cn',	'no matching record'),
(82,	'black',	'whois.afilias.net',	'NOT FOUND'),
(83,	'blackfriday',	'whois.uniregistry.net',	'is available'),
(84,	'blue',	'whois.afilias.net',	'NOT FOUND'),
(85,	'bmw',	'whois.ksregistry.net',	'not found...'),
(86,	'bnpparibas',	'whois.afilias-srs.net',	'NOT FOUND'),
(87,	'boo',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(88,	'boutique',	'whois.donuts.co',	'Domain not found.'),
(89,	'br',	'whois.nic.br',	'No match for'),
(90,	'br.com',	'whois.centralnic.com',	'DOMAIN NOT FOUND'),
(91,	'brussels',	'whois.nic.brussels',	'is still available'),
(92,	'budapest',	'whois-dub.mm-registry.com',	'is available for registration'),
(93,	'build',	'whois.nic.build ',	'No Data Found'),
(94,	'builders',	'whois.donuts.co',	'Domain not found'),
(95,	'business',	'whois.donuts.co',	'Domain not found.'),
(97,	'by',	'whois.cctld.by',	'no entries found'),
(98,	'bz',	'whois.afilias-grs.info.',	'NOT FOUND'),
(99,	'bzh',	'whois-bzh.nic.fr',	'Requested Domain cannot be found'),
(100,	'ca',	'whois.cira.ca',	'Domain status: available'),
(101,	'cab',	'whois.donuts.co',	'Domain not found'),
(102,	'cal',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(103,	'camera',	'whois.donuts.co',	'Domain not found'),
(104,	'camp',	'whois.donuts.co',	'Domain not found'),
(105,	'cancerresearch',	'whois.nic.cancerresearch',	'No Data Found'),
(106,	'canon',	'whois.nic.canon',	'DOMAIN NOT FOUND'),
(107,	'capetown',	'capetown-whois.registry.net.za',	'Available'),
(108,	'capital',	'whois.donuts.co',	'Domain not found.'),
(109,	'cards',	'whois.donuts.co',	'Domain not found.'),
(110,	'care',	'whois.donuts.co',	'Domain not found.'),
(111,	'career',	'whois.nic.career',	'No match for'),
(112,	'careers',	'whois.donuts.co',	'Domain not found'),
(113,	'casa',	'whois-dub.mm-registry.com',	'is available for registration'),
(114,	'cash',	'whois.donuts.co',	'Domain not found.'),
(115,	'casino',	'whois.donuts.co',	'Domain not found.'),
(116,	'cat',	'whois.cat',	'NOT FOUND'),
(117,	'catering',	'whois.donuts.co',	'Domain not found.'),
(118,	'cc',	'whois.nic.cc',	'No match'),
(119,	'cd',	'whois.cd',	'No match'),
(120,	'center',	'whois.donuts.co',	'Domain not found'),
(121,	'ceo',	'whois.nic.ceo',	'Not found:'),
(122,	'cern',	'whois.afilias-srs.net',	'NOT FOUND'),
(123,	'cf',	'whois.dot.cf',	'Invalid query or domain name not known'),
(124,	'ch',	'whois.nic.ch',	'not have an entry'),
(125,	'channel',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(126,	'chat',	'whois.donuts.co',	'Domain not found.'),
(127,	'cheap',	'whois.donuts.co',	'Domain not found.'),
(128,	'christmas',	'whois.uniregistry.net',	'is available'),
(129,	'chrome',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(130,	'church',	'whois.donuts.co',	'Domain not found.'),
(132,	'city',	'whois.donuts.co',	'Domain not found.'),
(133,	'cl',	'whois.nic.cl',	'no existe'),
(134,	'claims',	'whois.donuts.co',	'Domain not found.'),
(135,	'cleaning',	'whois.donuts.co',	'Domain not found.'),
(136,	'click',	'whois.uniregistry.net',	'is available for'),
(137,	'clinic',	'whois.donuts.co',	'Domain not found.'),
(138,	'clothing',	'whois.donuts.co',	'Domain not found'),
(139,	'club',	'whois.nic.club',	'Not found:'),
(140,	'cn',	'whois.cnnic.net.cn',	'no matching record'),
(141,	'cn.com',	'whois.centralnic.com',	'DOMAIN NOT FOUND'),
(142,	'cng.br',	'whois.nic.br',	'No match for'),
(143,	'cnt.br',	'whois.nic.br',	'No match for'),
(144,	'co',	'whois.nic.co',	'Not found'),
(145,	'co.ac',	'whois.nic.ac',	'Available'),
(146,	'co.at',	'whois.nic.at',	'nothing found'),
(147,	'co.il',	'whois.isoc.org.il',	'No data was found'),
(148,	'co.in',	'whois.inregistry.in',	'NOT FOUND'),
(149,	'co.jp',	'whois.nic.ad.jp',	'No match!!'),
(150,	'co.ke',	'whois.kenic.or.ke',	'Not Registered'),
(151,	'co.kr',	'whois.nic.or.kr',	'is not registered'),
(152,	'co.nz',	'whois.srs.net.nz',	'220 Available'),
(153,	'co.rs',	'whois.rnids.rs',	'%ERROR:103'),
(154,	'co.th',	'whois.thnic.net',	'No match for'),
(155,	'co.uk',	'whois.nic.uk',	'No match'),
(156,	'co.ve',	'whois.nic.ve',	'No match for'),
(157,	'co.za',	'http://whois.registry.net.za/whois/whois.sh?Domain=',	'No Matches'),
(158,	'coach',	'whois.donuts.co',	'Domain not found.'),
(159,	'codes',	'whois.donuts.co',	'Domain not found.'),
(160,	'coffee',	'whois.donuts.co',	'Domain not found'),
(162,	'cologne',	'whois-fe1.pdt.cologne.tango.knipp.de',	'% no matching objects found'),
(163,	'com',	'whois.crsnic.net',	'No match for'),
(164,	'com.au',	'whois.aunic.net',	'No Data Found'),
(165,	'com.br',	'whois.nic.br',	'No match for'),
(166,	'com.cn',	'whois.cnnic.net.cn',	'no matching record'),
(167,	'com.co',	'whois.nic.co',	'Not found'),
(170,	'com.fr',	'whois.nic.fr',	'No entries found'),
(173,	'com.hk',	'whois.hkdnr.net.hk',	'The domain has not been registered'),
(175,	'com.mx',	'whois.nic.mx',	'Object_Not_Found'),
(178,	'com.pl',	'whois.dns.pl',	'No information available'),
(179,	'com.pt',	'whois.dns.pt',	'no match'),
(180,	'com.ro',	'whois.rotld.ro',	'No entries found'),
(181,	'com.ru',	'whois.ripn.net',	'No entries found'),
(182,	'com.sg',	'whois.nic.net.sg',	'Domain Not Found'),
(183,	'com.tr',	'whois.metu.edu.tr',	'No match found'),
(184,	'com.tw',	'whois.twnic.net',	'No Found'),
(185,	'com.ua',	'whois.net.ua',	'No entries found'),
(186,	'com.ve',	'whois.nic.ve',	'No match for'),
(187,	'community',	'whois.donuts.co',	'Domain not found.'),
(188,	'company',	'whois.donuts.co',	'Domain not found'),
(189,	'computer',	'whois.donuts.co',	'Domain not found'),
(190,	'condos',	'whois.donuts.co',	'Domain not found.'),
(191,	'construction',	'whois.donuts.co',	'Domain not found'),
(192,	'consulting',	'whois.unitedtld.com',	'Domain not found.'),
(193,	'contractors',	'whois.donuts.co',	'Domain not found'),
(194,	'cooking',	'whois-dub.mm-registry.com',	'is available for registration'),
(195,	'cool',	'whois.donuts.co',	'Domain not found.'),
(197,	'country',	'whois-dub.mm-registry.com',	'is available for registration'),
(198,	'courses',	'whois.aridnrs.net.au',	'No Data Found'),
(199,	'cq.cn',	'whois.cnnic.net.cn',	'no matching record'),
(200,	'credit',	'whois.donuts.co',	'Domain not found.'),
(201,	'creditcard',	'whois.donuts.co',	'Domain not found.'),
(202,	'cricket',	'whois.nic.cricket',	'is available'),
(203,	'cruises',	'whois.donuts.co',	'Domain not found.'),
(204,	'cuisinella',	'whois.nic.cuisinella',	'No Data Found'),
(205,	'cx',	'whois.nic.cx',	'No match for'),
(206,	'cymru',	'whois.nic.cymru',	'This domain name has not been registered.'),
(207,	'cz',	'whois.nic.cz',	'No entries found'),
(208,	'dad',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(209,	'dance',	'whois.unitedtld.com',	'Domain not found.'),
(210,	'dating',	'whois.donuts.co',	'Domain not found.'),
(211,	'datsun',	'whois.nic.gmo',	'DOMAIN NOT FOUND'),
(212,	'day',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(213,	'dclk',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(214,	'de',	'whois.denic.de',	'Status: free'),
(215,	'deals',	'whois.donuts.co',	'Domain not found.'),
(216,	'degree',	'whois.rightside.co',	'Domain not found.'),
(217,	'delivery',	'whois.donuts.co',	'Domain not found.'),
(218,	'democrat',	'whois.unitedtld.com',	'Domain not found.'),
(219,	'dental',	'whois.donuts.co',	'Domain not found.'),
(220,	'dentist',	'whois.rightside.co',	'Domain not found.'),
(221,	'desi',	'whois.ksregistry.net',	'not found...'),
(223,	'dev',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(224,	'diamonds',	'whois.donuts.co',	'Domain not found'),
(225,	'diet',	'whois.uniregistry.net',	'is available for'),
(226,	'digital',	'whois.donuts.co',	'Domain not found.'),
(227,	'direct',	'whois.donuts.co',	'Domain not found.'),
(228,	'directory',	'whois.donuts.co',	'Domain not found'),
(229,	'discount',	'whois.donuts.co',	'Domain not found.'),
(230,	'dk',	'whois.dk-hostmaster.dk',	'No entries found'),
(231,	'dm',	'whois.nic.dm',	'not found...'),
(232,	'dn.ua',	'whois.net.ua',	'No entries found'),
(233,	'docs',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(234,	'domains',	'whois.donuts.co',	'Domain not found'),
(235,	'doosan',	'whois.nic.doosan',	'No match for'),
(236,	'durban',	'durban-whois.registry.net.za',	'Available'),
(237,	'dvag',	'whois.ksregistry.net',	'not found...'),
(238,	'dz',	'whois.nic.dz',	'NO OBJECT FOUND!'),
(239,	'eat',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(240,	'ec',	'whois.nic.ec',	'Status: Not Registered'),
(241,	'ecn.br',	'whois.nic.br',	'No match for'),
(242,	'edu',	'whois.internic.net',	'No match for'),
(243,	'edu.au',	'whois.aunic.net',	'No Data Found'),
(244,	'edu.cn',	'whois.cnnic.net.cn',	'no matching record'),
(246,	'edu.gt',	'http://www.gt/cgi-bin/whois.cgi?domain=',	'DOMINIO NO REGISTRADO'),
(247,	'edu.hk',	'whois.hkdnr.net.hk',	'The domain has not been registered'),
(249,	'edu.mx',	'whois.nic.mx',	'Object_Not_Found'),
(251,	'edu.pl',	'whois.dns.pl',	'No information available'),
(252,	'edu.pt',	'whois.dns.pt',	'no match'),
(253,	'edu.rs',	'whois.rnids.rs',	'%ERROR:103'),
(254,	'edu.sg',	'whois.nic.net.sg',	'Domain Not Found'),
(255,	'edu.tr',	'whois.metu.edu.tr',	'No match found'),
(257,	'education',	'whois.donuts.co',	'Domain not found'),
(258,	'ee',	'whois.tld.ee',	'% No entries found.'),
(259,	'email',	'whois.donuts.co',	'Domain not found'),
(260,	'emerck',	'whois.afilias-srs.net',	'NOT FOUND'),
(261,	'energy',	'whois.donuts.co',	'Domain not found.'),
(262,	'eng.br',	'whois.nic.br',	'No match for'),
(263,	'engineer',	'whois.rightside.co',	'Domain not found.'),
(264,	'engineering',	'whois.donuts.co',	'Domain not found.'),
(265,	'enterprises',	'whois.donuts.co',	'Domain not found'),
(266,	'epson',	'whois.aridnrs.net.au',	'No Data Found'),
(267,	'equipment',	'whois.donuts.co',	'Domain not found'),
(268,	'ernet.in',	'whois.inregistry.in',	'NOT FOUND'),
(270,	'esp.br',	'whois.nic.br',	'No match for'),
(271,	'esq',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(272,	'estate',	'whois.donuts.co',	'Domain not found'),
(273,	'etc.br',	'whois.nic.br',	'No match for'),
(274,	'eti.br',	'whois.nic.br',	'No match for'),
(275,	'eu',	'whois.eu',	'Status: AVAILABLE'),
(277,	'eu.lv',	'whois.biz',	'Not found'),
(278,	'eurovision',	'whois.nic.eurovision',	'% no matching objects found'),
(279,	'eus',	'whois.eus.coreregistry.net',	'% no matching objects found'),
(280,	'events',	'whois.donuts.co',	'Domain not found.'),
(281,	'exchange',	'whois.donuts.co',	'Domain not found.'),
(282,	'expert',	'whois.donuts.co',	'Domain not found'),
(283,	'exposed',	'whois.donuts.co',	'Domain not found'),
(284,	'fail',	'whois.donuts.co',	'Domain not found.'),
(286,	'farm',	'whois.donuts.co',	'Domain not found'),
(287,	'fashion',	'whois-dub.mm-registry.com',	'is available for registration'),
(289,	'fi',	'whois.ficora.fi',	'Domain not found'),
(291,	'finance',	'whois.donuts.co',	'Domain not found.'),
(292,	'financial',	'whois.donuts.co',	'Domain not found.'),
(293,	'firm.ro',	'whois.rotld.ro',	'No entries found'),
(294,	'firmdale',	'whois.nic.firmdale',	'Domain Not Found'),
(295,	'fish',	'whois.donuts.co',	'Domain not found.'),
(296,	'fishing',	'whois-dub.mm-registry.com',	'is available for registration'),
(297,	'fit',	'whois-dub.mm-registry.com',	'is available for registration'),
(298,	'fitness',	'whois.donuts.co',	'Domain not found.'),
(299,	'flights',	'whois.donuts.co',	'Domain not found'),
(300,	'florist',	'whois.donuts.co',	'Domain not found'),
(301,	'flowers',	'whois.uniregistry.net',	'is available for'),
(302,	'flsmidth',	'whois.ksregistry.net',	'not found...'),
(303,	'fly',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(304,	'fm',	'whois.nic.fm',	'Not Registered'),
(305,	'fm.br',	'whois.nic.br',	'No match for'),
(306,	'fo',	'whois.nic.fo',	'no entries found'),
(307,	'foo',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(308,	'football',	'whois.donuts.co',	'Domain not found.'),
(309,	'forsale',	'whois.unitedtld.com',	'Domain not found.'),
(310,	'fot.br',	'whois.nic.br',	'No match for'),
(311,	'foundation',	'whois.donuts.co',	'Domain not found.'),
(312,	'fr',	'whois.nic.fr',	'No entries found'),
(313,	'frl',	'whois.nic.frl',	'is still available'),
(314,	'frogans',	'whois-frogans.nic.fr',	'Requested Domain cannot be found'),
(315,	'fst.br',	'whois.nic.br',	'No match for'),
(316,	'fund',	'whois.donuts.co',	'Domain not found.'),
(317,	'furniture',	'whois.donuts.co',	'Domain not found.'),
(318,	'futbol',	'whois.unitedtld.com',	'Domain not found'),
(319,	'g12.br',	'whois.nic.br',	'No match for'),
(320,	'gal',	'whois.gal.coreregistry.net',	'% no matching objects found'),
(321,	'gallery',	'whois.donuts.co',	'Domain not found'),
(322,	'garden',	'whois-dub.mm-registry.com',	'is available for registration'),
(325,	'gbiz',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(326,	'gd',	'whois.nic.gd',	'not found...'),
(327,	'gd.cn',	'whois.cnnic.net.cn',	'no matching record'),
(329,	'geek.nz',	'whois.srs.net.nz',	'220 Available'),
(330,	'gen.nz',	'whois.srs.net.nz',	'220 Available'),
(331,	'gent',	'whois.nic.gent',	'is still available'),
(333,	'gg',	'whois.gg',	'NOT FOUND'),
(334,	'ggee',	'whois.nic.ggee',	'DOMAIN NOT FOUND'),
(335,	'gi',	'whois2.afilias-grs.net',	'NOT FOUND'),
(336,	'gift',	'whois.uniregistry.net',	'is available for'),
(337,	'gifts',	'whois.donuts.co',	'Domain not found.'),
(338,	'gives',	'whois.rightside.co',	'Domain not found.'),
(339,	'gl',	'whois.nic.gl',	'Domain Status: No Object Found'),
(340,	'glass',	'whois.donuts.co',	'Domain not found'),
(341,	'gle',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(342,	'global',	'whois.nic.global',	'NOT FOUND'),
(343,	'globo',	'whois.gtlds.nic.br',	'No match for'),
(344,	'gmail',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(345,	'gmina.pl',	'whois.dns.pl',	'No information available'),
(346,	'gmx',	'whois-fe1.gmx.tango.knipp.de',	'% no matching objects found'),
(348,	'go.jp',	'whois.nic.ad.jp',	'No match!!'),
(349,	'go.kr',	'whois.nic.or.kr',	'is not registered'),
(350,	'go.th',	'whois.thnic.net',	'No match for'),
(352,	'gob.mx',	'whois.nic.mx',	'Object_Not_Found'),
(353,	'goldpoint',	'whois.nic.goldpoint',	'DOMAIN NOT FOUND'),
(354,	'goo',	'whois.nic.gmo',	'DOMAIN NOT FOUND'),
(355,	'goog',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(356,	'google',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(357,	'gop',	'whois-cl01.mm-registry.com',	'is available for registration'),
(358,	'gov',	'whois.nic.gov',	'No match for'),
(359,	'gov.br',	'whois.nic.br',	'No match for'),
(360,	'gov.cn',	'whois.cnnic.net.cn',	'no matching record'),
(363,	'gov.il',	'whois.isoc.org.il',	'No data was found'),
(364,	'gov.in',	'whois.inregistry.in',	'NOT FOUND'),
(366,	'gov.mx',	'whois.nic.mx',	'Object_Not_Found'),
(368,	'gov.sg',	'whois.nic.net.sg',	'Domain Not Found'),
(369,	'gov.tr',	'whois.metu.edu.tr',	'No match found'),
(371,	'gq',	'whois.dominio.gq',	'Invalid query or domain name not known'),
(373,	'graphics',	'whois.donuts.co',	'Domain not found'),
(374,	'gratis',	'whois.donuts.co',	'Domain not found.'),
(375,	'green',	'whois.afilias.net',	'NOT FOUND'),
(376,	'gripe',	'whois.donuts.co',	'Domain not found.'),
(377,	'gs',	'whois.nic.gs',	'No Object Found'),
(378,	'gs.cn',	'whois.cnnic.net.cn',	'no matching record'),
(379,	'gsm.pl',	'whois.dns.pl',	'No information available'),
(380,	'guide',	'whois.donuts.co',	'Domain not found.'),
(381,	'guitars',	'whois.uniregistry.net',	'is available for'),
(382,	'guru',	'whois.donuts.co',	'Domain not found'),
(383,	'gv.ac',	'whois.nic.ac',	'Available'),
(384,	'gv.at',	'whois.nic.at',	'nothing found'),
(385,	'gx.cn',	'whois.cnnic.net.cn',	'no matching record'),
(386,	'gy',	'whois.registry.gy',	'Domain Status: No Object Found'),
(387,	'gz.cn',	'whois.cnnic.net.cn',	'no matching record'),
(388,	'hamburg',	'whois.nic.hamburg',	'% No match'),
(389,	'hangout',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(390,	'haus',	'whois.unitedtld.com',	'Domain not found.'),
(391,	'hb.cn',	'whois.cnnic.net.cn',	'no matching record'),
(392,	'he.cn',	'whois.cnnic.net.cn',	'no matching record'),
(393,	'healthcare',	'whois.donuts.co',	'Domain not found.'),
(394,	'help',	'whois.uniregistry.net',	'is available for'),
(395,	'here',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(396,	'hi.cn',	'whois.cnnic.net.cn',	'no matching record'),
(397,	'hiphop',	'whois.uniregistry.net',	'is available for'),
(398,	'hiv',	'whois.afilias-srs.net',	'NOT FOUND'),
(399,	'hk',	'whois.hkirc.hk',	'The domain has not been registered'),
(400,	'hk.cn',	'whois.cnnic.net.cn',	'no matching record'),
(401,	'hl.cn',	'whois.cnnic.net.cn',	'no matching record'),
(402,	'hn',	'whois.nic.hn',	'Domain Status: No Object Found'),
(403,	'hn.cn',	'whois.cnnic.net.cn',	'no matching record'),
(404,	'holdings',	'whois.donuts.co',	'Domain not found'),
(405,	'holiday',	'whois.donuts.co',	'Domain not found'),
(406,	'horse',	'whois-dub.mm-registry.com',	'is available for registration'),
(408,	'hosting',	'whois.uniregistry.net',	'is available for'),
(409,	'house',	'whois.donuts.co',	'Domain not found'),
(410,	'how',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(412,	'ht',	'whois.nic.ht',	'Domain Status: No Object Found'),
(413,	'hu',	'whois.nic.hu',	'No match'),
(415,	'ibm',	'whois.nic.ibm',	'No Data Found'),
(416,	'id',	'whois.pandi.or.id',	'DOMAIN NOT FOUND'),
(417,	'id.au',	'whois.aunic.net',	'No Data Found'),
(418,	'ie',	'whois.domainregistry.ie',	'% Not Registered'),
(419,	'ifm',	'whois.nic.ifm',	'% no matching objects found'),
(420,	'il',	'whois.isoc.org.il',	'No data was found'),
(421,	'im',	'whois.nic.im',	'was not found'),
(422,	'immo',	'whois.donuts.co',	'Domain not found.'),
(423,	'immobilien',	'whois.unitedtld.com',	'Domain not found.'),
(424,	'in',	'whois.inregistry.in',	'NOT FOUND'),
(425,	'in.rs',	'whois.rnids.rs',	'%ERROR:103'),
(426,	'in.th',	'whois.thnic.net',	'No match for'),
(427,	'ind.br',	'whois.nic.br',	'No match for'),
(429,	'industries',	'whois.donuts.co',	'Domain not found.'),
(430,	'inf.br',	'whois.nic.br',	'No match for'),
(431,	'infiniti',	'whois.nic.gmo',	'DOMAIN NOT FOUND'),
(432,	'info',	'whois.afilias.net',	'NOT FOUND'),
(433,	'info.pl',	'whois.dns.pl',	'No information available'),
(434,	'info.ro',	'whois.rotld.ro',	'No entries found'),
(435,	'info.ve',	'whois.nic.ve',	'No match for'),
(436,	'ing',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(437,	'ink',	'whois.donuts.co',	'Domain not found'),
(438,	'institute',	'whois.donuts.co',	'Domain not found'),
(439,	'insure',	'whois.donuts.co',	'Domain not found.'),
(440,	'int',	'whois.iana.org',	'but this server does not have'),
(441,	'international',	'whois.donuts.co',	'Domain not found'),
(442,	'investments',	'whois.donuts.co',	'Domain not found.'),
(443,	'io',	'whois.nic.io',	'is available'),
(445,	'ir',	'whois.nic.ir',	'no entries found'),
(446,	'is',	'whois.isnic.is',	'No entries found'),
(447,	'it',	'whois.nic.it',	'AVAILABLE'),
(448,	'iwi.nz',	'whois.srs.net.nz',	'220 Available'),
(449,	'java',	'whois.nic.java',	'No match for'),
(450,	'jcb',	'whois.nic.gmo',	'DOMAIN NOT FOUND'),
(451,	'je',	'whois.je',	'NOT FOUND'),
(452,	'jl.cn',	'whois.cnnic.net.cn',	'no matching record'),
(454,	'joburg',	'joburg-whois.registry.net.za',	'Available'),
(455,	'jor.br',	'whois.nic.br',	'No match for'),
(456,	'jp',	'whois.jprs.jp',	'No match!!'),
(457,	'js.cn',	'whois.cnnic.net.cn',	'no matching record'),
(458,	'juegos',	'whois.uniregistry.net',	'is available for'),
(459,	'k12.il',	'whois.isoc.org.il',	'No data was found'),
(460,	'k12.tr',	'whois.metu.edu.tr',	'No match found'),
(461,	'kaufen',	'whois.unitedtld.com',	'Domain not found.'),
(462,	'kddi',	'whois.nic.kddi',	'DOMAIN NOT FOUND'),
(465,	'kh.ua',	'whois.net.ua',	'No entries found'),
(466,	'ki',	'whois.nic.ki',	'Domain Status: No Object Found'),
(467,	'kiev.ua',	'whois.net.ua',	'No entries found'),
(468,	'kim',	'whois.afilias.net',	'NOT FOUND'),
(469,	'kitchen',	'whois.donuts.co',	'Domain not found'),
(470,	'kiwi',	'whois.nic.kiwi',	'is available for registration'),
(471,	'kiwi.nz',	'whois.srs.net.nz',	'220 Available'),
(472,	'koeln',	'whois-fe1.pdt.koeln.tango.knipp.de',	'% no matching objects found'),
(473,	'kr',	'whois.kr',	'is not registered'),
(474,	'krd',	'whois.aridnrs.net.au',	'No Data Found'),
(475,	'ky',	'whois.kyregistry.ky',	'is available for'),
(476,	'kyoto',	'whois.nic.kyoto',	'DOMAIN NOT FOUND'),
(477,	'kz',	'whois.nic.kz',	'Nothing found for this query.'),
(479,	'lacaixa',	'whois.nic.lacaixa',	'% no matching objects found'),
(480,	'land',	'whois.donuts.co',	'Domain not found'),
(481,	'lat',	'whois.nic.lat',	'Object_Not_Found'),
(482,	'latrobe',	'whois.nic.latrobe',	'No Data Found'),
(483,	'lawyer',	'whois.rightside.co',	'Domain not found.'),
(484,	'lc',	'whois2.afilias-grs.net',	'NOT FOUND'),
(485,	'lease',	'whois.donuts.co',	'Domain not found.'),
(486,	'leclerc',	'whois-leclerc.nic.fr',	'Requested Domain cannot be found'),
(487,	'legal',	'whois.donuts.co',	'Domain not found.'),
(488,	'lel.br',	'whois.nic.br',	'No match for'),
(489,	'lg.ua',	'whois.net.ua',	'No entries found'),
(490,	'lgbt',	'whois.afilias.net',	'NOT FOUND'),
(491,	'li',	'whois.nic.li',	'do not have an entry in our database matching your query'),
(492,	'life',	'whois.donuts.co',	'Domain not found.'),
(493,	'lighting',	'whois.donuts.co',	'Domain not found'),
(494,	'limited',	'whois.donuts.co',	'Domain not found.'),
(495,	'limo',	'whois.donuts.co',	'Domain not found'),
(496,	'link',	'whois.uniregistry.net',	'is available for'),
(497,	'ln.cn',	'whois.cnnic.net.cn',	'no matching record'),
(498,	'loans',	'whois.donuts.co',	'Domain not found.'),
(499,	'london',	'whois-lon.mm-registry.com',	'is available for registration'),
(500,	'lotte',	'whois.nic.lotte',	'DOMAIN NOT FOUND'),
(501,	'lt',	'whois.domreg.lt',	'Status:			available'),
(502,	'ltd.uk',	'whois.nic.uk',	'No match'),
(503,	'ltda',	'whois.afilias-srs.net',	'NOT FOUND'),
(504,	'lu',	'whois.dns.lu',	'No such domain'),
(505,	'luxe',	'whois-dub.mm-registry.com',	'is available for registration'),
(506,	'luxury',	'whois.donuts.co',	'Domain not found'),
(507,	'lv',	'whois.nic.lv',	'Status: free'),
(508,	'lviv.ua',	'whois.net.ua',	'No entries found'),
(509,	'ly',	'whois.nic.ly',	'Not found'),
(510,	'ma',	'whois.iam.net.ma',	'Domain Status: No Object Found'),
(511,	'madrid',	'whois.madrid.rs.corenic.net',	'% no matching objects found'),
(512,	'mail.pl',	'whois.dns.pl',	'No information available'),
(513,	'maison',	'whois.donuts.co',	'Domain not found'),
(514,	'management',	'whois.donuts.co',	'Domain not found'),
(515,	'mango',	'whois.mango.coreregistry.net',	'% no matching objects found'),
(516,	'maori.nz',	'whois.srs.net.nz',	'220 Available'),
(517,	'market',	'whois.rightside.co',	'Domain not found.'),
(518,	'marketing',	'whois.donuts.co',	'Domain not found'),
(519,	'md',	'whois.nic.md',	'No match for'),
(521,	'me.uk',	'whois.nic.uk',	'No match'),
(522,	'med.br',	'whois.nic.br',	'No match for'),
(524,	'media',	'whois.donuts.co',	'Domain not found.'),
(525,	'media.pl',	'whois.dns.pl',	'No information available'),
(526,	'melbourne',	'whois.aridnrs.net.au',	'No Data Found'),
(527,	'meme',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(528,	'memorial',	'whois.donuts.co',	'Domain not found.'),
(529,	'menu',	'whois.nic.menu',	'No Data Found'),
(530,	'mg',	'whois.nic.mg',	'Domain Status: No Object Found'),
(531,	'mi.th',	'whois.thnic.net',	'No match for'),
(532,	'miami',	'whois-dub.mm-registry.com',	'is available for registration'),
(533,	'miasta.pl',	'whois.dns.pl',	'No information available'),
(534,	'mil',	'whois.internic.net',	'No match for'),
(535,	'mil.br',	'whois.nic.br',	'No match for'),
(539,	'mil.pl',	'whois.dns.pl',	'No information available'),
(540,	'mil.tr',	'whois.metu.edu.tr',	'No match found'),
(542,	'mini',	'whois.ksregistry.net',	'not found...'),
(543,	'mk',	'whois.marnet.mk',	'% No entries found.'),
(544,	'ml',	'whois.dot.ml',	'Invalid query or domain name not known'),
(545,	'mn',	'whois.afilias-grs.info',	'NOT FOUND'),
(546,	'mo',	'whois.monic.mo',	'No match for'),
(547,	'mo.cn',	'whois.cnnic.net.cn',	'no matching record'),
(548,	'mobi',	'whois.dotmobiregistry.net',	'NOT FOUND'),
(549,	'moda',	'whois.unitedtld.com',	'Domain not found.'),
(550,	'monash',	'whois.nic.monash',	'No Data Found'),
(551,	'money',	'whois.donuts.co',	'Domain not found.'),
(552,	'mortgage',	'whois.rightside.co',	'Domain not found.'),
(553,	'moscow',	'whois.nic.moscow',	'No entries found'),
(554,	'mov',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(555,	'ms',	'whois.nic.ms',	'No Object Found'),
(556,	'msk.ru',	'whois.nic.ru',	'No entries found'),
(557,	'mtpc',	'whois.nic.gmo',	'DOMAIN NOT FOUND'),
(558,	'mu',	'whois.nic.mu',	'Domain Status: No Object Found'),
(559,	'muni.il',	'whois.isoc.org.il',	'No data was found'),
(560,	'museum',	'whois.museum',	'NOT FOUND'),
(561,	'mx',	'whois.nic.mx',	'Object_Not_Found'),
(563,	'mz',	'whois.nic.mz',	'Domain Status: No Object Found'),
(564,	'na',	'whois.na-nic.com.na',	'Domain Status: No Object Found'),
(565,	'name',	'whois.nic.name',	'No match'),
(566,	'navy',	'whois.rightside.co',	'Domain not found.'),
(567,	'nc',	'whois.nc',	'No entries found'),
(568,	'ne.jp',	'whois.nic.ad.jp',	'No match!!'),
(569,	'ne.kr',	'whois.nic.or.kr',	'is not registered'),
(570,	'net',	'whois.crsnic.net',	'No match for'),
(571,	'net.au',	'whois.aunic.net',	'No Data Found'),
(572,	'net.br',	'whois.nic.br',	'No match for'),
(573,	'net.cn',	'whois.cnnic.net.cn',	'no matching record'),
(574,	'net.co',	'whois.nic.co',	'Not found'),
(578,	'net.hk',	'whois.hkdnr.net.hk',	'The domain has not been registered'),
(579,	'net.il',	'whois.isoc.org.il',	'No data was found'),
(580,	'net.in',	'whois.inregistry.in',	'NOT FOUND'),
(582,	'net.mx',	'whois.nic.mx',	'Object_Not_Found'),
(584,	'net.nz',	'whois.srs.net.nz',	'220 Available'),
(586,	'net.pl',	'whois.dns.pl',	'No information available'),
(587,	'net.ru',	'whois.ripn.net',	'No entries found'),
(588,	'net.sg',	'whois.nic.net.sg',	'Domain Not Found'),
(589,	'net.th',	'whois.thnic.net',	'No match for'),
(590,	'net.tr',	'whois.metu.edu.tr',	'No match found'),
(591,	'net.tw',	'whois.twnic.net',	'No Found'),
(592,	'net.ua',	'whois.net.ua',	'No entries found'),
(593,	'net.uk',	'whois.nic.uk',	'No match'),
(594,	'net.ve',	'whois.nic.ve',	'No match for'),
(596,	'network',	'whois.donuts.co',	'Domain not found.'),
(597,	'new',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(598,	'nexus',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(599,	'nf',	'whois.nic.nf',	'Domain Status: No Object Found'),
(600,	'ng',	'whois.nic.net.ng',	'Domain Status: No Object Found'),
(601,	'ngo',	'whois.publicinterestregistry.net',	'NOT FOUND'),
(604,	'nico',	'whois.nic.nico',	'DOMAIN NOT FOUND'),
(605,	'ninja',	'whois.donuts.co',	'Domain not found'),
(606,	'nissan',	'whois.nic.gmo',	'DOMAIN NOT FOUND'),
(607,	'nl',	'whois.domain-registry.nl',	'is free'),
(608,	'nm.cn',	'whois.cnnic.net.cn',	'no matching record'),
(609,	'nm.kr',	'whois.nic.or.kr',	'is not registered'),
(610,	'no',	'whois.norid.no',	'No match'),
(612,	'nom.br',	'whois.nic.br',	'No match for'),
(613,	'nom.co',	'whois.nic.co',	'Not found'),
(614,	'nom.pl',	'whois.dns.pl',	'No information available'),
(615,	'nom.ro',	'whois.rotld.ro',	'No entries found'),
(617,	'nra',	'whois.afilias-srs.net',	'NOT FOUND'),
(618,	'nrw',	'whois.nic.nrw',	'% no matching objects found'),
(619,	'nt.ro',	'whois.rotld.ro',	'No entries found'),
(620,	'ntr.br',	'whois.nic.br',	'No match for'),
(621,	'nu',	'whois.nic.nu',	'not found'),
(622,	'nx.cn',	'whois.cnnic.net.cn',	'no matching record'),
(623,	'nz',	'whois.srs.net.nz',	'220 Available'),
(624,	'odo.br',	'whois.nic.br',	'No match for'),
(625,	'om',	'whois.registry.om',	'No Data Found'),
(626,	'one',	'whois.nic.one',	'No Data Found'),
(627,	'ong',	'whois.publicinterestregistry.net',	'NOT FOUND'),
(628,	'onl',	'whois.afilias-srs.net',	'NOT FOUND'),
(629,	'ooo',	'whois.nic.ooo',	'No match for'),
(630,	'or.ac',	'whois.nic.ac',	'Available'),
(631,	'or.at',	'whois.nic.at',	'nothing found'),
(632,	'or.jp',	'whois.nic.ad.jp',	'No match!!'),
(633,	'or.kr',	'whois.nic.or.kr',	'is not registered'),
(634,	'or.th',	'whois.thnic.net',	'No match for'),
(635,	'org',	'whois.publicinterestregistry.net',	'NOT FOUND'),
(636,	'org.au',	'whois.aunic.net',	'No Data Found'),
(637,	'org.br',	'whois.nic.br',	'No match for'),
(638,	'org.cn',	'whois.cnnic.net.cn',	'no matching record'),
(642,	'org.hk',	'whois.hkdnr.net.hk',	'The domain has not been registered'),
(643,	'org.il',	'whois.isoc.org.il',	'No data was found'),
(644,	'org.in',	'whois.inregistry.in',	'NOT FOUND'),
(646,	'org.mx',	'whois.nic.mx',	'Object_Not_Found'),
(648,	'org.nz',	'whois.srs.net.nz',	'220 Available'),
(650,	'org.pl',	'whois.dns.pl',	'No information available'),
(651,	'org.ro',	'whois.rotld.ro',	'No entries found'),
(652,	'org.rs',	'whois.rnids.rs',	'%ERROR:103'),
(653,	'org.ru',	'whois.nic.ru',	'No entries found'),
(654,	'org.sg',	'whois.nic.net.sg',	'Domain Not Found'),
(655,	'org.tr',	'whois.metu.edu.tr',	'No match found'),
(656,	'org.tw',	'whois.twnic.net',	'No Found'),
(657,	'org.ua',	'whois.net.ua',	'No entries found'),
(658,	'org.uk',	'whois.nic.uk',	'No match'),
(659,	'org.ve',	'whois.nic.ve',	'No match for'),
(661,	'organic',	'whois.afilias.net',	'NOT FOUND'),
(662,	'ovh',	'whois-ovh.nic.fr',	'Requested Domain cannot be found'),
(663,	'paris',	'whois-paris.nic.fr',	'Requested Domain cannot be found'),
(664,	'partners',	'whois.donuts.co',	'Domain not found.'),
(665,	'parts',	'whois.donuts.co',	'Domain not found.'),
(666,	'pc.pl',	'whois.dns.pl',	'No information available'),
(667,	'pe',	'kero.yachay.pe',	'Status: Not Registered'),
(668,	'pf',	'whois.registry.pf',	'Domain unknown'),
(670,	'photo',	'whois.uniregistry.net',	'is available for'),
(671,	'photography',	'whois.donuts.co',	'Domain not found'),
(672,	'photos',	'whois.donuts.co',	'Domain not found'),
(673,	'physio',	'whois.nic.physio',	'No Data Found'),
(674,	'pics',	'whois.uniregistry.net',	'is available for'),
(675,	'pictures',	'whois.donuts.co',	'Domain not found.'),
(676,	'pink',	'whois.donuts.co',	'Domain not found'),
(677,	'pizza',	'whois.donuts.co',	'Domain not found.'),
(678,	'pl',	'whois.dns.pl',	'No information available'),
(679,	'place',	'whois.donuts.co',	'Domain not found.'),
(680,	'plc.uk',	'whois.nic.uk',	'No match'),
(681,	'plumbing',	'whois.donuts.co',	'Domain not found'),
(682,	'pm',	'whois.nic.pm',	'No entries found'),
(683,	'pohl',	'whois.ksregistry.net',	'not found...'),
(684,	'poker',	'whois.afilias.net',	'NOT FOUND'),
(685,	'porn',	'whois.afilias-srs.net',	'NOT FOUND'),
(686,	'post',	'whois.dotpostregistry.net',	'NOT FOUND'),
(687,	'pp.ru',	'whois.nic.ru',	'No entries found'),
(688,	'ppg.br',	'whois.nic.br',	'No match for'),
(689,	'pr',	'whois.nic.pr',	'is not registered'),
(691,	'presse.fr',	'whois.nic.fr',	'No entries found'),
(692,	'priv.pl',	'whois.dns.pl',	'No information available'),
(694,	'pro.br',	'whois.nic.br',	'No match for'),
(695,	'prod',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(696,	'productions',	'whois.donuts.co',	'Domain not found.'),
(697,	'prof',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(698,	'properties',	'whois.donuts.co',	'Domain not found.'),
(699,	'property',	'whois.uniregistry.net',	'is available for'),
(700,	'psc.br',	'whois.nic.br',	'No match for'),
(701,	'psi.br',	'whois.nic.br',	'No match for'),
(702,	'pt',	'whois.dns.pt',	'no match'),
(703,	'pub',	'whois.unitedtld.com',	'Domain not found.'),
(705,	'qa',	'whois.registry.qa',	'No Data Found'),
(707,	'qh.cn',	'whois.cnnic.net.cn',	'no matching record'),
(708,	'quebec',	'whois.nic.quebec',	'% no matching objects found'),
(709,	're',	'whois.nic.re',	'No entries found'),
(710,	're.kr',	'whois.nic.or.kr',	'is not registered'),
(711,	'realestate.pl',	'whois.dns.pl',	'No information available'),
(712,	'rec.br',	'whois.nic.br',	'No match for'),
(713,	'rec.ro',	'whois.rotld.ro',	'No entries found'),
(714,	'recipes',	'whois.donuts.co',	'Domain not found'),
(715,	'red',	'whois.afilias.net',	'NOT FOUND'),
(716,	'rehab',	'whois.rightside.co',	'Domain not found.'),
(717,	'reise',	'whois.nic.reise',	'% No match'),
(718,	'reisen',	'whois.donuts.co',	'Domain not found.'),
(720,	'rel.pl',	'whois.dns.pl',	'No information available'),
(721,	'rentals',	'whois.donuts.co',	'Domain not found.'),
(722,	'repair',	'whois.donuts.co',	'Domain not found'),
(723,	'report',	'whois.donuts.co',	'Domain not found.'),
(724,	'republican',	'whois.rightside.co',	'Domain not found.'),
(725,	'res.in',	'whois.inregistry.in',	'NOT FOUND'),
(727,	'restaurant',	'whois.donuts.co',	'Domain not found.'),
(728,	'reviews',	'whois.unitedtld.com',	'Domain not found.'),
(729,	'rich',	'whois.afilias-srs.net',	'NOT FOUND'),
(730,	'rio',	'whois.gtlds.nic.br',	'No match for'),
(731,	'rip',	'whois.rightside.co',	'Domain not found.'),
(732,	'ro',	'whois.rotld.ro',	'No entries found'),
(733,	'rocks',	'whois.unitedtld.com',	'Domain not found.'),
(734,	'rodeo',	'whois-dub.mm-registry.com',	'is available for registration'),
(735,	'rs',	'whois.rnids.rs',	'%ERROR:103'),
(736,	'rsvp',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(737,	'ru',	'whois.ripn.net',	'No entries found'),
(738,	'ruhr',	'whois.nic.ruhr',	'% no matching objects found'),
(739,	'sa',	'whois.nic.net.sa',	'No Match'),
(741,	'saarland',	'whois.ksregistry.net',	'not found...'),
(742,	'sale',	'whois.rightside.co',	'Domain not found.'),
(743,	'samsung',	'whois.nic.samsung',	'No match for'),
(744,	'sarl',	'whois.donuts.co',	'Domain not found.'),
(745,	'saxo',	'whois.aridnrs.net.au',	'No Data Found'),
(746,	'sb',	'whois.nic.net.sb',	'Domain Status: No Object Found'),
(748,	'sc.cn',	'whois.cnnic.net.cn',	'no matching record'),
(749,	'sca',	'whois.nic.sca',	'No match for'),
(750,	'scb',	'whois.nic.scb',	'NOT FOUND'),
(751,	'schmidt',	'whois.nic.schmidt',	'No Data Found'),
(752,	'school',	'whois.donuts.co',	'Domain not found.'),
(753,	'school.nz',	'whois.srs.net.nz',	'220 Available'),
(755,	'schule',	'whois.donuts.co',	'Domain not found.'),
(756,	'scot',	'whois.scot.coreregistry.net',	'% no matching objects found'),
(757,	'se',	'whois.iis.se',	'not found'),
(760,	'services',	'whois.donuts.co',	'Domain not found.'),
(761,	'sexy',	'whois.uniregistry.net',	'is available for registration'),
(762,	'sg',	'whois.nic.net.sg',	'Domain Not Found'),
(763,	'sh',	'whois.nic.sh',	'is available for purchase'),
(764,	'sh.cn',	'whois.cnnic.net.cn',	'no matching record'),
(765,	'shiksha',	'whois.afilias.net',	'NOT FOUND'),
(766,	'shoes',	'whois.donuts.co',	'Domain not found'),
(767,	'shop.pl',	'whois.dns.pl',	'No information available'),
(768,	'si',	'whois.arnes.si',	'No entries found'),
(769,	'singles',	'whois.donuts.co',	'Domain not found'),
(770,	'sk',	'whois.sk-nic.sk',	'Not found'),
(771,	'sklep.pl',	'whois.dns.pl',	'No information available'),
(772,	'sky',	'whois.nic.sky',	'No match for'),
(773,	'slg.br',	'whois.nic.br',	'No match for'),
(774,	'sm',	'whois.nic.sm',	'No entries found'),
(775,	'sn',	'whois.nic.sn',	'NOT FOUND'),
(776,	'sn.cn',	'whois.cnnic.net.cn',	'no matching record'),
(777,	'so',	'whois.nic.so',	'DOMAIN NOT FOUND'),
(778,	'sochi.su',	'whois.nic.ru',	'No entries found'),
(779,	'social',	'whois.unitedtld.com',	'Domain not found.'),
(780,	'software',	'whois.rightside.co',	'Domain not found.'),
(781,	'solar',	'whois.donuts.co',	'Domain not found'),
(782,	'solutions',	'whois.donuts.co',	'Domain not found'),
(783,	'sos.pl',	'whois.dns.pl',	'No information available'),
(784,	'soy',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(786,	'spb.ru',	'whois.nic.ru',	'No entries found'),
(787,	'spiegel',	'whois.ksregistry.net',	'not found...'),
(788,	'st',	'whois.nic.st',	'No entries found'),
(789,	'store.ro',	'whois.rotld.ro',	'No entries found'),
(790,	'study',	'whois.nic.study',	'No Data Found'),
(791,	'style',	'whois.donuts.co',	'Domain not found.'),
(792,	'su',	'whois.ripn.net',	'No entries found'),
(793,	'sucks',	'whois.nic.sucks',	'No Data Found'),
(794,	'supplies',	'whois.donuts.co',	'Domain not found.'),
(795,	'supply',	'whois.donuts.co',	'Domain not found.'),
(796,	'support',	'whois.donuts.co',	'Domain not found'),
(797,	'surf',	'whois-dub.mm-registry.com',	'is available for registration'),
(798,	'surgery',	'whois.donuts.co',	'Domain not found.'),
(799,	'sx',	'whois.sx',	'Status: AVAILABLE'),
(800,	'sy',	'whois.tld.sy',	'Available'),
(801,	'sydney',	'whois.nic.sydney',	'No Data Found'),
(802,	'systems',	'whois.donuts.co',	'Domain not found'),
(803,	'taipei',	'whois.nic.taipei',	'Not found:'),
(804,	'targi.pl',	'whois.dns.pl',	'No information available'),
(805,	'tatar',	'whois.nic.tatar',	'No entries found'),
(806,	'tattoo',	'whois.uniregistry.net',	'is available for registration'),
(807,	'tax',	'whois.donuts.co',	'Domain not found.'),
(808,	'tc',	'whois.adamsnames.tc',	'Available'),
(809,	'technology',	'whois.donuts.co',	'Domain not found'),
(810,	'tel',	'whois.nic.tel',	'Not found'),
(811,	'tennis',	'whois.donuts.co',	'Domain not found.'),
(812,	'tf',	'whois.nic.tf',	'No entries found'),
(813,	'th',	'whois.thnic.co.th',	'No match for'),
(814,	'tienda',	'whois.donuts.co',	'Domain not found.'),
(815,	'tips',	'whois.donuts.co',	'Domain not found'),
(816,	'tires',	'whois.donuts.co',	'Domain not found.'),
(817,	'tirol',	'whois.nic.tirol',	'% No match'),
(819,	'tj.cn',	'whois.cnnic.net.cn',	'no matching record'),
(821,	'tl',	'whois.nic.tl',	'Domain Status: No Object Found'),
(822,	'tm',	'whois.nic.tm',	'is available'),
(823,	'tm.fr',	'whois.nic.fr',	'No entries found'),
(824,	'tm.mc',	'whois.ripe.net',	'no entries found'),
(825,	'tm.pl',	'whois.dns.pl',	'No information available'),
(826,	'tm.ro',	'whois.rotld.ro',	'No entries found'),
(828,	'tmp.br',	'whois.nic.br',	'No match for'),
(829,	'tn',	'whois.ati.tn',	'NO OBJECT FOUND!'),
(830,	'to',	'monarch.tonic.to',	'No match for'),
(831,	'today',	'whois.donuts.co',	'Domain not found'),
(832,	'tools',	'whois.donuts.co',	'Domain not found.'),
(833,	'top',	'whois.nic.top',	'No match'),
(834,	'toshiba',	'whois.nic.toshiba',	'DOMAIN NOT FOUND'),
(835,	'tourism.pl',	'whois.dns.pl',	'No information available'),
(836,	'town',	'whois.donuts.co',	'Domain not found.'),
(837,	'toys',	'whois.donuts.co',	'Domain not found.'),
(838,	'training',	'whois.donuts.co',	'Domain not found'),
(839,	'travel',	'whois.nic.travel',	'Not found'),
(840,	'travel.pl',	'whois.dns.pl',	'No information available'),
(841,	'trust',	'whois.nic.trust',	'No Data Found'),
(842,	'tt',	'https://www.nic.tt/cgi-bin/search.pl?name=',	'is available'),
(843,	'tui',	'whois.ksregistry.net',	'not found...'),
(844,	'tur.br',	'whois.nic.br',	'No match for'),
(845,	'turystyka.pl',	'whois.dns.pl',	'No information available'),
(846,	'tv',	'whois.nic.tv',	'No match for'),
(847,	'tv.br',	'whois.nic.br',	'No match for'),
(848,	'tw',	'whois.twnic.net.tw',	'No Found'),
(849,	'tw.cn',	'whois.cnnic.net.cn',	'no matching record'),
(850,	'tz',	'whois.tznic.or.tz',	'% No entries found.'),
(851,	'ua',	'whois.net.ua',	'No entries found'),
(852,	'ug',	'whois.co.ug',	'% No entries found.'),
(853,	'uk',	'whois.nic.uk',	'This domain name has not been registered.'),
(857,	'university',	'whois.donuts.co',	'Domain not found.'),
(859,	'uol',	'whois.gtlds.nic.br',	'No match for'),
(860,	'us',	'whois.nic.us',	'Not found'),
(862,	'uy',	'whois.nic.org.uy',	'No match for'),
(865,	'vacations',	'whois.donuts.co',	'Domain not found.'),
(866,	'vc',	'whois.adamsnames.tc',	'Available'),
(867,	've',	'whois.nic.ve',	'No match for'),
(868,	'vegas',	'whois.afilias-srs.net',	'NOT FOUND'),
(869,	'ventures',	'whois.donuts.co',	'Domain not found'),
(870,	'versicherung',	'whois.nic.versicherung',	'% No match'),
(871,	'vet',	'whois.rightside.co',	'Domain not found.'),
(872,	'vet.br',	'whois.nic.br',	'No match for'),
(873,	'vg',	'whois.adamsnames.tc',	'No Object Found'),
(874,	'viajes',	'whois.donuts.co',	'Domain not found'),
(875,	'video',	'whois.rightside.co',	'Domain not found.'),
(876,	'villas',	'whois.donuts.co',	'Domain not found.'),
(877,	'vision',	'whois.donuts.co',	'Domain not found.'),
(878,	'vlaanderen',	'whois.nic.vlaanderen',	'is still available'),
(879,	'vodka',	'whois-dub.mm-registry.com',	'is available for registration'),
(880,	'vote',	'whois.afilias.net',	'NOT FOUND'),
(881,	'voting',	'whois.voting.tld-box.at',	'% No match'),
(882,	'voto',	'whois.afilias.net',	'NOT FOUND'),
(883,	'voyage',	'whois.donuts.co',	'Domain not found'),
(884,	'vu',	'vunic.vu',	'is not valid!'),
(885,	'wales',	'whois.nic.wales',	'This domain name has not been registered.'),
(886,	'wang',	'whois.gtld.knet.cn',	'No match'),
(887,	'watch',	'whois.donuts.co',	'Domain not found.'),
(888,	'web.ve',	'whois.nic.ve',	'No match for'),
(891,	'wed',	'whois.nic.wed',	'Domain Status: No Object Found'),
(892,	'wedding',	'whois-dub.mm-registry.com',	'is available for registration'),
(893,	'wf',	'whois.nic.wf',	'No entries found'),
(894,	'whoswho',	'whois.nic.whoswho',	'Not found:'),
(895,	'wien',	'whois.nic.wien',	'% No match'),
(896,	'wiki',	'whois.nic.wiki',	'DOMAIN NOT FOUND'),
(897,	'wme',	'whois.nic.wme',	'DOMAIN NOT FOUND'),
(898,	'work',	'whois-dub.mm-registry.com',	'is available for registration'),
(899,	'works',	'whois.donuts.co',	'Domain not found.'),
(900,	'world',	'whois.donuts.co',	'Domain not found.'),
(901,	'ws',	'whois.website.ws',	'No match for'),
(902,	'wtc',	'whois.nic.wtc',	'No Data Found'),
(903,	'wtf',	'whois.donuts.co',	'Domain not found.'),
(904,	'www.ro',	'whois.rotld.ro',	'No entries found'),
(905,	'xj.cn',	'whois.cnnic.net.cn',	'no matching record'),
(961,	'xxx',	'whois.nic.xxx',	'NOT FOUND'),
(963,	'xz.cn',	'whois.cnnic.net.cn',	'no matching record'),
(964,	'yn.cn',	'whois.cnnic.net.cn',	'no matching record'),
(965,	'yodobashi',	'whois.nic.gmo',	'DOMAIN NOT FOUND'),
(966,	'yoga',	'whois-dub.mm-registry.com',	'is available for registration'),
(967,	'youtube',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(968,	'yt',	'whois.nic.yt',	'No entries found'),
(969,	'za.com',	'whois.centralnic.com',	'DOMAIN NOT FOUND'),
(972,	'zip',	'domain-registry-whois.l.google.com',	'Domain not found.'),
(973,	'zj.cn',	'whois.cnnic.net.cn',	'no matching record'),
(974,	'zlg.br',	'whois.nic.br',	'No match for'),
(976,	'zone',	'whois.donuts.co',	'Domain not found.'),
(977,	'zuerich',	'whois.ksregistry.net',	'not found...');

-- 2018-11-03 22:01:24
