<?php

require "cache/phpfastcache.php";
phpFastCache::setup("storage","auto");

function xssClean($data)
{

	return htmlspecialchars($data, ENT_QUOTES, 'UTF-8');

}

function mres($var)
{
global $mysqli;
    if (get_magic_quotes_gpc())
	{

        $var = stripslashes(trim($var));

    }

return mysqli_real_escape_string($mysqli,trim($var));

}
if(get_magic_quotes_gpc())
{

	$process = array(&$_GET, &$_POST, &$_COOKIE, &$_REQUEST);

	while (list($key, $val) = each($process))
	{

		foreach ($val as $k => $v)
		{

			unset($process[$key][$k]);

			if (is_array($v))
			{

				$process[$key][stripslashes($k)] = $v;
				$process[] = &$process[$key][stripslashes($k)];

			}
			else
			{

				$process[$key][stripslashes($k)] = stripslashes($v);

			}

		}

	}

	unset($process);

}
function get_email_Type()
{
global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT type FROM emailSettings"));
	return  $rows['type'];

}
function get_suggestedDomains()
{
global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT suggestedDomains FROM suggessted_limit"));
	return  $rows['suggestedDomains'];

}
function get_admin_contactemail()
{
global $mysqli;

	$rows=mysqli_fetch_array($mysqli->query("SELECT contactEmail FROM settings"));

	return  $rows['contactEmail'];

}
function get_emailMailer()
{
global $mysqli;

	$rows=mysqli_fetch_array($mysqli->query("SELECT emailMailer FROM emailSettings"));

	return  $rows['emailMailer'];

}
function isValidDate($date)
{

	if (preg_match("/^(\d{4})-(\d{2})-(\d{2})$/", $date, $matches))
	{

	if (checkdate($matches[2], $matches[3], $matches[1]))
	return true;

	}

	return false;
}
function add_page($id,$permalink,$description, $keywords, $status, $display_order, $header_status, $footer_status)
{
	global $mysqli;
	$mysqli->query("INSERT INTO pages(id,permalink,description,keywords,status,display_order,header_status,footer_status) VALUES('$id','$permalink','$description','$keywords','$status','$display_order','$header_status','$footer_status')");

}

function add_link($title,$permalink, $status, $display_order,$header_status,$footer_status)
{
	global $mysqli;
	$mysqli->query("INSERT INTO links(title,permalink,status,display_order,header_status,footer_status) VALUES('$title','$permalink','$status','$display_order','$header_status','$footer_status')");

}
function updateEmailSettings($hostName,$port,$username,$password,$type,$emailSMTP,$emailMailer)
{
global $mysqli;
$query=$mysqli->prepare("update `emailSettings` set host=?,port=?,username=?,password=?,emailSMTP=?,emailMailer=?,type=? where esId=1");

$query->bind_param("sssssss",$hostName,$port,$username,$password,$emailSMTP,$emailMailer,$type);
$query->execute();
$query->store_result();
$numrows=$query->affected_rows;
$query->close();

	if($numrows==1)
		{
		return true;
		}
	else
		{
		return false;
		}



}

function getDisplayOrder()
{
global $mysqli;

	$array = mysqli_fetch_array($mysqli->query("SELECT MAX(display_order) AS disp_order FROM pages"));

	$total = $array["disp_order"];

	if($total>0)
	$display_order = $total + 1;
	else
	$display_order = 1;

	return $display_order;

}
function getDisplayOrderLinks()
{
global $mysqli;

	$array = mysqli_fetch_array($mysqli->query("SELECT MAX(display_order) AS disp_order FROM links"));

	$total = $array["disp_order"];

	if($total>0)
	$display_order = $total + 1;
	else
	$display_order = 1;

	return $display_order;

}

function update_page($id, $permalink,$description,$keywords,$status,$header_status,$footer_status)
{
	global $mysqli;
	$mysqli->query("UPDATE `pages` SET permalink='$permalink',description='$description',keywords='$keywords',status='$status',header_status='$header_status',footer_status='$footer_status' WHERE id='$id'");
	$mysqli->query("UPDATE `page_language` SET permalink='$permalink' WHERE id='$id'");

}

function edit_link($id,$title,$permalink, $status,$header_status,$footer_status)
{
	global $mysqli;
	$mysqli->query("UPDATE `links` SET title='$title',status='$status',header_status='$header_status',footer_status='$footer_status',permalink='$permalink' WHERE id='$id'");


}
function update_homepage($id,$description,$keywords,$header_status,$footer_status)
{
	global $mysqli;
	$mysqli->query("UPDATE `pages` SET description='$description',keywords='$keywords',header_status='$header_status',footer_status='$footer_status' WHERE id='$id'");

}
function delete_page($id)
{
	global $mysqli;

    $id = (int)mres($id);

    $sql_delete =$mysqli->query("DELETE FROM pages WHERE id='$id'");

}
function clean_permalink($permalink)
{

	$to_clean = array(
	"#",
	"%",
	"&",
	"$",
	"*",
	"{",
	"}",
	"(",
	")",
	"@",
	"^",
	"|",
	"/",
	";",
	".",
	",",
	"`",
	"!",
	"\\",
	":",
	"<",
	">",
	"?",
	"/",
	"+",
	'"',
	"'"
	);

	$permalink = str_replace(" ", "-", $permalink);

	foreach($to_clean as $symbol)
	{

	$permalink = str_replace($symbol, "", $permalink);

	}

	while (strpos($permalink, '--') !== FALSE)
	$permalink = str_replace("--", "-", $permalink);

	$permalink = rtrim($permalink, "-");

	$permalink = ltrim($permalink, "-");

	if ($permalink != "-")
	return $permalink;
	else
	return "";

}

function gen_permalink($title)
{

	$permalink = strtolower(strip_tags($title));

	$permalink = trim($title);

	$permalink = str_replace(" ", "-", $permalink);

	$permalink = clean_permalink($permalink);

	$final = $permalink;

	return strtolower($final);

}
function already_exists($permalink)
{
global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT * FROM pages WHERE permalink='$permalink'"));

	$id=$rows['id'];

	if($id)
	return true;
	else
	return false;

}
function gen_page_permalink($title)
{

	$permalink = string_limit_words($title, 9);

	$permalink = preg_replace('/[^a-z0-9]/i', ' ', $permalink);

	$permalink = trim(preg_replace("/[[:blank:]]+/", " ", $permalink));

	$permalink = strtolower(str_replace(" ", "-", $permalink));

	$count = 1;

	$temppermalink = $permalink;

	while (is_valid_page($permalink))
	{

		$permalink = $temppermalink . '-' . $count;

		$count++;

	}

	return $permalink;

}
function rootpath()
{

	//if(!isset($_SESSION['root_path'])) {

	$_SESSION['root_path'] = regenRootPath();

 //}

return $_SESSION['root_path'];

}
function cleanUrl($url)
{

	$url = preg_replace('#^https?://#', '', $url);

	$url = preg_replace('/^www\./', '', $url);

	return $url;
}
function regenRootPath()
{
global $mysqli;
	$query = $mysqli->query("SELECT `rootPath` FROM `settings`");

	$fetch = mysqli_fetch_array($query);

	if ($fetch['rootPath'] != "")
	{

		$www = (urlStructure()) ? 'www.':'';
		$https = (httpsStatus()) ? 'https://':'http://';
		$_SESSION['root_path'] = $https . $www . cleanUrl($fetch['rootPath']);

	}

	return $_SESSION['root_path'];

}
function getNameTheme()
{
global $mysqli;
	$query = $mysqli->query("SELECT `name` FROM `themes`");

	$fetch = mysqli_fetch_array($query);

	return $fetch['name'];

}
function getFilnameTheme($id)
{
global $mysqli;
	$query = $mysqli->query("SELECT `filname` FROM `themes` where `id`='$id'");

	$fetch = mysqli_fetch_array($query);

	return $fetch['filname'];

}
function checkActiveTheme($id)
{
global $mysqli;
	$query = $mysqli->query("SELECT `filname` FROM `themes` where id='$id' and `status`=1");
	$row= mysqli_num_rows($query);
	if($row==1)
	{
	return true;
	}
	else
	{
	return false;
	}
}

function checkLanguageName($name)
{
global $mysqli;
	$query = $mysqli->query("SELECT `id` FROM `language` where lang_name='$name'");
	$row= mysqli_num_rows($query);
	if($row>0)
	{
	return true;
	}
	else
	{
	return false;
	}
}

function getThemePreview($unique)
{

global $mysqli;
	$query = $mysqli->query("SELECT `filname` FROM `themes` where uniqueid='$unique'");

	$row= mysqli_num_rows($query);
	if($row==1)
	{
	$fetch = mysqli_fetch_array($query);
	return $fetch['filname'];
	}
	else
	{
	return false;
	}

}
function LookupDomain($domain){
	global $whoisservers;
	$domain_parts = explode(".", $domain);
    $tld='';
    for($i=1;$i<=count($domain_parts)-1;$i++)
    {
        $tld.=$domain_parts[$i].".";
    }
    $tld= strtolower(substr($tld, 0, -1));

	$whoisserver = trim(getWhoisServerFromdb($tld));
	if(!$whoisserver) {
		return "<span class=\"alert alert-danger\"><i class='fa fa-exclamation-triangle fa-fw fa-lg'></i> Error: No appropriate Whois server found for $domain domain!</span>";
	}
	$result = QueryWhoisServer($whoisserver, $domain);
	if(!$result || $result==1) {
	if(!$result)
		return "<span class=\"alert alert-danger\"><i class='fa fa-exclamation-triangle fa-fw fa-lg'></i> Error: No results retrieved from $whoisserver server for $domain domain!</span>";
	else
		return "<span class=\"alert alert-danger\"><i class='fa fa-exclamation-triangle fa-fw fa-lg'></i> Error: No Data Found!</span>";

	}
	else
	{
		while(strpos($result, "Whois Server:") !== FALSE){
			preg_match("/Whois Server: (.*)/", $result, $matches);
			$secondary = $matches[1];
			if($secondary) {
				$result = QueryWhoisServer($secondary, $domain);
				$whoisserver = $secondary;
			}
		}
	}
	if(!$result || $result==1)
	{
	if(!$result)
		return "<span class=\"alert alert-danger\"><i class='fa fa-exclamation-triangle fa-fw fa-lg'></i> Error: No results retrieved from $whoisserver server for $domain domain!</span>";
	else
		return "<span class=\"alert alert-danger\"><i class='fa fa-exclamation-triangle fa-fw fa-lg'></i> Error: No Data Found!</span>";

	}
	else
	{

	return "<span class='center-block'>Domain:$tld '$domain' &nbsp;|&nbsp;&nbsp;Server: '$whoisserver'</span>\n\n" . $result;
	}



}

function ValidateDomain($domain) {
	if(!preg_match("/^([-a-z0-9]{2,100})\.([a-z\.]{2,8})$/i", $domain)) {
		return false;
	}
	return $domain;
}

function QueryWhoisServer($whoisserver, $domain) {
	$port = 43;
	$timeout = 10;
	$fp = @fsockopen($whoisserver, $port, $errno, $errstr, $timeout);
	if($fp)
	{
		if($whoisserver == "whois.verisign-grs.com")
		$domain = "domain ".$domain;
		// whois.verisign-grs.com needs to be proceeded by the keyword "domain ", otherwise it will return any result containing the searched string.
		fputs($fp, $domain . "\r\n");
		$out = "";
		while(!feof($fp)){
			$out .= fgets($fp);
		}
		fclose($fp);

		$res = "";
		if((strpos(strtolower($out), "error") === FALSE) && (strpos(strtolower($out), "not allocated") === FALSE)) {
			$rows = explode("\n", $out);
			foreach($rows as $row) {
				$row = trim($row);
				if(($row != '') && ($row{0} != '#') && ($row{0} != '%')) {
					$res .= $row."\n";
				}
			}
		}
		return $res;
	}
	else
	{
	return 1;
	}

}
function update_settings($name,$title, $description, $keywords, $rootpath, $logo, $favicon,$urlStructure,$https,$f_loader,$p_loader,$whois_link,$whoisStatus)
{
	global $mysqli;

    $title = strip_tags(htmlspecialchars(mres($title)));

	$description = strip_tags(htmlspecialchars(mres($description)));

	$keywords = strip_tags(htmlspecialchars(mres($keywords)));

    $rows = mysqli_num_rows($mysqli->query("SELECT * FROM `settings`"));

	if($rows>0)
	{
		$sql_update = $mysqli->query("UPDATE `settings` SET `name`='$name',`title`='$title',`description`='$description',`keywords`='$keywords',`rootpath`='$rootpath',`logo`='$logo',`favicon`='$favicon',urlStructure='$urlStructure', httpsStatus='$https',f_loader='$f_loader', p_loader='$p_loader', whois_url='$whois_link', whoisStatus='$whoisStatus'");
	}
	else
	{
		$sql_update = $mysqli->query("INSERT INTO settings(title,description, keywords,rootpath, urlStructure, httpsStatus,logo,favicon,f_loader,p_loader,whoisStatus,suggestedDomains) VALUES('$title','$description','$keywords','$rootpath','$urlStructure','$https','$logo','$favicon','$f_loader','$p_loader','$whoisStatus')");
	}
	unset($_SESSION['root_path']);
	unset($_SESSION['loader_session']);
	unset($_SESSION['admin_loader_session']);

}
function valid_facebook_url($field)
{

	if (!preg_match('/^[a-z\d.]{5,}$/i', $field))
	{

		return false;

	}

	return true;

}
function valid_twitter_username($field)
{

	if (!preg_match('/^[A-Za-z0-9_]+$/', $field))
	{

		return false;

	}

	return true;

}
function getWhoisServerFromdb($tld)
{
global $mysqli;
    $record=$mysqli->query("select whois from whoisServerList where name='$tld'");
	$value="";
    while($rows=mysqli_fetch_assoc($record))
	{
    $value=$rows['whois'];
	}
return $value;
}
function valid_google_url($field)
{

	if (!preg_match('/^([0-9]{1,21})$/', $field))
	{

	    return false;

	}

	return true;

}
function valid_title($field)
{

	if (strlen($field) > 70 || strlen($field) < 10)
	{

		return false;

	}

	return true;

}
function valid_desc($field)
{

	if (strlen($field) > 160 || strlen($field) < 20)
	{

		return false;

	}

	return true;

}


function valid_keyword($field)
{

	if (strlen($field) > 160 || strlen($field) < 20)
	{

		return false;

	}

	return true;

}
function get_cr_name()
{
	global $mysqli;

	$rows=mysqli_fetch_array($mysqli->query("SELECT cr_name FROM currency_settings"));

	return $rows['cr_name'];

}
function get_price()
{
global $mysqli;

	$rows=mysqli_fetch_array($mysqli->query("SELECT price_dollor FROM currency_settings"));

	return $rows['price_dollor'];

}
function get_twitter()
{
global $mysqli;

	$row=mysqli_fetch_array($mysqli->query("SELECT twitter FROM `social_profiles`"));

	return $row['twitter'];

}
function get_facebook()
{
global $mysqli;

	$row=mysqli_fetch_array($mysqli->query("SELECT facebook FROM `social_profiles`"));

	return $row['facebook'];

}
function get_google()
{
global $mysqli;

	$row=mysqli_fetch_array($mysqli->query("SELECT google_plus FROM `social_profiles`"));

	return $row['google_plus'];

}
function reset_pass($email)
{
global $mysqli;

	$rows=mysqli_fetch_array($mysqli->query("SELECT username FROM settings WHERE email = '$email'"));

	$username = $rows['username'];

	$password = genPassword();
	if(get_email_Type()==1)
	{
	send_email_smtp(get_admin_contactemail(),$username,"Password Received", "Your Login Details Updated - " . getMetaTitle()."<br/>Username: " . $username . "<br/>Your new password is: " . $password . "<br/>Login Here: " . rootPath() . '/admin/');

	}
	else
	{
	send_email_simple(get_admin_contactemail(),get_emailMailer(), "Password Received", "Your Login Details Updated - " . getMetaTitle() , "Your Login Details Updated<br/>Username: " . $username . "<br/>Your new password is: " . $password . "<br/>Login Here: " . rootPath() . '/admin/');

	}


	$sql_update = $mysqli->query("UPDATE settings SET password='" . md5($password) . "' WHERE email='" . $email . "'");

}
function getdomain($url)
{

	if(preg_match("#https?://#", $url) === 0)
	$url = 'http://' . $url;

	return strtolower(str_ireplace('www.', '', parse_url($url, PHP_URL_HOST)));

}
function get_name()
{
global $mysqli;

	$rows=mysqli_fetch_array($mysqli->query("SELECT name FROM settings"));

	return  $rows['name'];

}
function get_title()
{
global $mysqli;

	$rows=mysqli_fetch_array($mysqli->query("SELECT title FROM settings"));

	return  $rows['title'];

}
function get_whois()
{
global $mysqli;

	$rows=mysqli_fetch_array($mysqli->query("SELECT whois_url FROM settings"));

	return  $rows['whois_url'];

}
function get_admin_email()
{
global $mysqli;

	$rows=mysqli_fetch_array($mysqli->query("SELECT email FROM settings"));

	return  $rows['email'];

}

function sencrypt($text)
{

	return strtr(base64_encode($text) , '+/=', '-_,');

}
function sdecrypt($text)
{

	return base64_decode(strtr($text, '-_,', '+/='));

}
function get_admin_username()
{
global $mysqli;

	$sql_select=$mysqli->query("SELECT username FROM settings");

	$rows=mysqli_fetch_array($sql_select);

	$count=mysqli_num_rows($sql_select);

	if ($count > 0)
	return  $rows['username'];

}
function get_tracking_code()
{
global $mysqli;

	$fetch = mysqli_fetch_array($mysqli->query("SELECT status from analytics"));

	if ($fetch['status'])
	{

		$row = mysqli_fetch_array($mysqli->query("select tracking_code from analytics"));

		$code = str_replace("<q>", "'", $row["tracking_code"]);

		$code = htmlspecialchars_decode($code);

		return ($code);
	}

	return "";

}
function get_description()
{
global $mysqli;
	$array = mysqli_fetch_array($mysqli->query('SELECT `description` FROM settings'));

	if (trim($array['description']))
		return trim($array['description']);

	return '';

}
function get_tags()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query('SELECT `keywords` FROM settings'));

	if (trim($array['keywords']) != "")
		return trim($array['keywords']);

	return '';

}

function valid_url($url)
{

	$validation = filter_var($url, FILTER_VALIDATE_URL, FILTER_FLAG_HOST_REQUIRED) && (preg_match("#^http(s)?://[a-z0-9-_.]+\.[a-z]{2,4}#i", $url));

	if ($validation)
	return true;
	else
	return false;

}
function getemailSettings()
{
global $mysqli;
	$data=array();
	$query=$mysqli->query("select * from emailSettings where esId=1");

	while($row=mysqli_fetch_assoc($query))
	{
	$data[]=array("host"=>$row['host'],"port"=>$row['port'],"username"=>$row['username'],"password"=>$row['password'],"emailSMTP"=>$row['emailSMTP']);
	}

return $data;

}
function send_email_smtp($to,$from,$name,$subject,$body)
{

	$mail = new PHPMailer;
	$mail->isSMTP(); // Set mailer to use SMTP
	$mail->Host = 'smtp.gmail.com'; // Specify main and backup SMTP servers
	$mail->SMTPAuth = true; // Enable SMTP authentication
	$mail->Username = 'sender.02.mail@gmail.com';                 // SMTP username
	$mail->Password = 'tybxdunybyxfrjwu';
	$mail->SMTPSecure = 'tls'; // Enable TLS encryption, `ssl` also accepted
	$mail->Port = 587; // TCP port to connect to
	$mail->AddReplyTo($from, $name);                                    // TCP port to connect to
	$mail->setFrom($from,$name);
	$mail->addAddress($to);     // Add a recipient
	$mail->isHTML(true);                                  // Set email format to HTML
	$mail->Subject = $subject;
	$mail->Body    = $body;
	$mail->AltBody = $body;
	$mail->send();

}
function send_email_simple($to, $from, $name, $subject, $body)
{

	$mail = new PHPMailer;
	//$mail->SMTPDebug = 3;                               // Enable verbose debug output
	//$emailSettings=getemailSettings();
	$mail->isSMTP();                                      // Set mailer to use SMTP
	$mail->Host = 'smtp.gmail.com';  // Specify main and backup SMTP servers
	$mail->SMTPAuth = true;                               // Enable SMTP authentication
	$mail->Username = 'sender.02.mail@gmail.com';                 // SMTP username
	$mail->Password = 'tybxdunybyxfrjwu';                           // SMTP password
	$mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
	$mail->Port = 587;                                        // TCP port to connect to
	$mail->setFrom("sender.02.mail@gmail.com",$name);
	$mail->addAddress($to,$name);     // Add a recipient
	$mail->isHTML(true);                                  // Set email format to HTML
	$mail->Subject = $subject;
	$mail->Body    = $body;
	$mail->AltBody = $body;
	if($mail->send())
		return true;
	else
		return false;

}
function genPassword()
{

	$chars = "abcdefghijkmnopqrstuvwxyz023456789";

	srand((double)microtime() * 1000000);

	$i = 0;

	$pass = '';

	while ($i <= 8)
	{

		$num = rand() % 33;

		$tmp = substr($chars, $num, 1);

		$pass = $pass . $tmp;

		$i++;

	}

	return $pass;

}
function is_alpha($val)
{

	return (bool)preg_match("/^([0-9a-zA-Z ])+$/i", $val);

}
function checkEmail($email)
{

	return preg_match('/^\S+@[\w\d.-]{2,}\.[\w]{2,6}$/iU', $email) ? TRUE : FALSE;

}
function is_valid_page($permalink)
{
global $mysqli;
	$match = "select title from pages where permalink='" . $permalink . "'";

	$qry = $mysqli->query($match);

	$num_rows = mysqli_num_rows($qry);

	if ($num_rows > 0)
	return true;
	else
	return false;

}
function email_exists($val)
{
global $mysqli;
	$sql_select=$mysqli->query("SELECT username FROM settings WHERE email ='$val'");

	$rows=mysqli_fetch_array($sql_select);

	$count=mysqli_num_rows($sql_select);

	if($count > 0)
	return true;
	else
	return false;

}
function get_logo()
{
global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT logo FROM settings"));
	return  $rows['logo'];

}

function get_favicon()
{
global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT favicon FROM settings"));

	return  $rows['favicon'];

}
function valid_file_extension($ext)
{

	$allowedExts = array(
	"gif",
	"jpeg",
	"jpg",
	"png"
	);

	if (!in_array($ext, $allowedExts))
	{

	return false;

	}

	return true;

}
function valid_favicon_extension($ext)
{

	$allowedExts = array(
	"ico",
	"png"
	);

	if (!in_array($ext, $allowedExts))
	{

		return false;

	}

		return true;
}
function valid_language_extension($ext)
{

	$allowedExts = array(
	"txt",
	"docx",
	"php",
	"html",
	"pdf"
	);

	if (!in_array($ext, $allowedExts))
	{

		return false;

	}

		return true;
}
function show_med_rec1_ad()
{
global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT medrec1 FROM ads"));

	$code = str_replace("<q>", "'", $rows['medrec1']);

	$code = htmlspecialchars_decode($code);

	return ($code);

}
function show_med_rec2_ad()
{
global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT medrec2 FROM ads"));

	$code = str_replace("<q>", "'", $rows['medrec2']);

	$code = htmlspecialchars_decode($code);

	return ($code);

}
function analyticsEnabled() {
global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `status` FROM `analytics`"));

	if ($array['status'])
		return true;

	return false;

}
function show_analytics_status()
{
global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT tracking_code FROM analytics"));

	$code = str_replace("<q>", "'", $rows['tracking_code']);

	$code = htmlspecialchars_decode($code);

	return ($code);

}
function increment_page_views()
{
global $mysqli;
	$sql = $mysqli->query("SELECT pageviews FROM `stats` WHERE `date` = CURDATE()");

	$rows = mysqli_num_rows($sql);

	if ($rows > 0)
	{

		$sql_update = $mysqli->query("UPDATE `stats` SET `pageviews`=`pageviews`+1 WHERE `date`=CURDATE()");

	}
	else
	{

		$sql_insert = $mysqli->query("INSERT INTO `stats`(`pageviews`, `unique_hits`,`affiliates_hits`,`total_searches`, `date`) VALUES ('1','1','0','0',CURDATE())");

	}

}
function increment_unique_hits()
{
global $mysqli;
	$sql = $mysqli->query("SELECT unique_hits FROM `stats` WHERE `date`=CURDATE()");

	$rows = mysqli_num_rows($sql);

	if ($rows > 0)
	{

		$sql_update = $mysqli->query("UPDATE `stats` SET `unique_hits`=`unique_hits`+1 WHERE `date`=CURDATE()");

	}
	else
	{

		$sql_insert = $mysqli->query("INSERT INTO `stats`(`pageviews`, `unique_hits`,`affiliates_hits`,`total_searches`, `date`) VALUES ('1','1','0','0',CURDATE())");

	}

}
function increment_affiliates_hits()
{
global $mysqli;
	$sql = $mysqli->query("SELECT affiliates_hits FROM `stats` WHERE `date` = CURDATE()");

	$rows = mysqli_num_rows($sql);

	if ($rows > 0)
	{

		$sql_update = $mysqli->query("UPDATE `stats` SET `affiliates_hits`=`affiliates_hits`+1 WHERE `date`=CURDATE()");

	}
	else
	{

		$sql_insert = $mysqli->query("INSERT INTO `stats`(`pageviews`, `unique_hits`,`affiliates_hits`,`total_searches`, `date`) VALUES ('1','1','1','1',CURDATE())");

	}

}
function db_decode($str)
{

	$str = trim(str_replace("<q>", "'", $str));

	$str = htmlspecialchars_decode($str);

	return $str;

}
function authenticate($email, $password)
{
global $mysqli;
	$email = mres($email);

	$password = md5($password);

	$sql      = "select email from settings WHERE (email='$email' AND password='$password') OR (username='$email' AND password='$password')";

	$query    = $mysqli->query($sql);

	if (mysqli_num_rows($query) > 0)
	{

		return true;

	}
	else
	{

		return false;

	}

}
function show_medrec1()
{
global $mysqli;
	$row=mysqli_fetch_array($mysqli->query("SELECT medrec1,medrec1_status FROM ads"));

	if($row['medrec1_status']==1)
	return $row['medrec1'];

}
function show_medrec2()
{
global $mysqli;
	$row=mysqli_fetch_array($mysqli->query("SELECT medrec2,medrec2_status FROM ads"));

	if($row['medrec2_status']==1)
	return $row['medrec2'];

}
function show_medrec3()
{
global $mysqli;
	$row=mysqli_fetch_array($mysqli->query("SELECT medrec3,medrec3_status FROM ads"));

	if($row['medrec3_status']==1)
	return $row['medrec3'];

}
function captcha_admin_login_status()
{
global $mysqli;
	$array  = mysqli_fetch_array($mysqli->query("SELECT captcha_admin_login_status FROM captcha_settings"));

	if($array['captcha_admin_login_status'])
	return true;
	return false;

}
function captcha_contact_status()
{
global $mysqli;
	$array  = mysqli_fetch_array($mysqli->query("SELECT captcha_contact_status FROM captcha_settings"));

	if($array['captcha_contact_status'])
	return true;
	return false;

}
function getMetaTitle()
{
global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `title` FROM `settings`"));

	if ($array['title'] != "")
	return $array['title'];
    return "Instant Domain Search";

}
function getUser()
{
global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `username` FROM `settings`"));

	if($array['username'])
	return $array['username'];

}

function captcha_enable_settings($contact_enable,$login_enable)
{
global $mysqli;
    $sql_update = $mysqli->query("UPDATE `captcha_settings` SET `captcha_contact_status`='$contact_enable',`captcha_admin_login_status`='$login_enable'");

}
function captcha_contact_enable()
{
global $mysqli;
	$show  = "select captcha_contact_status from captcha_settings";

	$qry   = $mysqli->query($show);

	$array = mysqli_fetch_array($qry);

	return $array['captcha_contact_status'];

}
function captcha_login_enable()
{
global $mysqli;
	$show  = "select captcha_admin_login_status from captcha_settings";

	$qry   = $mysqli->query($show);

	$array = mysqli_fetch_array($qry);

	return $array['captcha_admin_login_status'];

}
function return_downloads_this_month()
{
global $mysqli;
	$sql="SELECT SUM(total_searches) AS total_searches from stats WHERE YEAR(date) = YEAR(CURDATE()) AND MONTH(date) = MONTH(CURDATE()) ";

	$query=@$mysqli->query($sql);

	$fetch_array = mysqli_fetch_array($query);

	if ($fetch_array['total_searches'])
	return $fetch_array['total_searches'];
	return "0";

}
function return_total_searches($date)
{
global $mysqli;
	$sql = "select sum(total_searches) as total_searches from stats where date='$date'";

	$query = $mysqli->query($sql);

	$fetch_array = mysqli_fetch_array($query);

	if ($fetch_array['total_searches']) return $fetch_array['total_searches'];
	return "0";

}
function return_downloads_all_time()
{
global $mysqli;
	$sql="SELECT SUM(total_searches) AS total_searches from stats";

	$query=$mysqli->query($sql);

	$fetch_array = mysqli_fetch_array($query);

	if ($fetch_array['total_searches'])
	return $fetch_array['total_searches'];
	return "0";

}
function update_social($facebook,$twitter,$google,$f_status,$t_status,$g_status,$all_status)
{
global $mysqli;
	$sql_update = $mysqli->query("UPDATE `social_profiles` SET `facebook`='$facebook',`twitter`='$twitter',`google_plus`='$google',`f_status`='$f_status',`t_status`='$t_status',`g_status`='$g_status',`social_buttons`='$all_status'");

}
function update_currency($cr_name,$price_dollor,$show)
{
	global $mysqli;
	$sql_update = $mysqli->query("UPDATE currency_settings SET cr_name='$cr_name', price_dollor='$price_dollor', show_place='$show'");

}
function update_ads($medrec1,$medrec1_status,$medrec2,$medrec2_status)
{
	global $mysqli;
	$sql_update = $mysqli->query("UPDATE `ads` SET `medrec1`='$medrec1',`medrec1_status`='$medrec1_status',`medrec2`='$medrec2',`medrec2_status`='$medrec2_status'");

}
function show_analytics_status1()
{
	global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT tracking_code FROM analytics"));

	$code = str_replace("<q>", "'", $rows['tracking_code']);

	$code = htmlspecialchars_decode($code);

	return ($code);

}
function update_analytics($tracking_code, $status)
{
global $mysqli;
	$sql_update = $mysqli->query("UPDATE `analytics` SET `tracking_code`='$tracking_code',`status`='$status'");

}
function update_license($username, $code)
{
global $mysqli;
	$rows = mysqli_num_rows($mysqli->query("SELECT * FROM `license`"));

	if($rows>0) {

	$mysqli->query("UPDATE `license`  SET `username`='$username',`purchase_code`='$code'");

	} else {

	$mysqli->query("INSERT INTO `license`(username,purchase_code) VALUES('$username','$code')");;

	}

}
function change_affiliates_status($godaddy,$wantname,$media,$namecheap,$one_a_one,$register,$united,$yahoo,$hover)
{
global $mysqli;
    $sql_update = $mysqli->query("UPDATE `affiliates` SET `status`='$godaddy' WHERE `affiliate_name`='godaddy'");

	$sql_update = $mysqli->query("UPDATE `affiliates` SET `status`='$wantname' WHERE `affiliate_name`='iwant_my_name'");

	$sql_update = $mysqli->query("UPDATE `affiliates` SET `status`='$media' WHERE `affiliate_name`='media_temple'");

	$sql_update = $mysqli->query("UPDATE `affiliates` SET `status`='$namecheap' WHERE `affiliate_name`='name_cheap'");

	$sql_update = $mysqli->query("UPDATE `affiliates` SET `status`='$one_a_one' WHERE `affiliate_name`='one_one'");

	$sql_update = $mysqli->query("UPDATE `affiliates` SET `status`='$register' WHERE `affiliate_name`='register'");

	$sql_update = $mysqli->query("UPDATE `affiliates` SET `status`='$united' WHERE `affiliate_name`='united_domains'");

	$sql_update = $mysqli->query("UPDATE `affiliates` SET `status`='$yahoo' WHERE `affiliate_name`='yahoo'");

	$sql_update = $mysqli->query("UPDATE `affiliates` SET `status`='$hover' WHERE `affiliate_name`='hover'");


}
function update_domains($tld,$domain)
{
	global $mysqli;
    $date=date("Y-m-d");

	$sld = $domain.'.'.$tld;

	$obj = new Whois($sld);

	if ($obj->isAvailable())
	{
		$sql_update = $mysqli->query("UPDATE `instant_domain` SET `$tld` = '1',last_date_check='$date'  WHERE `domain`='$domain'");
	}
	else
	{
		$sql_update = $mysqli->query("UPDATE `instant_domain` SET `$tld` = '2',last_date_check='$date'  WHERE `domain`='$domain'");
	}

}
function Text_Box_Validation($url)
{

	if(trim(substr($url,0,7))=="http://")
		$url = trim(substr($url,7,strlen($url)-7));

	if(trim(substr($url,0,8))=="https://")
		$url = trim(substr($url,8,strlen($url)-8));

	if(trim(substr($url,0,4))=="www.")
		$url = trim(substr($url,4,strlen($url)-4));

	$data = clean($url);

	while(strpos(trim($data),"---")!==false)
	{

	     $data = str_replace("---","--",$data);

	}

	while(trim(substr($data,0,1))=="." || trim(substr($data,strlen($data)-1,1))=="." || trim(substr($data,0,1))=="-" || trim(substr($data,strlen($data)-1,1))=="-")
	{

		$data = ltrim($data,"-");

		$data = rtrim($data,"-");

		$data = ltrim($data,".");

		$data = rtrim($data,".");

	}
	if(strpos($data,".")!==false)
	{

		$data = strrev($data);

		$data = explode(".",$data);

		$i = count($data);

		$url = "";

		for($i;$i>0;$i--)
		{

		     $url .=strrev($data[$i]);

		}

	}
	else
		$url = $data;

	$url = ltrim($url,"-");

	$url = rtrim($url,"-");

	return substr($url, 0,60);

}
function clean($string)
{

	$string = str_replace(' ', '', $string);

	$string = preg_replace('/[^A-Za-z.0-9\-]/', '', $string);

	return $string;

}
function return_affiliate_url($domain,$tld='com')
{
	global $mysqli;
		if($_SESSION['affiliate_name']=="godaddy")
			$affiliate_url = $_SESSION['url']."?sid=1673601704.1419598115&url=https://www.godaddy.com/domains/search.aspx?domainToCheck="  . $domain  . "." . $tld . "&checkAvail=1";
		else if($_SESSION['affiliate_name']=="iwant_my_name")
			$affiliate_url = $_SESSION['url']."&afftrack=&urllink=iwantmyname.com%2Fsearch%2Fadd%2F"  . $domain  . "." . $tld . "%3Fr%3DInstantDomainSearch%26_r%3DInstantDomainSearch%26_p%3Dsession%253Dunused%2526user%253Dunused";
		else if($_SESSION['affiliate_name']=="media_temple")
			$affiliate_url = $_SESSION['url'];
		else if($_SESSION['affiliate_name']=="united_domains")
			$affiliate_url = $_SESSION['url'];
		else if($_SESSION['affiliate_name']=="yahoo")
			$affiliate_url = $_SESSION['url'];
		else if($_SESSION['affiliate_name']=="one_one")
		{
		    $explode = explode('-',$_SESSION['url'],2);
			$PID = explode('-',$explode [1],2);
			$affiliate_url = "https://www.dpbolvw.net/interactive?sid=80072381.1420179601&domain="  . $domain  . "&tld="  . $tld  . "&aid=10933941&pid=" . $PID[0] . "&url=http://order.1and1.com/dcjump?ac=OM.US.US469K02463T2103a&ovm_kp=wh&ovm_wm=s_ch_360x50";
		}
		else if($_SESSION['affiliate_name']=="name_cheap")
			$affiliate_url = $_SESSION['url']."?sid=1673601704.1419598115&url=https://www.namecheap.com/domains/registration/results.aspx?domain=" . $domain . "." . $tld;
		else if($_SESSION['affiliate_name']=="register")
			$affiliate_url = $_SESSION['url'];
		else if($_SESSION['affiliate_name']=="hover")
			$affiliate_url = $_SESSION['url']. "?p.domain=".$domain.".".$tld;
		else
		{

			$rows=mysqli_fetch_array($mysqli->query("SELECT * FROM affiliates WHERE status = '1' ORDER BY precedence ASC"));
			if($rows['affiliate_name'] == 'godaddy')
				$affiliate_url = $_SESSION['url']."?sid=1673601704.1419598115&url=https://www.godaddy.com/domains/search.aspx?domainToCheck="  . $domain  . "." . $tld . "&checkAvail=1";
			else if($rows['affiliate_name'] == 'iwant_my_name')
				$affiliate_url = $_SESSION['url']."&afftrack=&urllink=iwantmyname.com%2Fsearch%2Fadd%2F"  . $domain  . "." . $tld . "%3Fr%3DInstantDomainSearch%26_r%3DInstantDomainSearch%26_p%3Dsession%253Dunused%2526user%253Dunused";
			else if($rows['affiliate_name'] == 'media_temple')
				$affiliate_url = $_SESSION['url'];
			else if($rows['affiliate_name'] == 'name_cheap')
				$affiliate_url = $_SESSION['url']."?sid=1673601704.1419598115&url=https://www.namecheap.com/domains/registration/results.aspx?domain=" . $domain . "." . $tld;
			else if($rows['affiliate_name'] == 'one_one')
			{
			    $explode = explode('-',$_SESSION['url'],2);
				$PID = explode('-',$explode [1],2);
				$affiliate_url = "https://www.dpbolvw.net/interactive?sid=80072381.1420179601&domain="  . $domain  . "&tld="  . $tld  . "&aid=10933941&pid=" . $PID[0] . "&url=http://order.1and1.com/dcjump?ac=OM.US.US469K02463T2103a&ovm_kp=wh&ovm_wm=s_ch_360x50";
			}
			else if($rows['affiliate_name'] == 'register')
				$affiliate_url = $_SESSION['url'];
			else if($rows['affiliate_name'] == 'united_domains')
				$affiliate_url = $_SESSION['url'];
			else if($rows['affiliate_name'] == 'yahoo')
				$affiliate_url = $_SESSION['url'];
			else if($_SESSION['affiliate_name']=="hover")
				$affiliate_url = $_SESSION['url']. "?p.domain=".$domain.".".$tld;
			else
			$affiliate_url = $_SESSION['url']."?sid=1673601704.1419598115&url=https://www.godaddy.com/domains/search.aspx?domainToCheck="  . $domain  . "." . $tld . "&checkAvail=1";

		}
		return $affiliate_url;
}
function tld_server($ext,$dom,$who,$tld1)
{
	global $mysqli;
	$data = array();
	$date=date("Y-m-d");
	$cache = phpFastCache();
	$prices = $cache->get('default_prices');
	unset($cache);
	if($tld1 == 'main_div'){
		$sld = $dom.'.'.$ext;
		$cache = phpFastCache();
		$existense = $cache->get($sld);
		if($existense==null || $_SESSION['tld_status'] != 1)
		{
			$obj = new Whois($sld);
			if($obj->isAvailable())
				$existense = 1;
			else
				$existense = 0;
			if($existense == 1)
			{
				$contains = mysqli_num_rows($mysqli->query("SELECT `$ext` FROM instant_domain WHERE domain='$dom'"));
				if($contains>0)
					$mysqli->query("UPDATE instant_domain SET `$ext`='1',last_date_check='$date' WHERE domain='$dom'");
				else
					$mysqli->query("INSERT INTO instant_domain(domain,`$ext`,last_date_check) VALUES('$dom','1','$date')");
			}
			else
			{
				$contains = mysqli_num_rows($mysqli->query("SELECT `$ext` FROM instant_domain WHERE domain='$dom'"));
				if($contains>0)
					$mysqli->query("UPDATE instant_domain SET `$ext`='2' WHERE domain='$dom'");
				else
					$mysqli->query("INSERT INTO instant_domain(domain,`$ext`,last_date_check) VALUES('$dom','2','$date')");
			}
			$cache->set($sld,$existense,$_SESSION['tld_time']);
		unset($obj);
		}
		if($existense == 1)
		{
			$data[1] = '<div id="change-background" class="com-rslt green-rslt">
				<div class="wrapper">
					<a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'" id="top_domain_href" target="_blank" href="'.return_affiliate_url($dom,$ext).'">
						<div class="com-wrap">
							<div class="com-wrap"><span class="live-domain-name">'.$dom.'.'.$ext.'</span> <div id="top_'.$ext.'_domain" class="com-btn btn-green">'.convert_currency($prices['prices'][$ext]).'</div></div>
						</div>
					</a>
				</div>
			</div>';
		}
		else
		{
			$whois_link = str_replace("{domain}",$dom.'.'.$ext,$_SESSION['whois_link']);

			if($_SESSION['whoisStatus'] == 1)
				$DefinedWhoisUrl = '<a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'" target="_blank" href="'.$whois_link.'">';
			else
				$DefinedWhoisUrl = '<a style="cursor:pointer" data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'">';

			$data[1] = '<div id="change-background" class="com-rslt red-rslt">
				<div class="wrapper">
					'.$DefinedWhoisUrl.'
						<div class="com-wrap">
							<div class="com-wrap"><span class="live-domain-name">'.$dom.'.'.$ext.'</span> <div id="top_'.$who.'_domain" class="com-btn btn-red">'.$who.'</div></div>
						</div>
					</a>
				</div>
			</div>';
		}
	}
		$data[0] = '';
		foreach( $_SESSION['TldArray'] as $i) {
			$ext = $i;
			$sld = $dom.'.'.$ext;
			$cache = phpFastCache();
			$existense = $cache->get($sld);

			if($existense==null || $_SESSION['tld_status'] != 1)
			{
				$obj = new Whois($sld);
				if($obj->isAvailable())
					$existense = 1;
				else
					$existense = 0;
				if($existense == 1)
				{
					$contains = mysqli_num_rows($mysqli->query("SELECT `$ext` FROM instant_domain WHERE domain='$dom'"));
					if($contains>0)
						$mysqli->query("UPDATE instant_domain SET `$ext`='1',last_date_check='$date' WHERE domain='$dom'");
					else
						$mysqli->query("INSERT INTO instant_domain(domain,`$ext`,last_date_check) VALUES('$dom','1','$date')");
				}
				else
				{
					$contains = mysqli_num_rows($mysqli->query("SELECT `$ext` FROM instant_domain WHERE domain='$dom'"));
					if($contains>0)
						$mysqli->query("UPDATE instant_domain SET `$ext`='2' WHERE domain='$dom'");
					else
						$mysqli->query("INSERT INTO instant_domain(domain,`$ext`,last_date_check) VALUES('$dom','2','$date')");
				}
				$cache->set($sld,$existense,$_SESSION['tld_time']);
			unset($obj);
			}
			if($existense == 1)
			{
				$data[0] .= '<div id="tab_'.$ext.'" class="extra"><a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'" target="_blank" id="href_'.str_replace('.', '', $ext).'" href="'.return_affiliate_url($dom,$ext).'">
					<div  class="col-lg-8 col-md-8 col-sm-7 col-xs-7 domain-name">
						<span class="InstantDomainShow">'.$dom.'</span><span class="domain-ext">.'.$ext.'</span>
					</div>
					<div class="col-lg-4 col-md-4 col-sm-5 col-xs-5 domain-button">
						<div id="tld_'.str_replace('.', '', $ext).'"  class="btn-dmn btn-green" href='.return_affiliate_url($dom,$ext).'">'.convert_currency($prices['prices'][$ext]).'
						</div>
					</div>
				</a></div>';

			}
			else
			{
				$whois_link = str_replace("{domain}",$dom.'.'.$ext,$_SESSION['whois_link']);

				if($_SESSION['whoisStatus'] == 1)
					$DefinedWhoisUrl = '<a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'" target="_blank" href="'.$whois_link.'">';
				else
					$DefinedWhoisUrl = '<a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'">';

				$data[0] .= ''.$DefinedWhoisUrl.'
					<div id="tab_'.$ext.'" class="extra"><div  class="col-lg-8 col-md-8 col-sm-7 col-xs-7 domain-name">
						<span class="InstantDomainShow">'.$dom.'</span><span class="domain-ext">.'.$ext.'</span>
					</div>
					<div class="col-lg-4 col-md-4 col-sm-5 col-xs-5 domain-button">
						<div id="tld_whois" class="btn-dmn btn-red" href="'.return_affiliate_url($dom,$ext).'">'.$who.'
						</div>
					</div></div>
				</a>';
			}

		}
		return $data;
}
function tld_server_test($ext,$dom,$who,$price,$tld1)
{	global $mysqli;
    $data = array();
	$date=date("Y-m-d");
	$sld = 'google.com';
	/* $cache = phpFastCache();
	$existense = $cache->get($sld);
	if($existense==null || $_SESSION['tld_status'] != 1)
	{
		$obj = new Whois($sld);
		if($obj->isAvailable())
			$existense = 1;
		else
			$existense = 0;
		if($existense == 1)
		{
			$contains = mysqli_num_rows($mysqli->query("SELECT `$ext` FROM instant_domain WHERE domain='$dom'"));
			if($contains>0)
				$mysqli->query("UPDATE instant_domain SET `$ext`='1',last_date_check='$date' WHERE domain='$dom'");
			else
				$mysqli->query("INSERT INTO instant_domain(domain,`$ext`,last_date_check) VALUES('$dom','1','$date')");
		}
		else
		{
			$contains = mysqli_num_rows($mysqli->query("SELECT `$ext` FROM instant_domain WHERE domain='$dom'"));
			if($contains>0)
				$mysqli->query("UPDATE instant_domain SET `$ext`='2' WHERE domain='$dom'");
			else
				$mysqli->query("INSERT INTO instant_domain(domain,`$ext`,last_date_check) VALUES('$dom','2','$date')");
		}
		$cache->set($sld,$existense,$_SESSION['tld_time']);
	unset($obj);
	} */
	$obj = new Whois($sld);
	return $obj->info();
		if($obj->isAvailable())
			$existense = 1;
		else
			$existense = 0;
	if($existense == 1)
	{
        if($tld1 == 'main_div')
	    {
			$data[0] = '<div id="change-background" class="com-rslt green-rslt">
				<div class="wrapper">
					<a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'" id="top_domain_href" target="_blank" href="'.return_affiliate_url($dom,$ext).'">
						<div class="com-wrap">
							<div class="com-wrap"><span class="live-domain-name">'.$dom.'.'.$ext.'</span> <div id="top_'.$ext.'_domain" class="com-btn btn-green">'.convert_currency($price).'</div></div>
						</div>
					</a>
				</div>
			</div>';
		}
		else
		{
			$data[0] = '<a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'" target="_blank" id="href_'.str_replace('.', '', $ext).'" href="'.return_affiliate_url($dom,$ext).'">
				<div  class="col-lg-8 col-md-8 col-sm-7 col-xs-7 domain-name">
					<span class="InstantDomainShow">'.$dom.'</span><span class="domain-ext">.'.$ext.'</span>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-5 col-xs-5 domain-button">
					<div id="tld_'.str_replace('.', '', $ext).'"  class="btn-dmn btn-green" href='.return_affiliate_url($dom,$ext).'">'.convert_currency($price).'
					</div>
				</div>
			</a>';
		}
	}
	else
	{
		$whois_link = str_replace("{domain}",$dom.'.'.$ext,$_SESSION['whois_link']);
        if($tld1 == 'main_div')
	    {
			if($_SESSION['whoisStatus'] == 1)
				$DefinedWhoisUrl = '<a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'" target="_blank" href="'.$whois_link.'">';
			else
				$DefinedWhoisUrl = '<a style="cursor:pointer" data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'">';
			$data[0] = '<div id="change-background" class="com-rslt red-rslt">
				<div class="wrapper">
					'.$DefinedWhoisUrl.'
						<div class="com-wrap">
							<div class="com-wrap"><span class="live-domain-name">'.$dom.'.'.$ext.'</span> <div id="top_'.$who.'_domain" class="com-btn btn-red">'.$who.'</div></div>
						</div>
					</a>
				</div>
			</div>';
		}
		else
		{
			if($_SESSION['whoisStatus'] == 1)
				$DefinedWhoisUrl = '<a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'" target="_blank" href="'.$whois_link.'">';
			else
				$DefinedWhoisUrl = '<a data-toggle="tooltip" data-placement="left" title="'.strtolower($dom.'.'.$ext).'">';

			$data[0] = ''.$DefinedWhoisUrl.'
				<div  class="col-lg-8 col-md-8 col-sm-7 col-xs-7 domain-name">
					<span class="InstantDomainShow">'.$dom.'</span><span class="domain-ext">.'.$ext.'</span>
				</div>
				<div class="col-lg-4 col-md-4 col-sm-5 col-xs-5 domain-button">
					<div id="tld_whois" class="btn-dmn btn-red" href="'.return_affiliate_url($dom,$ext).'">'.$who.'
					</div>
				</div>
			</a>';
		}
	}
	return $data;
}
function generatePagesSitemap()
{
	global $mysqli;
	$sitemap = "";

	$query = $mysqli->query("SELECT `permalink` FROM `pages` WHERE status = 1 ORDER BY `id` DESC");

	while ($array = mysqli_fetch_array($query))
	{

		$sitemap .='<url>' . PHP_EOL;

		$sitemap .="<loc>" . rootpath() . "/page/" . $array['permalink'] . "</loc>" . PHP_EOL;

		$sitemap .="<priority>0.6</priority>" . PHP_EOL;

		$sitemap .='</url>' . PHP_EOL;

	}

	return $sitemap;

}
function generateRootSitemap()
{

	$sitemap = "";

	$sitemap .='<url>' . PHP_EOL;

	$sitemap .="<loc>" . rootPath() . "/</loc>" . PHP_EOL;

	$sitemap .="<priority>1.0</priority>" . PHP_EOL;

	$sitemap .='</url>' . PHP_EOL;

	return $sitemap;

}
function generateContactSitemap()
{

	$sitemap = "";

	$sitemap .='<url>' . PHP_EOL;

	$sitemap .="<loc>" . rootPath() . "/contact</loc>" . PHP_EOL;

	$sitemap .="<priority>0.7</priority>" . PHP_EOL;

	$sitemap .='</url>' . PHP_EOL;

	return $sitemap;

}
function sitemapPagesStatus()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `pagesStatus` FROM `sitemaps`"));

	return $array["pagesStatus"];

}

function sitemapContactStatus()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `contactStatus` FROM `sitemaps`"));

	return $array["contactStatus"];

}

function sitemapDateUpdated()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `dateUpdated` FROM `sitemaps`"));

	return date('d M Y', strtotime($array['dateUpdated']));

}
function sitemapFileName()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `filename` FROM `sitemaps`"));

	return $array["filename"];

}
function updateSitemapsStatus($pagesStatus, $contactStatus,$filename)
{
	global $mysqli;
	$rows = mysqli_num_rows($mysqli->query("SELECT * FROM `sitemaps`"));

	if($rows>0)
	{

		$mysqli->query("UPDATE `sitemaps` SET `pagesStatus`='$pagesStatus',`contactStatus`='$contactStatus',`filename`='$filename'");

	}
	else
	{

		$mysqli->query("INSERT INTO `sitemaps`(pagesStatus,contactStatus,filename,dateUpdated) VALUES('$pagesStatus','$contactStatus','$filename',CURDATE())");

	}

}
function urlStructure()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `urlStructure` FROM `settings`"));

	return $array['urlStructure'];

}
function whoisStatus()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `whoisStatus` FROM `settings`"));

	return $array['whoisStatus'];

}
function httpsStatus()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `httpsStatus` FROM `settings`"));

	return $array['httpsStatus'];

}
function f_loader()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `f_loader` FROM `settings`"));

	return $array['f_loader'];

}
function p_loader()
{
	global $mysqli;
	$array = mysqli_fetch_array($mysqli->query("SELECT `p_loader` FROM `settings`"));

	return $array['p_loader'];

}
function is_alphaNumeric($string)
{

	if(preg_match('/^[a-zA-Z]+[a-zA-Z0-9._]+$/', $string))
	return true;

	return false;

}
function updateUser($username, $password, $email,$Contactemail)
{
		global $mysqli;
	$rows = mysqli_num_rows($mysqli->query("SELECT * FROM `settings`"));

	if($rows>0)
	{

		if ($password != "")
		{

			$mysqli->query("UPDATE `settings` SET `username`='$username',password='$password',email='$email',contactEmail='$Contactemail'");

		}

		else
		{

			$mysqli->query("UPDATE settings SET username='$username',email='$email',contactEmail='$Contactemail'");

		}
	}
	else
	{

		if ($password != "")
		{

			$mysqli->query("INSERT INTO `settings`(username,password,email,contactEmail) VALUES('$username','$password','$email','$Contactemail')");

		}

		else
		{

			$mysqli->query("INSERT INTO `settings`(username,email,contactEmail) VALUES('$username','$email','$Contactemail')");

		}

	}

    return true;

}
function getAddress()
{

	$pageURL = 'http';

	if (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == "on") {

		$pageURL .= "s";

	}
	$pageURL .= "://";

	if ($_SERVER["SERVER_PORT"] != "80") {

		$pageURL .= $_SERVER["SERVER_NAME"] . ":" . $_SERVER["SERVER_PORT"] . $_SERVER["REQUEST_URI"];

	} else {

		$pageURL .= $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];

	}

	return htmlentities($pageURL);

}
function convert_currency($val)
{
	global $mysqli;
	if(!isset($_SESSION['currency']))
	{

		$rows=mysqli_fetch_array($mysqli->query("SELECT * FROM currency_settings"));

		$_SESSION['currency']=$rows['cr_name'];

		$_SESSION['show_place']=$rows['show_place'];

	}
	if($val == 0)
	{
		return $_SESSION['Buy'];
	}
	else
	{
	    if($_SESSION['currency'] && $_SESSION['show_place']==1)
		return ($_SESSION['Buy'].' '.$_SESSION['currency'] . ' ' . $val);
		else
		return ($_SESSION['Buy'].' '.$val. ' ' . $_SESSION['currency']);
	}
}
function suggessted_limit()
{
	global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT * FROM suggessted_limit"));

	$limit = $rows['limit'];

	return $limit;

}
function preserve_days()
{
	global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT preserve_days FROM suggessted_limit"));

	$days = $rows['preserve_days'];

	return $days;

}
function instantDomainLimit()
{
	global $mysqli;
	$rows=mysqli_fetch_array($mysqli->query("SELECT instantLimit FROM suggessted_limit"));

	$limit = $rows['instantLimit'];

	return $limit;

}
function edit_page_language($id,$content,$language,$title)
{
	global $mysqli;
	$mysqli->query("UPDATE `page_language` SET content='$content',title='$title' WHERE `id`='$id' AND language = '$language'");

}
function edit_link_language($id,$permalink,$titleLanguage,$language)
{
	global $mysqli;
	$mysqli->query("UPDATE `linkLanguage` SET title='$titleLanguage',permalink='$permalink' WHERE `id`='$id' AND language = '$language'");

}
function add_page_language($id, $permalink, $title,$content)
{
	global $mysqli;
	$sql = $mysqli->query("SELECT * FROM language");

	while($rows = mysqli_fetch_array($sql))
	{
		$language = $rows['lang_name'];
		$mysqli->query("INSERT INTO `page_language`(id,title,permalink,content,language) VALUES('$id','$title','$permalink','$content','$language')");
	}
}
function add_link_language($id, $permalink, $title)
{
	global $mysqli;
	$sql = $mysqli->query("SELECT * FROM language");

	while($rows = mysqli_fetch_array($sql))
	{
		$language = $rows['lang_name'];
		$mysqli->query("INSERT INTO `linkLanguage`(id,title,permalink,language) VALUES('$id','$title','$permalink','$language')");
	}
}
function layout() {

    if($_SESSION['reset_RTL_session'] == 1)
	return true;
	else
	return false;

}
function file_get_contents_curl($url) {

       $ch = curl_init();
       curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.2 Safari/537.36");
       curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
       curl_setopt($ch, CURLOPT_URL, $url);
       curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
       $data = curl_exec($ch);
       curl_close($ch);
return $data;
}
function httpStatusCode($url) {

	$handle = curl_init($url);

	$USER_AGENT = $_SERVER['HTTP_USER_AGENT'];

	curl_setopt($handle,  CURLOPT_RETURNTRANSFER, true);

	curl_setopt($handle, CURLOPT_USERAGENT, $USER_AGENT);

	curl_setopt($handle, CURLOPT_TIMEOUT, 5);

	curl_setopt($handle, CURLOPT_CONNECTTIMEOUT, 5);

	curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);

	curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);

	curl_setopt($handle,CURLOPT_HEADER,true);

	curl_setopt($handle,CURLOPT_NOBODY,true);

	curl_setopt($handle, CURLOPT_FOLLOWLOCATION, true);

	$response = curl_exec($handle);

	$httpCode = curl_getinfo($handle, CURLINFO_HTTP_CODE);

	curl_close($handle);

	return $httpCode;

	}
if(!urlStructure() && substr($_SERVER['HTTP_HOST'], 0, 4) === 'www.') {

	$https = (httpsStatus() && isset($_SERVER['HTTPS'])) ? 'https://':'http://';

	if (substr($_SERVER['HTTP_HOST'], 0, 4) === 'www.') {

		header("HTTP/1.1 301 Moved Permanently");

		header('Location: ' . $https . substr($_SERVER['HTTP_HOST'], 4).$_SERVER['REQUEST_URI']);

		exit();

	}

} else if(urlStructure() && (strpos($_SERVER['HTTP_HOST'], 'www.') === false)) {

	$https = (httpsStatus() && isset($_SERVER['HTTPS'])) ? 'https://':'http://';

	if ((strpos($_SERVER['HTTP_HOST'], 'www.') === false)) {

		header("HTTP/1.1 301 Moved Permanently");

		header('Location: ' . $https . 'www.'.$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"]);

		exit();

	}

}

if(isset( $_SERVER["HTTPS"] ) && $_SERVER["HTTPS"] != "on" && httpsStatus())
{
    header("Location: https://" . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]);
    exit();
}
else if( isset( $_SERVER["HTTPS"] ) && $_SERVER["HTTPS"] == "on" && !httpsStatus())
 {
	header("Location: http://" . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]);
    exit();
}
?>
