<?php
$this->load->view('admin/includes/header');
?>
	<title>Server API Settings: <?php echo $title;?></title>
	<link href="<?php echo base_url()?>style/admin/style/css/selectivity-full.css" rel="stylesheet">
	</head>
	<body>
		<?php 
		include "includes/top_navbar.php"; 
		?>
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="row page-ttl">
					<div class="col-lg-12">
						<h1>
							<i class="fa fa-wrench"></i> Add TLD <small>ADD Tld Server</small>
						</h1>
					</div>
				</div> <!-- /.row -->
				<div class="page-content">
					<div class="margin_sides">
						<div class="row">
								<div class="errordiv form-group mrg-btm-min">
									<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
										<span id="error"></span>
									</div>
								</div>
								<div class="successdiv alert alert-success alert-dismissable col-lg-8 col-md-8 col-sm-8 col-xs-12">
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
									<i class="fa fa-check-square-o"></i><span id="success"></span>
								</div>
							<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
							
								<strong>Get TLD info by selecting TLD from the below list or can manually enter the TLD Info</strong><br><br>
								
							<select id="Selectbox">
							 <option disabled selected value> -- Select TLD -- </option>
							<?php 
							foreach($whoisServerList as $index=>$rows)
							{?>
								<option value="<?php echo $rows['name']."-".$rows['whois']."-".$rows['response']."-";?>"><?php echo $rows['name'];?></option>
							<?php }?>
							</select>
							<br><br><br>
								<form id="form" action="" method="POST">
									<div class="form-group">
										<label>Tld Name</label>
										<input class="form-control" name="tld" value="" placeholder="Enter TLD Name" required>
									</div>
									<div class="form-group">
										<label>WHOIS Servers</label>
										<input class="form-control" name="server" value="" placeholder="Enter WHOIS Server" required>
									</div>
									<div class="form-group">
										<label>Response</label>
										<input class="form-control" name="response" value="" placeholder="Enter Server Response" required title="You Must Enter Valid Email.">
									</div>
									<hr>
									<div class="form-group">
										<a href="<?php echo base_url()."admin/manage/tlds"?>"><button type="button" class="btn btn-default"><i class="fa fa-chevron-left"></i> Back </button></a>
										<button id="finalSubmit" type="submit" name="submit" class="btn btn-success"><i class="fa fa-plus"></i>  ADD TLD</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php $this->load->view('admin/includes/footer');?>	
		<script src="<?php echo base_url()?>style/admin/style/js/selectivity-full.js"></script>
		<script>
		$('#Selectbox').selectivity({
			allowClear: true,
			placeholder:"-- Select TLD --"
		});
	
		$('#Selectbox').on('change',function()
		{
			var val=$(this).val();
			var values=val.split('-');
			$('[name=tld]').val(values[0]);
			$('[name=server]').val(values[1]);
			$('[name=response]').val(values[2]);
		});
		
		$('.successdiv,.errordiv').hide();
		$('#form').on('submit',function(e)
			{
				e.preventDefault();
				var element=this;
				
				$('.successdiv,.errordiv').hide();
				
				$('#finalSubmit').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> ADD TLD');
				 var formDataArray = $(element).serializeArray();
				 var formData=new FormData();
				  for(var i = 0; i < formDataArray.length; i++){
					var formDataItem = formDataArray[i];
					formData.append(formDataItem.name, formDataItem.value);
				  }
				//sumbmitFinalRequest(formData);
				$.ajax({
						url:"<?php echo base_url()?>add-tld-post",
						type:"POST",
						data:formData,
						processData: false,
						contentType: false,
						success:function(data)
						{
							$('#finalSubmit').html('<i class="fa fa-plus"></i>  ADD TLD');
							
							var responseData=$.parseJSON(data);
							var response=responseData['response'];
							if(response==0)
							{
								$('#error').html(responseData['reason']);
								$('.errordiv').show();
							}
							else if (response==1)
							{
								$('#success').html('Successfully added');
								$('.successdiv').show();
							}
							else if (response==3)
							{
								window.location.href="<?php echo base_url().loginRedirectUri;?>";
							}
						}
					});
			}); 
		
		</script>
	</body>
</html>