<!DOCTYPE html>
<html>
	<head>
	    <meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<title>Update Password <?php echo $title ; ?></title>
		<meta name="description" content="">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
		<link rel="stylesheet" href="<?php echo base_url();?>style/admin/style/font-awesome/css/font-awesome.css">
		<link rel="stylesheet" href="<?php echo base_url();?>style/admin/style/css/bootstrap.css">
		<link rel="stylesheet" href="<?php echo base_url();?>style/admin/style/css/loginstyle.css">
		<link rel="shortcut icon" type="image/png" href="<?php echo base_url() ."/style/admin/style/images/" . $favicon;?>"/>		
		
	</head>	
<body class="admin-login">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header login-header">
				<a href="//nexthon.com"><img alt="nexthon.com" src="<?php echo base_url(); ?>/style/admin/style/images/nexthon.png"/></a>
			</div>
			<div class="modal-body">
			
				<div class="resetError form-group mrg-btm-min">
					<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
						<span id="error"></span>
					</div>
					
				</div>
				
				<div class=" resetSuccess form-group mrg-btm-min">
					<div class="alert alert-success"><i class="fa fa-exclamation-triangle"></i> 
						<span id="message"></span>
					</div>
				</div>
				
				<form method="post">
					<fieldset>
						
						<div class="form-group">
							<input id="new_password" type="password" name="new_password" class="form-control input-lg" placeholder="New Password">
						</div>
						
						<div class="form-group">
							<input id="confirm_password" type="password" name="confirm_password" class="form-control input-lg" placeholder="Confirm Password">
						</div>
						
						<div class="clearfix"></div>
						
						<div class="form-group">
							<div class="modal-footer row">
								
																
								<div class="col-xs-6 pad-min">
									<a href="reset-password" class="btn btn-primary btn-lg btn-block" id="createL" > <i class="fa fa-chevron-right"></i> Update Password </a>
								</div>
								
							</div>
						</div>
					</fieldset>
					
					<input type="hidden" name="resetHash" id="resetHash" value="<?php echo $resetHash;?>" />
				</form>
			</div>
		</div>	
	</div>  
</body>
		
<script src="<?php echo base_url()?>/style/admin/style/js/jquery-1.11.1.min.js"></script>
<script type="text/javascript">

	function strip_tags(str) 
	{
		str = str.toString();
		return str.replace(/<\/?[^>]+>/gi, '');
	}
	
	$('.resetError,.resetSuccess').hide();
	
	function updateProcess()
	{
		
		$('.resetError').hide();
		
		var new_password 	 = strip_tags($('#new_password').val().trim());
		
		var confirm_password = strip_tags($('#confirm_password').val().trim());
		
		var resetHash	     = strip_tags($('#resetHash').val().trim());
		
		if(new_password.length == 0)
		{
			$('.resetError').show();
			$('#error').html('New passord field is required');
			return;
		}		
		else if(confirm_password.length == 0)
		{
			$('.resetError').show();
			$('#error').html('Confirm passord field is required');
			return;
		}
		else if(confirm_password !== new_password)
		{
			$('.resetError').show();
			$('#error').html('You must type same password in both fields');
			return;
		}
		else
		{			
			$.ajax({ 
				url : "<?php echo site_url('update-password-post');?>",
				type: "post",
				data: {"new_password" : new_password, 'confirm_password': confirm_password, 'reset_hash' : resetHash},
				success: function(data)
				{					
					var responseData=$.parseJSON(data);
					var response=responseData['response'];
					if(response==0)
					{
						$('.resetError').show();
						$('.resetSuccess').hide();	
						$('#error').html(responseData['pas']);
					}
					else if (response==1)
					{				
						$('.resetError').hide();
						$('.resetSuccess').show();				
						$('#message').html('Your password is updated successfully. we are redirecting you to login page');
						setTimeout(redirect_to_login, 3000);
					}
					else
					{
						$('.resetError').show();
						$('.resetSuccess').hide();	
						$('#error').html("Unknown errro occured , Please try again later !");
					}
				}
			});
		}
	}
		
	
	$('#new_password, #confirm_password').keypress(function (e) 
	{
		var key = e.which;
		if(key == 13)  // the enter key code
		{
			updateProcess();
			return false;  
		}
	});
	
	$(document).on('click','#createL',function(e){
		
		e.preventDefault();
		updateProcess();
	});
	
	function redirect_to_login()
	{
		window.location.href="<?php echo base_url()."admin";?>";
	}
	
</script>
</html>