<?php
$this->load->view('admin/includes/header');
?>
	<title>
	Sitemap Settings: <?php echo $title;?>
	</title>
	</head>
	<body id="scroller">
		<?php $this->load->view('admin/includes/top_navbar');?>	
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="row page-ttl">
					<div class="col-lg-12">
						<h1>
							<i class="fa fa-sitemap"></i> Sitemap Settings <small>Manage Sitemaps</small>
						</h1>
					</div>
				</div><!-- /.row -->
				<div class="page-content">
					<div class="margin_sides">
						<div class="row">
							<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
								<?php 
								if (!is_writable("./" . $sitemap['filename']))
								{ 
								?>
									<div class="alert alert-danger">
										<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
										<i class="fa fa-times-circle"></i> 
										<strong><?php echo $sitemap['filename']; ?></strong> is not writeable Please CHMOD 777 and refresh this page.
									</div>
								<?php 
								} else { ?>
								
								<form id="form" action="" method="post">
										<div class="errordiv form-group mrg-btm-min">
											<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
												<span id="error"></span>
											</div>
										</div>
										<div class="successdiv form-group mrg-btm-min">
											<div class="alert alert-success"><i class="fa fa-exclamation-triangle"></i> 
												<span id="success"></span>
											</div>
										</div>
										
									<div class="input-group col-xs-8 col-sm-11 col-sm-10 col-lg-8">
										<span class="input-group-addon"><span class="visible-xs"><i class="fa fa-sitemap"></i></span><span class="hidden-xs"><?php echo(base_url()); ?></span></span>
										<input type="text" class="form-control" name="filename" placeholder="e.g: sitemap.xml" value="<?php echo ( $sitemap['filename']); ?>" required />
									</div>
									<a target="_blank" href="<?php echo(base_url() . "/" .  $sitemap['filename'].'?'.time()); ?>" class="btn btn-primary btn-xs mrg-10-top">View Sitemap</a>
                                    </br></br>
									<div class="form-group">
										<label>Include Pages</label>
										<?php 
										if($sitemap['pagesStatus']) 
										{ 
										?>
										<div class="switch res-switch">
											<input class="my_checkbox" type="checkbox" name="pagesStatus" checked>
											<label><i></i></label>
										</div>
										<?php
										}
										else
										{
										?>
										<div class="switch res-switch">
											<input class="my_checkbox" type="checkbox" name="pagesStatus">
											<label><i></i></label>
										</div>
										<?php 
										} 
										?>
									</div>
									<div class="form-group">
										<label>Include Contact Form</label>
										<?php 
										if($sitemap['contactStatus']) 
										{ 
										?>
										<div class="switch res-switch">
											<input class="my_checkbox" type="checkbox" name="contactStatus" checked>
											<label><i></i></label>
										</div>
										<?php 
										} 
										else
										{ 
										?>
										<div class="switch res-switch">
											<input class="my_checkbox" type="checkbox" name="contactStatus">
											<label><i></i></label>
										</div>
										<?php 
										}
										?>
									</div>
									<div class="form-group">
										<label>Last Generated</label>
										<h4>
											<span class="label label-default">
												<span id="date"><?php echo ($sitemap['dateUpdated']); ?></span>
												<i class="icon-time"></i>
											</span>
										</h4>
									</div>
									<hr>
									<div class="form-group">
										<button id="genSiteMap" type="button" class="btn btn-primary"> <i class="fa fa-retweet"></i> Generate Sitemap</button>
										<button type="submit" name="submit" class="btn btn-success" ><i class="fa fa-check"></i> Update</button>
									</div>
								
									<button class="notify-without-image" style="display:none" id="sitemaps_update"></button> 
								</form>
								</div>
								
								<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php $this->load->view('admin/includes/footer');?>
		
		<script>
		
		function scroller(id)
		{
			$('html,body').animate({
			scrollTop: $("#"+id).offset().top},
			'slow');
		}
		
		$('.successdiv,.errordiv').hide();
		
		$('#form').on('submit',function(e)
		{
			e.preventDefault();
			$('.successdiv,.errordiv').hide();
			var formDataArray = $(this).serializeArray();
			var data=new FormData();
			
			for(var i = 0; i < formDataArray.length; i++)
			{
				var formDataItem = formDataArray[i];
				data.append(formDataItem.name, formDataItem.value);
			}
			
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()."edit-sitemaps-post"?>",
				data: data,
				cache: false,
				processData: false,
				contentType: false,
				success: function(result)
				{	
					var responseData=$.parseJSON(result);
					var response=responseData['response'];
					if(response==0)
					{
						$('#error').html(responseData['reason']);
						$('.errordiv').show();
						scroller('scroller');
					}
					else if (response==1)
					{
						$('#success').html('Successfully updated');
						$('.successdiv').show();
						scroller('scroller');
						var delay=2000;
						setTimeout(function()
						{
							$('.successdiv').hide();
						},delay);
					}
					else if (response==3)
					{
						window.location.href="<?php echo base_url().loginRedirectUri;?>";
					}
				}
			}); 
		});
		
		$(document).on('click','#genSiteMap',function(e)
		{
			e.preventDefault();
			$('.successdiv,.errordiv').hide();
			var data=new FormData();
			data.append('rs','o1');
			
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()."gen-sitemaps-post"?>",
				data: data,
				cache: false,
				processData: false,
				contentType: false,
				success: function(result)
				{	
					var responseData=$.parseJSON(result);
					var response=responseData['response'];
					if(response==0)
					{
						$('#error').html(responseData['reason']);
						$('.errordiv').show();
						scroller('scroller');
					}
					else if (response==1)
					{
						$('#success').html(responseData['reason']);
						$('#date').html(responseData['date']);
						$('.successdiv').show();
						scroller('scroller');
						var delay=10000;
						setTimeout(function()
						{
							$('.successdiv').hide();
						},delay);
					}
					else if (response==3)
					{
						window.location.href="<?php echo base_url().loginRedirectUri;?>";
					}
				}
			}); 
		});
		</script>
	</body>
</html>