<?php
$this->load->view('admin/includes/header');
?>
	<title>Link Settings: <?php echo $title;?></title>
	</head>
	<body>
	<?php $this->load->view('admin/includes/top_navbar');?>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="row page-ttl">
				<div class="col-lg-12">
					<h1>
						<i class="fa fa-files-o"></i> Manage Links <small>Modify and update Links</small>
					</h1>
				</div>
			</div>
			<div class="page-content">
				<div class="margin_sides">
					<div class="row">
						<div class="col-md-8">
							<div class="errordiv form-group mrg-btm-min">
								<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
									<span id="error"></span>
								</div>
							</div>
							<div class="successdiv form-group mrg-btm-min">
								<div class="alert alert-success"><i class="fa fa-exclamation-triangle"></i> 
									<span id="success"></span>
								</div>
							</div>
						   
							<div class="awidget">
								<?php
								$count=count($links);
								if($count == 0)
								{?>
								<div align="right" style="padding-bottom:10px;">
									<a href="<?php echo base_url()."admin/add/link"?>" class="btn btn-success"><i class="fa fa-plus"></i> Add New Link</a>
								</div>
								<div class="panel panel-success">
									<div class="panel-body page-list-setting">
										<div class='col-md-12 content text-center'>				
											<h1 class='sf'>Nothing found!</h1>
											<h3 class='sf'>Not to worry. You can add New Links</h3>
										</div>
									</div>	
								</div>					
								<?php					
								} 
								else 
								{ 
								?>
								<div class="awidget-body">
									<div align="right" style="padding-bottom:10px;">
										<a href="<?php echo base_url()."admin/add/link"?>" class="btn btn-success"><i class="fa fa-plus"></i> Add New Link</a>
									</div>
									<div class="table_header" style="width:100%;line-height: 1px">
										<div style="width:35%;float:left;white-space: nowrap">Link Name</div>
										<div id="smalli" class="hidden-xs" style="width:45%;float:left;text-align: center;">Action</div>
										<div id="smalli" class="visible-xs" style="width:65%;float:left;text-align: center;">Action</div>
										<div class="hidden-xs" style="width:20%;float:left;text-align: center">Status</div>
									</div>
									<div id="list">
									<ul>
										<?Php 
										$i =1;								
										foreach($links as $index=>$row)
										{
											$id= stripslashes($row['id']);

											$text   = stripslashes(ucfirst($row['title']));

											$edit   = '<a href="'.base_url().'admin/edit/link/' . $row['id'] . '" title="Edit ' . $text . '" class="small">Edit</a>';

											$delete = '<a class="small" data-toggle="modal" onclick="delete_links('.$row['id'].')" id="del" class="open-dialog" href="#delete_modal_' . $row['id'] . '" title="Delete ' . $text . '" data-id='. $row['id'] . '>Delete</a>';

											$stat   = stripslashes($row['status']);

											?>
											<li id="arrayorder_<?php echo $id; ?>">
												<div class="small" style="width:100%;float:left;line-height: 1px">
													<div style="width:35%;float:left;line-height: 1px;white-space: nowrap">
														<?php echo $text; ?>
													</div>
													<div class="small smalli hidden-xs" style="width:45%;float:left;line-height: 1px;text-align: center; font-size:1.1em;">
														<?php 
														echo ($edit . " - " . $delete);
														?>
													</div>
													<div class="small smalli visible-xs" style="width:65%;float:left;line-height: 1px;text-align: center; font-size:1.1em;">
														<?php 
														echo ($edit . " - " . $delete);
														?>
													</div>
													<div class="hidden-xs" style="width:20%;float:left;line-height: 1px;text-align: center">
														<?php if($stat == 0) { echo ('OFF'); } else { echo ('ON'); } ?>
													</div>
												</div>
											</li>
											<?php 
											$i++;
										} 
										?>
										</ul>
									</div>
									<div class="clearfix"></div>
								</div>
								<?php
								} 
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script type="text/javascript">
	$('.successdiv,.errordiv').hide();
	$(document).ready(function(){
		$(function(){
			$("#list ul").sortable({ opacity: 0.8, cursor: 'move', update: function(){
				var order = $(this).sortable("serialize") + '&update=update';
				$.post("<?php echo base_url()."sort-links-post"?>", order);
				
			}                                                                 
			});
		});
	});   
	
	function delete_links(id)
	{
		swal({   title: "Are you sure?",   text: "Do you really want to delete this page?",   type: "warning",   showCancelButton: true,   confirmButtonColor: "#DD6B55",   confirmButtonText: "Yes, delete it!",   closeOnConfirm: false }, function(){
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()."del-links-post"; ?>",
				data: {id:id,delete_link:'delete_link'},
				cache: false,
				success: function(result)
				{		
					swal("Deleted!", "Your page have been deleted successfully!", "success");
					var delay=1000;
					setTimeout(function(){
						window.location="<?php echo base_url()."admin/manage/links"; ?>";
					},delay); 
				}
			});	
		});
	}
	</script>
	</body>
</html>