<?php
$this->load->view('admin/includes/header');
?>
	<title>Account Settings: <?php echo $title;?></title>
	</head>
	<body id="scroller">
		<?php $this->load->view('admin/includes/top_navbar');?>	
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="row page-ttl">
					<div class="col-lg-12">
						<h1>
							<i class="fa fa-user"></i> Email Settings
						</h1>
					</div>
				</div> <!-- /.row -->
				<div class="page-content">
					<div class="margin_sides">
						<div class="row">
							<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
								<form id="form" action="" method="post">
										<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
											<div class="errordiv form-group mrg-btm-min">
											<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
												<span id="error"></span>
											</div>
										</div>
										<div class="successdiv form-group mrg-btm-min">
											<div class="alert alert-success"><i class="fa fa-exclamation-triangle"></i> 
												<span id="success"></span>
											</div>
										</div>
									<div class="form-group">
									<label class="control-label">Type</label>
										<div class="simple-mail">
											<label>
												<input type="radio" name="type" value="0" <?php 
												if($emailSettings['type']==0)
												{
												echo 'checked';
												 } ?> >
												Simple Mail (PHP Mailer)
											</label>
										</div>
										<div class="SMTP">
											<label>
												<input type="radio" name="type" value="1" <?php 
												if($emailSettings['type']==1)
												{
												echo 'checked';
												} ?>>
												Mail Through SMTP
											</label>
										</div>
									</div>
									<div id="smtpForm">
										<div class="form-group">
											<label>Host</label>
											<input type="text" class="form-control" name="hostName" value="<?php 
											$val=isset($_POST['submit'])?$_POST['hostName']:$emailSettings['host'];echo $val;?>" required maxlength="100">
										</div>
										<div class="form-group">
											<label>Port</label>
											<input type="text" class="form-control" name="port" value="<?php $val=isset($_POST['submit'])?$_POST['port']:$emailSettings['port'];echo $val;?>" required title="You Must Enter port Number." maxlength="20">
										</div>
										<div class="form-group">
											<label>Username</label>
											<input type="text" class="form-control" name="username" value="<?php $val=isset($_POST['submit'])?$_POST['username']:$emailSettings['username'];echo $val;?>" required title="You Must Enter Valid Username." maxlength="100">
										</div>
										<div class="form-group">
											<label>Password</label>
											<input type="password" class="form-control" name="password" value="<?php $val=isset($_POST['submit'])?$_POST['password']:$emailSettings['password'];echo $val; ?>" required autocomplete="off" placeholder="Password" pattern=".{5,}" required title="Minimum Password Length is 5 Characters." maxlength="100">
										</div>
										<div class="form-group">
											<label>Email</label>
											<input type="email" class="form-control" name="emailSMTP" value="<?php $val=isset($_POST['submit'])?$_POST['emailSMTP']:$emailSettings['emailSMTP'];echo $val;?>" required title="You Must Enter Valid Email." maxlength="100">
										</div>
								</div>
								<div id="mailerForm">
									<div class="form-group">
											<label>Email</label>
											<input type="email" class="form-control" name="emailMailer" value="<?php $val=isset($_POST['submit'])?$_POST['emailMailer']:$emailSettings['emailMailer'];echo $val;?>" title="You Must Enter Valid Email." maxlength="100">
									</div>
								</div>
								<?php
									if($emailSettings['type']==0){ ?>
										<script>
										$("#smtpForm").hide();
										</script>
									<?php }
									if($emailSettings['type']==1){?>
										<script>
										$("#mailerForm").hide();
										</script>
									<?php } ?>
									<hr>
									
									<div class="form-group">
										<input type="hidden" value="0" name="formType">
										<button type="submit" name="submit" class="btn btn-success"><i class="fa fa-pencil"></i>  Update</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php $this->load->view('admin/includes/footer');?>
		
		<script>
		$(".SMTP").click(function(){
		$("#smtpForm").show();
		$("#mailerForm").hide();
		});
		$(".simple-mail").click(function(){
			$("#smtpForm").hide();
			$("#mailerForm").show();
		});
		function scroller(id)
		{
			$('html,body').animate({
			scrollTop: $("#"+id).offset().top},
			'slow');
		}
		
		$('.successdiv,.errordiv').hide();
		
		$('#form').on('submit',function(e)
		{
			e.preventDefault();
			$('.successdiv,.errordiv').hide();
			var formDataArray = $(this).serializeArray();
			var data=new FormData();
			
			for(var i = 0; i < formDataArray.length; i++)
			{
				var formDataItem = formDataArray[i];
				data.append(formDataItem.name, formDataItem.value);
			}
			
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()."edit-email-settings-post"?>",
				data: data,
				cache: false,
				processData: false,
				contentType: false,
				success: function(result)
				{	
					var responseData=$.parseJSON(result);
					var response=responseData['response'];
					if(response==0)
					{
						$('#error').html(responseData['reason']);
						$('.errordiv').show();
						scroller('scroller');
					}
					else if (response==1)
					{
						$('#success').html('Successfully updated');
						$('.successdiv').show();
						scroller('scroller');
						var delay=2000;
						setTimeout(function()
						{
							$('.successdiv').hide();
						},delay);
					}
					else if (response==3)
					{
						window.location.href="<?php echo base_url().loginRedirectUri;?>";
					}
				}
			}); 
		});
		</script>
	</body>
</html>