<?php
$this->load->view('admin/includes/header');
?>
	<title>Currency Settings: <?php echo $title;?></title>
	</head>
	<body id="scroller">
		<?php $this->load->view('admin/includes/top_navbar');?>	
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="row page-ttl">
					<div class="col-lg-12">
						<h1>
							<i class="fa fa-usd"></i> Currency Settings <small>Update Currency Settings</small>
						</h1>
					</div>
				</div><!-- /.row -->
				<div  class="page-content">
					<div class="margin_sides">
						<div class="row">
							<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
								<div class="errordiv form-group mrg-btm-min">
									<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
										<span id="error"></span>
									</div>
								</div>
								<div class="successdiv form-group mrg-btm-min">
									<div class="alert alert-success"><i class="fa fa-exclamation-triangle"></i> 
										<span id="success"></span>
									</div>
								</div>
								<form id="form" action="" method="post">
										<div class="form-group">
											<label>Currency Symbol</label>
												<input type="text" required="" class="form-control" id="doll" name="dollor" value="<?php echo ($currency['cr_name']); ?>" placeholder="Enter Your Currency Name/Symbol" />
										</div>
										<div class="form-group">
											<label>One US Dollar = ??</label>
												<input type="text" class="form-control" required="" id="rs" placeholder="Your Currency equal to how many dollors." name="currency" value="<?php echo ($currency['price_dollor']); ?>" />
										</div><?php
										if($currency['show_place']==1)
										{ 
											?>
											<div class="form-group">
												<label>Where to Show Currency Symbol</label>
													<div class="radio">
														<label><input type="radio" name="show_place" value="1" checked="checked" />Before</label>
													</div>
													<div class="radio">
														<label><input type="radio" name="show_place" value="0" />After</label>
													</div>
											</div>
											<hr />
											<?php 
										} 
										else
										{
										?>
										<div class="form-group">
											<label>Where to Show Currency Symbol</label>
												<div class="radio">
													<label><input type="radio" name="show_place" value="1" />Before</label>
												</div>
												<div class="radio">
													<label><input type="radio" name="show_place" value="0" checked="checked" />After</label>
												</div>
										</div>
										<?php
										} 
										?>
										<hr>
										<div class="form-group">
											<button type="submit" name="submit" class="btn btn-success" value="Add"><i class="fa fa-check"></i> Update</button>
										</div>
								</form>
								<button class="notify-without-image" id="settings" style="display:none;"></button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php $this->load->view('admin/includes/footer');?>
	<script>
		
		function scroller(id)
		{
			$('html,body').animate({
			scrollTop: $("#"+id).offset().top},
			'slow');
		}
		
		$('.successdiv,.errordiv').hide();
		
		$('#form').on('submit',function(e)
		{
			e.preventDefault();
			$('.successdiv,.errordiv').hide();
			var formDataArray = $(this).serializeArray();
			var data=new FormData();
			
			for(var i = 0; i < formDataArray.length; i++)
			{
				var formDataItem = formDataArray[i];
				data.append(formDataItem.name, formDataItem.value);
			}
			
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()."edit-currency-settings-post"?>",
				data: data,
				cache: false,
				processData: false,
				contentType: false,
				success: function(result)
				{	
					var responseData=$.parseJSON(result);
					var response=responseData['response'];
					if(response==0)
					{
						$('#error').html(responseData['reason']);
						$('.errordiv').show();
						scroller('scroller');
					}
					else if (response==1)
					{
						$('#success').html('Successfully updated');
						$('.successdiv').show();
						scroller('scroller');
						var delay=2000;
						setTimeout(function()
						{
							$('.successdiv').hide();
						},delay);
					}
					else if (response==3)
					{
						window.location.href="<?php echo base_url().loginRedirectUri;?>";
					}
				}
			}); 
		});
		</script>
	</body>
</html>
