<?php
$this->load->view('admin/includes/header');
?>
	<title>
	Captcha Settings: <?php echo $title;?>
	</title>
	</head>
	<body id="scroller">
	<?php $this->load->view('admin/includes/top_navbar');?>	
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="row page-ttl">
					<div class="col-lg-12">
						<h1>
							<i class="fa fa-eye-slash"></i> Captcha Settings <small>Change website captcha status</small>
						</h1>
					</div>
				</div>
				<ol class="page-content">
					<div class="margin_sides">
						<div class="row">
							<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
								<div class="widget">
									<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
										<div class="errordiv form-group mrg-btm-min">
										<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
											<span id="error"></span>
										</div>
									</div>
									<div class="successdiv form-group mrg-btm-min">
										<div class="alert alert-success"><i class="fa fa-exclamation-triangle"></i> 
											<span id="success"></span>
										</div>
									</div>
									<form id="form" role="form" action="" method="post">
									<input type="hidden" name="id" value="<?php echo $captcha['id']?>">
										<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
											<div class="form-group">
												<label>Captcha Verification on Contact Page</label>
												<div class="switch res-switch">
													<?php
													if ($captcha['captcha_contact_status']) 
													{?>
														<input class="my_checkbox" type="checkbox" name="contact_status" checked>
														<label><i></i></label>
														<?php
													}
													else
													{
													
														?>
														<input class="my_checkbox" type="checkbox" name="contact_status">
														<label><i></i></label>
														<?php
													
													}
													?>
												</div>
											</div>
											<div class="form-group">
												<label>Captcha Verification on Login Page</label>
												<div class="switch res-switch">
													<?php
													if ($captcha['captcha_admin_login_status']) 
													{?>
														<input class="my_checkbox" type="checkbox" name="login_status" checked>
														<label><i></i></label>
														<?php
													}
													else
													{?>
														<input class="my_checkbox" type="checkbox" name="login_status">
														<label><i></i></label>
														<?php
													}
													?>
												</div>
											</div>
											
											<!-- gogole recaptcha fields -->
											<div class="form-group">
												<label>Google Recaptcha Key</label>
												<input class="form-control" id="recaptcha_key" name="recaptcha_key" value="<?php echo $captcha['recaptcha_key'];?>" type="text" />
											</div>
											<div class="form-group">
												<label>Google Recaptcha Secret</label>
												<input class="form-control" id="recaptcha_secret" name="recaptcha_secret" value="<?php echo $captcha['recaptcha_secret'];?>" type="text" />
											</div>
											
											<hr>
											<div class="form-group">
												<button type="submit" id="submit" name="submit" class="btn btn-success" ><i class="fa fa-check"></i> Update</button>
											</div>
										</div>
									</form> 
								</div>
							</div>
						</div>
					</div>
				</ol>
			</div>
		</div>
		<?php $this->load->view('admin/includes/footer');?>
		<script>
		
		function scroller(id)
		{
			$('html,body').animate({
			scrollTop: $("#"+id).offset().top},
			'slow');
		}
		
		$('.successdiv,.errordiv').hide();
		
		$('#form').on('submit',function(e)
		{
			e.preventDefault();
			$('.successdiv,.errordiv').hide();
			var formDataArray = $(this).serializeArray();
			var data=new FormData();
			
			for(var i = 0; i < formDataArray.length; i++)
			{
				var formDataItem = formDataArray[i];
				data.append(formDataItem.name, formDataItem.value);
			}
			
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()."edit-captcha-post"?>",
				data: data,
				cache: false,
				processData: false,
				contentType: false,
				success: function(result)
				{	
					var responseData=$.parseJSON(result);
					var response=responseData['response'];
					if(response==0)
					{
						$('#error').html(responseData['reason']);
						$('.errordiv').show();
						scroller('scroller');
					}
					else if (response==1)
					{
						$('#success').html('Successfully updated');
						$('.successdiv').show();
						scroller('scroller');
						var delay=2000;
						setTimeout(function()
						{
							$('.successdiv').hide();
						},delay);
					}
					else if (response==3)
					{
						window.location.href="<?php echo base_url().loginRedirectUri;?>";
					}
				}
			}); 
		});
		</script>
	</body>
</html>