<?php
$this->load->view('admin/includes/header');
?>
	<title>Analytics:<?php echo $title;?></title>
	</head>
	<body>
		<?php $this->load->view('admin/includes/top_navbar');?>	
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="row page-ttl">
					<div class="col-lg-12">
						<h1 class="hidden-xs">
							<i class="fa fa-code"></i> Analytics Code <small>Update Analytics Code</small>
						</h1>
						<h4 class="visible-xs">
							<i class="fa fa-code"></i> Analytics Code <small>Update Analytics Code</small>
						</h4>
					</div>
				</div>
				<div class="page-content">
					<div class="margin_sides">
						<div class="row">
							<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
									<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
											<div class="errordiv form-group mrg-btm-min">
											<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
												<span id="error"></span>
											</div>
									</div>
									<div class="successdiv form-group mrg-btm-min">
										<div class="alert alert-success"><i class="fa fa-exclamation-triangle"></i> 
											<span id="success"></span>
										</div>
									</div>
								<form role="form" id="form" action="" method="post">
									<?php 
									$tracking_code = $analytics["tracking_code"]; ?>
										<div class="form-group">
											<label>Analytics Code</label> 
											<textarea class="form-control" rows="10" name="tracking_code"> <?php echo ($tracking_code);?></textarea> 
										</div>
										<div class="form-group">
											<label>Status</label>
											<?php
											if ($analytics['status']=='1')
											{ 
											?>
											<div class="form-group">
												<label class="text-center"><input class="my_checkbox" type="checkbox" name="my-checkbox" checked="checked" /></label>
											</div>
											<?php
											} 
											else 
											{ 
											?>
											<div class="form-group">
												<label class="text-center"><input class="my_checkbox" type="checkbox" name="my-checkbox" /></label>
											</div>
											<?php
											}
											?>
										</div>
										
										<div class="form-group">
											<button class="btn btn-success" name="submit" type="submit"><i class="fa fa-check"></i> Update</button>
										</div>
										
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php $this->load->view('admin/includes/footer');?>
	<script>
		
		function scroller(id)
		{
			$('html,body').animate({
			scrollTop: $("#"+id).offset().top},
			'slow');
		}
		
		$('.successdiv,.errordiv').hide();
		
		$('#form').on('submit',function(e)
		{
			e.preventDefault();
			$('.successdiv,.errordiv').hide();
			var formDataArray = $(this).serializeArray();
			var data=new FormData();
			
			for(var i = 0; i < formDataArray.length; i++)
			{
				var formDataItem = formDataArray[i];
				data.append(formDataItem.name, formDataItem.value);
			}
			
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()."edit-analytics-settings-post"?>",
				data: data,
				cache: false,
				processData: false,
				contentType: false,
				success: function(result)
				{	
					var responseData=$.parseJSON(result);
					var response=responseData['response'];
					if(response==0)
					{
						$('#error').html(responseData['reason']);
						$('.errordiv').show();
						scroller('scroller');
					}
					else if (response==1)
					{
						$('#success').html('Successfully updated');
						$('.successdiv').show();
						scroller('scroller');
						var delay=2000;
						setTimeout(function()
						{
							$('.successdiv').hide();
						},delay);
					}
					else if (response==3)
					{
						window.location.href="<?php echo base_url().loginRedirectUri;?>";
					}
				}
			}); 
		});
		</script>
	</body>
</html>