<?php
$this->load->view('admin/includes/header');
?>
	<title>Account Settings: <?php echo $title;?></title>
	</head>
	<body id="scroller">
		<?php $this->load->view('admin/includes/top_navbar');?>	
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="row page-ttl">
					<div class="col-lg-12">
						<h1>
							<i class="fa fa-user"></i> Account Settings <small>Change Administrator login details</small>
						</h1>
					</div>
				</div> <!-- /.row -->
				<div class="page-content">
					<div class="margin_sides">
						<div class="row">
							<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
								<form id="form" action="" method="post">
										<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
											<div class="errordiv form-group mrg-btm-min">
											<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
												<span id="error"></span>
											</div>
										</div>
										<div class="successdiv form-group mrg-btm-min">
											<div class="alert alert-success"><i class="fa fa-exclamation-triangle"></i> 
												<span id="success"></span>
											</div>
										</div>
									<div class="form-group">
										<label>Username</label>
										<input class="form-control" name="username" value="<?php echo($account['username']); ?>" required>
									</div>
									<div class="form-group">
										<label>Email</label>
										<input class="form-control" name="email" value="<?php echo($account['email']); ?>" required title="You Must Enter Valid Email.">
									</div>
									<div class="form-group">
										<label>Contact Email</label>
										<input class="form-control" name="contactEmail" value="<?php echo($account['contactEmail']); ?>" required title="You Must Enter Valid Email.">
									</div>
									<div class="form-group">
										<label>Current Password</label>
										<input type="password" class="form-control" name="oldpassword" autocomplete="off" placeholder="Current Password" pattern=".{5,}" required title="Minimum Password Length is 5 Characters.">
									</div>
									<div class="form-group">
										<label>New Password (Optional)</label>
										<input type="password" class="form-control" name="password" autocomplete="off" placeholder="New Password (Optional)" pattern=".{5,}" title="Minimum Password Length is 5 Characters.">
									</div>
									
									<hr>
									<div class="form-group">
										<button type="submit" name="submit" class="btn btn-success"><i class="fa fa-pencil"></i>  Update</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php $this->load->view('admin/includes/footer');?>
		
		<script>
		
		function scroller(id)
		{
			$('html,body').animate({
			scrollTop: $("#"+id).offset().top},
			'slow');
		}
		
		$('.successdiv,.errordiv').hide();
		
		$('#form').on('submit',function(e)
		{
			e.preventDefault();
			$('.successdiv,.errordiv').hide();
			var formDataArray = $(this).serializeArray();
			var data=new FormData();
			
			for(var i = 0; i < formDataArray.length; i++)
			{
				var formDataItem = formDataArray[i];
				data.append(formDataItem.name, formDataItem.value);
			}
			
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()."edit-account-settings-post"?>",
				data: data,
				cache: false,
				processData: false,
				contentType: false,
				success: function(result)
				{	
					var responseData=$.parseJSON(result);
					var response=responseData['response'];
					if(response==0)
					{
						$('#error').html(responseData['reason']);
						$('.errordiv').show();
						scroller('scroller');
					}
					else if (response==1)
					{
						$('#success').html('Successfully updated');
						$('input[name=password]').val('');
						$('input[name=oldpassword]').val('');
						$('.successdiv').show();
						scroller('scroller');
						var delay=2000;
						setTimeout(function()
						{
							$('.successdiv').hide();
						},delay);
					}
					else if (response==3)
					{
						window.location.href="<?php echo base_url().loginRedirectUri;?>";
					}
				}
			}); 
		});
		</script>
	</body>
</html>