<?php
$display_captcha = FALSE;
if($captcha_settings['captcha_admin_login_status'] && !empty($captcha_settings['recaptcha_key'])) 
{
	$display_captcha = TRUE;
}
?>
<!DOCTYPE html>
<html>
	<head>
	    <meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<title>Login <?php echo $title ; ?></title>
		<meta name="description" content="">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
		<link rel="stylesheet" href="<?php echo base_url()?>style/admin/style/font-awesome/css/font-awesome.css">
		<link rel="stylesheet" href="<?php echo base_url()?>style/admin/style/css/bootstrap.css">
		<link rel="stylesheet" href="<?php echo base_url()?>style/admin/style/css/loginstyle.css">
		<link rel="shortcut icon" type="image/png" href="<?php echo base_url() ."style/admin/style/images/" . $favicon;?>"/>
		<?php if($display_captcha) : ?>
			<script src='https://www.google.com/recaptcha/api.js'></script>
		<?php endif;?>
</head>	
<body class="admin-login">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header login-header">
				<a href="//nexthon.com"><img alt="nexthon.com" src="<?php echo base_url(); ?>style/admin/style/images/nexthon.png"/></a>
			</div>
			<div class="modal-body">
			
				<div class=" loginError form-group mrg-btm-min">
					<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
						<span id="error"></span>
					</div>
				</div>
				<form id="frm-login" method="post">
					<fieldset>
						<div class="form-group">
							<input id="ue" type="text" name="email" class="form-control input-lg" id="emails" placeholder="Email">
						</div>
						<div class="form-group">
							<input id="pas" type="password" name="password" id="passwords" class="form-control input-lg"  placeholder="password">
						</div>
						
						<?php if($display_captcha) : ?>						
							<div class="form-group">
								<div class="g-recaptcha" data-sitekey="<?php echo $captcha_settings['recaptcha_key'];?>"></div>
							</div>
						<?php	
						endif;
						?>
						<div class="clearfix"></div>
						
						<div class="form-group">
							<div class="modal-footer row">
								<div class="col-xs-6 pad-min">
									<a href="reset-password" class="btn btn-primary btn-lg btn-block" > Reset Password ?</a>
								</div>
								
								<div class="col-xs-6 pad-min">
									<button type="button" class="btn btn-success btn-lg btn-block" id="createL"><i class="fa fa-chevron-right"></i> Login</button>
								</div>
							</div>
						</div>
					</fieldset>
					
				</form>
			</div>
		</div>	
	</div>  
</body>
		
		<script src="<?php echo base_url()?>/style/admin/style/js/jquery-1.11.1.min.js"></script>
				<script type="text/javascript">
			function checkRecaptcha() {
				res = $('#g-recaptcha-response').val();

				if (res == "" || res == undefined || res.length == 0)
					return false;
				else
					return true;
			}

			$('#frm-login').submit(function(e) {

				if(!checkRecaptcha()) {
					$( "#frm-result" ).text("Please validate your reCAPTCHA.");
					return false;
				}
			});
		</script>
<script type="text/javascript">
	function strip_tags(str) 
	{
		str = str.toString();
		return str.replace(/<\/?[^>]+>/gi, '');
	}
	$('.loginError').hide();
	
	function loginProcess()
	{
		$('.loginError').hide();
		var ue=strip_tags($('#ue').val().trim());
		var pas=strip_tags($('#pas').val().trim());
		
		
		if(ue.length==0)
		{
			$('.loginError').show();
			$('#error').html('Username or Email field is required');
			return;
		}
		else if(pas.length==0)
		{
			$('.loginError').show();
			$('#error').html('Password field is required');
			return;
		}
		else
		{
			
			$.ajax({ 
				url : "<?php echo site_url('login-post');?>",
				type: "post",
				data: {"ue":ue,"pas":pas, "g-recaptcha-response" : $("#g-recaptcha-response").val()},
				success: function(data)
				{
					reset_captcha();
					var responseData=$.parseJSON(data);
					var response=responseData['response'];
					if(response==0)
					{
						$('.loginError').show();
						$('#error').html("Invalid Username or Password");
					}
					else if (response==2)
					{
						$('.loginError').show();
						$('#error').html("Captcha Verification Failed");
					}
					else if (response==1 || response==3)
					{
						window.location.href="<?php echo base_url()."admin";?>";
					}
					else
					{
						$('.loginError').show();
						$('#error').html("Unknown errro occured , Please try again later !");
					}
				}
			});
		}
	}
	
	function reset_captcha()
	{
		if($("#g-recaptcha-response").length)
		{
			grecaptcha.reset();
		}
	}
	
	$('#ue,#pas').keypress(function (e) 
	{
		 var key = e.which;
		 if(key == 13)  // the enter key code
		  {
			loginProcess();
			return false;  
		  }
	});
	
	$(document).on('click','#createL',function(e){
		e.preventDefault();
		loginProcess();
	});
</script>
</html>