<?php
include dirname(__FILE__) . '/includes/header.php'; 

include dirname(__FILE__) . '/includes/header_under.php';
 
$error = false;

$csrfVariable = 'csrf_' . basename($_SERVER['PHP_SELF']);

if(isset($_POST['submit'])) 
	{
		global $mysqli;

		if($_SESSION[$csrfVariable] != $_POST['csrf'])
		$error = true;

		$formType=$_POST['formType'];
		if($formType==0)
		{
		  $type = $_POST['type'];
		  $hostName=trim(filter_input(INPUT_POST,'hostName', FILTER_SANITIZE_STRING));
		  $port=trim(filter_input(INPUT_POST,'port', FILTER_SANITIZE_STRING));
		  $username=trim(filter_input(INPUT_POST,'username', FILTER_SANITIZE_STRING));
		  $password=trim(filter_input(INPUT_POST,'password', FILTER_SANITIZE_STRING));
		  $emailSMTP=trim($_POST['emailSMTP']);
		  $emailMailer=trim($_POST['emailMailer']);
		  
			if(!filter_var($emailSMTP, FILTER_VALIDATE_EMAIL))
			{
			$error="Please enter Correct SMTP Email Adrress<br>";
			}
			
			if(!filter_var($emailMailer, FILTER_VALIDATE_EMAIL))
			{
			$error="Please enter Correct PHP Mailer Email Adrress<br>";
			}
	   
			if($error=="")
			{
			
			updateEmailSettings($hostName,$port,$username,$password,$type,$emailSMTP,$emailMailer);
			} 
	}
}

$key = sha1(microtime());
$_SESSION[$csrfVariable] = $key;

$array = mysqli_fetch_array($mysqli->query("SELECT * FROM `emailSettings`")); 

?>
	<title>Account Settings: <?php echo(getMetaTitle()) ?></title>
	</head>
	<body>
		<?php 
		include "includes/top_navbar.php"; 
		?>
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="row page-ttl">
					<div class="col-lg-12">
						<h1>
							<i class="fa fa-user"></i> Email Settings
						</h1>
					</div>
				</div> <!-- /.row -->
				<div class="page-content">
					<div class="margin_sides">
						<div class="row">
							<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
								<?php 
			
								if($error!="") 
								{ 
								?>
								<div class="alert alert-danger alert-dismissable">
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
									<i class="fa fa-exclamation-triangle"></i>
									<?php 
									echo($error); 
									?>
								</div>
								<?php 
								} 
								else
								{
									if(isset($_POST['submit']))
									{
										?>
										<div class="alert alert-success alert-dismissable">
											<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
											<i class="fa fa-check-square-o"></i> Email Settings Updated Successfully
										</div>
										<?php 
									} 
								} 
								?>
								<form action="emailSettings.php" method="POST" novalidate>
									<div class="form-group">
									<label class="control-label">Type</label>
										<div class="simple-mail">
											<label>
												<input type="radio" name="type" value="0" <?php 
												if($array['type']==0)
												{
												echo 'checked';
												 } ?> >
												Simple Mail (PHP Mailer)
											</label>
										</div>
										<div class="SMTP">
											<label>
												<input type="radio" name="type" value="1" <?php 
												if($array['type']==1)
												{
												echo 'checked';
												} ?>>
												Mail Through SMTP
											</label>
										</div>
									</div>
									<div id="smtpForm">
										<div class="form-group">
											<label>Host</label>
											<input type="text" class="form-control" name="hostName" value="<?php 
											$val=isset($_POST['submit'])?$_POST['hostName']:$array['host'];echo $val;?>" required maxlength="100">
										</div>
										<div class="form-group">
											<label>Port</label>
											<input type="text" class="form-control" name="port" value="<?php $val=isset($_POST['submit'])?$_POST['port']:$array['port'];echo $val;?>" required title="You Must Enter port Number." maxlength="20">
										</div>
										<div class="form-group">
											<label>Username</label>
											<input type="text" class="form-control" name="username" value="<?php $val=isset($_POST['submit'])?$_POST['username']:$array['username'];echo $val;?>" required title="You Must Enter Valid Username." maxlength="100">
										</div>
										<div class="form-group">
											<label>Password</label>
											<input type="password" class="form-control" name="password" value="<?php $val=isset($_POST['submit'])?$_POST['password']:$array['password'];echo $val; ?>" required autocomplete="off" placeholder="Password" pattern=".{5,}" required title="Minimum Password Length is 5 Characters." maxlength="100">
										</div>
										<div class="form-group">
											<label>Email</label>
											<input type="text" class="form-control" name="emailSMTP" value="<?php $val=isset($_POST['submit'])?$_POST['emailSMTP']:$array['emailSMTP'];echo $val;?>" required title="You Must Enter Valid Email." maxlength="100">
										</div>
								</div>
								<div id="mailerForm">
									<div class="form-group">
												<label>Email</label>
												<input type="email" class="form-control" name="emailMailer" value="<?php $val=isset($_POST['submit'])?$_POST['emailMailer']:$array['emailMailer'];echo $val;?>" required title="You Must Enter Valid Email." maxlength="100">
									</div>
								</div>
								<?php

												if($array['type']==0)
												{ ?>
												<script>
												
												$("#smtpForm").hide();
												$("#mailerForm").show();
												</script>
												<?php } ?>
												<?php
												if($array['type']==1)
												{ ?>
												<script>
												$("#mailerForm").hide();
												$("#smtpForm").show();
												</script>
												<?php } ?>
												
									<input type="hidden" name="csrf" value="<?php echo $key; ?>" />
										<hr>
										
										<div class="form-group">
											<input type="hidden" value="0" name="formType">
											<button type="submit" name="submit" class="btn btn-success"><i class="fa fa-pencil"></i>  Update</button>
										</div>
									</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<script>
		
			
	
		$(".SMTP").click(function(){
		$("#smtpForm").show();
		$("#mailerForm").hide();
		});
			
		$(".simple-mail").click(function(){
			$("#smtpForm").hide();
			$("#mailerForm").show();
		});
		</script>
		<?php include dirname(__FILE__) . '/includes/footer.php'; ?>
	</body>
</html>