<?php
$this->load->view('admin/includes/header');
?>
	<title>Server API Settings: <?php echo $title;?></title>
	</head>
	<body>
		<?php 
		include "includes/top_navbar.php"; 
		?>
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="row page-ttl">
					<div class="col-lg-12">
						<h1>
							<i class="fa fa-wrench"></i> Server API Settings <small>Update <?php echo $tlds['tld']; ?> Tld Server</small>
						</h1>
					</div>
				</div> <!-- /.row -->
				<div class="page-content">
					<div class="margin_sides">
						<div class="row">
							<div class="errordiv form-group mrg-btm-min">
								<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
									<span id="error"></span>
								</div>
							</div>
							<div class="successdiv alert alert-success alert-dismissable col-lg-8 col-md-8 col-sm-8 col-xs-12">
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
								<i class="fa fa-check-square-o"></i><span id="success"></span>
							</div>
							<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
								<form id="form" action="" method="POST">
									<div class="form-group">
										<label>TLD Name</label>
										<input class="form-control" name="tld" placeholder="Enter TLD Name" value="<?php echo $tlds['tld']; ?>" required>
									</div>
									<div class="form-group">
										<label>WHOIS Servers</label>
										<input class="form-control" name="server" placeholder="Enter WHOIS Server" value="<?php echo $tlds['server']; ?>" required>
									</div>
									<div class="form-group">
										<label>Response</label>
										<input class="form-control" name="response" placeholder="Enter Server Response" value="<?php echo $tlds['response']; ?>" required title="You Must Enter Valid Email.">
									</div>
									<hr>
									<div class="form-group">
									<input type="hidden" value="<?php echo $tlds['id']; ?>" name="id"/>
										<a href="<?php echo base_url()."admin/manage/tlds"?>"><button type="button" class="btn btn-default"><i class="fa fa-chevron-left"></i> Back </button></a> 
										<button id="finalSubmit" type="submit" name="submit" class="btn btn-success"><i class="fa fa-pencil"></i>  Update</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php include dirname(__FILE__) . '/includes/footer.php'; ?>
		<script>
		
		$('.successdiv,.errordiv').hide();
		$('#form').on('submit',function(e)
			{
				e.preventDefault();
				var element=this;
				
				$('.successdiv,.errordiv').hide();
				
				$('#finalSubmit').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> Update');
				 var formDataArray = $(element).serializeArray();
				 var formData=new FormData();
				  for(var i = 0; i < formDataArray.length; i++){
					var formDataItem = formDataArray[i];
					formData.append(formDataItem.name, formDataItem.value);
				  }
				//sumbmitFinalRequest(formData);
				$.ajax({
						url:"<?php echo base_url()?>update-tld-post",
						type:"POST",
						data:formData,
						processData: false,
						contentType: false,
						success:function(data)
						{
							$('#finalSubmit').html('<i class="fa fa-pencil"></i>  Update');
							
							var responseData=$.parseJSON(data);
							var response=responseData['response'];
							if(response==0)
							{
								$('#error').html(responseData['reason']);
								$('.errordiv').show();
							}
							else if (response==1)
							{
								$('#success').html('Successfully Updated');
								$('.successdiv').show();
							}
							else if (response==3)
							{
								window.location.href="<?php echo base_url().loginRedirectUri;?>";
							}
						}
					});
			}); 
		
		</script>
	</body>
</html>