<?php
$this->load->view('admin/includes/header');
?>
	<title>Link Settings: <?php echo $title;?>	</title>
	</head>
	<body id="scroller">
	<?php $this->load->view('admin/includes/top_navbar');?>	
	<script type="text/javascript">
		$(function() {$("#keywords").tagsInput({width:"auto"});});	
    </script>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="row page-ttl">
				<div class="col-lg-12">
					<h1 class="hidden-xs">
						<i class="fa fa-files-o"></i> Add Link <small>Add new link</small>
					</h1>
					<h4 class="visible-xs">
						<i class="fa fa-files-o"></i> Add link <small>Add new link</small>
					</h4>
				</div>
			</div>
			<div class="page-content">
				<div class="margin_sides">
					<div class="row">
						<div class="col-lg-8 col-md-10 col-sm-12 col-xs-12">
							<div class="errordiv form-group mrg-btm-min" style="display:none">
								<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> 
									<span id="error"></span>
								</div>
							</div>
							<div class="successdiv form-group mrg-btm-min" style="display:none">
								<div class="alert alert-success"><i class="fa fa-exclamation-triangle"></i> 
									<span id="success"></span>
								</div>
							</div>
							
							<form id="form" role="form" action="" method="post">
								<div class="form-group">
									<label>Title</label> <input class="form-control" name="title" placeholder="Enter page title" required="required" />
								</div>
								<div class="form-group">
									<label>Permalink</label> <input class="form-control" name="permalink" placeholder="Enter page permalink" required="required"/>
								</div>
								
								<div class="form-group">
									<label>Status</label></br>
									<input class="my_checkbox" name="publish" type="checkbox"   checked="checked" />
								</div>
								<div class="form-group">
									<label>Show in Header</label></br>
									<input class="my_checkbox" name="header_status" type="checkbox"   checked="checked" />
								</div>
								<div class="form-group">
								<label>Show in footer</label></br>
									<input class="my_checkbox" name="footer_status" type="checkbox"   checked="checked" />
								</div>								
								<hr>
								<div class="form-group">
									<a href="links"><button type="button" class="btn btn-default"><i class="fa fa-chevron-left"></i> Back</button> </a>
									<button name="submit" type="submit" class="btn btn-success"><i class="fa fa-check"></i> Add Link</button>
								</div>
							</form>
							
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	</body>
	<?php $this->load->view('admin/includes/footer');?>	
	<script>
	function scroller(id)
	{
		$('html,body').animate({
		scrollTop: $("#"+id).offset().top},
		'slow');
	}
	
	$('.successdiv,.errordiv').hide();
	
	$('#form').on('submit',function(e)
	{
		e.preventDefault();
		
		$('.successdiv,.errordiv').hide();
		var formDataArray = $(this).serializeArray();
		var data=new FormData();
		
		for(var i = 0; i < formDataArray.length; i++)
		{
			var formDataItem = formDataArray[i];
			data.append(formDataItem.name, formDataItem.value);
		}
		
		$.ajax({
			type: "POST",
			url: "<?php echo base_url()."add-link-post"?>",
			data: data,
			cache: false,
			processData: false,
			contentType: false,
			success: function(result)
			{	
				$('#finalSubmit').html('<i class="fa fa-check"></i> Add page');
					
					var responseData=$.parseJSON(result);
					var response=responseData['response'];
					if(response==0)
					{
						$('#error').html(responseData['reason']);
						$('.errordiv').show();
						scroller('scroller');
					}
					else if (response==1)
					{
						$('#success').html('Successfully updated');
						$('.successdiv').show();
						scroller('scroller');
						var delay=2000;
						setTimeout(function()
						{
							$('.successdiv').hide();
							window.location.href="<?php echo base_url().'admin/manage/links';?>";
						},delay);
					}
					else if (response==3)
					{
						window.location.href="<?php echo base_url().loginRedirectUri;?>";
					}
			}
		}); 
	});
	</script>
</html>