<?php 
class FrontModelDefault extends CI_Model{
	
	function getSiteSettingsDefault()
	{            
		$dataDefault=$this->CrudModel->getData("settings","row_array"
			,$arg=['cache'=>['index'=>'settings','time'=>cacheTimeMakeGet(30,'d')]]
		);
		
		$dataDefault['analytics'] = $this->CrudModel->getData("analytics","row_array",$arg=['where'=>['status'=>1],
								'cache'=>['index'=>'analytics','time'=>cacheTimeMakeGet(30,'d')]
									]);
									
		$dataDefault['links'] = $this->CrudModel->getData("links","all_array",$arg=[								
								'cache'=>['index'=>'links','time'=>cacheTimeMakeGet(30,'d')]
									]);
									
		$dataDefault['social'] = $this->CrudModel->getData("social_profiles","all_array",$arg=[								
								'cache'=>['index'=>'social','time'=>cacheTimeMakeGet(30,'d')]
									]);
		
		$dataDefault['selectedCurrency'] = get_selected_curr();
		
		$dataDefault['ads'] = $this->CrudModel->getData("ads","row_array",$arg=[
								'cache'=>['index'=>'ads','time'=>cacheTimeMakeGet(30,'d')]
									]);
		
		$dataDefault['pages']=$this->CrudModel->getData("pages","all_array",$arg=['where'=>['status'=>1]
				,'cache'=>['index'=>'pages','time'=>cacheTimeMakeGet(30,'d')]
			]);
		
		
		$dataDefault['language']=$this->CrudModel->getData("language","all_array",$arg=['where'=>['status'=>1],'cache'=>['index'=>'language','time'=>cacheTimeMakeGet(30,'d')]]);
		
		$main_tld=$this->CrudModel->getData("main_tld","row_array",$arg=['select'=>['tld']
			,'cache'=>['index'=>'main_tld','time'=>cacheTimeMakeGet(30,'d')]
		]);
		$dataDefault['main_tld']=$main_tld['tld'];
		
		$dataDefault['tlds']=$this->CrudModel->getData("tlds","all_array",$arg=['select'=>['tld'],'where'=>['status'=>1],'order'=>['col'=>'display_order','type'=>'asc'],'cache'=>['index'=>'tlds','time'=>cacheTimeMakeGet(30,'d')]
		]);
		
		$dataDefault['suggessted_limit']=$this->CrudModel->getData("suggessted_limit","row_array",$arg=[
			'cache'=>['index'=>'suggessted_limit','time'=>cacheTimeMakeGet(30,'d')]
		]);
		
		$getDefaultLanguage=$this->getDefaultLanguage($dataDefault['language']);
		
		
		if(!$getDefaultLanguage['defaultLanguageData'])
		show_404();
	
		$dataDefault=array_merge($dataDefault,$getDefaultLanguage);
		

		
		$dataDefault['affiliates']=$this->CrudModel->getData("affiliates","all_array",$arg=[
			'where' => array('status' => 1),
			'order' => array('col' => 'displayOrder', 'type' => 'ASC'), 

		]);
		
		if(!empty($dataDefault['analytics'][0]))
		{
			$dataDefault['analytics'] = $dataDefault['analytics'][0];
		}
		
		return $dataDefault;
	}
	public function getDefaultLanguage($language)
	{
		$defaultLanguageData=false;
		$page_language=false;

		if(count($language)>0)
		{

			$getLanguage=isset($_GET['language']) && strlen($_GET['language'])>0?$_GET['language']:false;
			
			if($getLanguage)
			{
							
				$key=array_search($getLanguage,array_column($language,'lang_name'));
				if(!is_numeric($key))
				{
					$defaultLanguage=[];
				}
				else
				{
					$defaultLanguage=$language[$key];
					$this->session->defaultLanguage=$defaultLanguage;	
				}
			}
			else
			{
				if(isset($this->session->defaultLanguage))	
				{
					$defaultLanguage=$this->session->defaultLanguage;
				}
				else
				{
					$defaultLanguage=$language[0];
					$this->session->defaultLanguage=$defaultLanguage;
				}
			}
			
			if(array_key_exists('lang_file',$defaultLanguage))
			{
				$path='language/'.$defaultLanguage['lang_file'];
				if(file_exists("./".$path))
				{
					$json = file_get_contents(base_url() . $path);
					$defaultLanguageData=json_decode($json, true);
					$page_language=$this->DbHandlerDynamicFun->getData("page_language",$select=null,$where=['language'=>$defaultLanguage['lang_name']],$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
					$link_language=$this->DbHandlerDynamicFun->getData("linklanguage",$select=null,$where=['language'=>$defaultLanguage['lang_name']],$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
				}
			}
		}
		return ['defaultLanguageData'=>$defaultLanguageData,'page_language'=>$page_language,'link_language'=>$link_language];
	}
	
}