<?php 
class CrudModel extends CI_Model{
	
	function __construct()
	{
		parent::__construct();
		$this->checkAliveDb();
	}
	function getIpAddress()
	{
		switch(true) {
		case (!empty($_SERVER['HTTP_X_REAL_IP'])) : return $_SERVER['HTTP_X_REAL_IP'];
		case (!empty($_SERVER['HTTP_CLIENT_IP'])) : return $_SERVER['HTTP_CLIENT_IP'];
		case (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) : return $_SERVER['HTTP_X_FORWARDED_FOR'];
		default : return $_SERVER['REMOTE_ADDR'];
		}
	}
	
	function checkAliveDb()
	{
		if ($this->db->conn_id->ping() === FALSE)
		{
			sleep(1);
			$this->db->reconnect();
		}
	}
	
	function updateData($table,$data,$arg=[],$cache=false)
	{
		if(isset($arg['where'])){$this->db->where($where);}
		if(!isset($arg['batchCol']))
		$this->db->update($table,$data);
		else
		$this->db->update_batch($table,$data,$arg['batchCol']);
		if($cache){$this->cache->save($cache['index'],$cache['cacheValue'],$cache['time']);}
	}
	
	function deleteData($table,$where=false)
	{
		if($where!==false)
		$this->db->where($where);
		$this->db->delete($table);
	}

	function getData($table,$resultType="all_array",$arg=[])
	{
		if(isset($arg['cache'])){if($record=$this->cache->file->get($arg['cache']['index'])){return $record;}}
		
		if(isset($arg['wherein'])){$this->db->where_in($arg['wherein']['column'],$arg['wherein']['data']);}
		if(isset($arg['where'])){$this->db->where($arg['where']);}
		if(isset($arg['wherentin'])){$this->db->where_not_in($arg['wherein']['column'],$arg['wherein']['data']);}
		if(isset($arg['select'])){$this->db->select($arg['select']);}
		if(isset($arg['join'])){$this->db->join($arg['join']['table'],$arg['wherein']['query'],$arg['wherein']['type']);}
		if(isset($arg['like'])){$this->db->like($arg['like']['col'],$arg['like']['query']);}
		if(isset($arg['order'])){$this->db->order_by($arg['order']['col'],$arg['order']['type']);}
		if(isset($arg['groupby'])){$this->db->group_by($arg['groupby']);}
		if(isset($arg['limit'])){$this->db->limit($arg['limit']['pages'],$arg['groupby']['start']);}
		if(isset($arg['distinct'])){$this->db->distinct($arg['distinct']);}
		
		$return=null;
		if($resultType=="all_array"){$return=$this->db->get($table)->result_array();}
		else if($resultType=="row_array"){$return=$this->db->get($table)->row_array();}
		else{$return=$this->db->count_all_results($table);}
		if(isset($arg['cache'])){
		$this->cache->file->save($arg['cache']['index'],$return,$arg['cache']['time']);}
		return $return;
	}
	function insertData($table,$insert,$batch=false)
	{
		if(!$batch)
		$this->db->insert($table,$insert);
		else
		$this->db->insert_batch($table,$insert);
	}
	function rawQuery($query,$resultType)
	{
		$res=$this->db->query($query);
		if($resultType=="all_array")
		{
			return $res->result_array();
		}
		else if($resultType=="row_array")
		{
			return $res->row_array();
		}
		else
		{
			return $res->count_all_results($table);
		}
	}
}