<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

	function checkLoginCookie($type="get",$isUnsecure=false)
	{
		$CI =& get_instance();
		$sessCheck=isset($CI->session->secure)?true:false;
	
		if($isUnsecure==true && $sessCheck==false)
		return false;
		
		if(!$sessCheck)
		{
			$perma=base_url().substr_replace($_SERVER['REQUEST_URI'],"",0,1);
			setcookie("url", $perma, time() + (86400 * 30), "/");
			if($type=="get")
			{
				redirect(loginRedirectUri);
			}
			else
			{
				return $sessCheck;
			}
		}
		else
		{
			return $sessCheck;
		}
	}
	
	function cacheTimeMakeGet($q,$type){
		$rtrn=0;
		switch ($type) {
		case 'h':
			$rtrn=$q*60;
			break;
		case 'd':
			$rtrn=$q*24*60*60;
			break;
		default:
			$rtrn=24*60*60;
		}
		return $rtrn;
	}
	function intlCurFmtr($number)
	{
		if($number==0)
		{
			return $number;
		}
		
		$number=rtrim(sprintf("%.10f",$number), "0");
		list($whole, $decimal) = explode('.', $number);
		
		if($whole<=0)
		{
			return $number;
		}
		$decimal=round(".".$decimal,3); 
		$finalNumber=number_format($whole+$decimal,3,'.',',');
		return $finalNumber;
	}
	
	function validate_grecaptcha($page = "admin")
	{
		$is_valid = 0;		
		
		$CI =& get_instance();
		$captcha_settings = $CI->DbHandlerDynamicFun->getData("captcha_settings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		if($page == "admin" && $captcha_settings['captcha_admin_login_status'] == false)
		{
			return 1;
		} 
		else if($page == "contact" && $captcha_settings['captcha_contact_status'] == false)
		{
			return 1;
		} 
		else if(empty($captcha_settings['recaptcha_key']))
		{
			return 1;
		}
		else
		{
			$secret = "";
			if(!empty($captcha_settings['recaptcha_secret']))
			{
				$secret = $captcha_settings['recaptcha_secret'];
				
				$response = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$secret.'&response='.$_POST['g-recaptcha-response']);
					
				$result = json_decode($response);
				
				if ($result->success) {
					$is_valid = 1;
				}	
			}
		}
		
		if($is_valid)
		return 1;
		
		return 0;
		
	}
	
	function ci_send_email($to, $subject, $message)
	{
		$response = array("success" => 0);
		
		$CI =& get_instance(); 
		$settings =  $CI->DbHandlerDynamicFun->getData("emailsettings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		$web_settings =  $CI->DbHandlerDynamicFun->getData("settings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		if(empty($settings["emailMailer"]))
		{
			$response["error"] = "Invalid email configurations";
		}
		else if($settings["type"] == "1" && (empty($settings["host"]) || empty($settings["username"]) || empty($settings["password"]) || empty($settings["port"])) )
		{
			$response["error"] = "Invalid smtp configurations provided";			
		}
		else
		{
			$CI->load->library("email");
			
			$config = array("mailtype" => "html");
			
			if($settings["type"] == "1")
			{			
				//configure smtp settings			
				$config["protocol"]  = "smtp";
				$config["smtp_host"] = $settings["host"];
				$config["smtp_user"] = $settings["username"];
				$config["smtp_pass"] = $settings["password"];
				$config["smtp_port"] = $settings["port"];	
				$config["smtp_crypto"] = "tls";
			}
			
			$CI->email->initialize($config);
			
			$CI->email->from($settings["emailMailer"],  $web_settings["name"]);
			
			if($to == "admin")
			{
				$to = $settings["emailMailer"];
			}
			
			$CI->email->to($to);
			

			$CI->email->subject($subject);
			$CI->email->message($message);

			$result = $CI->email->send();
			
			if($result)
			{
				$response["success"] = 1;
			}
			else
			{
				$response["error"] = "Email sending failed";
			}			
		}
		
		return $response;
	}
	

	function get_selected_curr()
	{
		$CI = &get_instance();
		$response = array();
		
		$selected_curr  = get_cookie('nids-def-curr');

		if($selected_curr != "")
		{
			$selected_curr = explode(':', $selected_curr);
			
			if(sizeof($selected_curr))
			{
				$response['currency'] = $selected_curr[0];
				$response['symbol']	  = $selected_curr[1];
			}			
		}
		
		if(!empty($response['currency']))
		{
			$rate = $CI->cache->file->get('rate_' . $response['currency']);
			
			if(!empty($rate['rate']))	
			{
				$response['rate'] = $rate['rate'];
			}
			else
			{
				$rate = get_currency_rate($selected_curr[0]);
				
				if($rate)
				{
					$response['rate'] = $rate['rate'];
					$CI->cache->file->save('rate_' . $selected_curr[0], array('rate' => $rate), 86400);					
				}	
				
			}
			
		}
		
		return $response;		
				
	}	
	
	function get_currency_rate($to_curr)
	{
		
		$rate = 0;
		
		$from_to_curr = "USD_" . $to_curr;
		$url = "http://free.currencyconverterapi.com/api/v5/convert?q=" . $from_to_curr . "&compact=y";
		
		$contents = file_get_contents($url);
		$json = json_decode($contents, TRUE);
		
		if(!empty($json[$from_to_curr]['val']))
		{
			$rate =  $json[$from_to_curr]['val'];
		}
		
		return $rate;
		
	}
	
	function format_price_to_decimal($price)
	{
		return number_format((float)$price, 2, '.', '');
	}

