<?php 
defined('BASEPATH') OR exit('No direct script access allowed');
ignore_user_abort(false);
class SearchHandler extends CI_Controller{
	
	function search_whois()
	{
		if (!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}
		
		$response = array('success' => 0);
		
		$post_data = $this->input->post(NULL, TRUE);
		
		if(empty($post_data['domain']))
		{
			$response['error'] = 'Domain name is required';
		}
		else
		{
			include_once APPPATH.'third_party/Whois.php';			
			
			$obj = new Whois($post_data['domain']);			
			
			$whois_info = ($obj->info());
			
			$response['success'] = 1;
			$response['content'] = '<pre>' . $whois_info . '</pre>';
			
		}
		
		echo json_encode($response);
	}
	
	public function search()
	{
		$url=$this->input->post('domain');
		$tld=$this->input->post('tld');
		$forPrice = str_replace('.', '', $tld);
		$tld1 =$this->input->post('tld1');
		$domain=$this->Text_Box_Validation($url);
		$data = $this->tld_server($tld,$domain,$WhoisLinkName="WHOIS",$tld1);
		echo json_encode($data);
		exit();
		
	}
	function clean($string)
	{

		$string = str_replace(' ', '', $string);

		$string = preg_replace('/[^A-Za-z.0-9\-]/', '', $string);

		return $string;

	}
	function Text_Box_Validation($url)
	{
		if(trim(substr($url,0,7))=="http://")
			$url = trim(substr($url,7,strlen($url)-7));

		if(trim(substr($url,0,8))=="https://")
			$url = trim(substr($url,8,strlen($url)-8));

		if(trim(substr($url,0,4))=="www.")
			$url = trim(substr($url,4,strlen($url)-4));

		$data = $this->clean($url);

		while(strpos(trim($data),"---")!==false)
		{

			 $data = str_replace("---","--",$data);

		}

		while(trim(substr($data,0,1))=="." || trim(substr($data,strlen($data)-1,1))=="." || trim(substr($data,0,1))=="-" || trim(substr($data,strlen($data)-1,1))=="-")
		{

			$data = ltrim($data,"-");

			$data = rtrim($data,"-");

			$data = ltrim($data,".");

			$data = rtrim($data,".");

		}
		if(strpos($data,".")!==false)
		{

			$data = strrev($data);

			$data = explode(".",$data);

			$i = count($data);

			$url = "";

			for($i;$i>0;$i--)
			{

				 $url .=strrev($data[$i]);

			}

		}
		else
			$url = $data;

		$url = ltrim($url,"-");

		$url = rtrim($url,"-");

		return substr($url, 0,60);

	}
	
	function tld_server($ext,$dom,$who,$tld1) {
		
		$data = array();
		$date=date("Y-m-d");
		
		$affiliates=$this->CrudModel->getData("affiliates","all_array",$arg=['cache'=>['index'=>'affiliates','time'=>cacheTimeMakeGet(30,'d')]]);
		$cache_settings=$this->CrudModel->getData("cache_settings","row_array",$arg=['cache'=>['index'=>'cache_settings','time'=>cacheTimeMakeGet(30,'d')]]);
		$settings=$this->CrudModel->getData("settings","row_array");
		
		$currency_settings=$this->CrudModel->getData("currency_settings","row_array",$arg=['cache'=>['index'=>'currency_settings','time'=>cacheTimeMakeGet(30,'d')]]);
		$tlds=$this->CrudModel->getData("tlds","all_array",$arg=['select'=>['tld'],'where'=>['status'=>1],'order'=>['col'=>'display_order','type'=>'asc']
		]);
		$defaultAffiliate=$affiliates[0];
		$data[2]=0;
		$data[0] = '';
		if($tld1 == 'main_div'){
			$sld = $dom.'.'.$ext;
			$existense = $this->cache->file->get($sld);
			include APPPATH.'third_party/Whois.php';
			if($existense==null || $cache_settings['tld_status'] != 1)
			{
				
				$obj = new Whois($sld);
				if($obj->isAvailable())
					$existense = 1;
				else
					$existense = 0;
				$this->cache->file->save($sld,$existense,$cache_settings['tld_time']);
			}
				if($existense == 1)
				{
					$data[2]=1;   
					$data[1] = '
					<div class="container">
						<div class="domain-name"><span class="InstantDomainShow">'.strtolower($dom).'</span><span class="domain-ext">.'.strtolower($ext).'</span></div><!-- .domain-name -->
						<a onclick="affiliate_click();" id="top_domain_href" target="_blank" href="'.$this->return_affiliate_url($dom,$ext,$defaultAffiliate['url'],$defaultAffiliate['affiliate_name']).'" class="domain-buy-btn buy-avail zoomIn animated"><span id="top_'.$ext.'_domain">'.$this->convert_currency((isset($defaultAffiliate[$ext])?$defaultAffiliate[$ext]*$currency_settings['price_dollor']:0),$currency_settings).'</span> Buy</a>
					</div><!-- .container -->';
				}
				else
				{
					$data[2]=0;
					$whois_link = str_replace("{domain}",$dom.'.'.$ext,$settings['whois_url']);
					$data[1] = '<div class="container">
						<div class="domain-name"><span class="InstantDomainShow">'.strtolower($dom).'</span><span class="domain-ext">.'.strtolower($ext).'</span></div><!-- .domain-name -->
						<a id="top_domain_href1" target="_blank" href='.site_url().'whois/'.($dom.'.'.$ext).' class="domain-buy-btn whois-not-avail zoomIn animated"> Whois</a>
					</div><!-- .container -->';
					
				}
			} else {
			
			$limit=31;
			$is=1;
				
				$sld = $dom.'.'.$ext['tld'];
				if(!$existense=$this->cache->file->get($sld))
				{
					include APPPATH.'third_party/Whois.php';
					
					$obj = new Whois($sld);
					
					if($obj->isAvailable())
						$existense = 1; 
					else
						$existense = 0;
					
					$this->cache->file->save($sld,$existense,23232323);
				}
				if($existense == 1)
				{
					$is++;
					$price = (isset($defaultAffiliate[$ext['tld']]) ? $defaultAffiliate[$ext['tld']] : 0);
					
					$data[0] = '<a onclick="affiliate_click();" href="'.$this->return_affiliate_url($dom,$ext['tld'],$defaultAffiliate['url'],$defaultAffiliate['affiliate_name']).'" target="_blank" id="href_'.str_replace('.', '', $ext['tld']).'" class="right-by-wo-btn green-by-btn">Buy</a>
						<div id="tld_price_'.str_replace('.', '', $ext['tld']).'" class="right-price-per-yr">'.$this->convert_currency($price,$currency_settings).'</div>
						<div class="left-extension green">
							<span class="domain-ext"><span class="InstantDomainShow">'.$dom.'</span><span class="extention">.'.$ext['tld'].'</span></span>
						</div>
						<div class="clearfix"></div>';
				}
				else
				{
					$is++;
					$whois_link = str_replace("{domain}",$dom.'.'.$ext['tld'],$settings['whois_url']);

					if($settings['whoisStatus'] == 1)
					{
						$data[0] .= '<a id="href_'.str_replace('.', '', $ext['tld']).'"
									href="'.site_url().'whois/'.($dom.'.'.$ext['tld']).'"
									data-domain="'.$dom.'.'.$ext['tld'].'" class="btn-whois right-by-wo-btn red-by-btn">Whois</a>
									<div class="left-extension red">
										<span class="domain-ext "><span class="InstantDomainShow">'.$dom.'</span><span class="extention">.'.$ext['tld'].'</span></span>
									</div>
									<div class="clearfix"></div>';
					}
					else
					{
						$data[0] = '<a class="right-by-wo-btn red-by-btn">N/A</a>
									<div class="left-extension red">
										<span class="domain-ext "><span class="InstantDomainShow">'.$dom.'</span><span class="extention">.'.$ext['tld'].'</span></span>
									</div>
									<div class="clearfix"></div>';
					}
					
				}
				
			}
			return $data;
	}
	function convert_currency($val,$currency_settings)
	{
		if($val == 0)
		{
			return "";
		}
		else
		{
			return $val ." / Yr";
		}
	}
	function return_affiliate_url($domain,$tld='com',$url,$affiliate_name)
	{
		$affiliate_url="";
			if($affiliate_name=="godaddy")
				$affiliate_url = $url."?sid=1673601704.1419598115&url=https://www.godaddy.com/domains/search.aspx?domainToCheck="  . $domain  . "." . $tld . "&checkAvail=1";
			else if($affiliate_name=="iwant_my_name")
				$affiliate_url = $url."&afftrack=&urllink=iwantmyname.com%2Fsearch%2Fadd%2F"  . $domain  . "." . $tld . "%3Fr%3DInstantDomainSearch%26_r%3DInstantDomainSearch%26_p%3Dsession%253Dunused%2526user%253Dunused";
			else if($affiliate_name=="media_temple")
				$affiliate_url = $url;
			else if($affiliate_name=="united_domains")
				$affiliate_url = $url;
			else if($affiliate_name=="yahoo")
				$affiliate_url = $url;
			else if($affiliate_name=="one_one")
			{
				$explode = explode('-',$url,2);
				$PID = explode('-',$explode [1],2);
				$affiliate_url = "https://www.dpbolvw.net/interactive?sid=80072381.1420179601&domain="  . $domain  . "&tld="  . $tld  . "&aid=10933941&pid=" . $PID[0] . "&url=http://order.1and1.com/dcjump?ac=OM.US.US469K02463T2103a&ovm_kp=wh&ovm_wm=s_ch_360x50";
			}
			else if($affiliate_name=="name_cheap")
				$affiliate_url = $url."?sid=1673601704.1419598115&url=https://www.namecheap.com/domains/registration/results.aspx?domain=" . $domain . "." . $tld;
			else if($affiliate_name=="register")
				$affiliate_url = $url;
			else if($affiliate_name=="hover")
				$affiliate_url = $url. "?p.domain=".$domain.".".$tld;
			else
			{

				$rows=mysqli_fetch_array($mysqli->query("SELECT * FROM affiliates WHERE status = '1' ORDER BY precedence ASC"));
				if($rows['affiliate_name'] == 'godaddy')
					$affiliate_url = $url."?sid=1673601704.1419598115&url=https://www.godaddy.com/domains/search.aspx?domainToCheck="  . $domain  . "." . $tld . "&checkAvail=1";
				else if($rows['affiliate_name'] == 'iwant_my_name')
					$affiliate_url = $url."&afftrack=&urllink=iwantmyname.com%2Fsearch%2Fadd%2F"  . $domain  . "." . $tld . "%3Fr%3DInstantDomainSearch%26_r%3DInstantDomainSearch%26_p%3Dsession%253Dunused%2526user%253Dunused";
				else if($rows['affiliate_name'] == 'media_temple')
					$affiliate_url = $url;
				else if($rows['affiliate_name'] == 'name_cheap')
					$affiliate_url = $url."?sid=1673601704.1419598115&url=https://www.namecheap.com/domains/registration/results.aspx?domain=" . $domain . "." . $tld;
				else if($rows['affiliate_name'] == 'one_one')
				{
					$explode = explode('-',$url,2);
					$PID = explode('-',$explode [1],2);
					$affiliate_url = "https://www.dpbolvw.net/interactive?sid=80072381.1420179601&domain="  . $domain  . "&tld="  . $tld  . "&aid=10933941&pid=" . $PID[0] . "&url=http://order.1and1.com/dcjump?ac=OM.US.US469K02463T2103a&ovm_kp=wh&ovm_wm=s_ch_360x50";
				}
				else if($rows['affiliate_name'] == 'register')
					$affiliate_url = $url;
				else if($rows['affiliate_name'] == 'united_domains')
					$affiliate_url = $url;
				else if($rows['affiliate_name'] == 'yahoo')
					$affiliate_url = $url;
				else if($affiliate_name=="hover")
					$affiliate_url = $url. "?p.domain=".$domain.".".$tld;
				else
				$affiliate_url = $url."?sid=1673601704.1419598115&url=https://www.godaddy.com/domains/search.aspx?domainToCheck="  . $domain  . "." . $tld . "&checkAvail=1";

			}
			return $affiliate_url;
	}
}