<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class RoutesDynamicHandler extends CI_Controller
{
	
	public function loadaPage($permalink, $param = NULl)
	{
		
		$this->load->model('FrontModelDefault');
		$data=$this->FrontModelDefault->getSiteSettingsDefault();
		
		$permalink=stripslashes(trim($permalink));
		$page_language=$data['page_language'];
		
		$key=array_search($permalink,array_column($page_language,'permalink'));
		if(!is_integer($key))
		show_404();
		
		$data['pageTitle']=$page_language[$key]['title'];
		$data['activePageData']=$page_language[$key];
		$data['url']=base_url();
		
		$data['captcha_settings'] = $this->DbHandlerDynamicFun->getData("captcha_settings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		
		if($permalink == "whois" && $param != null)
		{
			if($data['whoisStatus'] == 1)
			{
				include_once APPPATH.'third_party/Whois.php';
			
				//get whois info here
				$obj = new Whois($param);
				$data['param_whois'] = $param;
				$data['whois_info'] = ($obj->info());
			}
			else
			{
				$data['param_whois'] = $param;
				$data['whois_info']  = 'Whois feature is disabled.';
			}
						
		}
		
		$this->load->view('front/index',$data);
		
	}
	
	public function contact_post()
	{		
		
		if (!$this->input->is_ajax_request()) {
		   exit('No direct script access allowed');
		}
		
		$response = array();		
		
		$post_data = $this->input->post(NULL, TRUE);
		
		$captcha_response = validate_grecaptcha("contact");
		
		if($captcha_response == FALSE)
		{
			$response["error"] = "Captcha verification failed";
			$response["success"] = 0;
		}
		else if(empty($post_data['fname']) || empty($post_data['email']))
		{
			$response["error"] = "Please fill all required fields";
			$response["success"] = 0;
		}
		else
		{
			//todo: send email to admin by getting email configs
			@ci_send_email("admin", "subject", "message");
			$response["success"] = 1;
			$response["message"] = "Your requrest has been submitted";
			
		}
		
		echo json_encode($response);
		exit;
	}
	
	
	
}






