<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class AjaxHandlerAdmin extends CI_Controller{
	
	public function handleLogin()
	{
		if(checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$ue=trim(stripslashes($this->input->post('ue')));
		$pas=trim(stripslashes($this->input->post('pas')));
		
		$this->form_validation->set_rules('ue','Username or Email','trim|required|max_length[150]');
		$this->form_validation->set_rules('pas','Password','trim|required|max_length[40]');
	
		if($this->form_validation->run())
		{
			$captcha_response = validate_grecaptcha();
			
			if($captcha_response)
			{
				$this->load->model('AjaxHandlerModel');
				$pas=$this->AjaxHandlerModel->secure_hash($pas);
				
				$userInfo=$this->DbHandlerDynamicFun->getData("settings",$select=['username'],$where="(username='$ue' or email='$ue') AND password='$pas'",$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null);
				if(count($userInfo)>0)
				{
					$this->session->userInfo=['username'=>$userInfo['username']];
					$this->session->secure=true;
					$this->compileResponse(['response'=>1]);
				}
				else
				{
					$this->compileResponse(['response'=>0, "reason" => "Invalid credentials" ]);
				}
				
			} else
			{
				$this->compileResponse(['response'=>2,"pas"=>"Captcha verification failed"]);
			}
			
			
		}
		else
		{
			$this->compileResponse(array("response"=>0,"ue"=>form_error('ue'),"pas"=>form_error('pas')));
		}
	}
	
	public function handleResetPassword()
	{
		
		$ue=trim(stripslashes($this->input->post('ue')));
		
		
		$this->form_validation->set_rules('ue','Username or Email','trim|required|max_length[150]');
		
	
		if($this->form_validation->run())
		{
			
			$this->load->model('AjaxHandlerModel');
			
			$userInfo=$this->DbHandlerDynamicFun->getData("settings",$select=['email', 'username'], $where="(username='$ue' or email='$ue')",$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null);
			
			if( $userInfo!=NULL > 0)
			{
				$resetHash = uniqid();

				$this->DbHandlerDynamicFun->updateData("settings", array('resetHash' => $resetHash) , array('username' => $userInfo['username']));
					
				$html = 'Please click <a href="'.site_url('admin/update-password/'.$resetHash).'">here </a> to update your password';
				ci_send_email($userInfo['email'], 'Reset your password', $html);
				$this->compileResponse(['response'=>1]);
			}
			else
			{
				$this->compileResponse(['response'=>0, "reason" => "Invalid credentials" ]);
			}
			
			
		}
		else
		{
			$this->compileResponse(array("response"=>0,"ue"=>form_error('ue'),"pas"=>form_error('pas')));
		}
		
	}
	
	public function handleUpdatePassword()
	{
		if(checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$new_password 	  = trim(stripslashes($this->input->post('new_password')));
		$confirm_password = trim(stripslashes($this->input->post('confirm_password')));
		$reset_hash       = trim(stripslashes($this->input->post('reset_hash')));
		
		if(empty($new_password) || empty($confirm_password) || empty($reset_hash))
		{
			$this->compileResponse(['response' => 0, "reason" => "Please input all required fields" ]);
		}		
		
		
		$userInfo=$this->DbHandlerDynamicFun->getData("settings",$select=['email', 'username'], $where="(resetHash ='$reset_hash')",$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null);
		
		if( count($userInfo) > 0)
		{
			$resetHash = uniqid();

			$this->load->model('AjaxHandlerModel');
			$new_password = $this->AjaxHandlerModel->secure_hash($new_password);
			
			$this->DbHandlerDynamicFun->updateData("settings", array('resetHash' => '', 'password' => $new_password) , array('username' => $userInfo['username']));
									
			$this->compileResponse(['response' => 1]);
		}
		else
		{
			$this->compileResponse(['response'=>0, "reason" => "invalid detail provided" ]);
		}
		
	}
	
	
	public function genSiteMapPost()
	{
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
			
		$sitemaps = "";
		
		$sitemapPrev=$this->DbHandlerDynamicFun->getData("sitemaps",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		$filename = $sitemapPrev['filename'];
		
		$sitemaps.= '<?xml version="1.0" encoding="utf-8"?>' . PHP_EOL;
		
		$sitemaps.= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . PHP_EOL;
		
		$this->load->model('AjaxHandlerModel');
		$sitemaps.= $this->AjaxHandlerModel->generateRootSitemap();
		
		if ($sitemapPrev['contactStatus']) 
		$sitemaps .= $this->AjaxHandlerModel->generateContactSitemap();
		
		if ($sitemapPrev['pagesStatus'])
		$sitemaps .= $this->AjaxHandlerModel->generatePagesSitemap();
		
		$sitemaps.= '</urlset>';
		
		$siteMapFilePath="./" . $filename;
		
		if (is_writable($siteMapFilePath)) 
		{
			$file = fopen($siteMapFilePath, "w+");
			
			fwrite($file, $sitemaps);
			
			fclose($file);
			$date=date('Y-m-d');
			$this->DbHandlerDynamicFun->updateData("sitemaps",['dateUpdated'=>$date],$where=false,$batchColumn=false);
			
			$regenerated = true;
			
			$sitemapURL = base_url().$filename;
			
			$regenerateMSG = "Sitemap Generated . Click <a href='http://www.sitemapwriter.com/notify.php?crawler=all&url=" . $sitemapURL . "' target='blank'><strong>Here</strong></a> To Notify Search Engines";
		
			$this->compileResponse(['response'=>1,'reason'=>$regenerateMSG,'date'=>$date]);
			
		}
	}
	public function editSitemapsPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$pagesStatus=trim(stripslashes($this->input->post('pagesStatus')));
		$contactStatus=trim(stripslashes($this->input->post('contactStatus')));
		$filename=trim(stripslashes($this->input->post('filename')));
		
		if($filename == "")
		$this->compileResponse(['response'=>3,'reason'=>"Please enter sitemap's file name"]);
	
		$sitemapPrev=$this->DbHandlerDynamicFun->getData("sitemaps",$select=['filename'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		if($filename!=$sitemapPrev['filename'] && $filename!="")
		{
			if(file_exists("./" . $filename))
			{
				$file = fopen("./" . $filename, "w+");

				fwrite($file, "");

				fclose($file);
			}
		}

		$pagesStatus = ($pagesStatus == "on") ? 1 : 0;

		$contactStatus = ($contactStatus == "on") ? 1 : 0;

		$this->DbHandlerDynamicFun->updateData("sitemaps",['pagesStatus'=>$pagesStatus,'contactStatus'=>$contactStatus,'filename'=>$filename],$where=false,$batchColumn=false);
		$this->compileResponse(['response'=>1]);
	}	
	public function addsUpdate()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$error=false;
		$this->load->model('AjaxHandlerModel');
		
		if(!isset($_POST["medrec1"]) || !isset($_POST["medrec2"]))
		$error="Invalid form input posted ! ";
	
		$medrec1 =trim(htmlspecialchars_decode($_POST["medrec1"]));
		
		$medrec2 =trim(htmlspecialchars_decode($_POST["medrec2"]));
		
		if(isset($_POST["medrec1_status"]) && $_POST["medrec1_status"]=="on")
		$medrec1_status = 1;
		else 
		$medrec1_status = 0;
		if(isset($_POST["medrec2_status"]) && $_POST["medrec2_status"]=="on") 
		$medrec2_status = 1;
		else
		$medrec2_status = 0;
		
		if(!$error)
		{
			$response=['response'=>1];
			$this->DbHandlerDynamicFun->updateData("ads",['medrec1'=>$medrec1,'medrec1_status'=>$medrec1_status,'medrec2'=>$medrec2,'medrec2_status'=>$medrec2_status],$where=false,$batchColumn=false);			
			$this->cache->file->delete('ads');
		} else {
			$response=['response'=>0,'reason'=>$error];
		}
		$this->compileResponse($response);
	}
	
	public function domainsUpdate()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$search =trim(stripslashes($_POST['search']));

		$page = trim(stripslashes($_POST['page']));

		$type =trim(stripslashes( $_POST['type']));

		$order = trim(stripslashes($_POST['order']));
		
		if($type == 'null' && !isset($_SESSION['type']))
		{

			$type = 'last_date_check';
			$_SESSION['type'] = $type;

		}
		else if($type != 'null')
		{

			$_SESSION['type'] = $type;
			
		}
		if($order == 'null' && !isset($_SESSION['order']))
		{

			$order = 'DESC';
			$_SESSION['order'] = $order;

		}
		else if($order != 'null')
		{

			$_SESSION['order'] = $order;
			
		}

		$cur_page = $page;

		$page -= 1;

		$per_page = 8;

		$first_btn = true;

		$last_btn = true;

		$start = $page * $per_page;

		if(isset($_POST['page']))
		{
			$result_pag_data=$this->DbHandlerDynamicFun->getData("instant_domain",$select=null,$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=$_SESSION['type'],$order_by_type=$_SESSION['order'],$limit=[$per_page,$start],$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=$search,$likecolumn='domain',$distinct=false);
			
			$n = count($result_pag_data); 
			
			$rows=$this->DbHandlerDynamicFun->getData("instant_domain",$select=null,$where=null,$resultType="count_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=$search,$likecolumn='domain',$distinct=false);
			
			$no_of_paginations = ceil($rows / $per_page);
		}
			 /*Calculating the starting and endign values for the loop*/
		if ($cur_page >= 7)
		{
			$start_loop = $cur_page - 3;
			
			if($no_of_paginations > $cur_page + 3)
			$end_loop = $cur_page + 3;
			else if ($cur_page <= $no_of_paginations && $cur_page > $no_of_paginations - 6)
			{
			
				$start_loop = $no_of_paginations - 6;
				$end_loop = $no_of_paginations;
				
			} 
			else 
			{
			
				$end_loop = $no_of_paginations;
			
			}
		}
		else 
		{

			$start_loop = 1;
			
			if ($no_of_paginations > 7)
			$end_loop = 7;
			else
			$end_loop = $no_of_paginations;
			
		}

		$msg="";

		$msg .= "<div class='pagination pg-domains'><ul >";

		if ($first_btn && $cur_page > 1)
		{

			$msg .= "<li p='1' style='border-left-width: 1px;
			-webkit-border-radius: 3px 0 0 3px;
			-moz-border-radius: 3px 0 0 3px;
			 border-radius: 3px 0 0 3px;' id='active'  class='active'>First</li>";
			 
		} 
		else if ($first_btn)
		{

			$msg .= "<li p='1' style='border-left-width: 1px;
			-webkit-border-radius: 3px 0 0 3px;
			-moz-border-radius: 3px 0 0 3px;
			border-radius: 3px 0 0 3px; id='active' class='inactive'>First</li>";
			
		}

		for ($i = $start_loop; $i <= $end_loop; $i++)
		{

			if ($cur_page == $i)
			$msg .= "<li p='$i' id='active' class='active active-page'>{$i}</li>";
			else
			$msg .= "<li p='$i' id='active' class='active'>{$i}</li>";
			
		}
															/*TO ENABLE THE END BUTTON*/
		if ($last_btn && $cur_page < $no_of_paginations)
		{

			$msg .= "<li p='$no_of_paginations' id='active' class='active' style='-webkit-border-top-right-radius: 3px;-webkit-border-bottom-right-radius: 3px;-moz-border-radius-topright: 3px;-moz-border-radius-bottomright: 3px;border-top-right-radius: 3px;border-bottom-right-radius: 3px;'>Last</li>";

		}
		else if ($last_btn) 
		{

			$msg .= "<li p='$no_of_paginations' id='active' class='inactive'>Last</li>";

		}
		$msg = $msg. "</div>";
		$msg .= "<div class='total-pages'>".$cur_page." out of ".$no_of_paginations." Total : ".$rows."</div>";

		$this->load->view('admin/load_data',['msg'=>$msg,'result_pag_data'=>$result_pag_data,'n'=>$n,'search'=>$search]);
		
	}
	
	public function editAnalyticsPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$tracking_code = trim($this->input->post("tracking_code"));
		
		$myCheckbox = trim($this->input->post("my-checkbox"));
		
		if ($myCheckbox == "on")
		$status = 1;
		else
		$status = 0;
	
		$this->DbHandlerDynamicFun->updateData("analytics",['tracking_code'=>$tracking_code,'status'=>$status],$where=false,$batchColumn=false);
		
		$this->cache->file->delete('analytics');
		
		$this->compileResponse(['response'=>1]);
	}
	
	public function editAccountPost(){
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		$this->load->model('AjaxHandlerModel');
		
		$username = trim($this->input->post("username"));
		$oldpassword = trim($this->input->post("oldpassword"));
		$email = trim($this->input->post("email"));
		$contactEmail = trim($this->input->post("contactEmail"));
		$password = trim($this->input->post("password"));
		
		if(strlen($username)<3)
		{
			$this->compileResponse(['response'=>0,"reason"=>"Minimum username Length is 3 Characters."]);
		}
		else if(!$this->AjaxHandlerModel->is_alphaNumeric($username)) 
		{
			$this->compileResponse(['response'=>0,"reason"=>"Username can have only Alphanumeric Characters."]);
		} 
		else if(strlen($oldpassword)<5)
		{
			$this->compileResponse(['response'=>0,"reason"=>"Minimum Password Length is 5 Characters."]);
		}
		
		if(!filter_var($email, FILTER_VALIDATE_EMAIL))
		{
			$this->compileResponse(['response'=>0,"reason"=>"You Must Enter Valid Email."]);
		} 
		
		if(!filter_var($contactEmail, FILTER_VALIDATE_EMAIL))
		{
			$this->compileResponse(['response'=>0,"reason"=>"You Must Enter Valid Contact Email."]);
		} 
		
		$oldpasswordHash=$this->AjaxHandlerModel->secure_hash($oldpassword);
		
		$checkPass=$this->DbHandlerDynamicFun->getData("settings",$select=null,$where=['password'=>$oldpasswordHash],$resultType="count_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		if($checkPass==0) 
		{
			$this->compileResponse(['response'=>0,"reason"=>"Please enter a valid old password."]);
		}
		
		if(strlen($password)>0)
		{
			$passwordHash=$this->AjaxHandlerModel->secure_hash($password);
		}
		else
		{
			$passwordHash=$oldpasswordHash;
		}
		
		$this->DbHandlerDynamicFun->updateData("settings",['username'=>$username,'password'=>$passwordHash,'email'=>$email,'contactEmail'=>$contactEmail],$where=false,$batchColumn=false);
		
		$this->session->userInfo=['username'=>$username];
		
		$this->compileResponse(['response'=>1]);
	}	
	public function editEmailPost(){
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		  $type = trim($this->input->post("type"));
		  if($type==1)
		  {
			  $hostName = trim($this->input->post("hostName"));
			  $port = trim($this->input->post("port"));
			  $username = trim($this->input->post("username"));
			  $password = trim($this->input->post("password"));
			  $emailSMTP = trim($this->input->post("emailSMTP"));
			  if(strlen($hostName)==0 || strlen($port)==0 || strlen($username)==0 || strlen($password)==0 || strlen($emailSMTP)==0)
			  {
				   $this->compileResponse(['response'=>0,"reason"=>"Please complete all the fields of mail through SMTP"]);
			  }
			  if(!filter_var($emailSMTP, FILTER_VALIDATE_EMAIL))
			  {
				  $this->compileResponse(['response'=>0,"reason"=>"Please enter a valid SMTP Email Adrress"]);
			  }
			  $upArray=['host'=>$hostName,'port'=>$port,'username'=>$username,'password'=>$password,'type'=>$type,'emailSMTP'=>$emailSMTP];
		  }
		  else
		  {
			  $emailMailer = trim($this->input->post("emailMailer"));
			  if(!filter_var($emailMailer, FILTER_VALIDATE_EMAIL) || strlen($emailMailer)==0)
			  {
				  $this->compileResponse(['response'=>0,"reason"=>"Please enter a valid SMTP Email Adrress"]);
			  }
			   $upArray=['emailMailer'=>$emailMailer,'type'=>$type];
		  }
		  
		$this->DbHandlerDynamicFun->updateData("emailsettings",$upArray,$where=['esId'=>1],$batchColumn=false);
		
		$this->compileResponse(['response'=>1]);
	}
	
	public function tldsUpdate()
	{
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$limit = trim($_POST['SuggesstedLimit']);
		
		$days = trim($_POST['PreserveDatabase']);
		
		$instantLimit = trim($_POST['instantLimit']);
		
		$suggestedDomains = trim($_POST['suggestedDomains']);
		
		$this->DbHandlerDynamicFun->updateData("suggessted_limit",['limit'=>$limit,'preserve_days'=>$days,'instantLimit'=>$instantLimit,'suggestedDomains'=>$suggestedDomains],$where=['id'=>1],$batchColumn=false);
		$this->cache->file->delete('suggessted_limit');
		
		unset($_SESSION['tlds']);
		
		unset($_SESSION['set']);
		
		$response=['response'=>1];
		
	}
	
	function updateAffiliateStatus()
	{
		$response = array('success' => 0);
		
		$post_data = $this->input->post(NULL, TRUE);
		
		
		if(!empty($post_data['affiliates']) && sizeof($post_data['affiliates']))
		{
			$update_data = $post_data['affiliates'];
			
			
			$this->DbHandlerDynamicFun->updateData("affiliates", $update_data , false, 'id');
			$response['success'] = 1;
			$response['message'] = 'Affiliates updated successfully';
		}
		else
		{
			$response['error'] = 'Affiliates data not found';
		}
		
		echo json_encode($response);
		exit;
	}
	
	public function suggestLanguage()
	{
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$language = trim($_POST['suggest_language']);
		
		$rows=$this->DbHandlerDynamicFun->getData("suggested_language",$select=null,$where=null,$resultType="count_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		if($rows>0) 
		{
			$this->DbHandlerDynamicFun->updateData("suggested_language",['language'=>$language],$where=['id'=>1],$batchColumn=false);
		}
		else
		{
			$this->DbHandlerDynamicFun->insertData("suggested_language",['language'=>$language],$batch=false);
		}
		unset($_SESSION['tlds']);
		unset($_SESSION['set']);
		
		$response=['response'=>1];
		
	}
	public function editDomainPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		$tld = trim($_POST["main_domain"]); 
		
		$this->DbHandlerDynamicFun->updateData("main_tld",['tld'=>$tld],$where=['id'=>1],$batchColumn=false);
		$this->cache->file->delete('main_tld');
		unset($_SESSION['tlds']);
		unset($_SESSION['set']);
		
		$response=['response'=>1];
		
	}
	
	public function delTldsPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		
		$id = $_POST['id'];

		$rows=$this->DbHandlerDynamicFun->getData("tlds",$select=['tld'],$where=['id'=>$id],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		if(count($rows)>0)
		{
			$tld = $rows['tld'];
									
			/*
			$this->load->dbforge();
			$this->dbforge->drop_column('instant_domain', $tld);
			$this->dbforge->drop_column('affiliates', $tld);*/
			
			$this->DbHandlerDynamicFun->drop_column('instant_domain', $tld);
			$this->DbHandlerDynamicFun->drop_column('affiliates', $tld);
			
			
			$sql_delete =$this->DbHandlerDynamicFun->deleteData('tlds',$where=['id'=>$id]);
			
			$rows=$this->DbHandlerDynamicFun->getData("tlds",$select=['tld','server','response'],$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
			foreach($rows as $index=>$obj)
			{
				$tld = $obj['tld'];
				$records [$tld][0] = $obj['server'];
				$records [$tld][1] = $obj['response'];
			}
			
			file_put_contents("./libs/whois.servers.json", json_encode($records));
			unset($_SESSION['TldArray']);
			unset($_SESSION['tlds']);
			unset($_SESSION['set']);
		}
		
		
	}
	public function editTldPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$TldName = trim($_POST['TldName']);
		
		$status = trim($_POST['status_tld']);
		$this->DbHandlerDynamicFun->updateData("tlds",['status'=>$status],$where=['tld'=>$TldName],$batchColumn=false);
		$this->cache->file->delete('tlds');
		unset($_SESSION['TldArray']);
		unset($_SESSION['tlds']);
		unset($_SESSION['set']);
		
		$response=['response'=>1];
		
	}
	public function tldSortPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		if(isset($_POST['arrayorder']))
		{
			$array = $_POST['arrayorder'];
			
			if($_POST['update'] == "update")
			{
				$count = 1;
				
				foreach ($array as $idval)
				{
					
					$this->DbHandlerDynamicFun->updateData("tlds",['display_order'=>$count],$where=['id'=>$idval],$batchColumn=false);
					$count++;
				}
				
			}
			unset($_SESSION['tlds']);
		}
		
	}
	public function pageSortPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		if(isset($_POST['arrayorder']))
		{
			$array = $_POST['arrayorder'];
			
			if($_POST['update'] == "update")
			{
				$count = 1;
				
				foreach ($array as $idval)
				{
					
					$this->DbHandlerDynamicFun->updateData("pages",['display_order'=>$count],$where=['id'=>$idval],$batchColumn=false);
					$count++;
				}
				
			}
		}
		
	}
	public function handleUpdatePricesPost()
	{
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		if(isset($_POST['affiliate_name']) && $_POST['affiliate_name'] != "")
		{
			$url=isset($_POST['url'])?$_POST['url']:"";
			
			if(strlen($url)=="")
			$this->compileResponse(['response'=>0,'reason'=>"UnKnown access occured"]);	
			
			$affiliate_name=isset($_POST['affiliate_name'])?$_POST['affiliate_name']:"";
			
			$image=isset($_POST['image'])?$_POST['image']:"";
			
			$this->DbHandlerDynamicFun->updateData("affiliates",['url'=>$url],$where=['affiliate_name'=>$affiliate_name],$batchColumn=false);
			
			unset($_SESSION['set']);

			unset($_SESSION['affiliate_links']);
		}
		else if(isset($_POST['TldPrice']) && $_POST['TldPrice'] != "")
		{
			$Tld=isset($_POST['Tld'])?$_POST['Tld']:"";
			$TldPrice=isset($_POST['TldPrice'])?$_POST['TldPrice']:"";
			$affiliate=isset($_POST['affiliate'])?$_POST['affiliate']:"";
			
			$this->DbHandlerDynamicFun->updateData("affiliates",["$Tld"=>$Tld],$where=['affiliate_name'=>$affiliate],$batchColumn=false);
			
			unset($_SESSION['set']);

			unset($_SESSION['affiliate_links']);
		}
		else
		{
			$this->compileResponse(['response'=>0,'reason'=>"Invalid access occured"]);
		}
		
	}
	
	public function editLinkPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$id=trim($this->input->post('id'));
		if(strlen($id)==0)
		$this->compileResponse(['response'=>0,'reason'=>"Invalid access occured"]);
		
		$language=trim($this->input->post('language'));
		$permalink=trim($this->input->post('permalink'));
		if(strlen($language)==0)
		$this->compileResponse(['response'=>0,'reason'=>"Please select language"]);
		
		$title = str_replace(array('"'), '', $this->input->post("title"));
		
		$title =trim($title);
		
		$titleLang = str_replace(array('"'), '', $this->input->post("titleLang"));
		
		$titleLang =trim($titleLang);
		
		if($this->input->post("publish") == "on")
		$status = 1;
		else
		$status = 0;
		
		if($this->input->post("header_status")== "on")
			$header_status = 1;
		else
			$header_status = 0;
			
		if($this->input->post("footer_status")== "on")
			$footer_status = 1;
		else
			$footer_status = 0;
			
	
		if (strlen($title) > 70 || strlen($title) <1)
		$this->compileResponse(['response'=>0,'reason'=>"Please add link title"]);
	
		if (strlen($titleLang) > 70 || strlen($titleLang) <1)
		$this->compileResponse(['response'=>0,'reason'=>"Please add page Title"]);
	
		if (strlen($permalink) > 70 || strlen($permalink) <1)
		$this->compileResponse(['response'=>0,'reason'=>"Please add link permalink"]); 
		
		$permalink = strtolower($this->input->post("permalink"));
		$permalink = trim($permalink);
		
		if(!filter_var($permalink,FILTER_VALIDATE_URL))
		$this->compileResponse(['response'=>0,'reason'=>"Please enter a valid permalink."]);
		
		$this->DbHandlerDynamicFun->updateData('links',['title'=>$title,'status'=>$status,'header_status'=>$header_status,'footer_status'=>$footer_status,'permalink'=>$permalink],$where=['id'=>$id],$batchColumn=false);
		
		$this->DbHandlerDynamicFun->updateData('linkLanguage',['title'=>$titleLang,'permalink'=>$permalink],$where=['id'=>$id,'language'=>$language],$batchColumn=false);
		
		$this->cache->file->delete('links');
		
		$this->compileResponse(['response'=>1]);
		
		
	}
	public function addLinkPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$title = str_replace(array('"'), '', $this->input->post("title"));
		
		$title =trim($title);
		
		if($this->input->post("publish") == "on")
		$status = 1;
		else
		$status = 0;
		
		if($this->input->post("header_status")== "on")
			$header_status = 1;
		else
			$header_status = 0;
			
		if($this->input->post("footer_status")== "on")
			$footer_status = 1;
		else
			$footer_status = 0;
		
		$permalink = strtolower($this->input->post("permalink"));
		$permalink = trim($permalink);
		
		if(!filter_var($permalink,FILTER_VALIDATE_URL))
		$this->compileResponse(['response'=>0,'reason'=>"Please enter a valid permalink."]);
		
		$maxIdLinks=$this->DbHandlerDynamicFun->getData("links",$select=['MAX(display_order) as disp_order'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		$total = $maxIdLinks['disp_order'];
		
		if($total>0)
		$display_order = $total + 1;
		else
		$display_order = 1;
		
		
		if (strlen($title) > 70 || strlen($title) <1)
		$this->compileResponse(['response'=>0,'reason'=>"Please add link title"]);
	
		if (strlen($permalink) > 70 || strlen($permalink) <1)
		$this->compileResponse(['response'=>0,'reason'=>"Please add link permalink"]); 
		
		$this->DbHandlerDynamicFun->insertData('links',['title'=>$title,'permalink'=>$permalink,'status'=>$status,'display_order'=>$display_order,'header_status'=>$header_status,'footer_status'=>$footer_status],$batch=false);
		$insertId=$this->db->insert_id();
		$id = $insertId;
		
		$languages=$this->DbHandlerDynamicFun->getData("language",$select=['lang_name'],$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		$insertData=[];
		
		foreach($languages as $index=>$language)
		{
			$insertData[]=['id'=>$id,'title'=>$title,'permalink'=>$permalink,'language'=>$language['lang_name']];
		}
		
		$this->DbHandlerDynamicFun->insertData('linkLanguage',$insertData,$batch=true);
		$this->compileResponse(['response'=>1]);
	}
	
	public function addPagePost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$title = str_replace(array('"'), '', $this->input->post('title'));
		
		$title = trim($title);
		
		$content = trim($this->input->post('content'));
		
		$description = trim($this->input->post('description'));
		
		$keywords = trim($this->input->post('keywords'));
		
		if($this->input->post('publish') == "on")
		$status = 1;
		else
		$status = 0;
		
		if($this->input->post('header_status')== "on")
			$header_status = 1;
		else
			$header_status = 0;
			
		if($this->input->post('footer_status')== "on")
			$footer_status = 1;
		else
			$footer_status = 0;
		
		$this->load->model('AdminModel');
		
		if (trim($this->input->post('permalink')) != "")
			$permalink = $this->AdminModel->gen_permalink($this->input->post('permalink'));
		else
			$permalink = $this->AdminModel->gen_permalink($this->input->post('title'));
		
		if (strlen($title) > 70 || strlen($title) <1)
		$this->compileResponse(['response'=>0,'reason'=>"Please enter valid title"]);
		
		$permalink = str_replace(array('"'), '', $permalink);
		
		$maxIdPages=$this->DbHandlerDynamicFun->getData("pages",$select=['MAX(display_order) as displayMax,MAX(id) AS maxId'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		$display_order = $maxIdPages['displayMax'];
		$id = $maxIdPages['maxId'];
		
		$id=$id+1;
		
		$this->DbHandlerDynamicFun->insertData('pages',['id'=>$id,'permalink'=>$permalink,'description'=>$description,'keywords'=>$keywords,'status'=>$status,'display_order'=>$display_order,'header_status'=>$header_status,'footer_status'=>$footer_status],$batch=false);
		
		$languages=$this->DbHandlerDynamicFun->getData("language",$select=['lang_name'],$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		$insertData=[];
		
		foreach($languages as $index=>$language)
		{
			$insertData[]=['id'=>$id,'title'=>$title,'permalink'=>$permalink,'content'=>$content,'language'=>$language['lang_name']];
		}
		
		$this->DbHandlerDynamicFun->insertData('page_language',$insertData,$batch=true);
		
		$this->compileResponse(['response'=>1]);
	}
	
	
	public function editPagePost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$id=trim($this->input->post('id'));
		if(strlen($id)==0)
		$this->compileResponse(['response'=>0,'reason'=>"Invalid access occured"]);
		
		$title = str_replace(array('"'), '', $this->input->post('title'));
		
		$title = trim($title);
		
		$content = trim($this->input->post('content'));
		
		$description = trim($this->input->post('description'));
		
		$keywords = trim($this->input->post('keywords'));
		
		if($this->input->post('publish') == "on")
		$status = 1;
		else
		$status = 0;
		
		if($this->input->post('header_status')== "on")
			$header_status = 1;
		else
			$header_status = 0;
			
		if($this->input->post('footer_status')== "on")
			$footer_status = 1;
		else
			$footer_status = 0;
		
		$this->load->model('AdminModel');
		
		$permalink=$this->input->post('permalink');
		if (strlen($permalink) > 70 || strlen($permalink) < 1)
		$this->compileResponse(['response'=>0,'reason'=>"Invalid permalink"]);
	
		$permalink = $this->AdminModel->gen_permalink($permalink);
		
		$permalink = str_replace(array('"'), '', $permalink);
		
		$selectedLanguage=trim($this->input->post('language'));
		
		if($permalink == "home") 
		{
			$this->DbHandlerDynamicFun->updateData('pages',['description'=>$description,'keywords'=>$keywords,'header_status'=>$header_status,'footer_status'=>$footer_status],$where=['id'=>$id],$batchColumn=false);
			$this->cache->file->delete('pages');
		}
		else 
		{
			$this->DbHandlerDynamicFun->updateData('pages',['permalink'=>$permalink,'description'=>$description,'keywords'=>$keywords,'status'=>$status,'header_status'=>$header_status,'footer_status'=>$footer_status],$where=['id'=>$id],$batchColumn=false);
			$this->cache->file->delete('pages');
			$this->DbHandlerDynamicFun->updateData('page_language',['permalink'=>$permalink],$where=['id'=>$id],$batchColumn=false);
			
		}
		
		if(strlen($selectedLanguage)>0)
		{
			$content=trim($this->input->post('content'));
			$title=trim($this->input->post('title'));
			$this->DbHandlerDynamicFun->updateData('page_language',['content'=>$content,'title'=>$title],$where=['id'=>$id,'language'=>$selectedLanguage],$batchColumn=false);
			
		}
		
		$this->compileResponse(['response'=>1]);
	}
	
	public function delPagePost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$id=trim($this->input->post('id'));
		if(strlen($id)==0)
		$this->compileResponse(['response'=>0,'reason'=>"Invalid access occured"]);
		
		$this->DbHandlerDynamicFun->deleteData('pages',$where=['id'=>$id]);
		$this->DbHandlerDynamicFun->deleteData('page_language',$where=['id'=>$id]);
	}
	
	public function delLinkPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$id=trim($this->input->post('id'));
		if(strlen($id)==0)
		$this->compileResponse(['response'=>0,'reason'=>"Invalid access occured"]);
		
		$this->DbHandlerDynamicFun->deleteData('links',$where=['id'=>$id]);
		$this->DbHandlerDynamicFun->deleteData('linkLanguage',$where=['id'=>$id]);
		
	}
	
	public function updatePricesAffiliate()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		$updateArray=[];
		
		$postedResults=$this->input->post();
		
		if(count($postedResults)==0)
		$this->compileResponse(['response'=>0,'reason'=>"Invalid access occured"]);
		
		$affiliate_name=$postedResults["affiliate_name"];
		
		$columnRecord=$this->DbHandlerDynamicFun->rawQuery("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = 'affiliates'",$resultType="all_array");
		
		foreach($columnRecord as $index=>$value)
		{
			$tld=$value['COLUMN_NAME'];
			
			if(array_key_exists($tld,$postedResults) && $tld!='affiliate_name')
			{
				$tldPrice=$postedResults[$tld];
				$updateArray[]=["$tld"=>$tldPrice,'affiliate_name'=>$affiliate_name];
			}
		}
		$this->DbHandlerDynamicFun->updateData('affiliates',$updateArray,$where=false,$batchColumn='affiliate_name');
		$this->compileResponse(['response'=>1]);
	}
	
	public function affiliateSortingsPost()
	{
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$array = $_POST['arrayorder'];
		$updateArray=[];
	
		if($_POST['update'] == "update")
		{
			if(is_array($array))
			{
				if(count($array)>0)
				{
					$count=1;
					foreach($array as $idval)
					{
						$updateArray[]=["displayOrder"=>$count,'id'=>$idval];
						$count++;
					}
					
					$this->DbHandlerDynamicFun->updateData('affiliates',$updateArray,$where=false,$batchColumn='id');
					
				}
			}
			
		}
	}
	
	public function sortLinksPost()
	{
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$array = $_POST['arrayorder'];
		$updateArray=[];
	
		if($_POST['update'] == "update")
		{
			if(is_array($array))
			{
				if(count($array)>0)
				{
					$count=1;
					foreach($array as $idval)
					{
						$updateArray[]=["display_order"=>$count,'id'=>$idval];
						$count++;
					}
					
					$this->DbHandlerDynamicFun->updateData('links',$updateArray,$where=false,$batchColumn='id');
					
				}
			}
			
		}
	}
	public function updateOrderLangauges()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$array = $_POST['arrayorder'];
		$updateArray=[];
	
		if($_POST['update'] == "update")
		{
			if(is_array($array))
			{
				if(count($array)>0)
				{
					$count=1;
					foreach($array as $idval)
					{
						$updateArray[]=["display_order"=>$count,'id'=>$idval];
						$count++;
					}
					$this->DbHandlerDynamicFun->updateData('language',$updateArray,$where=false,$batchColumn='id');
				}
			}
			
		}
	}
	public function delLangPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$file = trim($this->input->post('language_file'));
		$language = trim($this->input->post('language_name'));
		if(strlen($file)>0 && strlen($language)>0)
		{
			$this->DbHandlerDynamicFun->deleteData('page_language',$where=['language'=>$language]);
			$this->DbHandlerDynamicFun->deleteData('language',$where=['lang_name'=>$language]);
			if(file_exists('./language/'.$file))
			unlink('./language/'.$file);
			$this->cache->file->delete('language');
			unset($_SESSION['defaultLanguage']);
		}
	}
	public function editCachePost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$id=trim($this->input->post('id'));
		if(strlen($id)==0)
		$this->compileResponse(['response'=>0,'reason'=>"Invalid access occured"]);
		
		$tldCacheEnable = ($this->input->post('tldCacheEnable') == 'on') ? 1 : 0;
		
		$tldCacheExpireTime = trim($this->input->post('tldCacheExpireTime'));
		
		$suggestCacheEnable = (trim($this->input->post('suggestCacheEnable')) == 'on') ? 1 : 0;
		
		$suggestCacheExpireTime = trim($this->input->post('suggestCacheExpireTime'));
		
		if(!is_numeric($tldCacheExpireTime) || !is_numeric($suggestCacheExpireTime))
		$this->compileResponse(['response'=>0,'reason'=>"Please enter a numeric cache expiry time"]);
		
		$cacheSettings=$this->DbHandlerDynamicFun->getData("cache_settings",$select=null,$where=['id'=>$id],$resultType="count_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		if(count($cacheSettings)==0) 
		$this->compileResponse(['response'=>0,'reason'=>"InValid access"]);
		
		$this->DbHandlerDynamicFun->updateData('cache_settings',['tld_status'=>$tldCacheEnable,'tld_time'=>$tldCacheExpireTime,'suggest_status'=>$suggestCacheEnable,'suggest_time'=>$suggestCacheExpireTime],$where=['id'=>$id],$batchColumn=false);
		$this->compileResponse(['response'=>1]);
		
	
	unset($_SESSION['cache_time']);
	

	}	
	public function addLanguage()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
			$error = false;
			
			$array = array();	
			$array['Contact Us']=trim($this->input->post('contact_us'));
			$array['Contact']=trim($this->input->post('contact'));
			$array['Search']=trim($this->input->post('search'));
			$array['Placeholder']=trim($this->input->post('placeholder'));
			$array['Buy']=trim($this->input->post('buy'));
			$array['WhoIs']=trim($this->input->post('whois'));
			$array['More TLDs']=trim($this->input->post('more_tld'));
			$array['Suggested Domains']=trim($this->input->post('suggessted_domain'));
			$array['Buy Now']=trim($this->input->post('buynow'));
			$array['Name']=trim($this->input->post('name'));
			$array['Enter Your Name']=trim($this->input->post('enter_your_name'));
			$array['Email Address']=trim($this->input->post('email_address'));
			$array['Enter Your Email']=trim($this->input->post('email_your_email'));
			$array['Subject']=trim($this->input->post('subject'));
			$array['Enter a Subject']=trim($this->input->post('enter_subject'));
			$array['Enter Captcha Code']=trim($this->input->post('enter_captcha_code'));
			$array['Enter Code']=trim($this->input->post('enter_code'));
			$array['Your Message']=trim($this->input->post('your_message'));
			$array['Enter Your Message']=trim($this->input->post('enter_your_message'));
			$array['Send Message']=trim($this->input->post('send_message'));
			$array['Powered By']=trim($this->input->post('powered_by'));
			$array['All Rights Reserved']=trim($this->input->post('right_reserved'));
			$array['Incorrect Information']=trim($this->input->post('incorrect_information'));
			$array['Invalid Captcha']=trim($this->input->post('invalid_captcha'));
			$array['Empty Captcha']=trim($this->input->post('empty_captcha'));
			$array['Success Contact Message']=trim($this->input->post('success_contact'));
			$array['Invalid Email']=trim($this->input->post('invalid_email'));
			$array['Invalid Name']=trim($this->input->post('invalid_name'));
			$array['Language']=trim($this->input->post('language'));
			$array['social_message']=trim($this->input->post('social_message'));
			$array['oops']=trim($this->input->post('oops'));
			$array['404-page-not-found']=trim($this->input->post('404-page-not-found'));
			$array['take-me-home']=trim($this->input->post('take-me-home'));
			$array['email_required']=trim($this->input->post('email_required'));
			$array['name_required']=trim($this->input->post('name_required'));
			$array['message_required']=trim($this->input->post('message_required'));
			$array['field_empty']=trim($this->input->post('field_empty'));
			$array['notavailable']=trim($this->input->post('notavailable'));
			$array['embed']=trim($this->input->post('embed'));
			$language_name = str_replace(array('"'), '', $this->input->post('language_name'));
			$language_name=trim($language_name);
			
			if($this->input->post('rtl_status')=="on") 
			$RTL_status =1;
			else
			$RTL_status =0;	
			
			
			if($language_name == 'lang_array')
			$this->compileResponse(['response'=>0,'reason'=>'Invalid access occured']);
		
			$checkLanguageName=$this->DbHandlerDynamicFun->getData("language",$select=null,$where=['lang_name'=>$language_name],$resultType="count_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
			if($checkLanguageName>0)
			$this->compileResponse(['response'=>0,'reason'=>'Language name already exists']);
			
			$fetch_id=$this->DbHandlerDynamicFun->getData("language",$select=['MAX(id) AS id'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
			if(count($fetch_id)==0)
			$this->compileResponse(['response'=>0,'reason'=>'Invalid access occured']);
			
			$id = $fetch_id["id"];				
			$id=$id+1;
			
			$encode=json_encode($array);
			$lang_file = $language_name.".php";
			$myfile = fopen("./language/".$lang_file, "w");
			fwrite($myfile,$encode);
			fclose($myfile);
		
			
			
			$this->DbHandlerDynamicFun->insertData('language',['lang_name'=>$language_name,'lang_file'=>$lang_file,'status'=>1,'display_order'=>$id,'RTL_status'=>$RTL_status],$batch=false);
		
			$default_langauge=$this->DbHandlerDynamicFun->getData("language",$select=['lang_name'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col='display_order',$order_by_type='asc',$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
			$default_langauge = $default_langauge['lang_name'];
			
			$dbData=$this->DbHandlerDynamicFun->getData("page_language",$select=['DISTINCT(permalink)','title','content','id'],$where=['language'=>$default_langauge],$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
			foreach($dbData as $index=>$rows)
			{
				$id = $rows['id'];
				$permalink = $rows['permalink'];
				$title = $rows['title'];
				$content = $rows['content'];
				
				$this->DbHandlerDynamicFun->insertData('page_language',['id'=>$id,'title'=>$title,'content'=>$content,'language'=>$language_name],$batch=false);
		
			} 
			$this->cache->file->delete('language');
			unset($_SESSION['defaultLanguage']);
			$this->compileResponse(['response'=>1]);
	}
	public function editCaptchaPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$id=trim($this->input->post('id'));
		if(strlen($id)==0)
		$this->compileResponse(['response'=>0,'reason'=>"Invalid access occured"]);
		
		$contact_enable = trim($this->input->post('contact_status'));
		$login_enable = trim($this->input->post('login_status'));
		
		if ($contact_enable == "on") 
		$contact_enable = 1;
		else 
		$contact_enable = 0;
		if ($login_enable == "on") 
		$login_enable = 1;
		else
		$login_enable = 0;
		unset($_SESSION['contact_captcha_status']);
		$this->DbHandlerDynamicFun->updateData('captcha_settings',
		['captcha_contact_status'=>$contact_enable,'captcha_admin_login_status'=>$login_enable, 
		'recaptcha_key' => $this->input->post("recaptcha_key"),
		'recaptcha_secret' => $this->input->post("recaptcha_secret"),
		]
		,$where=['id'=>$id],$batchColumn=false);
		$this->compileResponse(['response'=>1]);	
	}
	
	public function editSocialSettingsPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$f_status = trim($this->input->post('f_status'));
		$t_status = trim($this->input->post('t_status'));
		$g_status = trim($this->input->post('g_status'));
		$all_status = trim($this->input->post('all_status'));
		$facebook = trim($this->input->post('facebook'));
		$twitter = trim($this->input->post('twitter'));
		$google = trim($this->input->post('google'));
		
		if($f_status == "on")
		$f_status = 1;
		else
		$f_status = 0;
		
		if($t_status == "on")
		$t_status = 1;
		else
		$t_status = 0;
		
		if($g_status == "on")
		$g_status = 1;
		else
		$g_status = 0;
		
		if($all_status == "on")
		$all_status = 1;
		else
		$all_status = 0;
		
		if($facebook!="")
		{
			$this->load->model('AdminModel');
			
			if(!$this->AdminModel->valid_facebook_url($facebook))
			$this->compileResponse(['response'=>0,'reason'=>'Invalid access occured']);
		}
		if($twitter!="")
		{
			$this->load->model('AdminModel');
			
			if(!$this->AdminModel->valid_twitter_username($twitter))
			$this->compileResponse(['response'=>0,'reason'=>'Invalid access occured']);
			
		}
		if($google!="")
		{
			$this->load->model('AdminModel');
			
			if(!$this->AdminModel->valid_google_url($google))
			$this->compileResponse(['response'=>0,'reason'=>'Invalid access occured']);
			
		}
		
		
		$this->DbHandlerDynamicFun->updateData('social_profiles',['facebook'=>$facebook,'twitter'=>$twitter,'google_plus'=>$google,'f_status'=>$f_status,'t_status'=>$t_status,'g_status'=>$g_status,'social_buttons'=>$all_status],$where=false,$batchColumn=false);
		$this->cache->file->delete('social');
		$this->compileResponse(['response'=>1]);
	}
	
	public function editCurrencyPost()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$cr_name = trim($this->input->post('dollor'));
		$price_dollor = trim($this->input->post('currency'));
		$show = trim($this->input->post('show_place'));
		
		if(!is_numeric($price_dollor))
		$this->compileResponse(['response'=>0,'reason'=>'Invalid Currency']);
		
		if(strlen($cr_name) > 50)
		$this->compileResponse(['response'=>0,'reason'=>'Currency symbol length must be less than 50']);
	
		if(strlen($price_dollor) > 15)
		$this->compileResponse(['response'=>0,'reason'=>'Invalid US-dollor price']);
	
		unset($_SESSION['currency']);
		unset($_SESSION['set']);
		unset($_SESSION['affiliate_links']);
		
		$this->DbHandlerDynamicFun->updateData('currency_settings',['cr_name'=>$cr_name,'price_dollor'=>$price_dollor,'show_place'=>$show],$where=false,$batchColumn=false);
		$this->cache->file->delete('currency_settings');
		$this->compileResponse(['response'=>1]);
	}	
	public function editLanguage()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
			$error = false;
			
			$id=trim($this->input->post('id'));
			
			if(!isset($id) || strlen($id)==0)
			$error="Invalid access occured";
			
			
			$array = array();	
			$array['Contact Us']=trim($this->input->post('contact_us'));
			$array['Contact']=trim($this->input->post('contact'));
			$array['Search']=trim($this->input->post('search'));
			$array['Placeholder']=trim($this->input->post('placeholder'));
			$array['Buy']=trim($this->input->post('buy'));
			$array['WhoIs']=trim($this->input->post('whois'));
			$array['More TLDs']=trim($this->input->post('more_tld'));
			$array['Suggested Domains']=trim($this->input->post('suggessted_domain'));
			$array['Buy Now']=trim($this->input->post('buynow'));
			$array['Name']=trim($this->input->post('name'));
			$array['Enter Your Name']=trim($this->input->post('enter_your_name'));
			$array['Email Address']=trim($this->input->post('email_address'));
			$array['Enter Your Email']=trim($this->input->post('email_your_email'));
			$array['Subject']=trim($this->input->post('subject'));
			$array['Enter a Subject']=trim($this->input->post('enter_subject'));
			$array['Enter Captcha Code']=trim($this->input->post('enter_captcha_code'));
			$array['Enter Code']=trim($this->input->post('enter_code'));
			$array['Your Message']=trim($this->input->post('your_message'));
			$array['Enter Your Message']=trim($this->input->post('enter_your_message'));
			$array['Send Message']=trim($this->input->post('send_message'));
			$array['Powered By']=trim($this->input->post('powered_by'));
			$array['All Rights Reserved']=trim($this->input->post('right_reserved'));
			$array['Incorrect Information']=trim($this->input->post('incorrect_information'));
			$array['Invalid Captcha']=trim($this->input->post('invalid_captcha'));
			$array['Empty Captcha']=trim($this->input->post('empty_captcha'));
			$array['Success Contact Message']=trim($this->input->post('success_contact'));
			$array['Invalid Email']=trim($this->input->post('invalid_email'));
			$array['Invalid Name']=trim($this->input->post('invalid_name'));
			$array['Language']=trim($this->input->post('language'));
			$array['social_message']=trim($this->input->post('social_message'));
			$array['oops']=trim($this->input->post('oops'));
			$array['404-page-not-found']=trim($this->input->post('404-page-not-found'));
			$array['take-me-home']=trim($this->input->post('take-me-home'));
			$array['email_required']=trim($this->input->post('email_required'));
			$array['name_required']=trim($this->input->post('name_required'));
			$array['message_required']=trim($this->input->post('message_required'));
			$array['field_empty']=trim($this->input->post('field_empty'));
			$array['notavailable']=trim($this->input->post('notavailable'));
			$array['embed']=trim($this->input->post('embed'));
			$language_name = str_replace(array('"'), '', $this->input->post('language_name'));
			$language_name=trim($language_name);
			
			if($this->input->post('lang_status')=="on") 
			$lang_status =1;
			else
			$lang_status =0;
		
			if($this->input->post('rtl_status')=="on") 
			$RTL_status =1;
			else
			$RTL_status =0;	
			
			$language=$this->DbHandlerDynamicFun->getData("language",$select=['lang_name','lang_file'],$where=['id'=>$id],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
			$old_language = $language['lang_name'];
			$lang_file = $language['lang_file'];
			
			if(!$error && $language_name != 'lang_array' && strlen($lang_file)!=0)
			{
				
				$this->DbHandlerDynamicFun->updateData('language',['status'=>$lang_status,'lang_name'=>$language_name,'RTL_status'=>$RTL_status],$where=['lang_file'=>$lang_file],$batchColumn=false);
				
				$this->DbHandlerDynamicFun->updateData('page_language',['language'=>$language_name],$where=['language'=>$old_language],$batchColumn=false);
				$this->DbHandlerDynamicFun->updateData('linklanguage',['language'=>$language_name],$where=['language'=>$old_language],$batchColumn=false);
				$this->cache->file->delete('language');
				$encode=json_encode($array);
				file_put_contents("./language/".$lang_file,$encode);
				unset($_SESSION['defaultLanguage']);
			}
			else
			{
				$error = "Unknown access occured";
			}
			
			if($error)
			{
				$this->compileResponse(['response'=>0,'reason'=>$error]);
			}
			else
			{
				$this->compileResponse(['response'=>1]);
				
			}
	}
	public function tldUpdatePost()
	{
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
	
		$id=isset($_POST['id'])?$_POST['id']:"";

		if (!is_numeric($id))
		$this->compileResponse(['response'=>0,'reason'=>"UnKnown access occured"]);	
	
		$id = (int) trim($_POST['id']);
		$tlds=$this->DbHandlerDynamicFun->getData("tlds",$select=['tld'],$where=['id'=>$id],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		if(count($tlds)==0)
		$this->compileResponse(['response'=>0,'reason'=>"UnKnown access occured"]);	
		
		$server = isset($_POST['server'])?trim($_POST["server"]):"";
		
		$tld =  isset($_POST['tld'])?trim($_POST["tld"]):"";
		
		$tld = preg_replace( "/^\.+|\.+$/", "", $tld);
		
		$response = isset($_POST['response'])?trim($_POST["response"]):"";
		
		if($server == "" || $response == "" || $tld == "")
		$this->compileResponse(['response'=>0,'reason'=>"UnKnown access occured"]);
		
		$WhoisTld = $tlds['tld'];
		$fields = array(
			"$WhoisTld" => array(
					'name' => "$tld",
					'type' => 'VARCHAR(10) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL',
			)
		);
		
		$this->load->dbforge();
		
		$this->dbforge->modify_column('affiliates', $fields);
		
		
		$fields = array(
			"$WhoisTld" => array(
					'name' => "$tld",
					'type' => 'TINYINT(1) NOT NULL',
			)
		);
		$this->dbforge->modify_column('instant_domain', $fields);
		
		$this->DbHandlerDynamicFun->updateData("tlds",['server'=>$server,'tld'=>$tld,'response'=>$response],$where=['id'=>$id],$batchColumn=false);
		
		$rows=$this->DbHandlerDynamicFun->getData("tlds",$select=['tld','server','response'],$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
	
		foreach($rows as $index=>$obj)
		{
			$tld = $obj['tld'];
			$records [$tld][0]= $obj['server'];
			$records [$tld][1]= $obj['response'];
		}
		
		file_put_contents("./libs/whois.servers.json", json_encode($records));
		unset($_SESSION['TldArray']);
		unset($_SESSION['tlds']);
		unset($_SESSION['set']);
			
		$this->compileResponse(['response'=>1]);
	
	}	
	public function loadAffilatePrices()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
		$image=isset($_POST['image'])?trim($_POST['image']):"";

		$affiliate=isset($_POST['image'])?trim($_POST['affiliate']):"";
		if(strlen($affiliate)==0)
		$this->compileResponse(['response'=>0,'reason'=>"UnKnown access occured"]);
		
		$data=[];
		$data['image']=$image;
		$data['affiliate']=$affiliate;
		$data['rows']=$this->DbHandlerDynamicFun->getData("affiliates",$select=null,$where=['affiliate_name'=>$affiliate],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		$data['tlds']=$this->DbHandlerDynamicFun->getData("tlds",$select=null,$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		$this->load->view('admin/affilatePrices',$data,false);
		
	}
	public function addTldPost()
	{
		
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		
			$error=false;
			$server = isset($_POST["server"]) ? trim($_POST["server"]):"";
			
			$tld = isset($_POST["tld"]) ?  trim($_POST["tld"]):"";
			
			$tld = preg_replace( "/^\.+|\.+$/", "", $tld);
			
			$response =  isset($_POST["response"]) ? trim($_POST["response"]):"";
			
			$count=$this->DbHandlerDynamicFun->getData("tlds",$select=['tld'],$where=['tld'=>$tld],$resultType="count_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
			if($count > 0)
				$error = "TLD already exist !";
			
			if($server == "" || $tld == "" || $response == "" && !$error)
				$error = "Please Fill Empty Fields !";
			
			if(!$error)
			{	
				$totalArr=$this->DbHandlerDynamicFun->getData("tlds",$select=['MAX(display_order) AS disp_order'],$where=['tld'=>$tld],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
				
				$total = $totalArr["disp_order"];

				if($total>0)
					$display_order = $total + 1;
				else
				$display_order = 1;
			
				$this->DbHandlerDynamicFun->insertData("tlds",['tld'=>$tld,'server'=>$server,'response'=>$response,'status'=>1,'display_order'=>$display_order],$batch=false);
				
				$this->load->dbforge();
				$fields = array(
					$tld => array('type' => 'TINYINT(1) NOT NULL')
				);
				$this->dbforge->add_column('instant_domain', $fields);
				
				$fields = array(
				 $tld => array('type' => 'VARCHAR(10) NOT NULL')
				);
				$this->dbforge->add_column('affiliates', $fields);
				
				$rows=$this->DbHandlerDynamicFun->getData("tlds",$select=['tld','server','response'],$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
				foreach($rows as $index=>$obj)
				{
					$tld = $obj['tld'];
					$records [$tld][0]= $obj['server'];
					$records [$tld][1]= $obj['response'];
				}
			
				file_put_contents("./libs/whois.servers.json", json_encode($records));
				unset($_SESSION['TldArray']);
				unset($_SESSION['tlds']);
				unset($_SESSION['set']);
				$response=['response'=>1];
				$this->cache->file->delete('tlds');
			}
			else
			{
				$response=['response'=>0,'reason'=>$error];
			}
	
		$this->compileResponse($response);
	}
	
	public function siteSetingsUpdate()
	{
		if(!checkLoginCookie('post'))
		{
			$this->compileResponse(['response'=>3]);
		}
		$error=false;
		$this->load->model('AjaxHandlerModel');
		
		$name=strip_tags(htmlspecialchars($this->input->post('name')));

		$title       = strip_tags(htmlspecialchars($this->input->post('title')));

		$description = strip_tags(htmlspecialchars($this->input->post('description')));

		$keywords    = strip_tags(htmlspecialchars($this->input->post('keywords')));

		$whois_link    = strip_tags(htmlspecialchars($this->input->post('whois_link')));

		$rootpath    = rtrim(trim($this->input->post('base_url')), "/");

		$f_loader = ($this->input->post('f_loader')=="on") ? 1 : 0;

		$p_loader = ($this->input->post('p_loader')=="on") ? 1 : 0;

		$whoisStatus = ($this->input->post('whoisStatus')=="on") ? 1 : 0;

		if($this->input->post('name')!="" && !$error)
		{

			if($this->AjaxHandlerModel->is_alpha($this->input->post('name')))
			$name = $this->input->post('name');
			else
			$error ="Invalid website name <br />";

		}
		if($this->input->post('title')!="" && !$error)
		{
			if($this->AjaxHandlerModel->valid_title($this->input->post('title')))
			$title = $this->input->post('title');
			else
			$error ="Invalid website title <br />";
		}
		if($this->input->post('description')!="" && !$error)
		{
			if($this->AjaxHandlerModel->valid_desc($this->input->post('description')))
			$description = $this->input->post('description');
			else
			$error ="Invalid website description <br />";

		}
		if($this->input->post('keywords')!="" && !$error)
		{
			if($this->AjaxHandlerModel->valid_keyword($this->input->post('keywords')))
			$keywords = $this->input->post('keywords');
			else
			$error ="Invalid website keywords <br />";

		}
		
		$settings=$this->DbHandlerDynamicFun->getData("settings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		if (isset($_FILES["mylogo"]) && trim($_FILES["mylogo"]["name"]) != "" && !$error)
		{

			$base = explode(".", strtolower(basename($_FILES["mylogo"]["name"])));

			$ext  = end($base);

			if ($this->AjaxHandlerModel->valid_file_extension($ext))
			{

				$logo = "logo." . $ext;

				unlink("./style/images/" .  $settings['logo']);

				move_uploaded_file($_FILES["mylogo"]["tmp_name"], "./style/images/" . $logo);

			}
			else
			{

				$logo = $settings['logo'];

				$error ="Invalid website logo <br />";

			}

		}
		else
		{

			$logo = $settings['logo'];

		}
		if (isset($_FILES["myfavicon"]) && trim($_FILES["myfavicon"]["name"]) != "" && !$error)
		{
			$base = explode(".", strtolower(basename($_FILES["myfavicon"]["name"])));

			$ext  = end($base);

			if ($this->AjaxHandlerModel->valid_file_extension($ext))
			{

				$favicon = "favicon." . $ext;

				unlink("./style/images/" . $settings['favicon']);

				move_uploaded_file($_FILES["myfavicon"]["tmp_name"], "./style/images/" . $favicon);

			}
			else
			{
				$favicon = $settings['favicon'];

				$error ="Invalid website favicon <br />";
			}
		}
		else
		{
			$favicon = $settings['favicon'];
		}

		if(!$error)
		{
			$response=['response'=>1];
			$this->DbHandlerDynamicFun->updateData("settings",['name'=>$name,'title'=>$title,'description'=>$description,'keywords'=>$keywords,'rootpath'=>$rootpath,'logo'=>$logo,'favicon'=>$favicon,'f_loader'=>$f_loader,'p_loader'=>$p_loader,'whois_url'=>$whois_link,'whoisStatus'=>$whoisStatus],$where=false,$batchColumn=false);
			$this->cache->file->delete('settings');
			
		}
		else
		{
			$response=['response'=>0,'reason'=>$error];
		}
		
		$this->compileResponse($response);
		
	}
	public function compileResponse($response)
	{
		echo json_encode($response);
		exit;
	}
	}