<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class AdminHandler extends CI_Controller{
	public function loadaPage($pageName)
	{
		
		$securePages=['stats','settings','ads','domains','tlds','manageAffiliates','whois','manageAffiliatesSortings','addLink','addPage','manageLanguages','manageLinks','managePages','addLanguage','editLink','manageCache','manageTlds','manageCaptcha','editwhois','editLanguage','manageCurrency','manageSitemaps','manageAccount','manageEmailSettings','manageAnalytics','manageSocialProfiles','editPage'];
		$unsecurePages=['login'];
		$pageCMet=false;
		
		if(in_array($pageName,$securePages))
		{
			checkLoginCookie();
			$pageCMet=true;
		}
		
		if(in_array($pageName,$unsecurePages))
		{
			if(checkLoginCookie($type="get",$isUnsecure=true))
			{
				redirect('');
			}
			$pageCMet=true;
		}
		
		if($pageCMet==false)
		show_404();
	
		$data=$this->DbHandlerDynamicFun->getData("settings",$select=['title','favicon','p_loader'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
		
		if($pageName=="stats")
		{
			$this->DbHandlerDynamicFun->disable_full_group_by();
			$data['stats']=$this->DbHandlerDynamicFun->getData("stats",$select=['date','pageviews',"unique_hits","affiliates_hits","sum(total_searches) as total_searches"],$where=['date >= CURDATE() - INTERVAL 6 DAY'],$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col="date",$order_by_type="asc",$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby='date',$like=null,$likecolumn=null,$distinct=false);
			
			$data['result_total_month']=$this->DbHandlerDynamicFun->getData("stats",$select=['SUM(pageviews) AS pageviews','SUM(affiliates_hits) AS affiliates_hits','SUM(unique_hits) AS unique_hits',"sum(total_searches) as total_searches",'date'],$where=['YEAR(date) = YEAR(CURDATE()) AND MONTH(date) = MONTH(CURDATE())'],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
			$data['result_total']=$this->DbHandlerDynamicFun->getData("stats",$select=['SUM(pageviews) AS pageviews','SUM(affiliates_hits) AS affiliates_hits','SUM(unique_hits) AS unique_hits',"sum(total_searches) as total_searches"],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="settings")
		{
			$data['settings']=$this->DbHandlerDynamicFun->getData("settings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageCache")
		{
			$data['cache']=$this->DbHandlerDynamicFun->getData("cache_settings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageSitemaps")
		{
			$data['sitemap']=$this->DbHandlerDynamicFun->getData("sitemaps",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageCaptcha")
		{
			$data['captcha']=$this->DbHandlerDynamicFun->getData("captcha_settings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageAccount")
		{
			$data['account']=$this->DbHandlerDynamicFun->getData("settings",$select=['username','email','contactEmail'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageEmailSettings")
		{
			$data['emailSettings']=$this->DbHandlerDynamicFun->getData("emailsettings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageAnalytics")
		{
			$data['analytics']=$this->DbHandlerDynamicFun->getData("analytics",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageCurrency")
		{
			$data['currency']=$this->DbHandlerDynamicFun->getData("currency_settings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageSocialProfiles")
		{
			$data['socialProfiles']=$this->DbHandlerDynamicFun->getData("social_profiles",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageLanguages")
		{
			$data['languages']=$this->DbHandlerDynamicFun->getData("language",$select=null,$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col='display_order',$order_by_type='asc',$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="manageLinks")
		{
			$data['links']=$this->DbHandlerDynamicFun->getData("links",$select=null,$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col='display_order',$order_by_type='asc',$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="managePages")
		{
			$data['pages']=$this->DbHandlerDynamicFun->getData("pages",$select=null,$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col='display_order',$order_by_type='asc',$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		if($pageName=="whois")
		{
			$data['whoisServerList']=$this->DbHandlerDynamicFun->getData("whoisserverlist",$select=['name','whois','response'],$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
		}
		
		if($pageName=="manageTlds" || $pageName=="tlds")
		{
			if($pageName=="manageTlds")
			{
				$order_by_ColVal="display_order";
				$order_by_typeVal="asc";
			}
			else
			{
				$order_by_ColVal=null;
				$order_by_typeVal=null;
			}	
			
			$data['tlds']=$this->DbHandlerDynamicFun->getData("tlds",$select=['tld','id','status'],$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=$order_by_ColVal,$order_by_type=$order_by_typeVal,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		
		if($pageName=="tlds")
		{
			$data['main_tld']=$this->DbHandlerDynamicFun->getData("main_tld",$select=['tld'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			$data['suggested_language']=$this->DbHandlerDynamicFun->getData("suggested_language",$select=['language'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			$data['suggessted_limit']=$this->DbHandlerDynamicFun->getData("suggessted_limit",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		
		if($pageName=="ads")
		{
			$data['ads']=$this->DbHandlerDynamicFun->getData("ads",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		}
		
		if($pageName=="manageAffiliates" || $pageName=="manageAffiliatesSortings")
		{
			if($pageName=="manageAffiliates" )
			{
				$select=['id', 'status', 'affiliate_name', 'affiliate_title'];
			}
			else
			{
				$select=['id','affiliate_name','affiliate_title','status','displayOrder'];
			}
		
			$data['affiliates']=$this->DbHandlerDynamicFun->getData("affiliates",$select,$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col='displayOrder',$order_by_type='asc',$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
			
		}
		
		if( $pageName=="editwhois")
		{
			$id=$this->uri->segment(4);
			
			if(strlen($id)==0)
			show_404();
			
			$data['tlds']=$this->DbHandlerDynamicFun->getData("tlds",$select=null,$where=['id'=>$id],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
			if(count($data['tlds'])==0)
				show_404();
		}
		
		if( $pageName=="editLink")
		{
			$id=$this->uri->segment(4);
			
			if(strlen($id)==0)
			show_404();
			
			$data['link']=$this->DbHandlerDynamicFun->getData("links",$select=null,$where=['id'=>$id],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
			if(count($data['link'])==0)
			show_404();
		
		
			$languages=$this->DbHandlerDynamicFun->getData("language",$select=['lang_name'],$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
			$data['languages']=$languages;
			$pageLanguage=[];
			
			if(isset($_GET['language']))
			{
				$language = trim($_GET['language']);
				if(strlen($language)>0)
				{
					$pageLanguage=$this->DbHandlerDynamicFun->getData("linkLanguage",$select=null,$where=['language'=>$language,'id'=>$id],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
					$data['language']=$language;
				}
			}
			$data['pageLanguage']=$pageLanguage;
			$data['id']=$id;
		
		}
		
		if( $pageName=="editPage")
		{
			$id=$this->uri->segment(4);
			
			if(strlen($id)==0)
			show_404();
			
			$data['pages']=$this->DbHandlerDynamicFun->getData("pages",$select=null,$where=['id'=>$id],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
			
			if(count($data['pages'])==0)
			show_404();
			
			$languages=$this->DbHandlerDynamicFun->getData("language",$select=['lang_name'],$where=null,$resultType="all_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
			$data['languages']=$languages;
			$pageLanguage=[];
			
			if(isset($_GET['language']))
			{
				$language = trim($_GET['language']);
				if(strlen($language)>0)
				{
					$pageLanguage=$this->DbHandlerDynamicFun->getData("page_language",$select=null,$where=['language'=>$language,'id'=>$id],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
					$data['language']=$language;
				}
			}
			$data['pageLanguage']=$pageLanguage;
			$data['id']=$id;
		}
		if( $pageName=="editLanguage")
		{
			$id=$this->uri->segment(4);
			
			if(strlen($id)==0)
			show_404();
			
			$language=$this->DbHandlerDynamicFun->getData("language",$select=['lang_file','lang_name','RTL_status','status'],$where=['id'=>$id],$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
			
			if(count($language)>0)
			{
				$lang_file = $language['lang_file'];									
				$lang_name = $language['lang_name'];									
				
				$json = file_get_contents('./language/'.$lang_file);
				
				$languageData=json_decode($json, true);
			}
			else
			{
				show_404();
			}
			
			$data['language']=$languageData;
			$data['languageInfoDb']=$language;
			$data['id']=$id;
			$data['language_name']=$lang_name;
			
			if(count($data['language'])==0)
			show_404();
		}
		
		
		
		$this->load->view("admin/".$pageName,$data);
		
	}
	
	public function login()
	{
		$data = array();
		
		$data=$this->DbHandlerDynamicFun->getData("settings",$select=['title','favicon','p_loader','captcha_admin_login_status'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
		
		$data['captcha_settings'] = $this->DbHandlerDynamicFun->getData("captcha_settings",$select=null,$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null,$distinct=false);
		
		$this->load->view("admin/login", $data);
	}
	
	public function resetPassword()
	{
		$data = array();
		
		$data=$this->DbHandlerDynamicFun->getData("settings",$select=['title','favicon','p_loader','captcha_admin_login_status'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
		
				
		$this->load->view("admin/resetPassword", $data);
	}
	
	public function updatePassword($resetHash)
	{
		if(empty($resetHash))
		{
			redirect(site_url('admin/login'));
		}
		
		
		$data = array();
		
		$data=$this->DbHandlerDynamicFun->getData("settings",$select=['title','favicon','p_loader','captcha_admin_login_status'],$where=null,$resultType="row_array",$join=false,$joinTable=null,$joinStatement=null,$joinType=null,$order_by_Col=null,$order_by_type=null,$limit=null,$wherep1=null,$whereinarray=null,$wherep2=null,$wherenotinarray=null,$groupby=null,$like=null,$likecolumn=null);
		
		$data['resetHash'] = $resetHash;
				
		$this->load->view("admin/updatePassword", $data);
	}
	
	public function logout()
	{
		
		if(isset($this->session->secure))
		{
			unset($_SESSION['username']);
			unset($_SESSION['secure']);
			redirect('admin/login');
		}
		else
		{
			redirect('');
		}
		
	}
}
	