<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your application. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

// Route::get('/enter', 'UserController@enter')->middleware('normaluser');

Auth::routes();

Route::get('ffmpeg', function(){
    // exec('ffmpeg -hide_banner -loglevel panic -y -t 9 -i video.flv -vf fps=10,flags=lanczos,palettegen palette.png 2>&1', $out, $status);
    // ffmpeg -v warning -ss 0 -i video.flv -vf scale=300:-1 -gifflags -transdiff -y bbb.gif
    // ffmpeg -v warning -ss 0 -i video.flv -vf scale=300:-1 -gifflags +transdiff -y bbb-trans.gif
    // ffmpeg -hide_banner -loglevel panic -i video.flv -y -i palette.png output2.gif
    // ffmpeg -hide_banner -loglevel panic -i video.flv -y -i palette.png -filter_complex "flags=lanczos[x];[x][1:v]paletteuse" output.gif
    // //
    // ffmpeg -y -t 9 -i video.mp4 -vf fps=10,flags=lanczos,palettegen palette.png
    // ffmpeg -y -ss 1 -t 3 -i video.flv -vf fps=10,scale=iw:ih:flags=lanczos,palettegen palette.png
    // ffmpeg -y -i video.flv -vf fps=10,scale=320:-1:flags=lanczos,palettegen palette.png
    // ffmpeg -hide_banner -ss 100 -i video.mp4 -y -i palette.png -filter_complex "fps=10,scale=320:-1:flags=lanczos[x];[x][1:v]paletteuse" -t 3 output.gif
    // ffmpeg -i in.flv -i palette.png -filter_complex "fps=10[x];[x][1:v]paletteuse" out.gif
    // ffprobe -v error -of flat=s=_ -select_streams v:0 -show_entries stream=height,width -of default=noprint_wrappers=1:nokey=1 video.flv

});


Route::get('ping', 'AlbumController@ping');

Route::get('grabzit', 'AlbumController@grabzit');

Route::get('strip', function(){
    Artisan::call('db:seed', ['--force' => true, '--class' =>'UpdateSeeder']);
    $dbseed = Artisan::output();
    echo "<br>db:seed ".$dbseed;

    // $text   = "!..These are _ a few_wor-ds.A.B:-)) (() . .,. , __-__-!! ?? ? be&%#$";
    // $trimmed = trim($text);
    // echo $trimmed;
    //
    // $trimmed = trim($text, " .,:)-_(!?");
    // echo '<br>'.$trimmed;
    // $trimmed = preg_replace('/-/', " ", $trimmed);
    // $trimmed = preg_replace('/_/', " ", $trimmed);
    // echo '<br>'.$trimmed;
    // $trimmed = preg_replace('/\./', " ", $trimmed);
    // echo "<br>";
    // var_dump($trimmed);
    // echo "<br>";
    // $newstr = preg_replace('/[^a-zA-Z0-9\']/', ' ', $text);
    // echo $newstr;
    // echo "<br>";
    // $newstr = str_replace("'", '', $newstr);
    // echo $newstr;
 });

 // Sitemap
 Route::get('/sitemap.xml', 'SitemapController@index');
 Route::group(['prefix' => 'sitemap'], function () {
    Route::get('albums.xml', ['as' => 'sitemap.albums', 'uses' => 'SitemapController@albums']);
    Route::get('images.xml', ['as' => 'sitemap.images', 'uses' => 'SitemapController@images']);
    Route::get('users.xml', ['as' => 'sitemap.users', 'uses' => 'SitemapController@users']);
    Route::get('tags.xml', ['as' => 'sitemap.tags', 'uses' => 'SitemapController@tags']);
 });

Route::get('testing5', ['as' => 'testing', 'uses' => 'HomeController@testing']);

Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['role:admin']], function () {
    Route::get('/', ['as' => 'admin', 'uses' => 'AdminController@root']);
    Route::get('dashboard', ['as' => 'admin.dashboard', 'uses' => 'AdminController@dashboard']);
    Route::get('settings', ['as' => 'admin.settings', 'uses' => 'SettingsController@index']);
    Route::post('settings/save', ['as' => 'admin.settings.save', 'uses' => 'SettingsController@save']);

    Route::get('documentation', ['as' => 'admin.documentation', 'uses' => 'AdminController@documentation']);

    Route::get('extension', function(){
        // echo "<br>int: " . PHP_INT_MAX;
         dd(get_loaded_extensions());

        // Artisan::call('migrate');
        // Artisan::call('help');
        // dd(Artisan::output());
    });

    // Update
    Route::group(['prefix' => 'update'], function () {
        Route::get('/', ['as' => 'admin.update.show', 'uses' => 'UpdateController@updateShow']);
        Route::post('getupdate', ['as' => 'admin.get.update', 'uses' => 'UpdateController@update']);
    });
    // Settings
    Route::group(['prefix' => 'settings'], function () {
        Route::get('site', ['as' => 'admin.settings.site', 'uses' => 'SettingsController@site']);
        Route::post('site', ['as' => 'admin.settings.site.save', 'uses' => 'SettingsController@siteSave']);
        Route::get('upload', ['as' => 'admin.settings.upload', 'uses' => 'SettingsController@upload']);
        Route::post('upload', ['as' => 'admin.settings.upload.save', 'uses' => 'SettingsController@uploadSave']);
        Route::get('seo', ['as' => 'admin.settings.seo', 'uses' => 'SettingsController@seo']);
        Route::post('seo', ['as' => 'admin.settings.seo.save', 'uses' => 'SettingsController@seoSave']);
        Route::get('sitemap', ['as' => 'admin.settings.sitemap', 'uses' => 'SettingsController@sitemap']);
        Route::post('sitemap', ['as' => 'admin.settings.sitemap.save', 'uses' => 'SettingsController@sitemapSave']);
        Route::get('pagination', ['as' => 'admin.settings.pagination', 'uses' => 'SettingsController@pagination']);
        Route::post('pagination', ['as' => 'admin.settings.pagination.save', 'uses' => 'SettingsController@paginationSave']);
        Route::get('social', ['as' => 'admin.settings.social', 'uses' => 'SettingsController@social']);
        Route::post('social', ['as' => 'admin.settings.social.save', 'uses' => 'SettingsController@socialSave']);
        Route::get('analytics', ['as' => 'admin.settings.analytics', 'uses' => 'SettingsController@analytics']);
        Route::post('analytics', ['as' => 'admin.settings.analytics.save', 'uses' => 'SettingsController@analyticsSave']);
        Route::get('ads', ['as' => 'admin.settings.ads', 'uses' => 'SettingsController@ads']);
        Route::post('ads', ['as' => 'admin.settings.ads.save', 'uses' => 'SettingsController@adsSave']);
    });

    // Pages
    Route::group(['prefix' => 'pages'], function () {
        Route::get('show', ['as' => 'admin.pages.list', 'uses' => 'PageController@index']);
        Route::get('show/{id}', ['as' => 'admin.pages.show', 'uses' => 'PageController@show']);
        Route::post('save', ['as' => 'admin.pages.save', 'uses' => 'PageController@save']);
        Route::get('order', ['as' => 'admin.pages.order', 'uses' => 'PageController@orderShow']);
        Route::post('order', ['as' => 'admin.pages.order.save', 'uses' => 'PageController@saveOrder']);
    });

    // Meme
    Route::group(['prefix' => 'meme'], function () {
        Route::get('show', ['as' => 'admin.meme.list', 'uses' => 'MemeController@index']);
        Route::get('show/{id}', ['as' => 'admin.meme.show', 'uses' => 'MemeController@show']);
        Route::get('create', ['as' => 'admin.meme.create', 'uses' => 'MemeController@create']);
        Route::post('save', ['as' => 'admin.meme.save', 'uses' => 'MemeController@save']);
        Route::post('update', ['as' => 'admin.meme.update', 'uses' => 'MemeController@update']);
        Route::post('delete', ['as' => 'admin.meme.delete', 'uses' => 'MemeController@delete']);
    });

    // requests
    Route::group(['prefix' => 'requests'], function () {
        Route::get('open', ['as' => 'admin.requests.open', 'uses' => 'RequestController@index']);
        Route::get('closed', ['as' => 'admin.requests.closed', 'uses' => 'RequestController@closed']);
        Route::get('open/show/{id}', ['as' => 'admin.requests.show', 'uses' => 'RequestController@show']);
        Route::get('closed/show/{id}', ['as' => 'admin.requests.show.closed', 'uses' => 'RequestController@show']);
        Route::post('close', ['as' => 'admin.requests.close', 'uses' => 'RequestController@close']);
    });

    // Albums
    Route::group(['prefix' => 'albums'], function () {
        Route::get('/', ['as' => 'admin.album.index', 'uses' => 'AlbumController@index']);
        Route::get('show/{id}', ['as' => 'admin.album.show', 'uses' => 'AlbumController@show']);
        Route::post('makeitso', ['as' => 'admin.album.makeitso', 'uses' => 'AlbumController@makeItSo']);
    });

    // Images
    Route::group(['prefix' => 'images'], function () {
        Route::get('/', ['as' => 'admin.image.index', 'uses' => 'ImageController@index']);
        Route::get('show/{id}', ['as' => 'admin.image.show', 'uses' => 'ImageController@show']);
        Route::post('makeitso', ['as' => 'admin.image.makeitso', 'uses' => 'ImageController@makeItSo']);
    });

    // Comments
    Route::group(['prefix' => 'comments'], function () {
        Route::get('/', ['as' => 'admin.comments.index', 'uses' => 'CommentController@index']);
        Route::get('show/{id}', ['as' => 'admin.comments.show', 'uses' => 'CommentController@show']);
        Route::post('makeitso', ['as' => 'admin.comments.makeitso', 'uses' => 'CommentController@makeItSo']);
    });

    // Users
    Route::group(['prefix' => 'users'], function () {
        Route::get('/', ['as' => 'admin.users.index', 'uses' => 'UserController@index']);
        Route::get('show/{id}', ['as' => 'admin.users.show', 'uses' => 'UserController@show']);
        Route::post('update', ['as' => 'admin.users.update', 'uses' => 'UserController@update']);
        Route::post('delete', ['as' => 'admin.users.delete', 'uses' => 'UserController@delete']);
    });

    // Tags
    Route::group(['prefix' => 'tags'], function () {
        Route::get('/', ['as' => 'admin.tags.index', 'uses' => 'TagController@index']);
        Route::get('create',  ['as' => 'admin.tags.create', 'uses' => 'TagController@create']);
        Route::get('edit/{id}', ['as' => 'admin.tags.edit', 'uses' => 'TagController@edit']);
        Route::post('store',  ['as' => 'admin.tags.store', 'uses' => 'TagController@store']);
        Route::post('update', ['as' => 'admin.tags.update', 'uses' => 'TagController@update']);
        Route::post('delete', ['as' => 'admin.tags.delete', 'uses' => 'TagController@delete']);
    });

    // Reports
    Route::group(['prefix' => 'reports'], function () {
        Route::get('albums', ['as' => 'admin.reports.albums', 'uses' => 'ReportController@albums']);
        Route::get('albums/{id}', ['as' => 'admin.reports.album.show', 'uses' => 'ReportController@albumShow']);
        Route::post('albums/makeitso', ['as' => 'admin.reports.album.makeitso', 'uses' => 'ReportController@makeItSo']);
        Route::get('comments', ['as' => 'admin.reports.comments', 'uses' => 'ReportController@comments']);
        Route::get('comments/{id}', ['as' => 'admin.reports.comment.show', 'uses' => 'ReportController@commentShow']);
        Route::post('comments/makeitso', ['as' => 'admin.reports.comment.makeitso', 'uses' => 'ReportController@makeItSo']);

        // Reports Editor
        Route::group(['prefix' => 'editor'], function () {
            Route::get('/', ['as' => 'admin.reports.editor', 'uses' => 'ReportEditorController@index']);
            Route::get('create', ['as' => 'admin.reports.editor.create', 'uses' => 'ReportEditorController@create']);
            Route::post('add', ['as' => 'admin.reports.editor.add', 'uses' => 'ReportEditorController@add']);
            Route::get('edit/{id}', ['as' => 'admin.reports.editor.edit', 'uses' => 'ReportEditorController@edit']);
            Route::post('update', ['as' => 'admin.reports.editor.update', 'uses' => 'ReportEditorController@update']);
            Route::post('delete', ['as' => 'admin.reports.editor.delete', 'uses' => 'ReportEditorController@delete']);
        });
    });
});

Route::get('terms', ['as' => 'terms', 'uses' => 'PageController@page']);
Route::get('about', ['as' => 'about', 'uses' => 'PageController@page']);
Route::get('privacy', ['as' => 'privacy', 'uses' => 'PageController@page']);
Route::get('contact', ['as' => 'contact.show', 'uses' => 'PageController@contactShow']);
Route::post('contact', ['as' => 'contact.post', 'uses' => 'PageController@contact']);
Route::get('removalrequest', ['as' => 'removalrequest.show', 'uses' => 'PageController@removalRequestShow']);
Route::post('removalrequest', ['as' => 'removalrequest.post', 'uses' => 'PageController@removalrequest']);

Route::get('{hash}.{extension}', 'ImageController@image')->where('hash', '[a-zA-Z0-9-]+')->where('extension', '[jpg, jpeg, gif, png, mp4, bmp]+');
Route::get('/thumb/{hash}.{extension}', 'ImageController@thumb')->where('hash', '[a-zA-Z0-9-]+')->where('extension', '[jpg, jpeg, gif, png, mp4, bmp]+');

// Tags
Route::group(['prefix' => 'tag'], function () {
    Route::get('{slug}', ['as' => 'tag.show', 'uses' => 'TagController@tag']);
});

Route::get('upload', 'AlbumController@showUpload');
Route::get('post/{slug}', ['as' => 'album.slug', 'uses' => 'AlbumController@show']);
Route::group(['prefix' => 'album'], function () {
    Route::get('/', ['as' => 'album.index', 'uses' => 'AlbumController@index']);
    Route::get('privacy', ['as' => 'album.privacy', 'uses' => 'AlbumController@getPrivacy']);
    Route::post('privacy', ['as' => 'album.set.privacy', 'uses' => 'AlbumController@setPrivacy']);
    Route::post('publish', ['as' => 'album.publish', 'uses' => 'AlbumController@publish']);
    Route::post('upload', ['as' => 'album.create', 'uses' => 'AlbumController@createAlbum']);
    Route::post('savetitle', ['as' => 'album.create', 'uses' => 'AlbumController@saveTitle']);
    Route::get('{hash}', ['as' => 'album.show', 'uses' => 'AlbumController@show']);

    Route::post('favorite', ['as' => 'album.favorite', 'uses' => 'AlbumController@favorite']);
    Route::post('vote', ['as' => 'album.vote', 'uses' => 'AlbumController@vote']);
    Route::get('{hash}/reorder', ['as' => 'album.reorder.show', 'uses' => 'AlbumController@showReorder']);
    Route::post('{hash}/reorder', ['as' => 'album.reorder', 'uses' => 'AlbumController@reorder']);
    Route::post('delete', ['as' => 'album.delete', 'uses' => 'AlbumController@delete']);
    Route::post('report', ['as' => 'album.report', 'uses' => 'AlbumController@report']);
});

Route::get('topic/{slug}', ['as' => 'topic.all', 'uses' => 'AlbumController@topic']);
Route::get('topic/{slug}/today', ['as' => 'topic.today', 'uses' => 'AlbumController@topic']);
Route::get('topic/{slug}/week', ['as' => 'topic.week', 'uses' => 'AlbumController@topic']);
Route::get('topic/{slug}/month', ['as' => 'topic.month', 'uses' => 'AlbumController@topic']);
Route::get('topic/{slug}/year', ['as' => 'topic.year', 'uses' => 'AlbumController@topic']);

Route::get('topic/{slug}/popularity', ['as' => 'topic.popularity', 'uses' => 'AlbumController@topic']);
Route::get('topic/{slug}/random', ['as' => 'topic.random', 'uses' => 'AlbumController@topic']);
Route::get('topic/{slug}/newest', ['as' => 'topic.newest', 'uses' => 'AlbumController@topic']);

Route::get('/', ['as' => 'viral.all', 'uses' => 'AlbumController@index']);
Route::get('viral/today', ['as' => 'viral.today', 'uses' => 'AlbumController@index']);
Route::get('viral/week', ['as' => 'viral.week', 'uses' => 'AlbumController@index']);
Route::get('viral/month', ['as' => 'viral.month', 'uses' => 'AlbumController@index']);
Route::get('viral/year', ['as' => 'viral.year', 'uses' => 'AlbumController@index']);

Route::get('viral/popularity', ['as' => 'viral.popularity', 'uses' => 'AlbumController@index']);
Route::get('viral/random', ['as' => 'viral.random', 'uses' => 'AlbumController@index']);
Route::get('viral/newest', ['as' => 'viral.newest', 'uses' => 'AlbumController@index']);

// Route::get('topic/{slug}/popularity', ['as' => 'topicpopularity.today', 'uses' => 'AlbumController@index']);

// Video 2 Gif
Route::get('video2gif', ['as' => 'video2gif.upload', 'uses' => 'AlbumController@showVideoUpload']);
Route::post('video2gif', ['as' => 'video2gif.new', 'uses' => 'AlbumController@video2gif']);

// MEME
Route::get('meme', ['as' => 'meme.index', 'uses' => 'MemeController@index']);
Route::get('meme/existing/{id}', ['as' => 'meme.existing', 'uses' => 'MemeController@existing']);
Route::get('meme/upload', ['as' => 'meme.upload', 'uses' => 'MemeController@showUpload']);
Route::post('meme/new', ['as' => 'meme.new', 'uses' => 'MemeController@new']);
Route::post('meme/save', ['as' => 'meme.save', 'uses' => 'MemeController@save']);

Route::post('image/save', ['as' => 'image.save', 'uses' => 'ImageController@save']);
Route::post('image/store', ['as' => 'image.store', 'uses' => 'ImageController@store']);
Route::post('image/delete', ['as' => 'image.delete', 'uses' => 'ImageController@deleteImage']);
Route::get('image/delete/{hash}', ['as' => 'image.delete.show', 'uses' => 'ImageController@deleteShow']);

Route::post('comment/report', ['as' => 'comment.report', 'uses' => 'CommentController@report']);
Route::post('comment/vote', ['as' => 'comment.vote', 'uses' => 'CommentController@vote']);
Route::post('comment/add', ['as' => 'comment.add', 'uses' => 'CommentController@add']);
// Route::post('comment/add', ['middleware' => 'throttle:2,1', 'as' => 'comment.add', 'uses' => 'CommentController@add']);

Route::group(['prefix' => 'user'], function () {
    Route::get('{user}', ['as' => 'user.comments', 'uses' => 'UserController@comments']);
    Route::get('{user}/submitted', ['as' => 'user.submitted', 'uses' => 'UserController@submitted']);
    Route::get('{user}/favorites', ['as' => 'user.favorites', 'uses' => 'UserController@favorites']);
    Route::get('{user}/albums', ['as' => 'user.albums', 'uses' => 'UserController@albums']);
    Route::get('{user}/images', ['as' => 'user.images', 'uses' => 'UserController@images']);
});

Route::get('/{hash}', ['as' => 'image.show', 'uses' => 'ImageController@show']);
