@extends('layouts.app')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="page page-filled">
            <div class="page-heading">

            </div>
            <div class="page-body">
                @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <div id="message" style="text-align: center; margin-top: 50px;">
                    Processing the video, this may take some time...
                </div>
                <div class="spinner">
                  <div class="bounce1"></div>
                  <div class="bounce2"></div>
                  <div class="bounce3"></div>
                </div>
            </div>
        </div>
    </div>
    @include('video2gif.sidebar')
</div>
@endsection

@section('scripts')

<script type="text/javascript">
    $(document).ready(function() {
        $("#uploadBtn").on("click", function(e){
            e.preventDefault();
            $('#uploadForm').attr('action', "{{ route('video2gif.new')}}").submit();
        });
    });
</script>
<script src="{{asset('js/custom-file-input.js')}}"></script>
@endsection
