@extends('layouts.app')

@section('title')
    @php
        $website_title = $user->username . ' submited albums on ' . $website_name;
    @endphp
@endsection

@section('content')

    <div class="row">
        <div class="col-md-8">
            <div class="user-profile user-profile-filled">
                <div class="user-profile-heading">
                    <div>
                        <span>submitted</span>
                    </div>
                </div>
                <div class="user-profile-body">
                    @if($user->albums->count())
                        @foreach($user->albums as $album)
                            <div class="showtooltip col-md-55" data-tooltip-content="#tooltip_{{ $album->hash }}">
                                <a href="{{ url('/album') }}/{{ $album->hash }}" >
                                    @if($album->images->pluck('hash')->first())
                                    <img  src="{{url('thumb')}}/{{$album->images->pluck('hash')->first() }}.{{$album->images->pluck('extension')->first()}}">
                                    @else
                                        <img  src="{{url('images/default.png')}}">
                                    @endif
                                </a>

                                <div class="tooltip_templates" hidden="false">
                                    <div id="tooltip_{{ $album->hash }}">
                                        <p>
                                        {{ $album->title }}
                                        </p>
                                        <div class="tooltip-bottom">{{ $album->getPointsAttribute() }} points · {{ $album->views }} views · {{ $album->createdAt()}}</div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        @if(Auth::user() == $user)
                            You didn't share any albums to community.
                        @else
                            {{$user->username}} didn't share any albums to community yet.
                        @endif
                    @endif
                </div>
            </div>
        </div>

        @include('user.sidebar')
@endsection
