@extends('layouts.app')

@section('title')
    @php
        $website_title = $user->username . ' images on ' . $website_name;
    @endphp
@endsection

@section('content')
    <div class="row">
        <div class="col-md-8">
            <div class="user-profile user-profile-filled">
                <div class="user-profile-heading">
                    <div>
                        <span>images</span>
                    </div>
                </div>
                <div class="user-profile-body">
                    @if($images->count())
                        @foreach($images as $image)
                            <div class="col-md-55 @if($image->privacy) private @elseif(!$image->privacy && Auth::user() == $user) public @endif"">
                                <a href="{{ url($image->hash) }}" >
                                    <img  src="{{url('thumb')}}/{{$image->hash }}.{{$image->extension}}" style="width: 143px; height:143px;" " alt="">
                                </a>
                            </div>
                        @endforeach
                    @else
                        @if(Auth::user() == $user)
                            You don't have any images uploaded yet.
                        @else
                            {{$user->username}}'s images are not publicly available.
                        @endif
                    @endif
                </div>
            </div>
        </div>
        @include('user.sidebar')
@endsection
