@extends('layouts.app')

@section('title')
    @php
        $website_title = $user->username . ' favorites on ' . $website_name;
    @endphp
@endsection

@section('content')

    <div class="row">
        <div class="col-md-8">
            <div class="user-profile user-profile-filled">
                <div class="user-profile-heading">
                    <div>
                        <span>favorites</span>
                    </div>
                </div>
                <div class="user-profile-body">
                    @if($favorites->count())
                        @foreach($favorites as $favorite)
                            @if($favorite->album->published == 1)
                                <div class="showtooltip col-md-55" data-tooltip-content="#tooltip_{{ $favorite->album->hash }}">
                                    {{-- <div class="thumbnail"> --}}
                                        <a href="{{ url('/album') }}/{{ $favorite->album->hash }}" >
                                            <img  src="{{url('thumb')}}/{{$favorite->album->images->pluck('hash')->first() }}.{{$favorite->album->images->pluck('extension')->first()}}" style="width: 143px; height:143px;" " alt="">
                                        </a>
                                    {{-- </div> --}}

                                    <div class="tooltip_templates" hidden="false">
                                        <div id="tooltip_{{ $favorite->album->hash }}">
                                            <p>
                                            @if ($favorite->album->title)
                                                {{ $favorite->album->title }}
                                            @else
                                                Untitiled
                                            @endif
                                            </p>
                                            <div class="tooltip-bottom">{{ $favorite->album->getPointsAttribute() }} points · {{ $favorite->album->views }} views · {{ $favorite->album->created_at->diffForHumans() }}</div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @else
                        @if(Auth::user() == $user)
                            You didn't favorite any albums yet.
                        @else
                            {{$user->username}} didn't favorite any albums yet.
                        @endif
                    @endif
                </div>
            </div>
        </div>

        @include('user.sidebar')
@endsection
