@extends('layouts.app')

@section('title')
    @php
        $website_title = $user->username . ' comments on ' . $website_name;
    @endphp
@endsection

@section('content')

    <div class="row">
        <div class="col-md-8">
            <div class="user-profile user-profile-filled">
                <div class="user-profile-heading">
                    <div>
                        <span>comments</span>
                    </div>
                </div>
                    {{-- @if($user->comments->count()) --}}
                        @foreach($comments as $comment)
                            @if($comment->album->published == 1)
                                <div class="comment-item" id="{{$comment->id}}">
                                        <div class="album-image">
                                            <a href="{{url('album')}}/{{ $comment->album->hash }}"><img src="{{url('thumb')}}/{{$comment->album->images->pluck('hash')->first()}}.{{$comment->album->images->pluck('extension')->first()}}"></a>
                                        </div>
                                        <div class="comment-wrapper">
                                            <div class="comment-heading">
                                                <span class="username left">
                                                    <a href="{{url('user')}}/{{ $user->username }}">{{ $user->username }}</a>
                                                </span>
                                                <span class="points left">{{ $comment->getPointsAttribute() }} pts</span>
                                                <span class="left" title="{{ $comment->created_at }}">{{ $comment->createdAt() }}</span>
                                                <div style="clear: both;"></div>
                                            </div>

                                            <div class="comment-body">
                                                <span>{{$comment->body}}</span>
                                            </div>

                                        </div>
                                        <div class="clear"></div>
                                </div>
                            @endif
                        @endforeach
                    {{-- @else
                        <div class="user-profile-body">
                            @if(Auth::user() == $user)
                                You didn't make any comments yet.
                            @else
                                {{$user->username}} didn't make any comments yet.
                            @endif
                        </div> --}}
                    {{-- @endif --}}
            </div>
        </div>
        @include('user.sidebar')
@endsection
